/*************************************************************************
 *
 *  $RCSfile: chainwidthbuilder.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: lla $ $Date: 2002/08/16 10:47:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAINWIDTHBUILDER_HXX
#define CHAINWIDTHBUILDER_HXX

#ifndef INCLUDED_VECTOR
#include <vector>
#endif

#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif

#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif

#ifndef CELL_SPACING
#define CELL_SPACING 6
#endif

// Helper to calc and set the right size of visual objects in a chain

// 	* | ----           ----  ----  ------ | 
// 	* ||Help|         |Back||Next||Cancel||
// 	* | ----           ----  ----  ------ |

// Here, you add Back, Next and Cancel button to the ChainWidthBuilder
// and do a calc() and a setSize() and newer you will loose text due to low width.

namespace setup
{
	template <class TClass>
	class ChainWidthBuilder
	{
		std::vector<TClass*> m_aList;
		Window            *m_pParent;
		sal_Int32          m_nPreferdSize;
		sal_Int32         *m_pNewSize;

	public:
		ChainWidthBuilder(Window* _pParent, sal_Int32 _nPreferdSize)
				:m_pParent(_pParent),
				 m_nPreferdSize(_nPreferdSize),
				 m_pNewSize(NULL)
			{}
		
		void append(TClass * _pValue)
			{
				m_aList.push_back(_pValue);
			}

		void calc()
			{
				// calc from left to right the minimum size of a Visual Object like PushButton
				sal_Int32 nValues = m_aList.size();
				if (nValues > 0)
				{
					m_pNewSize = new sal_Int32[nValues];
					
					sal_Int32 i = 0;
					for (std::vector<TClass*>::iterator it = m_aList.begin();
						 it != m_aList.end();
						 it++)
					{
						TClass* pTClass = *it;
						
						Size aMinimumSize = pTClass->CalcMinimumSize();
						sal_Int32 nWidth = std::max(m_nPreferdSize, aMinimumSize.Width());
						nWidth += 2 * CELL_SPACING;
						m_pNewSize[i] = nWidth;
						++i;
					}
				}
			}
		
		void setSize()
			{
				// calc from right to left (!) the new position and set it at the visual object
				OSL_ENSURE(m_pNewSize, "NewSize empty, calc() forgotten?");
				if (!m_pNewSize) return;
				
				sal_Int32 nValues = m_aList.size();
				if (nValues > 0)
				{
					Size   aWindowSize = m_pParent->GetSizePixel();
					sal_Int32 nNewXPos = aWindowSize.Width() - CELL_SPACING;
					
					for (sal_Int32 i = nValues - 1 ; i >= 0 ; i--)
					{
						sal_Int32 nWidth = m_pNewSize[i];
						
						nNewXPos = nNewXPos - nWidth - CELL_SPACING;
						
						TClass *pTClass = m_aList[i];
						Point  aCurrentPoint = pTClass->GetPosPixel();
						
						// get actual size
						Size  aSize  = pTClass->GetSizePixel();
						// set new width
						aSize.Width() = nWidth;
						// set new button
						pTClass->SetPosSizePixel(Point(nNewXPos, aCurrentPoint.Y()), aSize);
					}
				}
			}

		~ChainWidthBuilder()
			{
				delete [] m_pNewSize;
			}
	};
} // namespace


#endif
