/*************************************************************************
 *
 *  $RCSfile: loader.m,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: patrick.luby $ $Date: 2000/09/27 22:14:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <limits.h>
#include <dirent.h>

#include <premac.h>
#include <AppKit/AppKit.h>
#include <postmac.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <math.h>
#include <sys/mount.h>

#ifndef MACOSX
#include "bitmap"
#endif
#include "svunzip.h"

#ifndef _LOADER_CXX
#include <tools/solar.h>
#endif

#define MAX_ENTRYS				10000
#define MAX_ARCH_PATH			255
#define BUF_SZ					32000
#define ARCH_ACTUAL_VERSION		1

#define CALLTYPE

typedef const char* (*FncFindArch)(const char* pDefSource, const char* pDefName);

#define MASTER_EXTENSION	"bin"
#define JUNK_EXTENSION		"bin"
#define exit(status) \
	[pReleasePool release]; \
	exit(status);

BOOL m_bNoJunk = FALSE;
NSAutoreleasePool *pReleasePool;

typedef struct _ArchEntry
{
	ULONG	nOffset;
	ULONG	nSize;
	char*	pName;
} ArchEntry;

typedef struct _ArchDirectory
{
	FILE*		pArch;
	ULONG		nArchSize;
	FncFindArch	fncFindArch;

	char		cDelim;
	char		pSourceDir[MAX_ARCH_PATH];
	char		pMasterArch[MAX_ARCH_PATH];

	ULONG		nArchVersion;
	ULONG		nDirOffset;
	ULONG 		nDataOffset;

	ULONG 		nDirCount;
	ArchEntry* 	pDirectory[MAX_ENTRYS];
} ArchDirectory;

void ArchDirectory_Init( ArchDirectory* p )
{
	p->pArch			= NULL;
	p->fncFindArch		= NULL;
	p->nDirOffset		= 0L;
	p->nDataOffset		= 0L;
	p->nDirCount		= 0L;
	p->nArchSize		= 0L;

	p->cDelim			= '/';
}

void ArchDirectory_Deinit( ArchDirectory* p )
{
	ULONG n;
	if( p->pArch )
		fclose( p->pArch );

	for( n = 0; n < p->nDirCount; ++ n )
	{
		ArchEntry* pEntry = p->pDirectory[n];
		free( pEntry->pName );
		free( pEntry );
	}
}

void ArchDirectory_GetArchFileName( ArchDirectory* p, USHORT nSegment, char* pBuffer )
{
	char pDelim[2];
	char pExtension[10];
	unsigned short i;

	pDelim[0] = p->cDelim;
	pDelim[1] = 0x00;

	strcpy( pBuffer, p->pSourceDir );
	if( pBuffer[strlen(pBuffer)-1] != p->cDelim )
		strcat( pBuffer, pDelim );
	strcat( pBuffer, p->pMasterArch );

	if( !m_bNoJunk )
	{
		if( nSegment != 0 )
			sprintf( pExtension, "-%03ld.%s", nSegment, JUNK_EXTENSION );
		else
			sprintf( pExtension, "-%03ld.%s", nSegment, MASTER_EXTENSION );

		strcat( pBuffer, pExtension );
	}
}

BOOL ArchDirectory_ReadDirectory( ArchDirectory* p )
{
	USHORT	i;
	char 	cChar;
	int 	nIdx = 0;

	int nErr = fseek( p->pArch, p->nDirOffset, SEEK_SET );
	if( nErr )
		return FALSE;

	p->nDirCount = 0;

	fread( &(p->nArchVersion), sizeof(ULONG), 1, p->pArch );
	fread( &(p->nDirCount), sizeof(ULONG), 1, p->pArch );

	for( i = 0; i < p->nDirCount; ++i )
	{
		ArchEntry* 	pNew = (ArchEntry*)malloc( sizeof(ArchEntry) );

		pNew->pName = (char*) malloc( MAX_ARCH_PATH );

		fread( &(pNew->nOffset), sizeof(ULONG), 1, p->pArch );
		fread( &(pNew->nSize), sizeof(ULONG), 1, p->pArch );

		for( nIdx = 0; (cChar = fgetc(p->pArch)) != 0x00; ++nIdx )
			pNew->pName[nIdx] = cChar;
		pNew->pName[nIdx] = 0x00;

		p->pDirectory[i] = pNew;
	}

	p->nDataOffset = ftell( p->pArch );
	return TRUE;
}

void ArchDirectory_SetFindArchHdl( ArchDirectory* p, FncFindArch fncNew )
{
	p->fncFindArch = fncNew;
}

BOOL ArchDirectory_SetArchFile( ArchDirectory* p, const char* pBigFile )
{
	USHORT nLen;
	BOOL  bFnd = FALSE;
	char* pBuf = NULL;
	long i;
	char  aSrch1[5] = "BIGF";
	char  aSrch2[5] = "ILE:";
	char  aSrchStr[9];
	BOOL bReturn;
	USHORT nJunks;
	char cBuffer[MAX_ARCH_PATH];
	FILE* pTest;
	BOOL bAllFiles = TRUE;

	p->nArchSize = 0L;
	p->nDataOffset	= 0L;

	p->pArch = fopen( pBigFile, "rb" );
	if( !p->pArch )
		return FALSE;

	fseek( p->pArch, 0L, SEEK_END );
	p->nArchSize = ftell( p->pArch );
	fseek( p->pArch, 0L, SEEK_SET );


	pBuf = (char*) malloc(BUF_SZ);

	strcpy( aSrchStr, aSrch1 );
	strcat( aSrchStr, aSrch2 );

	while( !feof(p->pArch) && !bFnd )
	{
		ULONG nRead = fread( pBuf, sizeof(char), BUF_SZ, p->pArch );
		for( i = 0; i < nRead; ++i )
			if( pBuf[i] == 'B' )
				if( strncmp(&(pBuf[i]), aSrchStr, 8) == 0)
				{
					p->nDirOffset = atol(&(pBuf[i+8]));
					if( !p->nDirOffset )
					{
						fclose(p->pArch);
						free( pBuf );
						return FALSE;
					}
					bFnd = TRUE;
					break;
				}
	}
	free( pBuf );

	if( !bFnd )
	{
		fclose(p->pArch);
		return FALSE;
	}

	bReturn = ArchDirectory_ReadDirectory( p );
	nJunks = (USHORT) ceil( ((double)(p->pDirectory[p->nDirCount-1]->nOffset + p->pDirectory[p->nDirCount-1]->nSize) + p->nDataOffset) / (double)p->nArchSize );
	nJunks = nJunks - 1;

	fclose(p->pArch);

	nLen = strlen(pBigFile);
	memset(p->pSourceDir, 0, MAX_ARCH_PATH );
	memset(p->pMasterArch, 0, MAX_ARCH_PATH );

	for( i = nLen; i >= 0; --i)
		if(pBigFile[i] == p->cDelim)
		{
			strncpy(p->pSourceDir, pBigFile, i+1);
			strcpy(p->pMasterArch, &(pBigFile[i+1]));
			break;
		}

	if( nJunks )
	{
		nLen = strlen(p->pMasterArch);
		for( i = nLen; i >= 0; --i )
			if( p->pMasterArch[i] == '-' )
			{
				p->pMasterArch[i] = 0x00;
				break;
			}
	}

	if( !nJunks )
		m_bNoJunk = TRUE;
	else
	for( i = 0; i <= nJunks; ++i )
	{
		ArchDirectory_GetArchFileName( p, i, cBuffer );
		pTest = fopen( cBuffer, "rb" );
		if( pTest )
			fclose( pTest );
		else
		{
			bAllFiles = FALSE;
			fprintf( stderr, "\nfile not found '%s'", cBuffer );
		}

	}

	if( !bAllFiles )
	{
		fprintf( stderr, "\n\nerror: One or more files are missing! Please ensure that all necessary files are present.\n\n" );
		exit( -1 );
	}

	return bReturn;
}

const ArchEntry* ArchDirectory_ExistsFile( ArchDirectory* p, const char* pFileName )
{
	USHORT i;

	ArchEntry* pEntry = NULL;
	for( i = 0; i < p->nDirCount; ++i )
		if( strcasecmp(pFileName, p->pDirectory[i]->pName) == 0 )
		{
			pEntry = p->pDirectory[i];
			break;
		}
	return pEntry;
}

BOOL ArchDirectory_GetFile( ArchDirectory* p, const char* pFileName, const char* pDestDir )
{
	char pDestFileName[MAX_ARCH_PATH];
	char pDelim[2];
	const ArchEntry* pEntry = ArchDirectory_ExistsFile( p, pFileName );
	char pArchFileName[MAX_ARCH_PATH];
	USHORT nSplitArchNr;
	const char* pReturn;
	FILE* pDestFile;
	ULONG nStartPos;
	int nErr;
	ULONG nReadSz = 0;
	char* pBuf;
	ULONG nToRead;
	ULONG nRead;

	if( !pEntry )
		return FALSE;

	pDelim[0] = p->cDelim;
	pDelim[1] = 0x00;

	strcpy( pDestFileName, pDestDir );
	strcat( pDestFileName, pDelim );
	strcat( pDestFileName, pEntry->pName );

	nSplitArchNr = (USHORT)((pEntry->nOffset + p->nDataOffset) / p->nArchSize);
	ArchDirectory_GetArchFileName( p, nSplitArchNr, pArchFileName );

	pDestFile = fopen( pDestFileName, "wb" );
	if( !pDestFile )
		return FALSE;

DO_RETRY_FIRST:
	p->pArch = fopen( pArchFileName, "rb" );
	if( !p->pArch )
	{
		if( !p->fncFindArch )
		{
		EXIT_RETRY_FIRST:
			fclose( pDestFile );
			return FALSE;
		}
		pReturn = p->fncFindArch( p->pSourceDir, pArchFileName );
		if( !pReturn )
			goto EXIT_RETRY_FIRST;
		strcpy( p->pSourceDir, pReturn );
		ArchDirectory_GetArchFileName( p, nSplitArchNr, pArchFileName );
		goto DO_RETRY_FIRST;
	}


	nStartPos = (pEntry->nOffset - (nSplitArchNr * p->nArchSize)) + p->nDataOffset;
	nErr = fseek( p->pArch, nStartPos, SEEK_SET );
	if( nErr )
		return FALSE;

	pBuf = (char*) malloc(BUF_SZ);

	while( nReadSz < pEntry->nSize )
	{
		if( feof(p->pArch) )
		{
			fclose( p->pArch );
			nSplitArchNr += 1;
		DO_RETRY:
			ArchDirectory_GetArchFileName( p, nSplitArchNr, pArchFileName );
			p->pArch = fopen( pArchFileName, "rb" );
			if( !p->pArch )
			{
				if( !p->fncFindArch )
				{
				EXIT_RETRY:
					fclose( pDestFile );
					fclose( p->pArch );
					free( pBuf );
					return FALSE;
				}
				pReturn = p->fncFindArch( p->pSourceDir, pArchFileName);
				if( !pReturn )
					goto EXIT_RETRY;
				strcpy( p->pSourceDir, pReturn );
				goto DO_RETRY;
			}
		}

		nToRead = BUF_SZ;
		if( nReadSz + nToRead > pEntry->nSize )
			nToRead = pEntry->nSize - nReadSz;

		nRead = fread( pBuf, sizeof(char), nToRead, p->pArch );
		fwrite( pBuf, sizeof(char), nRead, pDestFile );

		nReadSz += nRead;
	}

	fclose( pDestFile );
	fclose( p->pArch );
	free( pBuf );

	return TRUE;
}


ULONG ArchDirectory_GetCount( ArchDirectory* p )
{
	return p->nDirCount;
}

ArchEntry** ArchDirectory_GetRawList( ArchDirectory* p )
{
	return (ArchEntry**) p->pDirectory;
}

void ArchDirectory_ExtractAll( ArchDirectory* p, const char* pDirname )
{
	ULONG i;
	ULONG nCnt			= ArchDirectory_GetCount(p);
	ArchEntry** ppRaw	= ArchDirectory_GetRawList(p);

	for( i = 0; i < nCnt; ++i ) {
		ArchEntry* pEntry = (ArchEntry*)ppRaw[i];
		ArchDirectory_GetFile( p, pEntry->pName, "." );
	}
	#ifdef UNX
	chmod( "setup", S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );
	#endif
}

#ifdef _LOADER_CXX
#undef BOOL
#endif

/* */


#define BITMAPDEPTH 						1
#define TOO_SMALL 							0
#define BIG_ENOUGH 							1

#define WINDOW_WIDTH						350
#define WINDOW_HEIGHT						100

#define __MAX_PATH 							1024
#define MAX_BLOCK							32000
#define KBYTE 								1024
#define LD_LIBRARY_PATH				   		"LD_LIBRARY_PATH"

#define SETUP_EVENT_TIME_TO_START	 		1L
#define SETUP_EVENT_INSTALL_SETUP	 		2L
#define SETUP_EVENT_KILL_LOADER_WINDOW		3L
#define SETUP_EVENT_START_SETUP		 		4L
#define SETUP_EVENT_EXIT_LOADER		 		5L

#ifndef MACOSX
Display*			display;
Window 				win;
#endif
int					screen_num;
char*				display_name = NULL;
BOOL 				bExtractBIG = FALSE;
ULONG 				nMinTempSize = 0;

static char*		progname;
static char 		strTmpPath[__MAX_PATH];
static char 		strInitPath[__MAX_PATH];
static char 		strAbsBinaryName[__MAX_PATH];
static char		 	strSetupBIN[__MAX_PATH];
static char			strExtractPath[__MAX_PATH];

static const char	strExePatch[] = "BIGFILE:patchpatchpatch";
unsigned long 		nSetupSize = 0;

void SendEvent(long);
BOOL __getFullPath(const char* pszFilename, char* pszPath, unsigned long
MaxLen);

static char strStartupShellScript[] =
{
"#!/bin/sh\n" \
"#\n" \
"# StarOffice setup script\n" \
"# (c) 1997, Star Division GmbH\n" \
"cd `dirname $0`\n" \
"sd_archive_path=`pwd`\n" \
"sd_setup_binary=setup.bin\n" \
"sd_platform=`uname -s`\n" \
"# execute setup binary\n" \
"exec $sd_archive_path/$sd_setup_binary $*\n"
};


#define MAX_BUF		 					32000
#define BUF_OVERFLOW_SPOOL_BACK			30

typedef struct _Library
{
	int		nFnd;
	char*	pName;
} Library;

#define MAX_FILENAMES				   (sizeof(staticLibCheckList)/sizeof(staticLibCheckList[0]))
Library staticLibCheckList[] = {
	{ 0, "libc.so.6" }
};

#define SUSE_RELEASE_FILE "/etc/SuSE-release"

void ChopNewline( char* pLine )
{
	while( *pLine && *pLine != '\n' && *(pLine+1) != 0 )
		pLine++;
	if( *pLine == '\n' )
		*pLine = 0;
}

char* CheckSuSE()
{
	FILE* fp;
	static char	aVersion[1024];
	int			nMajor = 0, nMinor = 0;
	struct stat	aStat;

	if( stat( SUSE_RELEASE_FILE, &aStat ) )
		return NULL;
	fp = fopen( SUSE_RELEASE_FILE, "r" );
	if( ! fp )
		return NULL;

	aVersion[0] = 0;
	fgets( aVersion, sizeof( aVersion ), fp );
	fscanf( fp, "VERSION = %d.%d", &nMajor, &nMinor );
	fclose( fp );
	if( nMajor < 6 )
		return NULL;

	ChopNewline( aVersion );
	return aVersion;
}


BOOL CopyFile( const char* pSource, const char* pDest )
{
	int	hSourceHdl	= open( pSource, O_RDONLY );
	int	hDestHdl	= open( pDest, O_CREAT | O_WRONLY );
	unsigned long	nTotalSize;
	unsigned long	nRead;
	char* 			pBuffer = (char*)malloc(MAX_BLOCK);

	if( hSourceHdl == -1 || hDestHdl == -1 )
		return FALSE;


	nTotalSize = lseek( hSourceHdl, 0L, SEEK_END );
	lseek( hSourceHdl, 0L, SEEK_SET );

	do {
		nRead = read( hSourceHdl, pBuffer, MAX_BLOCK );
		if( nRead )
			write( hDestHdl, pBuffer, nRead );
	} while( nRead != 0 );

	close( hSourceHdl );
	close( hDestHdl );

	chmod( pDest, S_IRWXU );

	return TRUE;
}

void KillSetupDir()
{
	DIR* pDir = opendir( strTmpPath );
	struct dirent* pFile;

	if( !pDir )
		return ;

	while( (pFile = readdir(pDir)) != NULL )
	{
		unlink( pFile->d_name );
	}

	chdir( strInitPath );
	rmdir( strTmpPath );
}

char* GetTempPath(char* pBuf)
{
	char* pTmp = getenv( "TMP" );

	if( !pTmp )
		pTmp = getenv( "TEMP" );

	if( pTmp )
		strcpy( pBuf, pTmp );
	else
		strcpy( pBuf, "/tmp" );

	return pBuf;
}

void GetTempFile(char* pBuf)
{
	char*		ret_val;
	size_t		i;
	char		sBuf[__MAX_PATH];
	unsigned	u;

	char		pfx[6];
	char		ext[5];
	struct stat aStat;

	strcpy( pfx, "sv" );
	strcpy( ext, ".tmp" );

	if ( !GetTempPath(sBuf) )
		return;

	i = strlen(sBuf);
	ret_val = (char*) malloc(i+2  + 8  + 4 );
	if (ret_val)
	{
		strcpy(ret_val,sBuf);

		if( i>0 && ret_val[i-1] != '\\' && ret_val[i-1] != '/' && ret_val[i-1] != ':' )
			ret_val[i++] = '/';

		strncpy(ret_val + i, pfx, 5);
		ret_val[i + 5] = '\0';
		i = strlen(ret_val);

		for (u = 1; u < 26*26*26; u++)
		{
			sprintf(ret_val+i, "%03u", u);

			strcat(ret_val,ext);

			if ( stat( ret_val, &aStat ) )
			{
				strcpy( pBuf, ret_val );
				break;
			}
		}
		free( ret_val);
		ret_val = 0;
	}
}

void __EnumFilesCallBack( char *pFile, ULONG nSize, void *pObject )
{ nMinTempSize += nSize; }

void UnpackBIG2Temp( ArchDirectory* pBigDir, BOOL bSize )
{
  	ArchEntry* pEntry;
	ULONG i;

	for( i = 0; i < pBigDir->nDirCount; ++i )
	{
		pEntry = (ArchEntry*)pBigDir->pDirectory[i];
		if( strncmp(pEntry->pName, "f0_", 3) == 0 )
			if( bSize )
				nMinTempSize += pEntry->nSize;
			else
			{
				ArchDirectory_GetFile( pBigDir, pEntry->pName, strTmpPath );
				SVUnzip( pEntry->pName, "*", (const char*)"qq", NULL );
				unlink( pEntry->pName );
			}
	}
}

void Unpack2Temp( BOOL bSize )
{
	char			file[16*1024];
	struct dirent*	pFile;
	DIR* 			pDir = opendir( strInitPath );

	if( !pDir ) return ;
	while( (pFile = readdir(pDir)) != NULL )
	{
		if( strncmp(pFile->d_name, "f0_", 3) == 0 )
		{
		   	strcpy( file, strInitPath );
		 	strcat( file, "/" );
	 		strcat( file, pFile->d_name );

			if( bSize )
				SVUnzipEnumFiles( file, "*", (UnzipEnumFilesCallBack*)__EnumFilesCallBack, NULL );
			else
				SVUnzip( file, "*", (const char*)"qq", NULL );
		}
	}
}

void InstallSetupFile( ArchDirectory* pBigDir )
{
	int nErr = 0;
	char	strSetupOrgZIP[__MAX_PATH];
	char	strSetupZIP[__MAX_PATH];
	char 	strSetupINI[__MAX_PATH];
	FILE*	pFile;
	struct	statfs buf;
	ULONG 	nSize = 0;

	GetTempFile( strTmpPath );

	if( strTmpPath[0] != '\0' )
		nErr = mkdir( strTmpPath, S_IRWXU );
	else
	{
		(void)	fprintf( stderr, "%s: cannot find temppath!\n",
						 progname );
		exit( -1 );
	}

	if( nErr == -1 )
	{
		(void)	fprintf( stderr, "%s: could not create temporary directory (%s)\n",
						 progname, strTmpPath );
		exit( -1 );
	}

	if( chdir(strTmpPath) == -1 )
	{
		(void)	fprintf( stderr, "%s: could not change to temporary directory (%s)\n",
						 progname, strTmpPath );
		exit( -1 );
	}

	if( !pBigDir )
	{
		Unpack2Temp( TRUE );
		nMinTempSize += 512000;
	}
	else
	{
		UnpackBIG2Temp( pBigDir, TRUE );
		nMinTempSize += 8192000;
	}
	nMinTempSize /= KBYTE;

	statfs( strTmpPath, &buf);
	nSize = buf.f_bsize;
	if( nSize < KBYTE )
		nSize = buf.f_bavail / (KBYTE / nSize);
	else if( nSize > KBYTE )
		nSize = buf.f_bavail * (nSize / KBYTE);
	else
		nSize = buf.f_bavail;

	if( nSize < nMinTempSize )
	{
		(void)	fprintf( stderr, "%s: The temporary directory is full. (%s)\n",
						 progname, strTmpPath );
		exit( -1 );
	}

	if( !pBigDir )
		Unpack2Temp( FALSE );
	else
		UnpackBIG2Temp( pBigDir, FALSE );

	if ( nErr )
	{
		(void)	fprintf( stderr, "%s: Could not unpack file '%s'\n",
						 progname, strSetupZIP );
		exit( -1 );
	}


	strcpy( strSetupINI, strTmpPath );
	strcat( strSetupINI, "/setup.ini" );

	pFile = fopen( strSetupINI, "w+" );

	if( pFile )
	{
		fprintf( pFile, "[source]\n" );
		if( pBigDir )
		{
			fprintf( pFile, "path=%s\n", strAbsBinaryName );
			fprintf( pFile, "big=1\n" );
			fprintf( pFile, "offset=%ld\n", nSetupSize );
		}
		else
				fprintf( pFile, "path=%s\n", strInitPath );

		fclose( pFile );
	}

	strcpy( strSetupBIN, strTmpPath );
	strcat( strSetupBIN, "/setup.bin" );
	chmod( strSetupBIN, S_IRWXU );

	strcpy( strSetupBIN, strTmpPath );
	strcat( strSetupBIN, "/sopatchlevel.sh" );
	chmod( strSetupBIN, S_IRWXU );

	strcpy( strSetupBIN, strTmpPath );
	strcat( strSetupBIN, "/setup" );
	chmod( strSetupBIN, S_IRWXU );

	SendEvent( SETUP_EVENT_KILL_LOADER_WINDOW );
}

void InstallBigSetupFile()
{
	ArchDirectory aDir;
	ArchDirectory_Init( &aDir );

	if( !ArchDirectory_SetArchFile(&aDir, strAbsBinaryName) )
	{
		(void)	fprintf( stderr, "%s: cannot open archivefile %s\n",
						 progname, strAbsBinaryName );
		exit( -1 );
	}

	if( bExtractBIG )
	{
		USHORT nLen = strlen(strExtractPath);
		if( nLen ) {
			if( chdir(strExtractPath) == -1 ) {
				(void) fprintf( stderr, "%s: could not change directory (%s)\n",
							 	progname, strExtractPath );
				exit( -1 );
			}
		}
		else strcpy( strExtractPath, "." );

		fprintf( stderr, " extracting files please wait...\n" );
		ArchDirectory_ExtractAll( &aDir, strExtractPath );
		exit( 0 );
	}
	else
		InstallSetupFile( &aDir );
}

#ifndef MACOSX
void getGC(Window win, GC* gc, XFontStruct* font_info)
{
	XGCValues		values;
	unsigned long	valuemask	= 0;
	unsigned int	line_width	= 6;
	int 			line_style	= LineOnOffDash;
	int 			cap_style	= CapRound;
	int				join_style	= JoinRound;
	int				dash_offset	= 0;
	static char		dash_list[]	= { 12, 24 };
	int				list_length	= 2;

	*gc = XCreateGC(display, win, valuemask, &values);

	XSetFont(display, *gc, font_info->fid);
	XSetForeground(display, *gc, BlackPixel(display,screen_num));
	XSetLineAttributes(display, *gc, line_width, line_style,
			cap_style, join_style);
	XSetDashes(display, *gc, dash_offset, dash_list, list_length);
}
#endif

#ifndef MACOSX
void load_font(XFontStruct **font_info)
{
	char *fontname = "9x15";
	if( (*font_info = XLoadQueryFont(display,fontname)) == NULL )
	{
		(void) fprintf( stderr, "%s: Cannot open 9x15 font\n",
			   progname);
		exit( -1 );
	}
}
#endif

#ifndef MACOSX
void draw_text(Window win, GC gc, XFontStruct *font_info, unsigned int win_width,
	unsigned int win_height)
{
	char*	strText = "Initializing installation program...";
	int 	nLen,
			nWidth;
	char	cd_height[50];
	int		font_height;

	nLen		= strlen( strText );
	nWidth		= XTextWidth( font_info, strText, nLen );
	font_height	= font_info->ascent + font_info->descent;

	XDrawString( display, win, gc, (win_width - nWidth)/2,
				 (win_height - font_height) / 2, strText, nLen );
}
#endif

void SendEvent( long nEvent )
{
	NSEvent *pClient;
	NSPoint aPoint = {0, 0};

	pClient = [NSEvent otherEventWithType: NSApplicationDefined location: aPoint modifierFlags: 0 timestamp: [[NSDate date] timeIntervalSinceNow] windowNumber: 0 context: NULL subtype: 0 data1: nEvent data2: 0];
	[NSApp postEvent: pClient atStart: NO]; 
}

int main(int argc, char**argv)
{
#ifndef MACOSX
	unsigned int	width	= WINDOW_WIDTH;
	unsigned int	height	= WINDOW_HEIGHT;
	int 			x;
	int				y;
	unsigned int 	border_width	= 4;
	unsigned int 	display_width,
					display_height;
	unsigned int 	icon_width,
					icon_height;
	char*			window_name		= "StarDivision Setup";
	char*			icon_name		= "Setup";

	Pixmap 			icon_pixmap;
	XSizeHints 		size_hints;
	XIconSize*		size_list;
	int				count;
#endif
	NSEvent			*report;
#ifndef MACOSX
	GC				gc;
	XFontStruct*	font_info;
	int				window_size = BIG_ENOUGH;
#endif
	int nIdx;
	int i;


	progname = argv[0];

	if( argc > 1 && strncmp(argv[1], "-extract", 8) == 0 )
	{
		bExtractBIG = TRUE;
		if( argc > 2 )
			strcpy( strExtractPath, argv[2] );
	}

	if( !__getFullPath(progname, strAbsBinaryName, __MAX_PATH) )
	{
		fprintf( stderr, "%s: absolute program path cannot be found.\n", progname );
		exit(0);
	}

	nIdx = strlen( strAbsBinaryName );
	while( strAbsBinaryName[nIdx] != '/' )
	{
		if( nIdx == 0)
			break;
		else
			nIdx--;
	}
	strncpy( strInitPath, strAbsBinaryName, nIdx );

#ifndef MACOSX
	if ( (display=XOpenDisplay(display_name)) == NULL )
	{
		(void) fprintf( stderr, "%s: cannot connect to X server %s\n",
				progname, XDisplayName(display_name) );
		exit( -1 );
	}

	screen_num		= DefaultScreen(display);
	display_width	= DisplayWidth(display, screen_num);
	display_height	= DisplayHeight(display, screen_num);

	x = (display_width - WINDOW_WIDTH) / 2;
	y = (display_height - WINDOW_HEIGHT) / 2;


	win = XCreateSimpleWindow(display, RootWindow(display,screen_num),
			x, y, width, height, border_width, BlackPixel(display,
			screen_num), WhitePixel(display,screen_num));

	if (XGetIconSizes(display, RootWindow(display,screen_num),
			&size_list, &count) == 0)
	{
	}
	else
	{
	}

	/* Create pixmap of depth 1 (bitmap) for icon */
	icon_pixmap = XCreateBitmapFromData(display, win, icon_bitmap_bits,
			icon_bitmap_width, icon_bitmap_height);

	/* Set size hints for window manager.  The window manager may
	 * override these settings.  Note that in a real
	 * application if size or position were set by the user
	 * the flags would be UPosition and USize, and these would
	 * override the window manager's preferences for this window. */

#ifdef X11R3
	size_hints.flags		= PPosition | PSize | PMinSize;
	size_hints.x 			= x;
	size_hints.y			= y;
	size_hints.width		= width;
	size_hints.height		= height;
	size_hints.min_width	= WINDOW_WIDTH;
	size_hints.min_height	= WINDOW_HEIGHT;
#else /* X11R4 or later */
	size_hints.flags		= PPosition | PSize | PMinSize;
	size_hints.min_width	= WINDOW_WIDTH;
	size_hints.min_height	= WINDOW_HEIGHT;
#endif

#ifdef X11R3
	XSetStandardProperties( display, win, window_name, icon_name, icon_pixmap,
							argv, argc, &size_hints );
#else /* X11R4 or later */
	{
	XWMHints		wm_hints;
	XClassHint		class_hints;
	XTextProperty	windowName,
					iconName;

	if( XStringListToTextProperty(&window_name, 1, &windowName) == 0 )
	{
		(void) fprintf( stderr, "%s: structure allocation for windowName failed.\n",
						progname );
		exit(-1);
	}
	if( XStringListToTextProperty(&icon_name, 1, &iconName) == 0 )
	{
		(void) fprintf( stderr, "%s: structure allocation for iconName failed.\n",
						progname );
		exit(-1);
	}

	wm_hints.initial_state	= NormalState;
	wm_hints.input			= True;
	wm_hints.icon_pixmap	= icon_pixmap;
	wm_hints.flags			= StateHint | IconPixmapHint | InputHint;

	class_hints.res_name	= progname;
	class_hints.res_class	= "Setup";

	XSetWMProperties( display, win, &windowName, &iconName,
					  argv, argc, &size_hints, &wm_hints, &class_hints );
	}
#endif

	XSelectInput( display, win, ExposureMask | KeyPressMask | ButtonPressMask |
				  StructureNotifyMask );
	load_font( &font_info );
	getGC( win, &gc, font_info );

/*	XMapWindow( display, win );
	draw_text(win, gc, font_info, width, height);
	XFlush(display);
*/

#endif

	pReleasePool = [[NSAutoreleasePool alloc] init];
	[NSApplication sharedApplication];

	SendEvent( SETUP_EVENT_TIME_TO_START );
	while( 1 )
	{
		report = [NSApp nextEventMatchingMask: NSAnyEventMask untilDate: NULL inMode: NSDefaultRunLoopMode dequeue: YES];

		switch( [report type] )
		{
			case NSApplicationDefined:
				switch( [report data1] )
				{
					case SETUP_EVENT_TIME_TO_START :
						SendEvent( SETUP_EVENT_INSTALL_SETUP );
						break;

					case SETUP_EVENT_INSTALL_SETUP :
						nSetupSize = atol( &(strExePatch[8]) );
						if( !nSetupSize )
							InstallSetupFile( NULL );
						else
							InstallBigSetupFile();
						break;

					case SETUP_EVENT_KILL_LOADER_WINDOW :
						SendEvent( SETUP_EVENT_START_SETUP );
						break;

					case SETUP_EVENT_START_SETUP : {
						int nFrom = 1;
						for( i = nFrom; i < argc; ++i )
						{
							strcat( strSetupBIN, " " );
							strcat( strSetupBIN, argv[i] );
						}
						system( strSetupBIN );
						SendEvent( SETUP_EVENT_EXIT_LOADER );
					} break;

					case SETUP_EVENT_EXIT_LOADER :
						KillSetupDir();

#ifndef MACOSX
						XUnloadFont( display, font_info->fid );
						XFreeGC( display, gc );
						XCloseDisplay( display );
#endif
						exit(1);
						break;
				}
				break;

#ifndef MACOSX
			case Expose:
				if (report.xexpose.count != 0)
					break;
				if( window_size != TOO_SMALL )
					draw_text( win, gc, font_info, width, height );
				break;

			case ConfigureNotify:
				width	= report.xconfigure.width;
				height	= report.xconfigure.height;

				if( (width < size_hints.min_width) ||
					(height < size_hints.min_height) )
					window_size = TOO_SMALL;
				else
					window_size = BIG_ENOUGH;
				break;
#endif

			default:
				break;
		}
	}

	exit(1);
}

/*****************************************************************************/
/* getFullPath */
/*****************************************************************************/

BOOL __getFullPath(const char* pszFilename, char* pszPath, unsigned long MaxLen)
{
	int   n;
	char* pBuffer;
	char* pDir;
	struct stat status;
	struct stat root;
	struct stat parent;
	char  Path[PATH_MAX + 1];

	pDir = strdup(pszFilename);

	/* check if path has a trailing '/', so it should specify a directory, */
		/* or if last component doesn't exist or is not a directory. So in any case */
	/* of this the last component should be remove before checking the path */
	if ((pDir[strlen(pDir) - 1] == '/') ||
		(stat(pDir, &status) < 0) || (! S_ISDIR(status.st_mode)))
	{
		char* pFile;

		if ((pFile = strrchr(pDir, '/')) != NULL)
		{
			*pFile++ = '\0';
			strcpy(Path, pFile);
			strcat(Path, "/");
		}
		else
		{
			strcpy(Path, pDir);
			strcat(Path, "/");
			free(pDir);
			pDir = strdup(".");
		}

		if ((strlen(pDir) > 0) &&
			((stat(pDir, &status) < 0) || (! S_ISDIR(status.st_mode))))
		{
			free(pDir);
			return (FALSE);
		}
	}
	else
		Path[0] = '\0';

	if ((n = pathconf(pDir, PATH_MAX)) < 0)
		n = PATH_MAX + 1;

	pBuffer = (char *)malloc((n + 1) * sizeof(char));
	strcpy(pBuffer, pDir);

	stat("/", &root);

	strcat(pBuffer, "/.");
	stat(pBuffer, &status);
	strcat(pBuffer, ".");

	while ((status.st_dev != root.st_dev) || (status.st_ino != root.st_ino))
	{
		DIR*		   dir;
		struct dirent* entry;

		if (((dir = opendir(pBuffer)) == NULL) ||
			(stat(pBuffer, &parent) < 0))
		{
			free(pDir);
			free(pBuffer);

			return (FALSE);
		}

		if (status.st_dev == parent.st_dev)
		{
			do
			{
				if ((entry = readdir(dir)) == NULL)
				{
					free(pDir);
					free(pBuffer);

					return (FALSE);
				}
			}
			while (entry->d_ino != status.st_ino);
		}
		else
		{
			/*
			 * if this point is a mount point we have to check
			 * each entry, because the inode number in the directory
			 * is for the parent directory, not for the mounted file
			 */
			char* full = (char *)malloc((strlen(pBuffer) + PATH_MAX + 1) * sizeof(char));
			char* name;

			strcpy(full, pBuffer);
			strcat(full, "/");
			name = full + strlen(full);

			do
			{
				if ((entry = readdir(dir)) == NULL)
				{
					free(full);

					free(pDir);
					free(pBuffer);

					return (FALSE);
				}

				if ((entry->d_name[0] == '.') && ((entry->d_name[1] == '\0') ||
					((entry->d_name[1] == '.') && (entry->d_name[2] == '\0'))))
					continue;

				strcpy(name, entry->d_name);

				if (stat(full, &parent) < 0)
					continue;
			}
			while ((parent.st_ino != status.st_ino) || (parent.st_dev != status.st_dev));

			free(full);
		}

		strcat(Path, entry->d_name);
		strcat(Path, "/");

		closedir(dir);

		stat(pBuffer, &status);
		strcat(pBuffer, "/..");
	}

	free(pDir);
	free(pBuffer);

	if (strlen(Path) < MaxLen)
	{
		int  n;
		char *p, *l;

		for (p = Path + strlen(Path), l = p; p >= Path; p--)
		{
			if (*p == '/')
			{
				n = l - (p + 1);
				memcpy(pszPath, p + 1, n);
				pszPath += n;
				*pszPath++ = '/';
				l = p;
			}
		}

		n = l - (p + 1);
		memcpy(pszPath, p + 1, n);
		pszPath += n;
		*pszPath = '\0';

		return (TRUE);
	}

	return (FALSE);
}

