/*************************************************************************
 *
 *  $RCSfile: GetVolumeInformation.c,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: hro $ $Date: 2001/07/30 14:38:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>
#include <systools/win32/StrConvert.h>

#include "GetVolumeInformation.h"



// Unicode wrapper of GetVolumeInformationW for Win9x

BOOL WINAPI GetVolumeInformationW_9x(
	LPCWSTR	lpRootPathName,				// root directory
	LPWSTR	lpVolumeNameBuffer,			// volume name buffer
	DWORD	nVolumeNameSize,			// length of name buffer
	LPDWORD	lpVolumeSerialNumber,		// volume serial number
	LPDWORD	lpMaximumComponentLength,	// maximum file name length
	LPDWORD	lpFileSystemFlags,			// file system options
	LPWSTR	lpFileSystemName,			// file system name buffer
	DWORD	nFileSystemNameSize			// length of file system name buffer
)
{
	LPSTR	lpRootPathNameA = NULL;
	LPSTR	lpVolumeNameBufferA = NULL;
	LPSTR	lpFileSystemNameA = NULL;
	BOOL	fSuccess;

	AllocNecessarySpaceAndCopyWStr2Str( lpRootPathName, &lpRootPathNameA );

	if ( lpVolumeNameBuffer )
		lpVolumeNameBufferA = (LPSTR)HeapAlloc( GetProcessHeap(), 0, sizeof(CHAR) * nVolumeNameSize );

	if ( lpFileSystemName )
		lpFileSystemNameA = (LPSTR)HeapAlloc( GetProcessHeap(), 0, sizeof(CHAR) * nFileSystemNameSize );

	fSuccess = GetVolumeInformationA( lpRootPathNameA,  
		lpVolumeNameBufferA,
		nVolumeNameSize,
		lpVolumeSerialNumber,
		lpMaximumComponentLength,
		lpFileSystemFlags,
		lpFileSystemNameA,
		nFileSystemNameSize
		);

	if ( lpVolumeNameBufferA )
	{
		MultiByteToWideChar( CP_ACP, 0, lpVolumeNameBufferA, -1, lpVolumeNameBuffer, nVolumeNameSize );
		HeapFree( GetProcessHeap(), 0, lpVolumeNameBufferA );
	}

	if ( lpFileSystemNameA )
	{
		MultiByteToWideChar( CP_ACP, 0, lpFileSystemNameA, -1, lpFileSystemName, nFileSystemNameSize );
		HeapFree( GetProcessHeap(), 0, lpFileSystemNameA );
	}

	FreeSpaceStr( lpRootPathNameA );

	return fSuccess;
}
