/*************************************************************************
 *
 *  $RCSfile: socket.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __SOCKET_HXX
#define __SOCKET_HXX

#ifndef __BASE_HXX
#include "base.hxx"
#endif

#ifndef __SEMAPHOR_HXX
#include "semaphor.hxx"
#endif

#include <windows.h>
#include <winsock.h>

#define SAL_SOCKET_CLASSNAME         "SALSocketMessageWindowClass16"
#define SAL_SOCKET_WINDOWNAME        "SALSocketMessageWindow"

#define WM_WSAUSER		(WM_USER + 200)
#define WM_WSASELECT	(WM_WSAUSER + 101)
#define WM_WSAASYNC		(WM_WSAUSER + 201)

#define WSAENOERROR 0L

#define FD_ALL (FD_READ | FD_WRITE | FD_OOB | FD_CLOSE | FD_CONNECT | FD_ACCEPT)

#define INPORT_ANY  0x0000
#define INPORT_FTP  0x0015
#define INPORT_HTTP 0x0050
#define INPORT_NEWS 0x0075
#define INPORT_POP3 0x006E
#define INPORT_SMTP 0x0019
#define INPORT_IMAP 0x008F
#define INPORT_NONE 0xFFFF


// Maximale Anzahl der Daten, die am Stueck auf einem Socket uebertragen werden koennen
#define MAX_TCP_BUFFER_SIZE	16384

//////////////////////////////////////////////////////////////////////////////
//
//	SALSocketAddress
//
//////////////////////////////////////////////////////////////////////////////

struct SALSocketAddress
{
protected:
	union {
		SOCKADDR	maSockAddr;
		SOCKADDR_IN	maInetAddr;
	} maImplData;
public:
	SALSocketAddress();
	SALSocketAddress(unsigned short nFamily);

	const SOCKADDR *getSockAddr() const {return &maImplData.maSockAddr;}

	unsigned short getFamily() const {return maImplData.maSockAddr.sa_family;}	
};

//////////////////////////////////////////////////////////////////////////////
//
//	SALInetAddress
//
//////////////////////////////////////////////////////////////////////////////

struct SALInetAddress : public SALSocketAddress
{
	SALInetAddress(short nFamily);
	
	const SOCKADDR_IN *getInetAddr() const {return &maImplData.maInetAddr;}
	operator const sal_Char *();

	short	getFamily() const {return maImplData.maInetAddr.sin_family;}	
	unsigned short	getPort() const;
	unsigned long	getHost() const;
	unsigned short	setPort(unsigned short nPort);
	unsigned long	setHost(unsigned long nHost);
	unsigned long	setHost(const sal_Char *pszDottedHost);
};

//////////////////////////////////////////////////////////////////////////////
//
//	SALHostAddress
//
//////////////////////////////////////////////////////////////////////////////

struct SALHostAddress
{
protected:
	SALSocketAddress	maHostAddr;
	sal_Char				*mpszHostName;

	friend SALHostAddress *ResolveHostName(const sal_Char *pszHost);
	friend SALHostAddress *ResolveHostAddress(unsigned long nHost);
	
public:
	SALHostAddress();
	~SALHostAddress();
	SALHostAddress(const sal_Char *, unsigned long nHost);
	SALHostAddress(const sal_Char *, const SALSocketAddress &rAddr);
	
	const sal_Char *getName() const {return mpszHostName;}
	const SALSocketAddress *getAddress() const {return &maHostAddr;}

	operator const sal_Char *() {return getName();}
};

SALHostAddress *ResolveHostName(const sal_Char *pszHost);
SALHostAddress *ResolveHostAddress(unsigned long nInetHost);
SALHostAddress *ResolveHostAddress(const SALInetAddress &);

SALHostAddress *GetLocalHost();

short GetServicePort(const sal_Char *pszServiceName, const sal_Char *pszProtocol);

//////////////////////////////////////////////////////////////////////////////
//
//	SALSocket
//
//////////////////////////////////////////////////////////////////////////////

class SALSocketQueue;
class SALSocketSet;

class SALSocket : public SALItem
{
public:
    SALSocket(int nFamily = PF_INET, int nType = SOCK_STREAM, int nProtocol = 0);
	SALSocket(const SALSocketAddress &);
	SALSocket(SOCKET s);
	
    virtual ~SALSocket();

	BOOL isValid() const {return mbValid;}

	int getAddresses(SALSocketAddress *pLocalAddr, SALSocketAddress *pRemoteAddr);

	int bind(const SALSocketAddress &);
	int listen(int backlog = SOMAXCONN);
	SALSocket *accept(SALSocketAddress *pAddr);
    int connect(const SALSocketAddress &rAddr, unsigned long milliseconds);
    int send(const void *buf, int len, int flags = 0);
	int send(const SALSocket &rSocket, const void *buf, int len, int flags = 0);
    int receive(void *buf, int len, int flags = 0);
	int receive(SALSocketAddress &rSocketAddr, void *buf, int len, int flags = 0);
	int cancel();
	int shutdown(int dir = 2);
	int select(SALSocketSet &, SALSocketSet &, SALSocketSet &, unsigned long milliseconds);

	int getError() const {return mnError;}

    void setBlocking(BOOL bBlocking) {mbBlocking = bBlocking;}
    BOOL isBlocking() const {return mbBlocking;}

    void registerWriteCondition();
    void unregisterWriteCondition();
    void registerReadCondition();
    void unregisterReadCondition();

    STATUS waitReadCondition(unsigned long milliseconds)
   	{ return mpReadCondition ? mpReadCondition->wait(milliseconds) : STATUS_ERROR; }
    STATUS waitWriteCondition(unsigned long milliseconds)
   	{ return mpWriteCondition ? mpWriteCondition->wait(milliseconds) : STATUS_ERROR; }

	int readOption(int nLevel, int nOption, void *pBuffer, int nBufSize);
	int writeOption(int nLevel, int nOption, const void *pBuffer, int nBufSize);

	int getType();

public:
    SALSocket *next() const {return (SALSocket *)nextItem();}
    SALSocket *prev() const {return (SALSocket *)prevItem();}
    SALSocketQueue *queue() const {return (SALSocketQueue *)getQueue();}

    SOCKET			mnSocket;

protected:
    BOOL				mbBlocking;
    SALCondition	*mpReadCondition;
    SALCondition	*mpWriteCondition;
    LONG				mnEvent;
    int		  		mnError;
    BOOL				mbValid;


	void setError(int nError);


	static SALSocket *findPendingSocket(SOCKET nSocket);

public:
	static HWND	ghWindow;
	static HWND getWindowHandle();
	static BOOL	handleWSASelect(SOCKET nSocket, UINT nEvent, UINT nError);
	static BOOL handleWSAAsync(HTASK hTask, UINT nBufLen, UINT nError);
	static LRESULT	CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wPara, LPARAM lParam);
   static SALSocketQueue   gaWSASocketQueue;
};

DECLARE_ITEMQUEUE(SALSocket);

inline int GetLastSocketError()
{
	return WSAGetLastError();
}

//////////////////////////////////////////////////////////////////////////////
//
//	SALSocketSet
//
//////////////////////////////////////////////////////////////////////////////

class SALSocketSet
{
protected:
	fd_set	m_Set;
public:
	SALSocketSet();

	void add(const SALSocket &);
	void remove(const SALSocket &);
	void clear();
	BOOL contains(const SALSocket &);
};

#endif

	

