/*************************************************************************
 *
 *  $RCSfile: _XSpreadsheetView.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change:$Date: 2003/01/27 18:12:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package ifc.sheet;

import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetView;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

/**
* Testing <code>com.sun.star.sheet.XSpreadsheetView</code>
* interface methods :
* <ul>
*  <li><code> getActiveSheet()</code></li>
*  <li><code> setActiveSheet()</code></li>
* </ul> <p>
* This test needs the following object relations :
* <ul>
*  <li> <code>'Sheet'</code> (of type <code>XSpreadsheet</code>):
*   to set new active spreadsheet </li>
* <ul> <p>
* @see com.sun.star.sheet.XSpreadsheetView
*/
public class _XSpreadsheetView extends MultiMethodTest {

    public XSpreadsheetView oObj = null;
    public XSpreadsheet oSheet = null;

    /**
    * Test calls the method, stores and checks returned value. <p>
    * Has <b> OK </b> status if returned value isn't null. <p>
    */
    public void _getActiveSheet() {
        oSheet = oObj.getActiveSheet();
        tRes.tested("getActiveSheet()", oSheet != null);
    }

    /**
    * Test sets new active sheet that was obtained by relation
    * <code>'Sheet'</code>, gets the current active sheet and compares
    * returned value with value that was stored by method
    * <code>getFilterFields()</code>. <p>
    * Has <b> OK </b> status if values aren't equal. <p>
    * The following method tests are to be completed successfully before :
    * <ul>
    *  <li> <code> getActiveSheet() </code> : to have the current
    *  active sheet </li>
    * </ul>
    */
    public void _setActiveSheet() {
        requiredMethod("getActiveSheet()");

        XSpreadsheet new_Sheet = (XSpreadsheet)tEnv.getObjRelation("Sheet");
        if (new_Sheet == null) throw new StatusException(Status.failed
            ("Relation 'Sheet' not found"));

        oObj.setActiveSheet(new_Sheet);
        new_Sheet = oObj.getActiveSheet();
        tRes.tested("setActiveSheet()", !oSheet.equals(new_Sheet));
    }


}  // finish class _XSpreadsheetView


