#*************************************************************************
#
#   $RCSfile: vc70_patch.pl,v $
#
#   $Revision: 1.2.2.1 $
#
#   last change: $Author: hr $ $Date: 2004/01/09 18:23:20 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

# patch vcproj for net2002
# workaround for a bug in the dsp->vcproj

###### "project name" => "library name"
%proj2patch= ("_sre" => "_sre","_socket" => "_socket","_symtable" =>"_symtable","mmap" => "mmap","parser" => "parser","select" => "select","unicodedata" => "unicodedata","winreg" => "_winreg","winsound" => "winsound");

###### hard coded globals
$AddOpt_Ident = "AdditionalOptions=\"/MACHINE:I386\""; # Identifier

# ActiveState Perl uses Backslashes on WNT
if ( $^O eq 'MSWin32') {
	$dirsep = "\\";
} else {
	$dirsep = "/";
}

###### main #####
( my $script_name = $0 ) =~ s/^.*\b(\w+)\.pl$/$1/;

&usage() if ( $#ARGV != 0 );

my $target_dir = shift;
foreach $proj (sort keys %proj2patch)
{
	  &patch_vcproj( $proj, $proj2patch{$proj} );
}


###### subs #####
sub patch_vcproj
{
	my $project = shift;
	my $libname = shift;

	my $prj_file = $target_dir.$dirsep.$project."\.vcproj";
	my $orig_prj_file = $prj_file . "\.orig";
	my $tmp_out_file = $prj_file . "\.tmp";
	my $add_export_option = "/export\:init$libname";
	my $line;
	print "Patching file:$prj_file\n";
	if ( ! -e $orig_prj_file ) {     # do nothing if already patched!
		open(IN,"<$prj_file") || die "Can't open $prj_file!\n";
		open(OUT,">$tmp_out_file") || die "Can't open $tmp_out_file\n";
		while ( $line = <IN> ) {
			$line =~ s/\"\r?$/ $add_export_option\"/ if ( $line =~ /$AddOpt_Ident/g ) ;
			print OUT $line;
		}
		close(IN);
		close(OUT);
		rename($prj_file, $orig_prj_file);
		rename($tmp_out_file, $prj_file);
	}
}

############################################################################
sub usage		#29.10.2003 13:05
############################################################################
 {
	print "Usage: $script_name <target dirctory>\n";
	exit(0);
}	##usage


