#!/bin/sh

CONVERTDIR=$2

# solaris awk cannot deal with oct chars
if [ "$OS" = "SOLARIS" ]; then
    awk=nawk
else
    awk=awk
fi

if [ "$1" = "unx" ]; then
    for file in $CONVERTDIR/*.ds?; do
        mv $file ${file}_tmp
        cat ${file}_tmp | tr -d "\015" > $file
        rm ${file}_tmp
    done
fi

if [ "$1" = "dos" ]; then
    for file in $CONVERTDIR/*.ds?; do
        mv $file ${file}_tmp
        cat ${file}_tmp | $awk '{print $0"\015";}' > $file
        rm ${file}_tmp
    done
fi
