/*************************************************************************
 *
 *  $RCSfile: dbbrowse.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 15:41:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop
#include "dbbrowse.hxx"
#include "dbbrowse.hrc"

#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _TOOLS_RESID_HXX //autogen
#include <tools/resid.hxx>
#endif

#include <algorithm>

extern ResMgr* pResMgr;

//==================================================================

#define HANDLE_ID	0

//==================================================================

//------------------------------------------------------------------------------
void DbBrowseBox::BrowserMouseEventPtr::Clear()
{
	DELETEZ(pEvent);
}

//------------------------------------------------------------------------------
void DbBrowseBox::BrowserMouseEventPtr::Set(const BrowserMouseEvent* pEvt, BOOL bIsDown)
{
	if (pEvt == pEvent)
	{
		bDown = bIsDown;
		return;
	}
	Clear();
	if (pEvt)
	{
		pEvent = new BrowserMouseEvent(pEvt->GetWindow(),
									   *pEvt,
									   pEvt->GetRow(),
									   pEvt->GetColumn(),
									   pEvt->GetColumnId(),
									   pEvt->GetRect());
		bDown = bIsDown;
	}
}

//------------------------------------------------------------------------------
DbBrowseBox::DbBrowseBox(Window* pParent, const ResId& rId, BrowserMode nMode)
			  :BrowseBox(pParent, rId, nMode)
			  ,aStatusList(ResId(RID_IMGLIST_DBBRW, pResMgr))
			  ,nEditRow(-1)
			  ,nOldEditRow(-1)
			  ,nEditCol(0)
			  ,nOldEditCol(0)
			  ,bHasFocus(FALSE)
			  ,nStartEvent(0)
			  ,nEndEvent(0)
			  ,nCellModifiedEvent(0)
{
	SetLineColor(Color(COL_LIGHTGRAY));

	//////////////////////////////////////////////////////////////////////
	// HACK: BrowseBox invalidiert nicht ihre Childs, wie es eigentlich sein sollte.
	// Deshalb wird WB_CLIPCHILDREN zurueckgesetzt, wodurch das Invalidieren
	// der Childs erzwungen wird.
	WinBits aStyle = GetStyle();
	if( aStyle & WB_CLIPCHILDREN )
	{
		aStyle &= ~WB_CLIPCHILDREN;
		SetStyle( aStyle );
	}
}

//==================================================================
DbBrowseBox::DbBrowseBox(Window* pParent, WinBits nBits, BrowserMode nMode)
			  :BrowseBox(pParent, nBits, nMode)
			  ,aStatusList(ResId(RID_IMGLIST_DBBRW, pResMgr))
			  ,nEditRow(-1)
			  ,nOldEditRow(-1)
			  ,nEditCol(0)
			  ,nOldEditCol(0)
			  ,bHasFocus(FALSE)
			  ,nStartEvent(0)
			  ,nEndEvent(0)
			  ,nCellModifiedEvent(0)
{
	SetLineColor(Color(COL_LIGHTGRAY));

	//////////////////////////////////////////////////////////////////////
	// HACK: BrowseBox invalidiert nicht ihre Childs, wie es eigentlich sein sollte.
	// Deshalb wird WB_CLIPCHILDREN zurueckgesetzt, wodurch das Invalidieren
	// der Childs erzwungen wird.
	WinBits aStyle = GetStyle();
	if( aStyle & WB_CLIPCHILDREN )
	{
		aStyle &= ~WB_CLIPCHILDREN;
		SetStyle( aStyle );
	}
}

//------------------------------------------------------------------------------
DbBrowseBox::~DbBrowseBox()
{
	if (nStartEvent)
		Application::RemoveUserEvent(nStartEvent);
	if (nEndEvent)
		Application::RemoveUserEvent(nEndEvent);
	if (nCellModifiedEvent)
		Application::RemoveUserEvent(nCellModifiedEvent);
}

//------------------------------------------------------------------------------
void DbBrowseBox::LoseFocus()
{
	BrowseBox::LoseFocus();
	DetermineFocus();
}

//------------------------------------------------------------------------------
void DbBrowseBox::GetFocus()
{
	BrowseBox::GetFocus();
	// Dieses sollte den Fall abdecken, da die BrowseBox oder eines ihrer Controls
	// von auerhalb per Tab den Focus erhalten soll.
	if (!bHasFocus && HasFocus() && IsEditing())
		Controller()->GetWindow().GrabFocus();

	DetermineFocus();
}

//------------------------------------------------------------------------------
void DbBrowseBox::DetermineFocus()
{
	BOOL bFocus = FALSE;
	for (Window* pWindow = Application::GetFocusWindow();
		 pWindow && !bFocus;
		 pWindow = pWindow->GetParent())
		 bFocus = pWindow == this;

	if (bFocus != bHasFocus)
		bHasFocus = bFocus;
}

//------------------------------------------------------------------------------
void DbBrowseBox::InvalidateRow(long nRow)
{
	Rectangle aRect = GetFieldRectPixel(nRow, 0, TRUE);
	aRect.Union(GetFieldRectPixel(nRow, GetColumnId(ColCount()-1), TRUE));
	Invalidate(aRect);
};

//------------------------------------------------------------------------------
IMPL_LINK(DbBrowseBox, StartEditHdl, void*, EMPTYTAG)
{
	nStartEvent = 0;
	if (IsEditing())
	{
		aController->GetWindow().Show();
		aController->GetWindow().GrabFocus();
	}
	return 0;
}

//------------------------------------------------------------------------------
void DbBrowseBox::PaintField( OutputDevice& rDev, const Rectangle& rRect,
								USHORT nColumnId ) const
{
	if (nColumnId == HANDLE_ID)
		PaintStatusCell(rDev, rRect);
	else
		PaintCell(rDev, rRect, nColumnId);
}

//------------------------------------------------------------------------------
Image DbBrowseBox::GetImage(RowStatus eStatus) const
{
	Image aImage;
	switch (eStatus)
	{
		case CURRENT:
			aImage = aStatusList.GetImage(IMG_DBBRW_CURRENT);
			break;
		case CURRENTNEW:
			aImage = aStatusList.GetImage(IMG_DBBRW_CURRENTNEW);
			break;
		case MODIFIED:
			aImage = aStatusList.GetImage(IMG_DBBRW_MODIFIED);
			break;
		case NEW:
			aImage = aStatusList.GetImage(IMG_DBBRW_NEW);
			break;
		case DELETED:
			aImage = aStatusList.GetImage(IMG_DBBRW_DELETED);
			break;
		case PRIMARYKEY:
			aImage = aStatusList.GetImage(IMG_DBBRW_PRIMARYKEY);
			break;
		case CURRENT_PRIMARYKEY:
			aImage = aStatusList.GetImage(IMG_DBBRW_CURRENT_PRIMARYKEY);
			break;
	}
	return aImage;
}

//------------------------------------------------------------------------------
void DbBrowseBox::PaintStatusCell(OutputDevice& rDev, const Rectangle& rRect) const
{
	USHORT nRow = (USHORT)GetRowAtYPosPixel( rRect.Top(), FALSE );
	if( nRow<0 )
		return;
	RowStatus eStatus = GetRowStatus( nRow );
	if ( eStatus == CLEAN )
		return;
	Image aImage(GetImage(eStatus));

	DBG_ASSERT(rDev.GetOutDevType() == OUTDEV_WINDOW, "Falsches Device!");
	Window& rWin = (Window&) rDev;

	// ImagePosition berechnen
	Size aImageSize(aStatusList.GetImageSize());
	Point aPos(rRect.TopLeft());

	if (aImageSize.Width() > rRect.GetWidth() ||
		aImageSize.Height() > rRect.GetHeight())
		rDev.SetClipRegion(rRect);

	if (aImageSize.Width() < rRect.GetWidth())
		aPos.X() += (rRect.GetWidth() - aImageSize.Width()) / 2;

	rWin.DrawImage(aPos, aImage);

	if (rDev.IsClipRegion())
		rDev.SetClipRegion();
}

//------------------------------------------------------------------------------
DbBrowseBox::RowStatus DbBrowseBox::GetRowStatus(long nRow) const
{
	return CLEAN;
}

//------------------------------------------------------------------------------
void DbBrowseBox::KeyInput( const KeyEvent& rEvt )
{
	USHORT nCode = rEvt.GetKeyCode().GetCode();
	BOOL   bShift = rEvt.GetKeyCode().IsShift();
	BOOL   bCtrl = rEvt.GetKeyCode().IsMod1();
	USHORT nId = BROWSER_NONE;

	if (!bCtrl && !bShift && nCode == KEY_TAB)
		Dispatch(BROWSER_CURSORRIGHT);
	else if (!bCtrl && bShift && nCode == KEY_TAB)
		Dispatch(BROWSER_CURSORLEFT);
	else
		BrowseBox::KeyInput(rEvt);
}

//------------------------------------------------------------------------------
void DbBrowseBox::MouseButtonDown(const BrowserMouseEvent& rEvt)
{
	USHORT	nColId = rEvt.GetColumnId();
	USHORT  nColPos = GetColumnPos( nColId );
	long	nRow = rEvt.GetRow();

	if (nRow > GetRowCount() || nColPos > ColCount()) // im ungueltigen Bereich
		return;

	// double clicks schlucken
	if (rEvt.GetClicks() > 1 && rEvt.GetRow() >= 0)
		return;
	aMouseEvent.Set(&rEvt,TRUE);
	BrowseBox::MouseButtonDown(rEvt);
}

//------------------------------------------------------------------------------
void DbBrowseBox::MouseButtonUp( const BrowserMouseEvent& rEvt )
{
	USHORT	nColId = rEvt.GetColumnId();
	USHORT  nColPos = GetColumnPos( nColId );
	long	nRow = rEvt.GetRow();

	if (nRow > GetRowCount() || nColPos > ColCount()) // im ungueltigen Bereich
		return;

	// double clicks schlucken
	if (rEvt.GetClicks() > 1 && rEvt.GetRow() >= 0)
		return;

	aMouseEvent.Set(&rEvt,FALSE);
	BrowseBox::MouseButtonUp(rEvt);
	aMouseEvent.Clear();

	if (!IsEditing())
		ActivateCell();

	if (IsEditing() && aController->WantMouseEvent())	   // weitergeben des Ereignisses an das Control
	{
		// Falls das Feld vorher verschoben wurde, muessen die Koordinaten angepat werden
		// keine Selektion zulassen
		aController->GetWindow().GrabFocus();
		Point aPos = rEvt.GetPosPixel() - rEvt.GetRect().TopLeft();
		MouseEvent aEvent(aPos, rEvt.GetClicks(), rEvt.GetMode(),
						  rEvt.GetButtons(),
						  rEvt.GetModifier());

		aController->GetWindow().MouseButtonDown(aEvent);
		aController->GetWindow().MouseButtonUp(aEvent);

		Window *pWin = &aController->GetWindow();
		if (!pWin->IsTracking())
		{
			for (pWin = pWin->GetWindow(WINDOW_FIRSTCHILD);
				 pWin && !pWin->IsTracking();
				 pWin = pWin->GetWindow(WINDOW_NEXT))
				 {}
		}
		if (pWin && pWin->IsTracking())
			pWin->EndTracking();
	}
}

//------------------------------------------------------------------------------
long DbBrowseBox::PreParentNotify(NotifyEvent& rEvt)
{
	switch (rEvt.GetType())
	{
		case EVENT_KEYINPUT:
			if (IsEditing())
			{
				const KeyEvent* pKeyEvent =	rEvt.GetKeyEvent();
				USHORT nCode = pKeyEvent->GetKeyCode().GetCode();
				BOOL   bShift = pKeyEvent->GetKeyCode().IsShift();
				BOOL   bCtrl = pKeyEvent->GetKeyCode().IsMod1();
				USHORT nId = BROWSER_NONE;

				if ( !bCtrl && !bShift )
					switch ( nCode )
					{
						case KEY_DOWN:          nId = BROWSER_CURSORDOWN; break;
						case KEY_UP:            nId = BROWSER_CURSORUP; break;
						case KEY_PAGEDOWN:      nId = BROWSER_CURSORPAGEDOWN; break;
						case KEY_PAGEUP:        nId = BROWSER_CURSORPAGEUP; break;
						case KEY_HOME:          nId = BROWSER_CURSORHOME; break;
						case KEY_END:           nId = BROWSER_CURSOREND; break;
						case KEY_TAB:
						case KEY_RIGHT:         nId = BROWSER_CURSORRIGHT; break;
						case KEY_LEFT:          nId = BROWSER_CURSORLEFT; break;
					}

				if ( !bCtrl && bShift )
					switch ( nCode )
					{
						case KEY_DOWN:          nId = BROWSER_SELECTDOWN; break;
						case KEY_UP:            nId = BROWSER_SELECTUP; break;
						case KEY_TAB:			nId = BROWSER_CURSORLEFT; break;
					}


				if ( bCtrl && !bShift )
					switch ( nCode )
					{
						case KEY_DOWN:          nId = BROWSER_SCROLLUP; break;
						case KEY_UP:            nId = BROWSER_SCROLLDOWN; break;
						case KEY_PAGEDOWN:      nId = BROWSER_CURSORENDOFFILE; break;
						case KEY_PAGEUP:        nId = BROWSER_CURSORTOPOFFILE; break;
						case KEY_HOME:          nId = BROWSER_CURSORTOPOFSCREEN; break;
						case KEY_END:           nId = BROWSER_CURSORENDOFSCREEN; break;
					}


				if (nId != BROWSER_NONE && aController->MoveAllowed(*pKeyEvent))
				{
					Dispatch(nId);
					return 1;
				}
			}
			break;
	}
	return BrowseBox::PreParentNotify(rEvt);
}


//------------------------------------------------------------------------------
long DbBrowseBox::ParentNotify(NotifyEvent& rEvt)
{
	switch (rEvt.GetType())
	{
		case EVENT_GETFOCUS:
		case EVENT_LOSEFOCUS:
			DetermineFocus();
	}
	return BrowseBox::ParentNotify(rEvt);
}

//------------------------------------------------------------------------------
BOOL DbBrowseBox::IsCursorMoveAllowed(long nNewRow, USHORT nNewColId) const
{
	USHORT nInfo = 0;

	if (GetSelectColumnCount() || (aMouseEvent.Is() && aMouseEvent->GetRow() < 0))
		nInfo |= COLSELECT;
	if ((GetSelection() != NULL && GetSelectRowCount()) ||
		(aMouseEvent.Is() && aMouseEvent->GetColumnId() == HANDLE_ID))
		nInfo |= ROWSELECT;
	if (!nInfo && nNewRow != nEditRow)
		nInfo |= ROWCHANGE;
	if (!nInfo && nNewColId != nEditCol)
		nInfo |= COLCHANGE;

	if (nInfo == 0)	  // nichts passiert
		return TRUE;

	//////////////////////////////////////////////////////////////////////
	// Speichern eines Zellinhalts
	if (IsEditing() && aController->IsModified() && !((DbBrowseBox *) this)->SaveModified())
	{
		aController->GetWindow().GrabFocus();
		return FALSE;
	}

	if (IsModified() && !QueryDeactivation(nInfo))
	{
		if (nInfo & COLSELECT ||
			nInfo & ROWSELECT)
		{
			// selektion abbrechen
			((DbBrowseBox *) this)->SetNoSelection();
		}

		if (IsEditing())
			aController->GetWindow().GrabFocus();

		return FALSE;
	}

	((DbBrowseBox *) this)->DeactivateCell(nEditRow, nEditCol);

	((DbBrowseBox *) this)->CursorMoving(nNewRow, nNewColId);
	return TRUE;
}

//------------------------------------------------------------------------------
BOOL DbBrowseBox::QueryDeactivation(USHORT) const
{
	return TRUE;
}

//------------------------------------------------------------------------------
void DbBrowseBox::CursorMoving(long nNewRow, USHORT nNewCol)
{
}

//------------------------------------------------------------------------------
void DbBrowseBox::CursorMoved()
{
	long nNewRow = GetCurRow();
	if (nNewRow != nEditRow)	// Zeilenwechsel
	{
		if (nEditRow >= 0)
		{
			if (nEditRow < nNewRow)
			{
				InvalidateStatusCell(nEditRow);
				InvalidateStatusCell(nNewRow);
			}
			else
			{
				InvalidateStatusCell(nNewRow);
				InvalidateStatusCell(nEditRow);
			}
		}
		else
			InvalidateStatusCell(nNewRow);
	}
	ActivateCell();
}

//------------------------------------------------------------------------------
void DbBrowseBox::Select()
{
	if (!aMouseEvent.Is() &&
		((!GetSelectRowCount() || GetSelection() == NULL) && !GetSelectColumnCount()))

	{
		ActivateCell();
	}
}

//------------------------------------------------------------------------------
void DbBrowseBox::EndScroll()
{
	if (IsEditing())
	{
		Rectangle aRect = GetCellRect(nEditRow, nEditCol, FALSE);
		ResizeController(aController,aRect);
		if (nStartEvent)
			Application::RemoveUserEvent(nStartEvent);
		nStartEvent = Application::PostUserEvent(LINK(this,DbBrowseBox,StartEditHdl));
	}
	BrowseBox::EndScroll();
}

//------------------------------------------------------------------------------
void DbBrowseBox::ActivateCell(long nRow, USHORT nCol, BOOL bCellFocus)
{
	if (IsEditing())
		return;

	nEditCol = nCol;
	nEditRow = nRow;

	if ((GetSelectRowCount() && GetSelection() != NULL) || GetSelectColumnCount() ||
		(aMouseEvent.Is() && (aMouseEvent.IsDown() || aMouseEvent->GetClicks() > 1))) // bei MouseDown passiert noch nichts
	{
		return;
	}

	if (nEditRow >= 0 && nEditCol > HANDLE_ID)
	{
		aController = GetController(nRow, nCol);
		if (aController.Is())
		{
			Rectangle aRect = GetCellRect(nEditRow, nEditCol, FALSE);
			ResizeController(aController, aRect);

			InitController(aController, nEditRow, nEditCol);

			aController->ClearModified();
			aController->SetModifyHdl(LINK(this,DbBrowseBox,ModifyHdl));
			aController->GetWindow().Enable();
			aController->GetWindow().Show();

			// nur wenn der Browser den Focus hat, das Editfeld aktivieren
			if (bHasFocus && bCellFocus)
			{
				if (nStartEvent)
					Application::RemoveUserEvent(nStartEvent);
				nStartEvent = Application::PostUserEvent(LINK(this,DbBrowseBox,StartEditHdl));
			}
		}
	}
}

//------------------------------------------------------------------------------
void DbBrowseBox::DeactivateCell(long nRow, USHORT nCol)
{
	if (IsEditing())
	{
		GrabFocus();		// Sicherstellen, da der Focus behalten wird
		aController->GetWindow().Hide();
		aController->GetWindow().Disable();
		aController->SetModifyHdl(Link());

		// Das hidden Window wird neu gezeichnet
		Update();

		aOldController = aController;
		aController.Clear();

		nOldEditCol = nCol;
		nOldEditRow = nRow;

		nEndEvent = Application::PostUserEvent(LINK(this,DbBrowseBox,EndEditHdl));
	}
}


//------------------------------------------------------------------------------
Rectangle DbBrowseBox::GetCellRect(long nRow, USHORT nColId, BOOL bRel) const
{
	Rectangle aRect = GetFieldRectPixel(nRow, nColId, bRel);
	return aRect;
}

//------------------------------------------------------------------------------
IMPL_LINK(DbBrowseBox, EndEditHdl, void*, EMPTYTAG)
{
	nEndEvent = 0;
	ReleaseController(aOldController, nOldEditRow, nOldEditCol);

	aOldController  = CellControllerRef();
	nOldEditRow		= -1;
	nOldEditCol		=  0;

	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK(DbBrowseBox, ModifyHdl, void*, EMPTYTAG)
{
	nCellModifiedEvent = Application::PostUserEvent(LINK(this,DbBrowseBox,CellModifiedHdl));
	return 0;
}

//------------------------------------------------------------------------------
IMPL_LINK(DbBrowseBox, CellModifiedHdl, void*, EMPTYTAG)
{
	nCellModifiedEvent = 0;
	CellModified();
	return 0;
}

//------------------------------------------------------------------------------

void DbBrowseBox::ColumnResized( USHORT nColId )
{
	if (IsEditing())
	{
		Rectangle aRect = GetCellRect(nEditRow, nEditCol, FALSE);
		CellControllerRef aControllerRef = Controller();
		ResizeController(aControllerRef, aRect);
		Controller()->GetWindow().GrabFocus();
	}
}

//------------------------------------------------------------------------------
void DbBrowseBox::OnStartDrag()
{
	if (aMouseEvent.Is())		// da der MouseEvent "Up" beim Draggen geschluckt
								// wird, wird jetzt einer simuliert
		MouseButtonUp(*aMouseEvent);
}

//------------------------------------------------------------------------------
void DbBrowseBox::Resize()
{
	BrowseBox::Resize();
	// Ist das Fenster kleiner als Titelzeile + Controlarea, dann abbrechen
	if (GetOutputSizePixel().Height() <
	   (GetControlArea().GetHeight() + GetDataWindow().GetPosPixel().Y()))
		return;

	// liefert die Groee der Reserved ControlArea
	Point aPoint = GetControlArea().TopLeft();
	USHORT nX = (USHORT)aPoint.X();

	ArrangeControls(nX, (USHORT)aPoint.Y());

	// Die ReservedControlArea auf den tatsaechlichen Wert setzen
	ReserveControlArea((USHORT)nX);
}

//------------------------------------------------------------------------------
void DbBrowseBox::ArrangeControls(USHORT& nX, USHORT nY)
{
}

//------------------------------------------------------------------------------
CellController* DbBrowseBox::GetController(long, USHORT)
{
	return NULL;
}

//-----------------------------------------------------------------------------
void DbBrowseBox::ResizeController(CellControllerRef& rController, const Rectangle& rRect)
{
	rController->GetWindow().SetPosSizePixel(rRect.TopLeft(), rRect.GetSize());
}

//------------------------------------------------------------------------------
void DbBrowseBox::InitController(CellControllerRef& rController, long nRow, USHORT nCol)
{
}

//------------------------------------------------------------------------------
void DbBrowseBox::ReleaseController(CellControllerRef& rController, long nRow, USHORT nCol)
{
}

//------------------------------------------------------------------------------
void DbBrowseBox::CellModified()
{
}


//------------------------------------------------------------------------------
BOOL DbBrowseBox::SaveModified()
{
	return TRUE;
}

//------------------------------------------------------------------------------
void DbBrowseBox::DoubleClick(const BrowserMouseEvent& rEvt)
{
	// Bei Doppelclick auf die Spalte wird die optimale Breite der Spalte errechnet
	// und angepat
	USHORT nColId = rEvt.GetColumnId();
	if (nColId != HANDLE_ID)
		SetColumnWidth(nColId, GetAutoColumnWidth(nColId));
}

//------------------------------------------------------------------------------
ULONG DbBrowseBox::GetAutoColumnWidth(USHORT nColId)
{
	ULONG nColWidth  = 20;	// minimum
	long nLastVisRow = GetTopRow() + GetVisibleRows() - 1;
	for (long i = GetTopRow(); i < nLastVisRow; i++)
		nColWidth = std::max(nColWidth,GetTotalCellWidth(i,nColId) + 12);
	return nColWidth;
}

//------------------------------------------------------------------------------
ULONG DbBrowseBox::GetTotalCellWidth(long nRow, USHORT nColId)
{
	return 0;
}

//------------------------------------------------------------------------------
void DbBrowseBox::InvalidateHandleColumn()
{
	Rectangle aHdlFieldRect = GetFieldRectPixel( 0, 0 );
	Rectangle aInvalidRect( Point(0,0), GetOutputSizePixel() );
	aInvalidRect.Right() = aHdlFieldRect.Right();
	Invalidate( aInvalidRect );
}

//------------------------------------------------------------------------------
CellController::CellController(Window* pW)
			   :pWindow(pW)
{
	DBG_ASSERT(pWindow, "kein Editierfenster angegeben!");
	DBG_ASSERT(!pWindow->IsVisible(), "Editierfenster darf nicht sichbar sein!");
}

//-----------------------------------------------------------------------------
CellController::~CellController()
{
}

//-----------------------------------------------------------------------------
BOOL CellController::WantMouseEvent() const
{
	return FALSE;
}

//-----------------------------------------------------------------------------
BOOL CellController::MoveAllowed(const KeyEvent& rEvt) const
{
	return TRUE;
}

//------------------------------------------------------------------------------
EditCellController::EditCellController(Edit* pWin)
				   :CellController(pWin)
{
}

//-----------------------------------------------------------------------------
void EditCellController::ClearModified()
{
	GetEditWindow().ClearModifyFlag();
}

//------------------------------------------------------------------------------
BOOL EditCellController::MoveAllowed(const KeyEvent& rEvt) const
{
	BOOL bResult;
	switch (rEvt.GetKeyCode().GetCode())
	{
		case KEY_END:
		case KEY_RIGHT:
		{
			Selection aSel = GetEditWindow().GetSelection();
			bResult = !aSel && aSel.Max() == GetEditWindow().GetText().Len();
		}	break;
		case KEY_HOME:
		case KEY_LEFT:
		{
			Selection aSel = GetEditWindow().GetSelection();
			bResult = !aSel && aSel.Min() == 0;
		}	break;
		default:
			bResult = TRUE;
	}
	return bResult;
}

//------------------------------------------------------------------------------
BOOL EditCellController::IsModified() const
{
	return GetEditWindow().IsModified();
}

//------------------------------------------------------------------------------
void EditCellController::SetModifyHdl(const Link& rLink)
{
	GetEditWindow().SetModifyHdl(rLink);
}

//------------------------------------------------------------------------------
ComboBoxCellController::ComboBoxCellController(ComboBoxCtrl* pWin)
					   :CellController(pWin)
{
}

//------------------------------------------------------------------------------
BOOL ComboBoxCellController::MoveAllowed(const KeyEvent& rEvt) const
{
	return GetComboBox().MoveAllowed(rEvt);
}

//------------------------------------------------------------------------------
BOOL ComboBoxCellController::IsModified() const
{
	return GetComboBox().IsModified();
}

//------------------------------------------------------------------------------
void ComboBoxCellController::ClearModified()
{
	GetComboBox().ClearModifyFlag();
}

//------------------------------------------------------------------------------
void ComboBoxCellController::SetModifyHdl(const Link& rLink)
{
	GetComboBox().SetModifyHdl(rLink);
}

