
package org.netbeans.modules.openoffice.wizard.panels.service;

import java.awt.*;
import java.beans.*;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.*;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

import org.openide.Places;
import org.openide.TopManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.*;
import org.openide.loaders.*;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class InterfacePickUp extends JPanel implements PropertyChangeListener, VetoableChangeListener, DataFilter
{

   private static final boolean DEBUG = false;
   private static String IDLNAME;
   public boolean status;
   private Node root;
   private boolean validIdlName;
   private BeanTreeView tv;
   private ExplorerPanel tree;
   private JPanel jPanel1;
   private JLabel jLabel3;
   private JTextField idlName;
   private Dialog dialog;
      
   public InterfacePickUp()
    {
  
        initComponents();
        tv = new BeanTreeView();
        tv.setPopupAllowed(false);
        tv.setDefaultActionAllowed(false);
        tree.setMinimumSize(new Dimension(400, 250));
        tree.setPreferredSize(new Dimension(400, 250));
        tree.setBorder(new EtchedBorder());
        tree.add(tv, "Center");
        root = TopManager.getDefault().getPlaces().nodes().repository(this);
        tree.getExplorerManager().setRootContext(root);
      tree.getExplorerManager().addPropertyChangeListener(this);
       tree.getExplorerManager().addVetoableChangeListener(this);
//       idlName.getDocument().addDocumentListener(this);
//       setName("Test");
        //NbBundle.getBundle(class$org$netbeans$modules$corba$wizard$panels$PackagePanel != null ? class$org$netbeans$modules$corba$wizard$panels$PackagePanel : (class$org$netbeans$modules$corba$wizard$panels$PackagePanel = class$("org.netbeans.modules.corba.wizard.panels.PackagePanel"))).getString("TXT_Package"));
        
    }

    private void initComponents()
    {
        tree = new ExplorerPanel();
        jPanel1 = new JPanel();
        jLabel3 = new JLabel();
        idlName = new JTextField();
        setLayout(new GridBagLayout());
        setPreferredSize(new Dimension(500, 340));
        setMinimumSize(new Dimension(480, 320));
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(6, 12, 12, 12);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(tree, gridbagconstraints);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 1;
        gridbagconstraints.weightx = 1.0D;
        gridbagconstraints.weighty = 1.0D;
        add(jPanel1, gridbagconstraints);
        //jLabel3.setText(bundle.getString("TXT_Name"));
        jLabel3.setText(
        NbBundle.getMessage( InterfacePickUp.class, "LBL_InterfacePickUp" ) );
        jLabel3.setLabelFor(idlName);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.insets = new Insets(12, 12, 6, 6);
        gridbagconstraints.anchor = 17;
        add(jLabel3, gridbagconstraints);
        //idlName.setToolTipText(bundle.getString("TIP_NameOfIdlFile"));
        idlName.setToolTipText( NbBundle.getMessage( InterfacePickUp.class,
        "LBL_InterfacePickUpToolTip" ) );
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(12, 6, 6, 12);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(idlName, gridbagconstraints);
    }

    public boolean display()
    {   status = false;
        DialogDescriptor dialogdescriptor = new DialogDescriptor(this,"Choose the IDL file which defines your new interface", true, 2, NotifyDescriptor.OK_OPTION, 0, null, null);
        dialogdescriptor.setButtonListener( new ActionListener() {
            
        
           public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                       IDLNAME = idlName.getText();
                       status = true;
                 }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
               
        dialog = TopManager.getDefault().createDialog(dialogdescriptor);
        dialog.setVisible(true);
        
        return status;

    }

    public boolean acceptDataObject(org.openide.loaders.DataObject dataobject)
    {
       FileObject fileobject = dataobject.getPrimaryFile();
       return dataobject.isValid() && fileobject.isData() && fileobject.getExt().equals("idl") || fileobject.isFolder();      
    }    
 
    public void propertyChange(PropertyChangeEvent propertychangeevent)
    {
        Object obj = propertychangeevent.getNewValue();
        if(obj != null && (obj instanceof Node[]))
        {
            Node anode[] = (Node[])obj;
            if(anode.length == 1)
            {
                Node node = anode[0];
                String s = "";
                do
                {
                    Node node1 = node.getParentNode();
                    if(node1 == null || node1 == root)
                    {
                        if(s.endsWith("."))
                            s = s.substring(0, s.length() - 1);
                        break;
                    }
                    
                    s = node.getDisplayName() + "." + s;
                    
                    node = node1;
                }
                while(true);
                idlName.setText(s);
                //checkFileNameValidity(false);
            }
        }
    }

    public FileObject getInterfaceFile()
    { FileObject fileobject = null;
        try
         {
           String s = idlName.getText().replace('.', '/');
           
           s = s + ".idl";
           TopManager topmanager = TopManager.getDefault();
           Repository repository = topmanager.getRepository();
           fileobject = repository.findResource(s);
          }
            catch(Exception exception)
            {
            }
         return fileobject;
    }
    
    public void vetoableChange(PropertyChangeEvent propertychangeevent)
        throws PropertyVetoException
    {
        Object obj = propertychangeevent.getNewValue();
        if(obj != null && (obj instanceof Node[]))
        {
            Node anode[] = (Node[])obj;
            if(anode.length != 1)
                throw new PropertyVetoException("", propertychangeevent);
        }
    }
}
