

package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.OperationCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateOperationAction extends NodeAction
    implements Create
{

    public CreateOperationAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((OperationCreator)anode[0].getCookie(OperationCreator.class)).createOperation();
    }

    protected boolean enable(Node anode[])
    {
        return anode.length == 1 && anode[0].getCookie(OperationCreator.class) != null;
    }

    public String getName()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateOperation");
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_Operation");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

    
}
