/*
 * OOIDLWizardIterator.java
 *
 * Created on 30. Januar 2002
 *
 */

package org.netbeans.modules.openoffice.wizard;

import java.io.*;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.*;
import org.openide.loaders.*;
import org.openide.util.NbBundle;
import org.openide.util.actions.*;
import org.openide.src.*;
import org.openide.src.Import;
import org.openide.src.ClassElement;
import org.openide.nodes.*;
import org.openide.NotifyDescriptor;

import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import java.util.Date;
import java.text.DateFormat;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

/**
 *
 * @author  Michael Bohn
 *
 */


public class OOIDLWizardIterator implements TemplateWizard.Iterator {

    private static OOIDLWizardIterator instance;
    private static OOIDLData myIDLData;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;


    public static synchronized OOIDLWizardIterator singleton()
    {
        if(instance == null)
            instance = new OOIDLWizardIterator();
        return instance;
    }



    protected WizardDescriptor.Panel[] createPanels () {
        return new WizardDescriptor.Panel[] {
            // Assuming you want to keep the default 2nd panel:
            wiz.targetChooser (),
            new CreateIDLPanel(myIDLData),
            /* --> EDIT ME <--
            new MyPanel2 ()
             */

        };
    }

    // And the list of step names:

    protected String[] createSteps () {
        return new String[] {
            null,
            NbBundle.getMessage (OOIDLWizardIterator.class, "LBL_IDLDesign")
            /* --> EDIT ME <--
            NbBundle.getMessage (OOServiceCreateIterator.class, "LBL_step_2")
             */
        };
    }


  public Set instantiate (TemplateWizard wiz) throws IOException/*, IllegalStateException*/
   {
      String name = wiz.getTargetName ();
      DataFolder targetFolder = wiz.getTargetFolder ();
      DataObject template = wiz.getTemplate ();
      DataObject result ;

      if (name == null)
      {
       result = template.createFromTemplate (targetFolder);
      } else {
                   result = template.createFromTemplate (targetFolder, name);
             }
      String s1 = myIDLData.getIdlSource();
      
      if(s1 != null && s1.length() > 0)
        {     
              
              FileLock filelock = null;
              PrintWriter printwriter = null;
                try
                {
                    FileObject fileobject = result.getPrimaryFile();
                    filelock = fileobject.lock();
                    printwriter = new PrintWriter(new OutputStreamWriter(fileobject.getOutputStream(filelock)));
                    DateFormat dateformat = DateFormat.getDateTimeInstance(1, 2);
                    printwriter.println("//\n// " + result.getName() + ".idl\n//\n// Created on " + dateformat.format(new Date()) + "\n// by " + System.getProperty("user.name") + "\n//\n");
                    printwriter.println("\n ");
                    printwriter.println("#ifndef __" + fileobject.getPackageNameExt('_','_') + "__" );     
                    printwriter.println("#define __" + fileobject.getPackageNameExt('_','_') + "__\n" );     
                    
                    printwriter.println(s1);
                    printwriter.println("#endif" );     
                     if(printwriter != null)
                         printwriter.close();
                     if(filelock != null)
                         filelock.releaseLock();
                }
                catch(IOException ioexception)
                {
                }
                OpenCookie open = (OpenCookie) result.getCookie (OpenCookie.class);
                if (open != null) { open.open ();}
                OOServiceCreateIterator.singleton();           
      }   
    return Collections.singleton (result);
  }


 public void initialize (TemplateWizard wiz)
  {
    this.wiz = wiz;
    myIDLData = new OOIDLData();
    
    try {
        // Get package.
        myIDLData.setTargetFolder( wiz.getTargetFolder() );
    }
    catch ( IOException ioexception ) {
    }
    
    index = 0;
    panels = createPanels ();
    String[] steps = createSteps ();
    for (int i = 0; i < panels.length; i++)
     {
       Component c = panels[i].getComponent ();
       if (steps[i] == null)
        {
         steps[i] = c.getName ();
        }
       if (c instanceof JComponent)
        { // assume Swing components
         JComponent jc = (JComponent) c;
         // Step #.
         jc.putClientProperty ("WizardPanel_contentSelectedIndex", new Integer (i)); // NOI18N
         // Step name (actually the whole list for reference).
         jc.putClientProperty ("WizardPanel_contentData", steps); // NOI18N
        }
     }
  }

 public void uninitialize (TemplateWizard wiz)
  {
    this.wiz = null;
    panels = null;
//    myData = null;
  }

 public String name ()
  {
    return NbBundle.getMessage(OOServiceCreateIterator.class, "TITLE_x_of_y",
    new Integer (index + 1), new Integer (panels.length));
  }

 public boolean hasNext ()
  {
    return index < panels.length - 1;
  }

 public boolean hasPrevious ()
  {
    return index > 0;
  }

 public void nextPanel ()
  {
   if (! hasNext ()) throw new NoSuchElementException ();
        index++;
  }

 public void previousPanel ()
  {
   if (! hasPrevious ()) throw new NoSuchElementException ();
   index--;
  }

  public org.openide.WizardDescriptor$Panel current()
   {
     return panels[index];
   }
 
  public final void addChangeListener (ChangeListener l) {}
  public final void removeChangeListener (ChangeListener l) {}


}
