
package org.netbeans.modules.openoffice;

import java.io.*;
import java.util.HashMap;
import java.util.Date;
import java.text.DateFormat;

import org.openide.loaders.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.actions.*;
import org.openide.util.actions.SystemAction;
import org.openide.util.*;


public class OOURDDataLoader extends UniFileLoader {

    /** generated
     */
 

    /** Creates new OOURDDataLoader */
    public OOURDDataLoader() {
        super (OOURDDataObject.class);
    }

    /** Does initialization. Initializes display name,
    * extension list and the actions. */
    protected void initialize () {
        super.initialize ();
        setDisplayName (NbBundle.getBundle (OOURDDataLoader.class).
                        getString("PROP_OOURDLoader_Name"));
        ExtensionList exts = new ExtensionList ();
        exts.addExtension ("urd");
        setExtensions (exts);
        setActions(new SystemAction[] {
                       SystemAction.get(FileSystemAction.class),
                       null,
                       SystemAction.get(CompileAction.class),
                       null,
                       SystemAction.get(CutAction.class),
                       SystemAction.get(CopyAction.class),
                       SystemAction.get(PasteAction.class),
                       null,
                       SystemAction.get(DeleteAction.class),
                       SystemAction.get(RenameAction.class),
                       null,
                       SystemAction.get(ToolsAction.class),
                       SystemAction.get(PropertiesAction.class),
                   });
    }


    /** Create a special file entry for the makefile.
     * For token substitution.
     * @param obj the data object
     * @param primaryFile the only file
     * @return a special file entry
     */
    protected MultiDataObject.Entry createPrimaryEntry (MultiDataObject obj, FileObject primaryFile) {
        return new OOURDFileEntry (obj, primaryFile);
    }


    /** Get the primary file.
     * @param fo the file to find the primary file for
     *
     * @return the primary file, or <code>null</code> if its extension is not {@link #getExtensions recognized}
     */
    protected FileObject findPrimaryFile (FileObject fo) {
        FileObject supe = super.findPrimaryFile (fo);
        if (supe != null) return supe;
        String name = fo.getName ();
        String ext = fo.getExt ();
        if (ext != null && ! ext.equals ("")) name += '.' + ext;
            if ( ext.equals ("urd"))
                return fo;
        return null;
    }


    /** Creates the correct kind of object.
     * @return the data object
     * @param fo the file
     * @throws IOException if something fails
     */
    protected MultiDataObject createMultiObject (final FileObject fo)
    throws IOException {
        return new OOURDDataObject (fo, this);
    }

 
    /** This entry defines the format for replacing the text during
     * instantiation the data object.
     */
    static class OOURDFileEntry extends FileEntry.Format {

        /** generated
         */
       

        /** Creates new file entry.
         * This will handle substitution of tokens.
         * @param obj the data object
         * @param file the makefile
         */
        OOURDFileEntry (MultiDataObject obj, FileObject file) {
            super (obj, file);
        }

        /** Method to provide suitable format for substitution of lines.
         *
         * @param target the target folder of the installation
         * @param n the name the file will have
         * @param e the extension the file will have
         * @return format to use for formating lines
         */
        protected java.text.Format createFormat (FileObject target, String n, String e) {
            HashMap map = new HashMap();
            // [PENDING] this is not really terribly useful unless it matches Java conventions
            map.put ("NAME", n);
            map.put ("DATE", DateFormat.getDateInstance (DateFormat.LONG).format (new Date()));
            map.put ("TIME", DateFormat.getTimeInstance (DateFormat.SHORT).format (new Date()));
            map.put ("USER", System.getProperty ("user.name"));

            MapFormat format = new MapFormat (map);
            format.setLeftBrace ("__");
            format.setRightBrace ("__");
            format.setExactMatch (false);
            return format;
        }
    }
}
