@echo off
set OO_SDK_NAME=StarOffice7_SDK

REM This script asks for variables, which are necessary for building the
REM examples of the Office Development Kit. The script duplicates the template
REM script and inserts the variables into the copied script.
REM The Script was developed for the operating systems Microsoft Windows.

setlocal

set OO_SDK_NAME=[SDKNAME]
set OO_SDK_HOME=
set OFFICE_HOME=
set OO_SDK_MAKE_HOME=
set OO_SDK_CPP_HOME=
set OO_SDK_JAVA_HOME=
set SDK_AUTO_DEPLOYMENT=
set OFFICE_PROGRAM_PATH=


REM Enter installation directory of the Office Software Development Kit.
set OO_SDK_HOME_SUGGESTION=%CD%
:L1_SDK
set OO_SDK_HOME=
set /p OO_SDK_HOME=Enter the Office Software Development Kit directory [%OO_SDK_HOME_SUGGESTION%]:

if NOT defined OO_SDK_HOME (
  if defined OO_SDK_HOME_SUGGESTION (
    if exist "%OO_SDK_HOME_SUGGESTION%" (
      set OO_SDK_HOME=%OO_SDK_HOME_SUGGESTION%
    ) else (
      echo Error: Could not find directory "%OO_SDK_HOME_SUGGESTION%" .
      echo Error: An SDK is required, please specify the path to a valid installation.
      echo.
      goto :L1_SDK
    )
  ) else (
    echo Error: An SDK is required, please specify the path to a valid installation.
    echo.
    goto :L1_SDK
  )
)

if not exist "%OO_SDK_HOME%\idl" (
  echo Could not find directory "%OO_SDK_HOME%\idl" .
  echo Error: An SDK is required, please specify the path to a valid installation.
  echo.
  goto :L1_SDK
)

REM Enter installation directory of the Office program.
set OFFICE_HOME_SUGGESTION=
echo.
:L2_OFFICE
set OFFICE_HOME=
set /p OFFICE_HOME=Enter the Office installation directory [%OFFICE_HOME_SUGGESTION%]:

if not defined OFFICE_HOME (
  if defined OFFICE_HOME_SUGGESTION (
    if exist "%OFFICE_HOME_SUGGESTION%" (
      set OFFICE_HOME=%OFFICE_HOME_SUGGESTION%
    ) else (
      echo Error: Could not find directory "%OFFICE_HOME_SUGGESTION%" .
      echo Error: An office installation is required, please specify the path to a valid installation.
      echo.
      goto :L2_OFFICE
    )
  ) else (
    echo Error: An office installation is required, please specify the path to a valid installation.
    echo.
    goto :L2_OFFICE
  )
)

if not exist "%OFFICE_HOME%\program" (
  echo Could not find directory "%OFFICE_HOME%\program" .
  echo Error: An office installation is required, please specify the path to a valid installation.
  echo.
  goto :L2_OFFICE
)


REM Enter installation directory of the make program.
set OO_SDK_MAKE_HOME_SUGGESTION=
echo.
:L3_MAKE
set OO_SDK_MAKE_HOME=
set /p OO_SDK_MAKE_HOME=Enter GNU make (3.79.1 or higher) tools directory [%OO_SDK_MAKE_HOME_SUGGESTION%]:

if not defined OO_SDK_MAKE_HOME (
  if defined OO_SDK_MAKE_HOME_SUGGESTION (
    if exist "%OO_SDK_MAKE_HOME_SUGGESTION%" (
      set OO_SDK_MAKE_HOME=%OO_SDK_MAKE_HOME_SUGGESTION%
    ) else (
      echo Error: Could not find directory "%OO_SDK_MAKE_HOME_SUGGESTION%" .
      echo Error: GNU make is required, please specify a GNU make tools directory.
      echo.
      goto :L3_MAKE
    )
  ) else (
      echo Error: GNU make is required, please specify a GNU make tools directory.
      echo.
      goto :L3_MAKE
  )
)

if not exist "%OO_SDK_MAKE_HOME%\make.exe" (
  echo Could not find directory "%OO_SDK_MAKE_HOME%\make.exe" .
  echo Error: GNU make is required, please specify a GNU make tools directory.
  echo.
  goto :L3_MAKE
)


REM Enter installation directory of the C++ program.
set OO_SDK_CPP_HOME_SUGGESTION=
echo.
:L4_CPP
set /p OO_SDK_CPP_HOME=Enter C++ tools directory (optional) [%OO_SDK_CPP_HOME_SUGGESTION%]:

if not defined OO_SDK_CPP_HOME (
  if defined OO_SDK_CPP_HOME_SUGGESTION (
    if exist "%OO_SDK_CPP_HOME_SUGGESTION%" (
      set OO_SDK_CPP_HOME=%OO_SDK_CPP_HOME_SUGGESTION%
    ) else (
      echo Error: Could not find directory "%OO_SDK_CPP_HOME_SUGGESTION%" .
    )
  )
)

if defined OO_SDK_CPP_HOME (
  if not exist "%OO_SDK_CPP_HOME%" (
    echo Could not find directory "%OO_SDK_CPP_HOME%".
    set OO_SDK_CPP_HOME=
    goto :SKIP_CPP
  )
)

goto :SKIPPED_CPP

REM CPP skip
:SKIP_CPP
set SKIP=
set /p SKIP=Do you want to skip the choice of the 'C++ compiler' (YES/NO) [YES]:
if defined SKIP (
  if "%SKIP%"=="YES" (
    goto :SKIPPED_CPP
  ) else (
    if "%SKIP%"=="NO" (
      goto :L4_CPP
    ) else (
      goto :SKIP_CPP
    )
  )
) else (
 goto :SKIPPED_CPP
)

:SKIPPED_CPP

REM Enter installation directory of the JAVA program.
set OO_SDK_JAVA_HOME_SUGGESTION=
echo.
:L6_JAVA
set OO_SDK_JAVA_HOME=
set /p OO_SDK_JAVA_HOME=Enter JAVA SDK (1.4.1_01 or higher) installation directory [%OO_SDK_JAVA_HOME_SUGGESTION%]:

if not defined OO_SDK_JAVA_HOME (
  if defined OO_SDK_JAVA_HOME_SUGGESTION (
    if exist "%OO_SDK_JAVA_HOME_SUGGESTION%" (
      set OO_SDK_JAVA_HOME=%OO_SDK_JAVA_HOME_SUGGESTION%
    ) else (
      echo Error: Could not find directory "%OO_SDK_JAVA_HOME_SUGGESTION%" .
      echo Error: Java is required, please specify a Java SDK installation directory.
      echo.
      goto :L6_JAVA
    )
  ) else (
    echo Error: Java is required, please specify a Java SDK installation directory.
    echo.
    goto :L6_JAVA
  )
)

if not exist "%OO_SDK_JAVA_HOME%" (
  echo Could not find directory "%OO_SDK_JAVA_HOME%" .
  echo Error: Java is required, please specify a Java SDK installation directory.
  echo.
  goto :L6_JAVA
)


REM Automatic deployment?
set SDK_AUTO_DEPLOYMENT_SUGGESTION=YES
echo.
:L5_AUTODEPLOYMENT
set SDK_AUTO_DEPLOYMENT=
set /p SDK_AUTO_DEPLOYMENT=Automatic deployment of UNO components (YES/NO) [%SDK_AUTO_DEPLOYMENT_SUGGESTION%]:

if not defined SDK_AUTO_DEPLOYMENT (
  set SDK_AUTO_DEPLOYMENT=%SDK_AUTO_DEPLOYMENT_SUGGESTION%
) else (
  if not "%SDK_AUTO_DEPLOYMENT%"=="YES" (
    if not "%SDK_AUTO_DEPLOYMENT%"=="NO" (
      echo Error: The value entered "%SDK_AUTO_DEPLOYMENT%" is invalid.
      echo.
      goto :L5_AUTODEPLOYMENT
    )
  )
)


echo @echo off > setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM This script sets all enviroment variables, which>> setsdkenv_windows.bat
echo REM are necessary for building the examples of the Office Development Kit.>> setsdkenv_windows.bat
echo REM The Script was developed for the operating systems Windows.>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM The SDK name>> setsdkenv_windows.bat
echo set OO_SDK_NAME=%OO_SDK_NAME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Installation directory of the Software Development Kit.>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_HOME=D:\StarOffice_SDK>> setsdkenv_windows.bat
echo set OO_SDK_HOME=%OO_SDK_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Office installation directory.>> setsdkenv_windows.bat
echo REM Example: set OFFICE_HOME=C:\Programme\StarOffice>> setsdkenv_windows.bat
echo set OFFICE_HOME=%OFFICE_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set classpath>> setsdkenv_windows.bat
echo set CLASSPATH=%OFFICE_PROGRAM_PATH%\classes\jurt.jar;%OFFICE_PROGRAM_PATH%\classes\unoil.jar;%OFFICE_PROGRAM_PATH%\classes\ridl.jar;%OFFICE_PROGRAM_PATH%\classes\sandbox.jar;%OFFICE_PROGRAM_PATH%\classes\juh.jar>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Directory of the make command.>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_MAKE_HOME=D:\NextGenerationMake\make>> setsdkenv_windows.bat
echo set OO_SDK_MAKE_HOME=%OO_SDK_MAKE_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Directory of the C++ tools.>> setsdkenv_windows.bat
echo REM Example:set OO_SDK_CPP_HOME=C:\Programme\Microsoft Visual Studio\VC98\bin>> setsdkenv_windows.bat
echo set OO_SDK_CPP_HOME=%OO_SDK_CPP_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Java installation directory.>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_JAVA_HOME=c:\j2sdk1.4.1_01>> setsdkenv_windows.bat
echo set OO_SDK_JAVA_HOME=%OO_SDK_JAVA_HOME%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Automatic deployment>> setsdkenv_windows.bat
echo REM Example: set SDK_AUTO_DEPLOYMENT=YES>> setsdkenv_windows.bat
echo set SDK_AUTO_DEPLOYMENT=%SDK_AUTO_DEPLOYMENT%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Special output directory>> setsdkenv_windows.bat
echo REM Example: set OO_SDK_OUTPUT_DIR=c:\temp>> setsdkenv_windows.bat
echo REM set OO_SDK_OUTPUT_DIR=c:\temp>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Check installation path for the StarOffice Development Kit.>> setsdkenv_windows.bat
echo if not defined OO_SDK_HOME (>> setsdkenv_windows.bat
echo   echo Error: the variable OO_SDK_HOME is missing!>> setsdkenv_windows.bat
echo   goto :error>> setsdkenv_windows.bat
echo )>>setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Check installation path for the office.>> setsdkenv_windows.bat
echo if not defined OFFICE_HOME (>> setsdkenv_windows.bat
echo   echo Error: the variable OFFICE_HOME is missing!>> setsdkenv_windows.bat
echo   goto :error>> setsdkenv_windows.bat
echo )>>setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Check installation path for GNU make.>> setsdkenv_windows.bat
echo if not defined OO_SDK_MAKE_HOME (>> setsdkenv_windows.bat
echo   echo Error: the variable OO_SDK_MAKE_HOME is missing!>> setsdkenv_windows.bat
echo   goto :error>> setsdkenv_windows.bat
echo )>>setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Check installation path for Java.>> setsdkenv_windows.bat
echo if not defined OO_SDK_JAVA_HOME (>> setsdkenv_windows.bat
echo   echo Error: the variable OO_SDK_JAVA_HOME is missing!>> setsdkenv_windows.bat
echo   goto :error>> setsdkenv_windows.bat
echo )>>setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set library path. >> setsdkenv_windows.bat
echo set LIB=%%OO_SDK_HOME%%\windows\lib;%%OO_SDK_HOME%%\WINexample.out\lib;%%LIB%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set office program path.>> setsdkenv_windows.bat
echo set OFFICE_PROGRAM_PATH=%%OFFICE_HOME%%\program>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the SDK tools to the path.>> setsdkenv_windows.bat
echo set PATH=%%OO_SDK_HOME%%\windows\bin;%%OFFICE_HOME%%\program;%%OO_SDK_HOME%%\WINexample.out\bin;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set PATH appropriate to the output directory>> setsdkenv_windows.bat
echo if defined OO_SDK_OUTPUT_DIR (>> setsdkenv_windows.bat
echo   set PATH=%OO_SDK_OUTPUT_DIR%\%OO_SDK_NAME%\WINexample.out\bin;%PATH%>> setsdkenv_windows.bat
echo ) else (>> setsdkenv_windows.bat
echo   set PATH=%OO_SDK_HOME%\WINexample.out\bin;%PATH%>> setsdkenv_windows.bat
echo )>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the command make to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_MAKE_HOME set PATH=%%OO_SDK_MAKE_HOME%%;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the C++ tools to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_CPP_HOME set PATH=%%OO_SDK_CPP_HOME%%;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Add directory of the Java tools to the path, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_JAVA_HOME set PATH=%%OO_SDK_JAVA_HOME%%\bin;%%OO_SDK_JAVA_HOME%%\jre\bin;%%PATH%%>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set environment for C++ tools, if necessary.>> setsdkenv_windows.bat
echo if defined OO_SDK_CPP_HOME call "%%OO_SDK_CPP_HOME%%\VCVARS32.bat">> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo REM Set tilte to identify the prepared shell.>> setsdkenv_windows.bat
echo title Shell prepared for SDK >> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo goto end>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo :error>> setsdkenv_windows.bat
echo Error: Please insert the necessary environment variables into the batch file.>> setsdkenv_windows.bat
echo. >> setsdkenv_windows.bat
echo :end>> setsdkenv_windows.bat

echo.
echo For using your prepared environment, please run the "setsdkenv_windows.bat" file!


endlocal
