/*************************************************************************
 *
 *  $RCSfile: hyphdsp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tl $ $Date: 2001/01/25 10:56:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LINGUISTIC_HYPHDSP_HXX_
#define _LINGUISTIC_HYPHDSP_HXX_


#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEDISPLAYNAME_HPP_
#include <com/sun/star/lang/XServiceDisplayName.hpp>
#endif
#include <com/sun/star/linguistic2/XHyphenator.hpp>
#include <com/sun/star/linguistic2/XPossibleHyphens.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/linguistic2/XSearchableDictionaryList.hpp>
#include <com/sun/star/linguistic2/XLinguServiceEventBroadcaster.hpp>

#ifndef _TOOLS_TABLE_HXX
#include <tools/table.hxx>
#endif

#include <uno/lbnames.h>			// CPPU_CURRENT_LANGUAGE_BINDING_NAME macro, which specify the environment type
#include <cppuhelper/implbase1.hxx>	// helper for implementations


#include "lngopt.hxx"
#include "misc.hxx"
#include "defs.hxx"

class LngSvcMgr;

///////////////////////////////////////////////////////////////////////////

class LangSvcEntry_Hyph
{
	friend class HyphenatorDispatcher;

	::rtl::OUString										aSvcImplName;
	::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XHyphenator >	aSvcRef;

//	INT16			nLang;     //used as key in the table
	SvcFlags		aFlags;

public:
	LangSvcEntry_Hyph() {}
	LangSvcEntry_Hyph( const ::rtl::OUString &rSvcImplName );
	~LangSvcEntry_Hyph();

	BOOL	IsAlreadyWarned() const		{ return aFlags.bAlreadyWarned != 0; }
	void	SetAlreadyWarned(BOOL bVal)	{ aFlags.bAlreadyWarned = 0 != bVal; }
	BOOL	IsDoWarnAgain() const		{ return aFlags.bDoWarnAgain != 0; }
	void	SetDoWarnAgain(BOOL bVal)	{ aFlags.bDoWarnAgain = 0 != bVal; }
};

DECLARE_TABLE( HyphSvcList, LangSvcEntry_Hyph * );


class HyphenatorDispatcher :
	public cppu::WeakImplHelper1
	<
		::com::sun::star::linguistic2::XHyphenator
	>,
	public LinguDispatcher
{
	HyphSvcList		aSvcList;

	::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet >						xPropSet;
	::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XSearchableDictionaryList >	xDicList;

	LngSvcMgr	   &rMgr;

	// disallow copy-constructor and assignment-operator for now
	HyphenatorDispatcher(const HyphenatorDispatcher &);
	HyphenatorDispatcher & operator = (const HyphenatorDispatcher &);

	inline ::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet >
			GetPropSet();
	inline ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XSearchableDictionaryList >
			GetDicList();

	void	ClearSvcList();

	com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XHyphenatedWord>
			buildHyphWord( const ::com::sun::star::uno::Reference<
					::com::sun::star::linguistic2::XDictionaryEntry> &xEntry,
				INT16 nLang, INT16 nMaxLeading );

	com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XPossibleHyphens >
			buildPossHyphens( const ::com::sun::star::uno::Reference<
					::com::sun::star::linguistic2::XDictionaryEntry > &xEntry,
					INT16 nLanguage );

public:
	HyphenatorDispatcher( LngSvcMgr &rLngSvcMgr );
	virtual ~HyphenatorDispatcher();

	// XSupportedLocales
    virtual ::com::sun::star::uno::Sequence<
			::com::sun::star::lang::Locale > SAL_CALL
		getLocales()
			throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL
		hasLocale( const ::com::sun::star::lang::Locale& aLocale )
			throw(::com::sun::star::uno::RuntimeException);

	// XHyphenator
    virtual ::com::sun::star::uno::Reference<
			::com::sun::star::linguistic2::XHyphenatedWord > SAL_CALL
		hyphenate( const ::rtl::OUString& aWord,
				const ::com::sun::star::lang::Locale& aLocale,
				sal_Int16 nMaxLeading,
				const ::com::sun::star::beans::PropertyValues& aProperties )
			throw(::com::sun::star::lang::IllegalArgumentException,
				  ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference<
			::com::sun::star::linguistic2::XHyphenatedWord > SAL_CALL
		queryAlternativeSpelling( const ::rtl::OUString& aWord,
				const ::com::sun::star::lang::Locale& aLocale,
				sal_Int16 nIndex,
				const ::com::sun::star::beans::PropertyValues& aProperties )
			throw(::com::sun::star::lang::IllegalArgumentException,
				  ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference<
			::com::sun::star::linguistic2::XPossibleHyphens > SAL_CALL
		createPossibleHyphens(
				const ::rtl::OUString& aWord,
				const ::com::sun::star::lang::Locale& aLocale,
				const ::com::sun::star::beans::PropertyValues& aProperties )
			throw(::com::sun::star::lang::IllegalArgumentException,
				  ::com::sun::star::uno::RuntimeException);

	// LinguDispatcher
	virtual void
		SetServiceList( const ::com::sun::star::lang::Locale &rLocale,
				const ::com::sun::star::uno::Sequence<
					rtl::OUString > &rSvcImplNames );
	virtual ::com::sun::star::uno::Sequence< rtl::OUString >
		GetServiceList( const ::com::sun::star::lang::Locale &rLocale ) const;
	virtual DspType
		GetDspType() const;
};


inline ::com::sun::star::uno::Reference<
	::com::sun::star::beans::XPropertySet >
		HyphenatorDispatcher::GetPropSet()
{
	return xPropSet.is() ? 
				xPropSet : xPropSet = ::linguistic::GetLinguProperties();
}


inline ::com::sun::star::uno::Reference<
	::com::sun::star::linguistic2::XSearchableDictionaryList >
		HyphenatorDispatcher::GetDicList()
{
	return xDicList.is() ? 
				xDicList : xDicList = ::linguistic::GetSearchableDictionaryList();
}


///////////////////////////////////////////////////////////////////////////


#endif

