/*************************************************************************
 *
 *  $RCSfile: javainfoimpl.cxx,v $
 *
 *  $Revision: 1.7.12.4 $
 *
 *  last change: $Author: vg $ $Date: 2004/05/03 16:47:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "javainfoimpl.hxx"

#include "windows.hxx"

#include "osl/file.hxx"
#include "osl/process.h"
#include "osl/security.hxx"
#include "osl/thread.h"

#include <algorithm>

#if defined WNT

#define RT_LIB  "jvm.dll"
/* Path to the runtime library relative to the directory of a JRE
 */
#define JVM_LIBPATH  \
        "/bin/client/jvm.dll", \
        "/bin/hotspot/jvm.dll",\
        "/bin/classic/jvm.dll"
/* Path to the access-bridge.jar relative to the jre installation directory
 */
#define ACCESS_BRIDGE_PATH    "/lib/ext/access-bridge.jar"

#elif defined UNX

#ifdef MACOSX
#define RT_LIB  "JavaVM"
#else
#define RT_LIB  "libjvm.so"
#endif

/* The ARCH define is used to build up path strings, such as
 * "/lib/sparc/client/libjvm.so" or "/lib/i386/client/libjvm.so"
*/
#if defined SPARC
#define ARCH "sparc"
#elif defined INTEL
#define ARCH "i386"
#elif defined POWERPC
#define ARCH "ppc"
#elif defined MIPS
#define ARCH "mips"
#elif defined S390
#define ARCH "s390"
#else // SPARC, INTEL, POWERPC, MIPS
#error unknown plattform
#endif // SPARC, INTEL, POWERPC, MIPS

/* Path to the runtime lib starting from the jre directory.
   The first string must be /lib/sparc/client/libjvm !!!
 */

#ifdef MACOSX
#define JVM_LIBPATH \
        "/../../../JavaVM"
#else
#define JVM_LIBPATH \
        "/bin/classic/libjvm.so", \
        "/lib/" ARCH "/client/libjvm.so", \
        "/lib/" ARCH "/classic/libjvm.so"
#endif

/* These are relative paths starting from the jre/lib directory. They are used
   to from full paths which are finally put into LD_LIBRARY_PATH
*/

#ifdef MACOSX
   #define LD_LIB_PATH "/../Libraries", \
                    "/lib"
#else
   #if (defined(LINUX) && defined(POWERPC)) || defined(NETBSD)
        #define LD_LIB_PATH "/bin", \
                    "/bin/classic", \
                    "/lib/" ARCH "/client", \
                    "/lib/" ARCH "/classic", \
                    "/lib/" ARCH "/native_threads", \
                    "/lib/" ARCH
   #else
        #define LD_LIB_PATH "/bin", \
                    "/bin/classic", \
                    "/lib/" ARCH "/client", \
                    "/lib/" ARCH "/native_threads", \
                    "/lib/" ARCH
   #endif
#endif

#define ACCESS_BRIDGE_PATH    "/lib/ext/gnome-java-bridge.jar"
/* These are possible names of Java installation directories. They are used along
   with DEFAULT_SEARCH_PATH to find a Java if no JAVA_HOME, PATH or LD_LIBRARY_PATH
   contains a Java.
*/
#define JAVA_DIR_NAMES  "j2re1.5.0", \
                        "j2sdk1.5.0", \
                        "j2re1.4.2_06", \
                        "j2sdk1.4.2_06", \
                        "j2re1.4.2_05", \
                        "j2sdk1.4.2_05", \
                        "j2re1.4.2_04", \
                        "j2sdk1.4.2_04", \
                        "j2re1.4.2_03", \
                        "j2sdk1.4.2_03", \
                        "j2re1.4.2_02", \
                        "j2sdk1.4.2_02", \
                        "j2re1.4.2_01", \
                        "j2sdk1.4.2_01", \
                        "j2re1.4.2", \
                        "j2sdk1.4.2", \
                        "j2re1.4.1_03", \
                        "j2sdk1.4.1_03", \
                        "j2re1.4.1_02", \
                        "j2sdk1.4.1_02", \
                        "j2re1.4.1_01", \
                        "j2sdk1.4.1_01", \
                        "j2re1.4.1", \
                        "jdk1.4.1", \
                        "j2sdk1.4.1", \
                        "j2re1.4.0_03", \
                        "j2sdk1.4.0_03", \
                        "j2re1.4.0_02", \
                        "j2sdk1.4.0_02", \
                        "j2re1.4.0_01", \
                        "j2sdk1.4.0_01", \
                        "j2re1.4.0", \
                        "j2sdk1.4.0", \
                        "j2re1_3_1_07", \
                        "j2sdk1_3_1_07", \
                        "jre1.3.1_07", \
                        "jdk1.3.1_07", \
                        "j2re1_3_1_06", \
                        "j2sdk1_3_1_06", \
                        "jre1.3.1_06", \
                        "jdk1.3.1_06", \
                        "j2re1_3_1_05", \
                        "j2sdk1_3_1_05", \
                        "jre1.3.1_05", \
                        "jdk1.3.1_05", \
                        "j2re1_3_1_04", \
                        "j2sdk1_3_1_04", \
                        "jre1.3.1_07", \
                        "jdk1.3.1_07", \
                        "jre1.3.1_06", \
                        "jdk1.3.1_06", \
                        "jre1.3.1_05", \
                        "jdk1.3.1_05", \
                        "jre1.3.1_04", \
                        "jdk1.3.1_04", \
                        "j2re1_3_1_03", \
                        "j2sdk1_3_1_03", \
                        "jre1.3.1_03", \
                        "jdk1.3.1_03", \
                        "j2re1_3_1_02", \
                        "j2sdk1_3_1_02", \
                        "jre1.3.1_02", \
                        "jdk1.3.1_02", \
                        "j2re1_3_1_01", \
                        "j2sdk1_3_1_01", \
                        "jre1.3.1_01", \
                        "jdk1.3.1_01", \
                        "j2re1_3_1", \
                        "j2sdk1_3_1", \
                        "jre1.3.1", \
                        "jdk1.3.1", \
                        "j2re1_3_0_02", \
                        "j2sdk1_3_0_02", \
                        "j2re1_3_0_01", \
                        "j2sdk1_3_0_01", \
                        "j2re1_3_0", \
                        "j2sdk1_3_0", \
                        "j2re", \
                        "j2se", \
                        "j2sdk", \
                        "jdk", \
                        "jre", \
                        "java", \
                        "Home", \
                        "IBMJava2-" ARCH "-131", \
                        "IBMJava2-" ARCH "-141"


/* These are directories in which a java installation is
   looked for.
*/
#ifdef MACOSX
#define DEFAULT_SEARCH_PATH "System/Library/Frameworks/JavaVM.framework/Versions/1.3.1/"

// We have problem mixing X11 and Cocoa/Carbon event loops in JDK 1.4.X
// so do not add the following to the default search path for MacOSX yet 
// "System/Library/Frameworks/JavaVM.framework/Versions/1.4.2/"

#else
#define DEFAULT_SEARCH_PATH "", \
                            "usr/", \
                            "usr/local/", \
                            "usr/lib/"
#endif
/* These are names of directories which could contain several java installations
 */
#define JAVA_COLLECT_DIR "", \
                         "java/",\
                         "jdk/", \
                         "jre/", \
                         "j2sdk/", \
                         "j2re/"


#endif // WNT, UNX

#define OUSTR( x )  ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( x ))

using namespace rtl;
using namespace osl;

using jvmaccess::JavaInfo;
using jvmaccess::impl::SunVersion;

namespace css = com::sun::star;

namespace {

Mutex* getJavaEnvMutex()
{
    static Mutex* pMutex= NULL;

    if( ! pMutex)
    {
        MutexGuard guard( Mutex::getGlobalMutex() );
        if( !pMutex)
        {
            static Mutex aMutex;
            pMutex= &aMutex;
        }
    }
    return pMutex;
}

}

css::uno::Sequence<OUString> JavaInfo::Impl::seqJRESearchPaths;
css::uno::Sequence<OUString> JavaInfo::Impl::seqSDKSearchPaths;
OUString JavaInfo::Impl::usPathDelim(OUSTR("/"));
OUString JavaInfo::Impl::usPathSep;
OUString JavaInfo::Impl::usCurDir(OUSTR("."));
OUString JavaInfo::Impl::usParentDir(OUSTR(".."));
OUString JavaInfo::Impl::usJreDir(OUSTR("/jre"));

#if defined WNT
    OUString usJava(OUSTR("java.exe"));
#else // WNT
    OUString usJava(OUSTR("java"));
#endif // WNT


#if defined UNX
css::uno::Sequence<OUString> JavaInfo::Impl::seqJavaDirNames;
css::uno::Sequence<OUString> JavaInfo::Impl::seqDefSearchPath;
css::uno::Sequence<OUString> JavaInfo::Impl::seqJavaCollectDir;
#endif // UNX


JavaInfo::Impl::~Impl()
{
}

JavaInfo::Impl::Impl(const SunVersion& ver, const OUString& home, JavaType type):
    version(ver),
    type( type),
    accessibility(access_not_init),
    bComplete(true)
{
    if(home.getLength() == 0 || type == 0)
         throw InitException();
    init();
    // init type string
    switch(type)
    {
    case SDK_TYPE: usType= OUSTR("SDK"); break;
    case JRE_TYPE: usType= OUSTR("JRE"); break;
    }

    //create a file URL for JavaHome
    if(File::getFileURLFromSystemPath(home, usJavaHome) != File::E_None)
        throw InitException();
    if( ! initRuntimeLib())
        throw InitException();
    if( ! initLibDirs())
        throw InitException();
}

JavaInfo::Impl::Impl(const OUString& _usJavaHome, const OUString& _usRuntimeLib, JavaType _type):
    accessibility(access_not_init),
    bComplete(true)
{
    if(_usJavaHome.getLength() == 0 || _usRuntimeLib.getLength() == 0 || _type == 0)
        throw InitException();
    usJavaHome= _usJavaHome;
    usRuntimeLib= _usRuntimeLib;
    type=_type;
    init();
    if(type == JRE_TYPE)
        usType= OUSTR("JRE");
    else if(type == SDK_TYPE)
        usType= OUSTR("SDK");
    else
        throw InitException();
    if(! initLibDirs())
        throw InitException();
    if(! initVersion())
        throw InitException();
}
JavaInfo::Impl::Impl(const OUString& _usHomeDir):
    accessibility(access_not_init),
    bComplete(true),
	type(UNKNOWN_TYPE)
{
    if(_usHomeDir.getLength() == 0)
        throw InitException();
    usJavaHome= _usHomeDir;
    init();

	bComplete = initType() && bComplete; 
    if( ! initRuntimeLib())
        throw InitException();
    
    bComplete = initVersion() && bComplete;
    bComplete = initLibDirs() && bComplete;
}


bool JavaInfo::Impl::getPathsAndTypeFromBin(const OUString& usBinDir, OUString& usJavaHome, OUString& usRuntimeLib, JavaType *pType)
{
    init();

    bool ret= false;
    if(usBinDir.getLength())
    {
        OUString usBin;
        // "."
        if(usBinDir.equals(usCurDir))
        {
            OUString usWorkDirUrl;
            if(osl_Process_E_None == osl_getProcessWorkingDir(&usWorkDirUrl.pData))
                usBin= usWorkDirUrl;
        }
        // ".."
        else if(usBinDir.equals(usParentDir))
        {
            OUString usWorkDir;
            if(osl_Process_E_None == osl_getProcessWorkingDir(&usWorkDir.pData))
                usBin= getDirFromFile(usWorkDir);
        }
        else
        {
            usBin= usBinDir;
        }
        if(usBin.getLength())
        {
            // try to find an SDK
            sal_Int32 cPaths= seqSDKSearchPaths.getLength();
            for(sal_Int32 i= 0; i < cPaths; i++)
            {
                OUString usHome= getDirFromFile(usBin); //makes "..../sdk/bin" -> "..../sdk"
                OUString usRt = usHome + seqSDKSearchPaths[i];
                DirectoryItem item;
                if(DirectoryItem::get(usRt, item) == File::E_None)
                {
                    *pType= SDK_TYPE;
                    usRuntimeLib= usRt;
                    usJavaHome= usHome;
                    ret= true;
                    break;
                }
            }

            // try to find a JRE
            if( ! usJavaHome.getLength())
            {
                sal_Int32 cPaths= seqJRESearchPaths.getLength();
                for(sal_Int32 i= 0; i < cPaths; i++)
                {
                    OUString usHome= getDirFromFile(usBin); //makes ".../jre/bin" -> "..../jre"
                    OUString usRt= usHome + seqJRESearchPaths[i];
                    DirectoryItem item;
                    if(DirectoryItem::get(usRt, item) == File::E_None)
                    {
                        *pType= JRE_TYPE;
                        usRuntimeLib= usRt;
                        usJavaHome= usHome;
                        ret= true;
                        break;
                    }
                }
            }
        }
    }
    return ret;
}

#if defined UNX
bool JavaInfo::Impl::getPathsAndTypeFromLib(const OUString& usBinDir, OUString& usJavaHome, OUString& usRuntimeLib, JavaType *pType)
{
     init();
     bool ret= false;
     if(usBinDir.getLength())
     {
        OUString usLib;
        // "."
        if(usBinDir.equals(usCurDir))
        {
            OUString usWorkDirUrl;
            if(osl_Process_E_None == osl_getProcessWorkingDir(&usWorkDirUrl.pData))
                usLib= usWorkDirUrl;
        }
        // ".."
        else if(usBinDir.equals(usParentDir))
        {
            OUString usWorkDir;
            if(osl_Process_E_None == osl_getProcessWorkingDir(&usWorkDir.pData))
                usLib= getDirFromFile(usWorkDir);
        }
        else
        {
            usLib= usBinDir;
        }
        if(usLib.getLength())
        {
            //try to find the runtime Lib
            OUString usRt(usLib + usPathDelim + OUSTR(RT_LIB));
            DirectoryItem item;
            OUString usRelRt;
            OUString usJreHome;
            if(DirectoryItem::get(usRt, item) == File::E_None)
            {
                //There is a runtime Lib
                // check if the path contains "lib/sparc/client/libjvm.so"
                // therefor we compare the last part of usLib with that string.
                //-build "lib/sparc/client/libjvm.so
                for(int i= 0; i <seqJRESearchPaths.getLength(); i++)
                {
                    usRelRt= seqJRESearchPaths[i];
                    //determine at which point the substring should begin
                    sal_Int32 index= 0;
                    index= usRt.lastIndexOf(SAL_PATHDELIMITER);
                    for(int i= 0; i < 3; i++)
                        index= usRt.lastIndexOf(SAL_PATHDELIMITER, index);

                    // does the last part of usRt is "lib/sparc/client/libjvm.so" ?
                    if(index != -1)
                    {
                        if(usRt.match(usRelRt, index))
                        {
                            usJreHome= OUString(usRt, index);
                            usRuntimeLib= usRt;
                            break;
                        }
                    }
                }
            }

            // If we have a valid path to the runtime lib then try to figure out the type
            // and home dir
            // Based on the runtime lib we assume that there is a jre directory for an SDK
            // and a home/bin/java file
            if(usRuntimeLib.getLength())
            {
                OUString usJreRt( OUSTR("jre") + usRelRt);
                //determine at which point the substring should begin
                sal_Int32 index= 0;
                index= usRt.lastIndexOf(SAL_PATHDELIMITER);
                for(int i= 0; i < 4; i++)
                    index= usRt.lastIndexOf(SAL_PATHDELIMITER, index);
                if(index != -1)
                {
                    if(usRt.match( usJreDir + usRelRt, index))
                    {
                        //the path contains "jre/lib/sparc/client/libjvm.so"
                        //no check if there is a /bin/java executable in the same directory
                        OUString usHome(usRt.getStr(), index);
                        OUString usJava(usHome + OUSTR("/bin/java"));
                        DirectoryItem item;
                        if(DirectoryItem::get(usJava, item) == File::E_None)
                        {
                            *pType= SDK_TYPE;
                            usJavaHome= usHome;
                            ret= true;
                        }
                    }
                    else
                    {
                        *pType= JRE_TYPE;
                        usJavaHome= usJreHome;
                        ret= true;
                    }
                }
            }
        }
     }
     return ret;
}
#endif // UNX

bool JavaInfo::Impl::isComplete()
{
    //bComplete is initially true. If it is false then this function has
    // been called already or the contructor Impl(OUString dir) was used
    //to create the instance. Anyway, once bComplete is false, it is always
    //false.
    if (bComplete == false)
        return bComplete;

    if (!initAccessibility())
        bComplete = false;

    return bComplete;
}
 
//requires usJavaHome
//Don't make assumptions about the type
bool JavaInfo::Impl::initRuntimeLib()
{
    OSL_ASSERT(usJavaHome.getLength());
    bool ret= false;
    // find the lib using possible jre or sdk paths
    css::uno::Sequence<OUString> seqPaths;
    bool bAllPaths = false;
    if(type == SDK_TYPE)
        seqPaths= seqSDKSearchPaths;
    else if(type == JRE_TYPE)
        seqPaths= seqJRESearchPaths;
    else
        bAllPaths = true;

    if( ! bAllPaths)
    {
        sal_Int32 cPaths= seqPaths.getLength();
        for(sal_Int32 i= 0; i < cPaths; i++)
        {
            //Construct an absolute path to the possible runtime
            OUString usRt= usJavaHome + seqPaths[i];
            DirectoryItem item;
            if(DirectoryItem::get(usRt, item) == File::E_None)
            {
                //found runtime lib
                usRuntimeLib= usRt;
                ret= true;
                break;
            }
        }
    }
    else
    {
        sal_Int32 cPaths= seqSDKSearchPaths.getLength();
        for(sal_Int32 i= 0; i < cPaths; i++)
        {
            //Construct an absolute path to the possible runtime
            OUString usRt= usJavaHome + seqSDKSearchPaths[i];
            DirectoryItem item;
            if(DirectoryItem::get(usRt, item) == File::E_None)
            {
                //found runtime lib
                usRuntimeLib= usRt;
                ret= true;
                break;
            }
        }
        if ( ! ret)
        {
            sal_Int32 cPaths= seqJRESearchPaths.getLength();
            for(sal_Int32 i= 0; i < cPaths; i++)
            {
                //Construct an absolute path to the possible runtime
                OUString usRt= usJavaHome + seqJRESearchPaths[i];
                DirectoryItem item;
                if(DirectoryItem::get(usRt, item) == File::E_None)
                {
                    //found runtime lib
                    usRuntimeLib= usRt;
                    ret= true;
                    break;
                }
            }
        }
    }
    return ret;
}


bool JavaInfo::Impl::initType()
{
    OSL_ASSERT(usJavaHome.getLength() > 0);
    bool ret= false;
    // The home directory must be valid
    // If the installation directory contains a jre directory then
    // it is a sdk
    // build the path to the jre directory, e.g c:\java\j2sdk\jre
    OUString usJre= usJavaHome + usJreDir;
    //create a file url to the jre directory
    DirectoryItem item;
    FileBase::RC retFile= DirectoryItem::get(usJre, item); 
    if(retFile == File::E_None)
    {
        //check if there is the executable SDK/bin/java
        OUString usJavaExe(usJavaHome + OUSTR("/bin/") + usJava);
        DirectoryItem iJava;        
        FileBase::RC retJava = DirectoryItem::get(usJavaExe, item); 
        if(retJava == File::E_None)
        {
            //found jre directory
            type= SDK_TYPE;
            // init type string
            usType= OUSTR("SDK");
            ret= true;
        }
        else
            ret = false;
    }
    else if(retFile == File::E_NOENT)
    {
        type= JRE_TYPE;
        usType= OUSTR("JRE");
        ret= true;
    }
    else
    {
        type = UNKNOWN_TYPE;
        ret= false;
    }
    return ret;
}

bool JavaInfo::Impl::initLibDirs()
{
    bool ret= true;
#if defined WNT
    OSL_ASSERT(usRuntimeLib.getLength());
    OUString usDir= getDirFromFile(usRuntimeLib);
    if(File::getSystemPathFromFileURL(usDir, usLibLocations) != File::E_None)
        ret= false;
#elif defined UNX
    OSL_ASSERT(usJavaHome.getLength() && type);
    char *arPaths[]= {LD_LIB_PATH};
    int len= sizeof(arPaths) / sizeof(char*);

    for(int i= 0; i < len; i ++)
    {
        OUString usRelPath(arPaths[i], strlen(arPaths[i]), osl_getThreadTextEncoding());
        OUString usAbsUrl;
        if(type == JRE_TYPE)
            usAbsUrl= usJavaHome + usRelPath;
        else //SDK
            usAbsUrl= usJavaHome + usJreDir + usRelPath;
        // convert to system path
        OUString usSysPath;
        if(File::getSystemPathFromFileURL(usAbsUrl, usSysPath) == File::E_None)
        {
            if(i > 0)
                usLibLocations+= usPathSep;
            usLibLocations+= usSysPath;
        }
        else
        {
            ret= false;
            break;
        }
    }
#endif // WNT, UNX
    return ret;
}

// used for late initialization
//does not throw exception
bool JavaInfo::Impl::initAccessibility()
{
    OSL_ASSERT(usJavaHome.getLength() && type);
    bool ret= false;
    if(accessibility == access_not_init)
    {
        MutexGuard guard(getJavaEnvMutex());
        {
            if(accessibility == access_not_init)
            {
                OUString usAccess(RTL_CONSTASCII_USTRINGPARAM(
                                      ACCESS_BRIDGE_PATH));
                if(type == JRE_TYPE)
                {
                    OUString usAbsAccess= usJavaHome + usAccess;
                    //create a file url to the access-bridge.jar
                    OUString usUrl;
                    DirectoryItem item;
                    FileBase::RC retFile= DirectoryItem::get(usAbsAccess, item);
                    if(retFile == File::E_None)
                    {
                        //found access-bridge.jar
                        ret= true;
                        accessibility= access_ok;
                    }
                    else if(retFile == File::E_NOENT)
                    {
                        accessibility= access_no;
                        ret=true;
                    }
                    else
                        ret = false;
                }
                else if(type == SDK_TYPE)
                {
                    OUString usAbsAccess= usJavaHome + usJreDir + usAccess;
                    //create a file url to the access-bridge.jar
                    OUString usUrl;
                    DirectoryItem item;
                    FileBase::RC retFile= DirectoryItem::get(usAbsAccess, item);
                    if(retFile == File::E_None)
                    {
                        //found access-bridge.jar
                        ret= true;
                        accessibility= access_ok;
                    }
                    else if(retFile == File::E_NOENT)
                    {
                        ret= true;
                        accessibility= access_no;
                    }
                    else
                        ret =  false;
                }
                else
                    OSL_ENSURE(0, "Type not yet determined");
            }
            else
                ret = true;
        }
    }
    else
        ret = true;
    return ret;
}
bool JavaInfo::Impl::initVersion()
{
    version = jvmaccess::impl::initVersion(usJavaHome);
    return version;
}

void JavaInfo::Impl::init()
{
    // create the relativ paths which are used to find the runtime
    if(seqJRESearchPaths.getLength() == 0)
    {
        MutexGuard guard(getJavaEnvMutex());
        if(seqJRESearchPaths.getLength() == 0)
        {
            // init platform dependent strings
            char arSep[]= {SAL_PATHSEPARATOR, 0};
            usPathSep= OUSTR(arSep);

            //init platform dependent search paths
            char* arJRE[]= { JVM_LIBPATH };
            sal_Int32 cStr= (sizeof (arJRE)) / sizeof (char*);
            seqJRESearchPaths.realloc(cStr);
            seqSDKSearchPaths.realloc(cStr);
            for(sal_Int32 i= 0; i < cStr; i++)
            {
                seqJRESearchPaths[i]= OUString(arJRE[i], strlen(arJRE[i]),
                                               osl_getThreadTextEncoding());
                seqSDKSearchPaths[i]= usJreDir + seqJRESearchPaths[i];
            }
#if defined UNX
            char *arDirNames[]= {JAVA_DIR_NAMES};
            int cDirNames= sizeof(arDirNames) / sizeof(char*);
            seqJavaDirNames.realloc(cDirNames);
            for(i= 0; i < cDirNames; i++)
                seqJavaDirNames[i]= OUString(arDirNames[i], strlen(arDirNames[i]), osl_getThreadTextEncoding());

            char *arSearchPath[]= {DEFAULT_SEARCH_PATH};
            int cSearch= sizeof(arSearchPath) / sizeof(char*);
            seqDefSearchPath.realloc(cSearch);
            for(i= 0; i< cSearch; i++)
                seqDefSearchPath[i]= OUString(arSearchPath[i], strlen(arSearchPath[i]), osl_getThreadTextEncoding());

            char *arCollectDir[]= {JAVA_COLLECT_DIR};
            int cColl= sizeof(arCollectDir) / sizeof(char*);
            seqJavaCollectDir.realloc(cColl);
            for(i= 0; i< cColl; i++)
                seqJavaCollectDir[i]= OUString(arCollectDir[i], strlen(arCollectDir[i]), osl_getThreadTextEncoding());
#endif // UNX
        }
    }
}


const OUString& JavaInfo::Impl::getVersion()
{
    return version.usVersion;
}

//throw UnsupportedException if we could not accessibility for some
//reason.
bool JavaInfo::Impl::supportsAccessibility()
{
    if (! initAccessibility())
        throw UnsupportedException();
    OSL_ASSERT(accessibility != access_not_init);
    if( accessibility == access_no)
        return false;
    return true;
}

inline OUString JavaInfo::Impl::getDirFromFile(const OUString& usFilePath)
{
    sal_Int32 index= usFilePath.lastIndexOf('/');
    return OUString(usFilePath.getStr(), index);
}

void JavaInfo::Impl::createImpl(std::vector<Impl*>& vecImpl, const OUString& usVersion, int requirements, bool bIgnoreRequirements)
{
    init();
    bool bRequirementsMet= false;
    //This list will be filled whith the installation dirs of javas which does not meet the requirements
    std::vector<OUString> vecBadJava;
#if defined WNT
    // Get Javas from the registry
    createImplFromWinReg(vecImpl, usVersion, requirements, bIgnoreRequirements, &bRequirementsMet, vecBadJava);
    if(!bIgnoreRequirements && bRequirementsMet)
        return;
#endif // WNT
    // Get Java from JAVA_HOME environmentVariable
    createImplFromJavaHome(vecImpl, usVersion, requirements, bIgnoreRequirements, &bRequirementsMet,vecBadJava);
    if(!bIgnoreRequirements && bRequirementsMet)
        return;
    // Get Java from Path Variable
    createImplFromPath(vecImpl, usVersion, requirements, bIgnoreRequirements, &bRequirementsMet, vecBadJava);
    if(!bIgnoreRequirements && bRequirementsMet)
        return;

#if defined UNX
    //  Looks for Java in the directory where the executable is
    createImplFromBinDir(vecImpl, usVersion, requirements, bIgnoreRequirements, &bRequirementsMet, vecBadJava);
    if(!bIgnoreRequirements && bRequirementsMet)
        return;

    createImplFromLibPath(vecImpl, usVersion, requirements, bIgnoreRequirements, &bRequirementsMet, vecBadJava);
    if(!bIgnoreRequirements && bRequirementsMet)
        return;

    createImplDirScan(vecImpl, usVersion, requirements, bIgnoreRequirements, &bRequirementsMet, vecBadJava);
    if(!bIgnoreRequirements && bRequirementsMet)
        return;
    createImplDirScanHome(vecImpl, usVersion, requirements, bIgnoreRequirements, &bRequirementsMet, vecBadJava);
    if(!bIgnoreRequirements && bRequirementsMet)
        return;
#endif // UNX
}


bool JavaInfo::Impl::checkRequirements(Impl *pImpl, const OUString& usVersion, int requirements)
{
    bool ret= false;
    // In no version and requirement were given than every Java is ok
    if(usVersion.getLength() == 0 && requirements == 0)
        return true;

    // accessibility is only requirement
    if(usVersion.getLength() == 0 && requirements == Accessibility)
    {
        if(pImpl->supportsAccessibility())
            return true;
        else
            return false;
    }

    // version + Accessibility
    SunVersion version(usVersion);
    if(version)
    {
        if(requirements & EqualVersion && requirements & SmallerVersion)
        {
            if(pImpl->version == version
               || pImpl->version < version)
                ret= true;
        }
        else if(requirements & EqualVersion && requirements & GreaterVersion)
        {
            if(pImpl->version == version
               || pImpl->version > version)
                ret= true;
        }
        else if(requirements & EqualVersion)
        {
            if(pImpl->version == version)
                ret= true;
        }
        else if(requirements & SmallerVersion)
        {
            if(pImpl->version < version)
                ret= true;
        }
        else if(requirements & GreaterVersion)
        {
            if(pImpl->version > version)
                ret= true;
        }
        else // no version flags: we assume EqualVersion
        {
            if(pImpl->version == version)
                ret= true;
        }
            // Accessibility ?
        if( ret && (requirements & Accessibility) &&  ! pImpl->supportsAccessibility())
            ret= false;
    }
    return ret;
}

void JavaInfo::Impl::createImplFromJavaHome(std::vector<Impl*>& vecImpl, const OUString& usVersion,
               int requirements, bool bIgnoreRequirements, bool *bRequirementsMet, std::vector<OUString>& vecBadJava)
{
    // Get Java from JAVA_HOME environment
    char *szJavaHome= getenv("JAVA_HOME");
    if(szJavaHome)
    {
        OUString usHome(szJavaHome,strlen(szJavaHome),osl_getThreadTextEncoding());
        OUString usHomeUrl;
        if(File::getFileURLFromSystemPath(usHome, usHomeUrl) == File::E_None)
        {
            if(isAlreadyEvaluated(usHomeUrl, vecImpl, bIgnoreRequirements, vecBadJava))
               return;
            try {
                Impl *pImpl= new Impl(usHomeUrl);
                if( ! bIgnoreRequirements)
                {
                    if(checkRequirements(pImpl, usVersion, requirements))
                    {
                        vecImpl.push_back(pImpl);
                        *bRequirementsMet= true;
                        return;
                    }
                    else
                    {
                        *bRequirementsMet= false;
                        vecBadJava.push_back(usHomeUrl);
                    }
                }
                else
                    vecImpl.push_back(pImpl);

            } catch (...) {
            }
        }
    }
}


void JavaInfo::Impl::createImplFromPath(std::vector<Impl*>& vecImpl, const OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<OUString>& vecBadJava)
{
// Get Java from PATH environment variable
    char *szPath= getenv("PATH");
    if(szPath)
    {
        OUString usAllPath(szPath, strlen(szPath), osl_getThreadTextEncoding());
        sal_Int32 nIndex = 0;
        do
        {
            OUString usToken = usAllPath.getToken( 0, SAL_PATHSEPARATOR, nIndex );
            OUString usTokenUrl;
            if(File::getFileURLFromSystemPath(usToken, usTokenUrl) == File::E_None)
            {
                OUString usJavaHome;
                OUString usRuntimeLib;
                JavaType type= (JavaType)0;
                if(getPathsAndTypeFromBin(usTokenUrl, usJavaHome, usRuntimeLib, &type))
                {
                    //check if there is already a JavaInfo with the same installation Dir
                    if(isAlreadyEvaluated(usJavaHome, vecImpl, bIgnoreRequirements, vecBadJava))
                       continue;
                    try
                    {
                        Impl *pImpl= new Impl(usJavaHome, usRuntimeLib, type);
                        if( ! bIgnoreRequirements)
                        {
                            if(checkRequirements(pImpl, usVersion, requirements))
                            {
                                vecImpl.push_back(pImpl);
                                *bRequirementsMet= true;
                                return;
                            }
                            else
                            {
                                vecBadJava.push_back(usJavaHome);
                                *bRequirementsMet= false;
                            }
                        }
                        else
                            vecImpl.push_back(pImpl);

                    } catch (...) {
                    }
                }
            }
        }
        while ( nIndex >= 0 );
    }
}

#if defined UNX
void JavaInfo::Impl::createImplFromBinDir(std::vector<Impl*>& vecImpl, const OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<OUString>& vecBadJava)
{
    sal_Int32 cDirs= seqJavaDirNames.getLength();
    OUString usExe;
    if(osl_getExecutableFile(&usExe.pData) == osl_Process_E_None)
    {
        OUString usDir= getDirFromFile(usExe);

        for(int i= 0; i < cDirs; i++)
        {
            OUString usJava(usDir + usPathDelim + seqJavaDirNames[i]);

            DirectoryItem item;
            if(DirectoryItem::get(usJava, item) == File::E_None)
            {
                if(isAlreadyEvaluated(usJava, vecImpl, bIgnoreRequirements, vecBadJava))
                       continue;
                try
                {
                    Impl *pImpl= new Impl(usJava);
                    if( ! bIgnoreRequirements)
                    {
                        if(checkRequirements(pImpl, usVersion, requirements))
                        {
                            vecImpl.push_back(pImpl);
                            *bRequirementsMet= true;
                            return;
                        }
                        else
                        {
                            vecBadJava.push_back(usJava);
                            *bRequirementsMet= false;
                        }
                    }
                    else
                    {
                        vecImpl.push_back(pImpl);
                        break;
                    }

                } catch (...) {
                }
            }
        }
    }
}

void JavaInfo::Impl::createImplFromLibPath(std::vector<Impl*>& vecImpl, const OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<OUString>& vecBadJava)
{
    // Get Java from PATH environment variable
#ifdef MACOSX
    char *szPath= getenv("DYLD_LIBRARY_PATH");
#else
    char *szPath= getenv("LD_LIBRARY_PATH");
#endif
    if(szPath)
    {
        OUString usAllPath(szPath, strlen(szPath), osl_getThreadTextEncoding());
        sal_Int32 nIndex = 0;
        do
        {
            OUString usToken = usAllPath.getToken( 0, SAL_PATHSEPARATOR, nIndex );
            OUString usTokenUrl;
            if(File::getFileURLFromSystemPath(usToken, usTokenUrl) == File::E_None)
            {
                OUString usJavaHome;
                OUString usRuntimeLib;
                JavaType type= (JavaType)0;
                if(getPathsAndTypeFromLib(usTokenUrl, usJavaHome, usRuntimeLib, &type))
                {
                    //check if there is already a JavaInfo with the same installation Dir
                    if(isAlreadyEvaluated(usJavaHome, vecImpl, bIgnoreRequirements, vecBadJava))
                       continue;
                    try
                    {
                        Impl *pImpl= new Impl(usJavaHome, usRuntimeLib, type);
                        if( ! bIgnoreRequirements)
                        {
                            if(checkRequirements(pImpl, usVersion, requirements))
                            {
                                vecImpl.push_back(pImpl);
                                *bRequirementsMet= true;
                                return;
                            }
                            else
                            {
                                vecBadJava.push_back(usJavaHome);
                                *bRequirementsMet= false;
                            }
                        }
                        else
                            vecImpl.push_back(pImpl);

                    } catch (...) {
                    }
                }
            }
        }
        while ( nIndex >= 0 );
    }
}

void JavaInfo::Impl::createImplDirScan(std::vector<Impl*>& vecImpl, const OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<OUString>& vecBadJava)
{
    int lenDefSearchPath= seqDefSearchPath.getLength();
    int lenJavaCollDir= seqJavaCollectDir.getLength();
    int lenJavaDirNames= seqJavaDirNames.getLength();
    int lenJvmPath= seqJRESearchPaths.getLength();
    OUString *arDefSearchPath= seqDefSearchPath.getArray();
    OUString *arJavaCollDir= seqJavaCollectDir.getArray();
    OUString *arJavaDirNames= seqJavaDirNames.getArray();

    OUString usFile(OUSTR("file:///"));
    for( int i= 0; i < lenDefSearchPath; i ++)
    {
        OUString usDir1(usFile + arDefSearchPath[i]);
        DirectoryItem item;
        if(DirectoryItem::get(usDir1, item) == File::E_None)
        {
            for(int j= 0; j < lenJavaCollDir; j++)
            {
                // /usr/java/
                OUString usDir2(usDir1 + arJavaCollDir[j]);
                DirectoryItem item2;
                if(DirectoryItem::get(usDir2, item2) == File::E_None)
                {
                    for( int k= 0; k < lenJavaDirNames; k++)
                    {
                        // /usr/java/j2re1.4.0
                        OUString usDir3(usDir2 + arJavaDirNames[k]);
                        DirectoryItem item3;
                        if(DirectoryItem::get(usDir3, item) == File::E_None)
                        {
                            //check if there is already a JavaInfo with the same installation Dir
                            if(isAlreadyEvaluated(usDir3, vecImpl, bIgnoreRequirements, vecBadJava))
                               continue;
                            //Sometimes there are two Javas detected if, for example, the home dir is java.
                            // then java is detected as SDK and java/jre as jre. the same applies for all sdk s
                            // with a home dir that has a name from JAVA_COLLECT_DIR.
                            if(arJavaDirNames[k].equals(OUSTR("jre")))
                            {
                                //remove trailing "/"
                                OUString parent= usDir2.copy(0, usDir2.getLength() - 1);
                                if(isAlreadyEvaluated(parent, vecImpl, bIgnoreRequirements, vecBadJava))
                                    continue;
                            }

                            try
                            {
                                Impl *pImpl= new Impl(usDir3);
                                if( ! bIgnoreRequirements)
                                {
                                    if(checkRequirements(pImpl, usVersion, requirements))
                                    {
                                        vecImpl.push_back(pImpl);
                                        *bRequirementsMet= true;
                                        return;
                                    }
                                    else
                                    {
                                        vecBadJava.push_back(usDir3);
                                        *bRequirementsMet= false;
                                    }
                                }
                                else
                                    vecImpl.push_back(pImpl);

                            } catch (...) {
                            }
                        }
                    }
                }
            }
        }
    }
}

void JavaInfo::Impl::createImplDirScanHome(std::vector<Impl*>& vecImpl, const OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<OUString>& vecBadJava)
{
    int lenJavaCollDir= seqJavaCollectDir.getLength();
    int lenJavaDirNames= seqJavaDirNames.getLength();
    int lenJvmPath= seqJRESearchPaths.getLength();
    OUString *arJavaCollDir= seqJavaCollectDir.getArray();
    OUString *arJavaDirNames= seqJavaDirNames.getArray();

    OUString usHome;
    Security sec;
    if(sec.getHomeDir(usHome))
    {
        OUString usFile(usHome + usPathDelim);
        DirectoryItem item;
        for(int j= 0; j < lenJavaCollDir; j++)
        {
            // /homedir/java
            OUString usDir2(usFile + arJavaCollDir[j]);
            DirectoryItem item2;
            if(DirectoryItem::get(usDir2, item2) == File::E_None)
            {
                for( int k= 0; k < lenJavaDirNames; k++)
                {
                    // /homedir/java/j2re1.4.0
                    OUString usDir3(usDir2 + arJavaDirNames[k]);
                    DirectoryItem item3;
                    if(DirectoryItem::get(usDir3, item) == File::E_None)
                    {
                        //check if there is already a JavaInfo with the same installation Dir
                        if(isAlreadyEvaluated(usDir3, vecImpl, bIgnoreRequirements, vecBadJava))
                            continue;
                        //Sometimes there are two Javas detected if, for example, the home dir is java.
                        // then java is detected as SDK and java/jre as jre. the same applies for all sdk s
                        // with a home dir that has a name from JAVA_COLLECT_DIR.
                        if(arJavaDirNames[k].equals(OUSTR("jre")))
                        {
                            //remove trailing "/"
                            OUString parent= usDir2.copy(0, usDir2.getLength() - 1);
                            if(isAlreadyEvaluated(parent, vecImpl, bIgnoreRequirements, vecBadJava))
                                continue;
                        }

                        try
                        {
                            Impl *pImpl= new Impl(usDir3);
                            if( ! bIgnoreRequirements)
                            {
                                if(checkRequirements(pImpl, usVersion, requirements))
                                {
                                    vecImpl.push_back(pImpl);
                                    *bRequirementsMet= true;
                                    return;
                                }
                                else
                                {
                                    vecBadJava.push_back(usDir3);
                                    *bRequirementsMet= false;
                                }
                            }
                            else
                                vecImpl.push_back(pImpl);

                        } catch (...) {
                        }
                    }
                }
            }
        }
    }
}
#endif // UNX

bool JavaInfo::Impl::isAlreadyEvaluated(const OUString& usJavaHome, const std::vector<Impl*>& vecImpl,
                                   bool bIgnoreRequirements, const std::vector<OUString>& vecBadJava)
{
    bool ret= false;
    if(bIgnoreRequirements)
    {
        std::vector<Impl*>::const_iterator it_impl= std::find_if(vecImpl.begin(), vecImpl.end(), InfoFindSame(usJavaHome));
        if(it_impl != vecImpl.end())
            ret= true; // there is already one
    }
    else
    {
        std::vector<OUString>::const_iterator it_bad= std::find(vecBadJava.begin(), vecBadJava.end(), usJavaHome);
        if(it_bad != vecBadJava.end())
            ret= true;
    }
    return ret;
}

#if defined WNT
void JavaInfo::Impl::createImplFromWinReg(std::vector<Impl*>& vecImpl, const OUString& usVersion, int requirements,
                                       bool bIgnoreRequirements,bool *bRequirementsMet, std::vector<OUString>& vecBadJava)
{
        // Get Java s from registry
    std::vector<SunVersion> vecVersion;
    std::vector<OUString> vecJavaHome;
    if(jvmaccess::impl::getSDKInfoFromRegistry(vecVersion, vecJavaHome))
    {
        // create impl objects
        typedef std::vector<OUString>::iterator ItHome;
        typedef std::vector<SunVersion>::iterator ItVer;
        ItVer it_ver= vecVersion.begin();
        for(ItHome it_home= vecJavaHome.begin(); it_home != vecJavaHome.end(); it_home++, it_ver++)
        {
            if(isAlreadyEvaluated(*it_home, vecImpl, bIgnoreRequirements, vecBadJava))
                continue;
            try
            {
                Impl *pImpl= new Impl(*it_ver, *it_home, SDK_TYPE);
                if( ! bIgnoreRequirements)
                {
                    if(checkRequirements(pImpl, usVersion, requirements))
                    {
                        vecImpl.push_back(pImpl);
                        *bRequirementsMet= true;
                        return;
                    }
                    else
                    {
                        vecBadJava.push_back(*it_home);
                        *bRequirementsMet= false;
                    }
                }
                else
                    vecImpl.push_back(pImpl);
            }
            catch( ... ) {
            }
        }
    }
    vecVersion.clear();
    vecJavaHome.clear();
    if(jvmaccess::impl::getJREInfoFromRegistry(vecVersion, vecJavaHome))
    {
        typedef std::vector<OUString>::iterator ItHome;
        typedef std::vector<SunVersion>::iterator ItVer;
        ItVer it_ver= vecVersion.begin();
        for(ItHome it_home= vecJavaHome.begin(); it_home != vecJavaHome.end(); it_home++, it_ver++)
        {
            try
            {
                Impl *pImpl= new Impl(*it_ver, *it_home, JRE_TYPE);
                if( ! bIgnoreRequirements)
                {
                    if(checkRequirements(pImpl, usVersion, requirements))
                    {
                        vecImpl.push_back(pImpl);
                        *bRequirementsMet= true;
                        return;
                    }
                    else
                        *bRequirementsMet= false;
                }
                else
                    vecImpl.push_back(pImpl);

            }
            catch( ... ) {
            }
        }
    }
}
#endif // WNT

