/*************************************************************************
 *
 *  $RCSfile: menumanager.hxx,v $
 *
 *  $Revision: 1.15.32.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 17:33:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_CLASSES_MENUMANAGER_HXX_
#define __FRAMEWORK_CLASSES_MENUMANAGER_HXX_

/** Attention: stl headers must(!) be included at first. Otherwhise it can make trouble
               with solaris headers ...
*/
#include <vector>

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_FEATURESTATEEVENT_HPP_
#include <com/sun/star/frame/FeatureStateEvent.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HPP_
#include <com/sun/star/frame/XFrameActionListener.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _RTL_USTRING_
#include <rtl/ustring.hxx>
#endif

#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif

#ifndef _SV_ACCEL_HXX
#include <vcl/accel.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#define	REFERENCE										::com::sun::star::uno::Reference
#define	XFRAME											::com::sun::star::frame::XFrame
#define XDISPATCH										::com::sun::star::frame::XDispatch
#define XDISPATCHPROVIDER								::com::sun::star::frame::XDispatchProvider
#define XSTATUSLISTENER									::com::sun::star::frame::XStatusListener
#define XEVENTLISTENER									::com::sun::star::lang::XEventListener
#define XFRAMEACTIONLISTENER                            ::com::sun::star::frame::XFrameActionListener
#define FEATURSTATEEVENT								::com::sun::star::frame::FeatureStateEvent
#define RUNTIMEEXCEPTION								::com::sun::star::uno::RuntimeException
#define EVENTOBJECT										::com::sun::star::lang::EventObject
#define FRAMEACTIONEVENT                                ::com::sun::star::frame::FrameActionEvent

namespace framework
{

class BmkMenu;
class AddonMenu;
class AddonPopupMenu;
class MenuManager : public XSTATUSLISTENER		,
					public XFRAMEACTIONLISTENER ,
					public ThreadHelpBase		,
					public ::cppu::OWeakObject
{
	public:
		MenuManager( REFERENCE< XFRAME >& rFrame,
					 Menu* pMenu,
					 sal_Bool bDelete,
					 sal_Bool bDeleteChildren );

		MenuManager( REFERENCE< XFRAME >& rFrame,
					 BmkMenu*			pBmkMenu,
					 sal_Bool			bDelete,
					 sal_Bool			bDeleteChildren );

		MenuManager( REFERENCE< XFRAME >& rFrame,
					 AddonMenu*			pAddonMenu,
					 sal_Bool			bDelete,
					 sal_Bool			bDeleteChildren );

		MenuManager( REFERENCE< XFRAME >& rFrame,
					 AddonPopupMenu*	pAddonMenu,
					 sal_Bool			bDelete,
					 sal_Bool			bDeleteChildren );

		virtual ~MenuManager();

		// XInterface
		virtual void SAL_CALL acquire() throw()
			{ OWeakObject::acquire(); }
		virtual void SAL_CALL release() throw()
			{ OWeakObject::release(); }
		virtual ::com::sun::star::uno::Any SAL_CALL queryInterface(
			const ::com::sun::star::uno::Type & rType ) throw( RUNTIMEEXCEPTION );

		// XStatusListener
		virtual void SAL_CALL statusChanged( const FEATURSTATEEVENT& Event ) throw ( RUNTIMEEXCEPTION );

		// XEventListener
		virtual void SAL_CALL disposing( const EVENTOBJECT& Source ) throw ( RUNTIMEEXCEPTION );
		
		// XFrameActionListener
		virtual void SAL_CALL frameAction( const FRAMEACTIONEVENT& Action ) throw ( RUNTIMEEXCEPTION );

		DECL_LINK( Select, Menu * );

		Menu*	GetMenu() const { return m_pVCLMenu; }

		void	RemoveListener();

	protected:
		DECL_LINK( Highlight, Menu * );
		DECL_LINK( Activate, Menu * );
		DECL_LINK( Deactivate, Menu * );

	private:
		void UpdateSpecialFileMenu( Menu* pMenu );
		void UpdateSpecialWindowMenu( Menu* pMenu );


		struct MenuItemHandler
		{
			MenuItemHandler( USHORT aItemId, MenuManager* pManager, REFERENCE< XDISPATCH >& rDispatch ) :
				nItemId( aItemId ), pSubMenuManager( pManager ), xMenuItemDispatch( rDispatch ) {}

			USHORT					nItemId;
			::rtl::OUString			aTargetFrame;
			::rtl::OUString			aMenuItemURL;
			::rtl::OUString			aFilter;
			::rtl::OUString			aPassword;
			::rtl::OUString			aTitle;
			MenuManager*			pSubMenuManager;
			REFERENCE< XDISPATCH >	xMenuItemDispatch;
		};

		void			 CreatePicklistArguments(
							::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgsList,
							const MenuItemHandler* );

		MenuItemHandler* GetMenuItemHandler( USHORT nItemId );

		sal_Bool							m_bInitialized;
		sal_Bool							m_bDeleteMenu;
		sal_Bool							m_bDeleteChildren;
		sal_Bool							m_bActive;
		sal_Bool							m_bIsBookmarkMenu;
		sal_Bool							m_bWasHiContrast;
		sal_Bool							m_bShowMenuImages;
		::rtl::OUString						m_aMenuItemCommand;
		Menu*								m_pVCLMenu;
		REFERENCE< XFRAME >					m_xFrame;
		::std::vector< MenuItemHandler* >	m_aMenuItemHandlerVector;
};

} // namespace

#endif
