/*************************************************************************
 *
 *  $RCSfile: PropertyInfo.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: armin $ $Date: 2001/03/08 09:23:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PROPERTYINFO_HXX_
#define _PROPERTYINFO_HXX_

#include <osl/diagnose.h>

#ifndef _COM_SUN_STAR_HIERARCHY_XLOGICALCONTENTPROPERTYINFOMANAGER_HPP_
#include <com/sun/star/hierarchy/XLogicalContentPropertyInfoManager.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XLOGICALCONTENTPROPERTYINFOMANAGERPROVIDER_HPP_
#include <com/sun/star/hierarchy/XLogicalContentPropertyInfoManagerProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_CONTENTPROPERTYINFOFLAGS_HPP_
#include <com/sun/star/hierarchy/ContentPropertyInfoFlags.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_SERVICENOTREGISTEREDEXCEPTION_HPP_
#include <com/sun/star/lang/ServiceNotRegisteredException.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include <com/sun/star/ucb/XContent.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIER_HPP_
#include <com/sun/star/ucb/XContentIdentifier.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUES_HPP_
#include <com/sun/star/beans/PropertyValues.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XCONFIGMANAGER_HPP_
#include <com/sun/star/frame/XConfigManager.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif


#include <list>

using namespace std;
using namespace rtl;
using namespace cppu;
using namespace com::sun::star::hierarchy;
using namespace com::sun::star::registry;
using namespace com::sun::star::frame;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;

// Struct with a List of XLogicalContentPropertyInfoProvider for a special ContentType (and a special Scheme)

struct ProviderList
{
	OUString															aContentTypeName;
	list< Reference< XLogicalContentPropertyInfoProvider > >			aProviderList;
};

// Struct with a List of ContentTypes for a special Scheme

struct ContentTypeList
{
	OUString				aSchemeName;
	list< ProviderList >	aContentTypeList;
};

struct ProviderPriority
{
	Reference< XLogicalContentPropertyInfoProvider >	aProvider;
	long												lPriority;
};



#define MASK_CONTENTPROPERTYINFOFLAGS_MERGING		0x000000f0

const char PropertyInfoRdb[]	= "/propertyinfo.rdb";


// =======================================================================
// OPropertyInfoProviderService
// =======================================================================


class OPropertyInfoProviderService: 
		public XLogicalContentPropertyInfoManagerProvider,
		public XLogicalContentPropertyInfoManager,
		public XServiceInfo,
		public OWeakObject
{
private:
	Reference< XMultiServiceFactory >		m_xMgr;						// MultiServiceFactory
	Reference< XConfigManager >				m_xConfigMgr;				// Config-Manager
	Reference< XSimpleRegistry >			m_xRegistry;				// Registry
	list< ContentTypeList >					m_aList;					// Scheme-ContentType-List

protected:

	list< ContentTypeList >::iterator									searchScheme(const OUString &aScheme);
	list< ProviderList >::iterator										searchContentType(const list< ContentTypeList >::iterator &aItScheme, const OUString &aContentType);
	list< Reference< XLogicalContentPropertyInfoProvider > >::iterator	searchProvider(const list< ProviderList >::iterator &aItContentType, const Reference< XLogicalContentPropertyInfoProvider >& aProvider);


	list< ContentTypeList >::iterator		registerScheme(const OUString &aSchemeName);
	list< ProviderList >::iterator			registerContentType(const list< ContentTypeList >::iterator &aItScheme, const OUString &aContentTypeName);
	void									registerProvider(const list< ProviderList >::iterator &aItContentType, const Reference < XLogicalContentPropertyInfoProvider >& Provider);
	void																registerSortedProviderList(const list< ProviderList >::iterator &aItContentType, list< ProviderPriority > aProviderPriorityList );

	PropertyValues												mergeProperties(const PropertyValues& sPrimaryPropertyValue, const PropertyValues& sSecondaryPropertyValue );

	void		loadPropertyInfoProviderList() throw(InvalidRegistryException, IllegalArgumentException, RuntimeException);
	void		registerProviderInRegistry( const Reference < XLogicalContentPropertyInfoProvider >& Provider, const SchemeContentTypePair& SchemeContentType, list< ProviderList >::iterator aItContentTypeList) throw(InvalidRegistryException, IllegalArgumentException, RuntimeException);
	void		deregisterProviderInRegistry( const Reference < XLogicalContentPropertyInfoProvider >& Provider, const SchemeContentTypePair& SchemeContentType, list< ProviderList >::iterator aItContentTypeList ) throw(InvalidRegistryException, IllegalArgumentException, RuntimeException);


public:

	OPropertyInfoProviderService(const Reference< XMultiServiceFactory >& xMgr);
	~OPropertyInfoProviderService();

	// XInterface
	
	virtual Any								SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
	virtual void 							SAL_CALL acquire() 						 { OWeakObject::acquire(); }
	virtual void 							SAL_CALL release() 						 { OWeakObject::release(); }
	
	// XLogicalContentPropertyInfoManagerProvider
	virtual PropertyValues SAL_CALL getPropertyValuesWithFlags( const Reference< XContent >& Content, sal_Int32 ContentPropertyInfoFlags ) throw(RuntimeException);

	// XLogicalContentPropertyInfoProvider
	virtual PropertyValues SAL_CALL getPropertyValues( const Reference< XContent >& Content, const SchemeContentTypePair& SchemeContentType ) throw(RuntimeException);

	// XLogicalContentPropertyInfoManager

	virtual void SAL_CALL registerLogicalPropertyInfoProvider( const Reference< XLogicalContentPropertyInfoProvider >& Provider, const Sequence< SchemeContentTypePair >& SchemeContentTypes, sal_Bool OverwriteExisting ) throw(RuntimeException);
    virtual void SAL_CALL deregisterLogicalPropertyInfoProvider( const Reference< XLogicalContentPropertyInfoProvider >& Provider, const Sequence< SchemeContentTypePair >& SchemeContentTypes ) throw(IllegalArgumentException, RuntimeException);

	// XServiceInfo
	virtual OUString				SAL_CALL getImplementationName() throw(RuntimeException);
	virtual sal_Bool				SAL_CALL supportsService(const OUString& aServiceName) throw(RuntimeException);
	virtual Sequence< OUString >	SAL_CALL getSupportedServiceNames() throw(RuntimeException);

};

#endif // _PROPERTYINFO_HXX_

