/*************************************************************************
 *
 *  $RCSfile: regtools.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __INETSET_REGTOOLS_HXX__
#define __INETSET_REGTOOLS_HXX__


#if _MSC_VER >= 1200
#include <tools/prewin.h>
#else
#include <tools/presys.h>
#endif
#include <windows.h>
#include <shlobj.h>
#if _MSC_VER >= 1200
#include <tools/postwin.h>
#else
#include <tools/postsys.h>
#endif

#include <rtl/string.hxx>

sal_Bool getRegKey(HKEY rKey, const ::rtl::OString name, HKEY &result);
sal_Bool getRegValue(HKEY rKey, const ::rtl::OString name, DWORD &type,
                 void *buf, DWORD &len);
sal_Bool getRegDWORD(HKEY rKey, const ::rtl::OString name, DWORD &result);
sal_Bool getRegSTRING(HKEY rKey, const ::rtl::OString name, ::rtl::OString &result);

sal_Bool createRegKey(HKEY rKey, const char *rSubKey, const char* rName);
sal_Bool delRegKey(HKEY rKey, const char *rSubKey, const char* rName);
char *getRegValue(HKEY rKey, const char *rSubKey, const char* rName);
sal_Bool isRegKeyAvailable(HKEY rKey, const char *rSubKey, const char* rName);
sal_Bool setRegValue(HKEY rKey, const char *rSubKey,
                 const char *rName, const char *rValue);
sal_Bool setRegDWORD(HKEY rKey, const char *rSubKey,
                 const char *rName, const DWORD &rValue);
sal_Bool setRegBINARY(HKEY rKey, const char *rSubKey, const char *rName,
                  const void *rValue, const int len);

#endif
