/*************************************************************************
 *
 *  $RCSfile: dbidialogs.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_DBIDIALOGS_HXX_
#define _EXTENSIONS_DBI_DBIDIALOGS_HXX_

#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _SV_FIXED_HXX 
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_EDIT_HXX 
#include <vcl/edit.hxx>
#endif
#ifndef _SV_BUTTON_HXX 
#include <vcl/button.hxx>
#endif
#ifndef _SV_BUTTON_HXX 
#include <vcl/button.hxx>
#endif
#ifndef _EXTENSIONS_DBI_FIXEDEDIT_HXX_
#include "fixededit.hxx"
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	//=====================================================================
	//= OQueryNameConflictDialog
	//=====================================================================
	class OQueryNameConflictDialog : public ModalDialog
	{
	protected:
		::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >
					m_xAllNames;

		String		m_sUninitializedMessage;
		String		m_sInvalidName;

		FixedText		m_aMessage;
		FixedText		m_aRequest;
		Edit			m_aNewName;
		OKButton		m_aOK;
		CancelButton	m_aCancel;

	public:
		OQueryNameConflictDialog(
			Window* _pParent,
			const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& _rxAllNames,
			const String& _rCurrentName);

		String	getNewName() const { return m_aNewName.GetText(); }

	protected:
		DECL_LINK( OnOK, void* );
		DECL_LINK( OnNameModified, void* );

		void implUpdateMessage(const String& _rName);
	};

	//=====================================================================
	//= OFormExistsDialog
	//=====================================================================
	class OFormExistsDialog : public ModalDialog
	{
	protected:
		FixedText		m_aExistsLabel;
		FixedEdit		m_aURL;
		FixedText		m_aAlternatives;
		RadioButton		m_aOverwrite;
		RadioButton		m_aSkipForm;
		RadioButton		m_aSaveAs;
		AutoFixedEdit	m_aNewLocalName;
		OKButton		m_aOK;
		CancelButton	m_aCancel;

	public:
		OFormExistsDialog(Window* _pParent, const String& _rCompleteURL);

		sal_Bool	isOverwrite() const { return m_aOverwrite.IsChecked(); }
		sal_Bool	isSkipForm() const { return m_aSkipForm.IsChecked(); }
		sal_Bool	isSaveAs() const { return m_aSaveAs.IsChecked(); }

		String		getNewLocalName() const { return m_aNewLocalName.GetText(); }

	protected:
		DECL_LINK( OnRadioClicked, void* );

		void implCheckEditState();
	};

//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_DBIDIALOGS_HXX_

