/*************************************************************************
 *
 *  $RCSfile: adrmod.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <tools/resmgr.hxx>
#include <svtools/iniprop.hxx>
#include <svtools/iniman.hxx>


#include "adrmod.hxx"
#include "adrresid.hxx"
#include "registry.hxx"
#include "datman.hxx"


static PtrAdrModul pAdrModul=NULL;
static nAdrModulCount=0;


HdlAdrModul	OpenAdrModul()
{
	if(pAdrModul==NULL)
	{
		pAdrModul=new AdrModul();
	}
	nAdrModulCount++;
	return &pAdrModul;
}

void CloseAdrModul(HdlAdrModul ppAdrModul)
{
	nAdrModulCount--;
	if(nAdrModulCount==0 && ppAdrModul!=NULL)
	{
		delete pAdrModul;
		pAdrModul=NULL;
	}
}

PtrAdrModul GetAdrModul()
{
	return pAdrModul;
}

AdrResId::AdrResId( USHORT nId ) :
	ResId( nId, pAdrModul->GetResMgr() )
{
}

AdrModul::AdrModul()
{
	pResMgr = ResMgr::CreateResMgr( "aui" MAKE_NUMSTR(SUPD) );
}

AdrModul::~AdrModul()
{
	delete pResMgr;
}

AdrDataManager*	 AdrModul::createDataManager()
{
	if(!xRegistry.is())
		xRegistry=new AdrRegistry();
	return new AdrDataManager(xRegistry);
}

String AdrModul::GetOldAddressBookURL()
{
	String aString;
	SfxAppIniManagerProperty aProp;
	GetpApp()->Property( aProp );
	if( !aProp.GetIniManager() ) return aString;
	
	String aAddressBook = 
		aProp.GetIniManager()->Get( SFX_KEY_ADDRESSBOOK );
	String aURL=aAddressBook.GetToken( 0, ';' );
	return aURL;
}

// PropertyNames 
STATIC_USTRING(FM_PROP_TABINDEX,L"TabIndex");
STATIC_USTRING(FM_PROP_TAG,L"Tag");
STATIC_USTRING(FM_PROP_NAME,L"Name");
STATIC_USTRING(FM_PROP_CLASSID,L"ClassId");
STATIC_USTRING(FM_PROP_RECORDCOUNT,L"RecordCount");
STATIC_USTRING(FM_PROP_RECORDSTATUS,L"RecordStatus");
STATIC_USTRING(FM_PROP_RECORDCOUNTFINAL,L"IsRecordCountFinal");
STATIC_USTRING(FM_PROP_VALUE,L"Value");
STATIC_USTRING(FM_PROP_TEXT,L"Text");
STATIC_USTRING(FM_PROP_LABEL,L"Label");
STATIC_USTRING(FM_PROP_EDITMODE,L"RecordMode");
STATIC_USTRING(FM_PROP_CANINSERT,L"CanInsert");
STATIC_USTRING(FM_PROP_CANUPDATE,L"CanUpdate");
STATIC_USTRING(FM_PROP_CANDELETE,L"CanDelete");
STATIC_USTRING(FM_PROP_NAVIGATION,L"NavigationBarMode");
STATIC_USTRING(FM_PROP_HASNAVIGATION,L"HasNavigationBar");
STATIC_USTRING(FM_PROP_CYCLE,L"Cycle");
STATIC_USTRING(FM_PROP_CONTROLSOURCE,L"DataField");
STATIC_USTRING(FM_PROP_ENABLED,L"Enabled");
STATIC_USTRING(FM_PROP_READONLY,L"ReadOnly");
STATIC_USTRING(FM_PROP_ISREADONLY,L"IsReadOnly");
STATIC_USTRING(FM_PROP_FILTER_CRITERIA,L"Filter");
STATIC_USTRING(FM_PROP_SORT_CRITERIA,L"SortOrder");
STATIC_USTRING(FM_PROP_ISREQUIRED,L"IsRequired");
STATIC_USTRING(FM_PROP_AUTOINCREMENT,L"IsAutoIncrement");
STATIC_USTRING(FM_PROP_CACHESIZE,L"CacheSize");
STATIC_USTRING(FM_PROP_DATAENTRY,L"DataEntry");
STATIC_USTRING(FM_PROP_LASTDIRTY,L"LastUpdated");
STATIC_USTRING(FM_PROP_STATEMENT,L"Statement");
STATIC_USTRING(FM_PROP_WIDTH,L"Width");
STATIC_USTRING(FM_PROP_SEARCHINFO,L"SearchInfo");
STATIC_USTRING(FM_PROP_MULTILINE,L"MultiLine");
STATIC_USTRING(FM_PROP_TARGET_URL,L"TargetURL");
STATIC_USTRING(FM_PROP_TARGET_FRAME,L"TargetFrame");
STATIC_USTRING(FM_PROP_DEFAULTCONTROL,L"DefaultControl");
STATIC_USTRING(FM_PROP_MAXTEXTLEN,L"MaxTextLen");
STATIC_USTRING(FM_PROP_EDITMASK,L"EditMask");
STATIC_USTRING(FM_PROP_SIZE,L"Size");
STATIC_USTRING(FM_PROP_SPIN,L"Spin");
STATIC_USTRING(FM_PROP_DATE,L"Date");
STATIC_USTRING(FM_PROP_TIME,L"Time");
STATIC_USTRING(FM_PROP_STATE,L"State");
STATIC_USTRING(FM_PROP_TRISTATE,L"TriState");
STATIC_USTRING(FM_PROP_HIDDEN_VALUE, L"HiddenValue");
STATIC_USTRING(FM_PROP_BUTTONTYPE,L"ButtonType");
STATIC_USTRING(FM_PROP_STRINGITEMLIST,L"StringItemList");
STATIC_USTRING(FM_PROP_DEFAULT_TEXT,L"DefaultText");
STATIC_USTRING(FM_PROP_DEFAULTCHECKED,L"DefaultState");
STATIC_USTRING(FM_PROP_FORMATKEY,L"FormatKey");
STATIC_USTRING(FM_PROP_FORMATSSUPPLIER,L"FormatsSupplier");
STATIC_USTRING(FM_PROP_SUBMIT_ACTION,L"SubmitAction");
STATIC_USTRING(FM_PROP_SUBMIT_TARGET,L"SubmitTarget");
STATIC_USTRING(FM_PROP_SUBMIT_METHOD,L"SubmitMethod");
STATIC_USTRING(FM_PROP_SUBMIT_ENCODING,L"SubmitEncoding");
STATIC_USTRING(FM_PROP_IMAGE_URL,L"ImageURL");
STATIC_USTRING(FM_PROP_EMPTY_IS_NULL,L"ConvertEmptyToNull");
STATIC_USTRING(FM_PROP_LISTSOURCETYPE,L"ListSourceType");
STATIC_USTRING(FM_PROP_LISTSOURCE,L"ListSource");
STATIC_USTRING(FM_PROP_SELECT_SEQ,L"SelectedItems");
STATIC_USTRING(FM_PROP_VALUE_SEQ,L"SelectedValues");
STATIC_USTRING(FM_PROP_DEFAULT_SELECT_SEQ,L"DefaultSelection");
STATIC_USTRING(FM_PROP_MULTISELECTION,L"MultiSelection");
STATIC_USTRING(FM_PROP_ALIGN,L"Align");
STATIC_USTRING(FM_PROP_DEFAULT_DATE,L"DefaultDate");
STATIC_USTRING(FM_PROP_DEFAULT_TIME,L"DefaultTime");
STATIC_USTRING(FM_PROP_DEFAULT_VALUE,L"DefaultValue");
STATIC_USTRING(FM_PROP_DECIMAL_ACCURACY,L"DecimalAccuracy");
STATIC_USTRING(FM_PROP_CURSORSOURCE,L"DataSelection");
STATIC_USTRING(FM_PROP_CURSORSOURCETYPE,L"DataSelectionType");
STATIC_USTRING(FM_PROP_DATASOURCE, L"DataSource");
STATIC_USTRING(FM_PROP_FIELDTYPE,L"Type");
STATIC_USTRING(FM_PROP_DECIMALS,L"Decimals");
STATIC_USTRING(FM_PROP_REFVALUE,L"RefValue");
STATIC_USTRING(FM_PROP_VALUEMIN,L"ValueMin");
STATIC_USTRING(FM_PROP_VALUEMAX,L"ValueMax");
STATIC_USTRING(FM_PROP_STRICTFORMAT,L"StrictFormat");
STATIC_USTRING(FM_PROP_ALLOWADDITIONS,L"AllowInserts");
STATIC_USTRING(FM_PROP_ALLOWEDITS,L"AllowUpdates");
STATIC_USTRING(FM_PROP_ALLOWDELETIONS,L"AllowDeletes");
STATIC_USTRING(FM_PROP_MASTERFIELDS,L"MasterFields");
STATIC_USTRING(FM_PROP_SLAVEFIELDS,L"SlaveFields");
STATIC_USTRING(FM_PROP_ISPASSTHROUGH,L"IsPassThrough");
STATIC_USTRING(FM_PROP_QUERY,L"Query");
STATIC_USTRING(FM_PROP_LITERALMASK,L"LiteralMask");
STATIC_USTRING(FM_PROP_VALUESTEP,L"ValueStep");
STATIC_USTRING(FM_PROP_SHOWTHOUSANDSEP,L"ShowThousandsSeparator");
STATIC_USTRING(FM_PROP_CURRENCYSYMBOL,L"CurrencySymbol");
STATIC_USTRING(FM_PROP_DATEFORMAT,L"DateFormat");
STATIC_USTRING(FM_PROP_DATEMIN,L"DateMin");
STATIC_USTRING(FM_PROP_DATEMAX,L"DateMax");
STATIC_USTRING(FM_PROP_DATE_SHOW_CENTURY,L"DateShowCentury");
STATIC_USTRING(FM_PROP_TIMEFORMAT, L"TimeFormat");
STATIC_USTRING(FM_PROP_TIMEMIN, L"TimeMin");
STATIC_USTRING(FM_PROP_TIMEMAX,L"TimeMax");
STATIC_USTRING(FM_PROP_LINECOUNT,L"LineCount");
STATIC_USTRING(FM_PROP_BOUNDCOLUMN, L"BoundColumn");
STATIC_USTRING(FM_PROP_FONT,L"FontDescriptor");
STATIC_USTRING(FM_PROP_BACKGROUNDCOLOR,L"BackgroundColor");
STATIC_USTRING(FM_PROP_FILLCOLOR,L"FillColor");
STATIC_USTRING(FM_PROP_TEXTCOLOR,L"TextColor");
STATIC_USTRING(FM_PROP_LINECOLOR,L"LineColor");
STATIC_USTRING(FM_PROP_BORDER,L"Border");
STATIC_USTRING(FM_PROP_DROPDOWN,L"Dropdown");
STATIC_USTRING(FM_PROP_MULTI,L"Multi");
STATIC_USTRING(FM_PROP_HSCROLL,L"HScroll");
STATIC_USTRING(FM_PROP_VSCROLL,L"VScroll");
STATIC_USTRING(FM_PROP_TABSTOP,L"Tabstop");
STATIC_USTRING(FM_PROP_AUTOCOMPLETE,L"Autocomplete");
STATIC_USTRING(FM_PROP_HARDLINEBREAKS,L"HardLineBreaks");
STATIC_USTRING(FM_PROP_PRINTABLE,L"Printable");
STATIC_USTRING(FM_PROP_ECHO_CHAR,L"EchoChar");
STATIC_USTRING(FM_PROP_ROWHEIGHT,L"RowHeight");
STATIC_USTRING(FM_PROP_HELPTEXT, L"HelpText");
STATIC_USTRING(FM_PROP_FONT_NAME, L"FontName");
STATIC_USTRING(FM_PROP_FONT_STYLENAME, L"FontStyleName");
STATIC_USTRING(FM_PROP_FONT_FAMILY, L"FontFamily");
STATIC_USTRING(FM_PROP_FONT_CHARSET, L"FontCharset");
STATIC_USTRING(FM_PROP_FONT_HEIGHT, L"FontHeight");
STATIC_USTRING(FM_PROP_FONT_WEIGHT, L"FontWeight");
STATIC_USTRING(FM_PROP_FONT_SLANT, L"FontSlant");
STATIC_USTRING(FM_PROP_FONT_UNDERLINE, L"FontUnderline");
STATIC_USTRING(FM_PROP_FONT_STRIKEOUT, L"FontStrikeout");
STATIC_USTRING(FM_PROP_HELPURL, L"HelpURL");
STATIC_USTRING(FM_PROP_RECORDMARKER, L"HasRecordMarker");
STATIC_USTRING(FM_PROP_BOUNDFIELD, L"BoundField");
STATIC_USTRING(FM_PROP_TREATASNUMERIC, L"TreatAsNumber");
STATIC_USTRING(FM_PROP_EFFECTIVE_VALUE, L"EffectiveValue");
STATIC_USTRING(FM_PROP_EFFECTIVE_DEFAULT, L"EffectiveDefault");
STATIC_USTRING(FM_PROP_EFFECTIVE_MIN, L"EffectiveMin");
STATIC_USTRING(FM_PROP_EFFECTIVE_MAX, L"EffectiveMax");
STATIC_USTRING(FM_PROP_HIDDEN, L"Hidden");
STATIC_USTRING(FM_PROP_FILTERPROPOSAL, L"useFilterValueProposal");
STATIC_USTRING(FM_PROP_FIELDSOURCE, L"FieldSource");
STATIC_USTRING(FM_PROP_TABLENAME, L"TableName");
STATIC_USTRING(FM_PROP_FILTERSUPPLIER, L"FilterSupplier");
STATIC_USTRING(FM_PROP_CURRENTFILTER, L"CurrentFilter");
STATIC_USTRING(FM_PROP_SELECTED_FIELDS, L"SelectedFields");
STATIC_USTRING(FM_PROP_SELECTED_TABLES, L"SelectedTables");
STATIC_USTRING(FM_PROP_THREADSAFE, L"ThreadSafe");


