/*************************************************************************
 *
 *  $RCSfile: xml.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <xml.hxx>



OElement OXMLReader::getHead()
{
	{
		OGuard aGuard( m_aMutex );
		if( m_bDone && !m_aQueue.size() )
			THROW( SAXException() );
	}

	m_aDataAvailable.wait();
	OGuard aGuard( m_aMutex );
	OElement aElement = m_aQueue.front();
	m_aQueue.pop_front();
	return aElement;
}

void OXMLReader::pushBack( const OElement& rElement )
{
	OGuard aGuard( m_aMutex );
	m_aQueue.push_front( rElement );
	m_aDataAvailable.set();
}

XIdlClassRef OXMLReader::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OXMLReader", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XAddressBookXMLImport_getReflection(),
		XActiveDataSource_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OXMLReader::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OXMLReader::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XDocumentHandler );
	QUERYIFACE( XAddressBookXMLImport );
	return UsrObject::queryInterface( aUik, rOut );
}

void OXMLReader::setTarget( const UsrAny& rResult )
{
	OGuard aGuard( m_aMutex );
	m_aAny = rResult;
}

UsrAny OXMLReader::getResult()
{
	return m_aAny;
}

void OXMLReader::run()
{
	TRY
	{
		UsrAny aAny;
		{
			OGuard aGuard( m_aMutex );
			aAny = m_aAny;
		}
		readValue( aAny.getReflection(), aAny.get() );
		{
			OGuard aGuard( m_aMutex );
			m_aAny = aAny;
		}
	}
	CATCH( UsrException, e )
	{
		m_aException = exceptionToAny( e );
	}
	END_CATCH;
}

Reflection* OXMLReader::getSubElementReflection( 
	Reflection* pRefl, const void* pDest, const UString& rSubElement )
{
	switch( pRefl->getTypeClass() )
	{
		case TypeClass_STRUCT:
		{
			XIdlFieldRef xField = 
				pRefl->getIdlClass()->getField( rSubElement );
			if( !xField.is() ) THROW( SAXException() );
			return getReflectionFromClass( xField->getType() );
		}
		case TypeClass_INTERFACE:
		{
			XPropertySetRef xProp( *(const XInterfaceRef*) pDest, USR_QUERY );
			if( xProp.is())
			{
				if( !xProp->getPropertySetInfo()->hasPropertyByName(
					rSubElement ) ) THROW( SAXException() );
				return getReflectionFromClass(
					xProp->getPropertySetInfo()->getPropertyByName(
						rSubElement ).Type );
			}
			break;
		}
	}
	THROW( SAXException() );
	return 0;
}

void OXMLReader::setSubElement(
	Reflection* pRefl, void* pDest, const UString& rSubElement, 
	const UsrAny& rAny )
{
	switch( pRefl->getTypeClass() )
	{
		case TypeClass_STRUCT:
		{
			XIdlFieldRef xField = 
				pRefl->getIdlClass()->getField( rSubElement );
			if( !xField.is() ) THROW( SAXException() );
			UsrAny aTmp( pDest, pRefl );
			xField->set( aTmp, rAny );
			pRefl->assignObject( pDest, aTmp.get() );
			return;
		}
		case TypeClass_INTERFACE:
		{
			XPropertySetRef xProp( *(const XInterfaceRef*) pDest, USR_QUERY );
			if( xProp.is() )
			{
				xProp->setPropertyValue(
					rSubElement, rAny );
				return;
			}
			break;
		}
	}
	THROW( SAXException() );
}

void OXMLReader::readValue( Reflection* pReflection, void* pDest )
{
	if( pReflection->getTypeClass() == TypeClass_ANY )
	{
		XIdlClassRef xClass;
		readValue( XIdlClass_getReflection(), &xClass );
		UsrAny& rAny = *(UsrAny*)pDest;
		getReflectionFromClass( xClass )->createObject( rAny );
		readValue( rAny.getReflection(), rAny.get() );
		return;
	}

	OElement aElement = getHead();
	if( aElement.m_aName == L"key" && aElement.m_bStart )
	{
		// Value is a subkey so read subproperty
		UString aSubElement = aElement.m_xAttributes->getValueByName( L"name" );
		UsrAny aSubAny;
		Reflection* pSubRefl = getSubElementReflection(
			pReflection, pDest, aSubElement );
		// Usr Bug: otherwise we'll get an any in an any
		if( !pSubRefl->equals( *UsrAny_getReflection() ) )
		{
			pSubRefl->createObject( aSubAny );
			readValue( aSubAny.getReflection(), aSubAny.get() );
		}
		else readValue( UsrAny_getReflection(), &aSubAny );
		setSubElement( pReflection, pDest, aSubElement, aSubAny );

		// Read closing key
		getHead();
		return;
	}
	if( aElement.m_aName == L"struct" && aElement.m_bStart )
	{
		// read a struct
		while( TRUE )
		{
			aElement = getHead();
			if( aElement.m_aName == L"struct" && !aElement.m_bStart )
				return;
			pushBack( aElement );
			readValue( pReflection, pDest );
		}
	}
	
	// actual simple value
	switch( pReflection->getTypeClass() )
	{
		case TypeClass_STRING:
		{
			if( aElement.m_aName != L"string" )
				THROW( SAXException() );
			*(UString*)pDest = aElement.m_xAttributes->getValueByName( L"value" );
			getHead();
			return;
		}
		case TypeClass_SHORT:
		{
			if( aElement.m_aName != L"number" )
				THROW( SAXException() );
			*(INT16*)pDest = (INT16)SHOULDTAKEUNICODE( 
				aElement.m_xAttributes->getValueByName( L"value" ) );
			getHead();
			return;
		}
		case TypeClass_LONG:
		{
			if( aElement.m_aName != L"number" )
				THROW( SAXException() );
			*(INT32*)pDest = (INT32)SHOULDTAKEUNICODE( 
				aElement.m_xAttributes->getValueByName( L"value" ) );
			getHead();
			return;
		}
		case TypeClass_BOOLEAN:
		{
			if( aElement.m_aName != L"boolean" )
				THROW( SAXException() );
			*(BOOL*)pDest = aElement.m_xAttributes->getValueByName( L"value" ) == L"true";
			getHead();
			return;
		}
		case TypeClass_SEQUENCE:
		{
			SequenceReflection* pSeqRef = (SequenceReflection*)pReflection;
			UsrAny aAny;
			pReflection->createObject( aAny );

			// read <sequence>
			aElement = getHead();

			// empty sequence -> pushback key
			if( aElement.m_aName == L"key" && !aElement.m_bStart)
			{
				pushBack( aElement );
				pSeqRef->assignObject( pDest, aAny.get() );
				return;
			}
			pushBack( aElement );

			INT32 nLen = 0;
			// empty array
			UsrAny aSubAny;
			do
			{
				aElement = getHead();
				if( aElement.m_aName == L"sequence" && aElement.m_bStart == FALSE )
				{
					pReflection->assignObject( pDest, aAny.get() );
					return;
				}
				pushBack( aElement );
				
				pSeqRef->realloc( aAny, nLen + 1 );
				pSeqRef->getElementReflection()->createObject( aSubAny );
				readValue( 
					aSubAny.getReflection(), aSubAny.get() );
				pSeqRef->set( aAny, nLen++, aSubAny );
			}
			while( TRUE );
		}
		case TypeClass_INTERFACE:
		{
			if( XIdlClass_getReflection()->equals( *pReflection ) )
			{
				UString aType;
				pushBack( aElement );
				readValue( OUString_getReflection(), &aType );
				XIdlClassRef xRet;
				if( aType.len() )
				{
					XIdlReflectionRef xProv( 
						getProcessServiceManager()->createInstance(
							L"com.sun.star.reflection.CoreReflection" ), USR_QUERY );
					xRet = xProv->forName( aType );
				}
				*(XIdlClassRef*)pDest = xRet;
				return;
			}
			break;
		}
		case TypeClass_ENUM:
		{
			UString aValue = aElement.m_xAttributes->getValueByName( 
				L"value" );
			XIdlFieldRef xField = 
				pReflection->getIdlClass()->getField(
					aValue );
			if( !xField.is() ) THROW( SAXException() );
			UsrAny aResult = xField->get( UsrAny() );
			aResult.setEnumAsINT32( 
				aResult.getINT32(), pReflection );
			pReflection->assignObject( pDest, aResult.get() );
			getHead();
			return;
		}
	}
	THROW( SAXException());
}


void OXMLReader::startDocument(void)
	THROWS( (SAXException, UsrSystemException) ) 
{
	create();
}

void OXMLReader::endDocument(void)
	THROWS( (SAXException, UsrSystemException) ) 
{
	m_bDone = TRUE;
	m_aDataAvailable.set();
	join();
	if( m_aException.get() )
		throwException( m_aException );
}

void OXMLReader::startElement(
	const UString& aName, const XAttributeListRef& xAttribs) THROWS( (SAXException, UsrSystemException) ) 
{
	OElement aElem;
	aElem.m_nLine = m_xLocator->getLineNumber();
	aElem.m_aName = aName;
	aElem.m_bStart = TRUE;
	XCloneableRef xClone( xAttribs, USR_QUERY );
	aElem.m_xAttributes = XAttributeListRef( xClone->createClone(), USR_QUERY );
	OGuard aGuard( m_aMutex );
	m_aQueue.push_back( aElem );
	m_aDataAvailable.set();
}

void OXMLReader::endElement(
	const UString& aName) THROWS( (SAXException, UsrSystemException) ) 
{
	OElement aElem;
	aElem.m_nLine = m_xLocator->getLineNumber();
	aElem.m_aName = aName;
	aElem.m_bStart = FALSE;
	OGuard aGuard( m_aMutex );
	m_aQueue.push_back( aElem );
	m_aDataAvailable.set();
}

void OXMLReader::characters(
	const UString& aChars) THROWS( (SAXException, UsrSystemException) ) 
{
}

void OXMLReader::ignorableWhitespace(
	const UString& aWhitespaces) THROWS( (SAXException, UsrSystemException) ) 
{
}

void OXMLReader::processingInstruction(
	const UString& aTarget, const UString& aData) THROWS( (SAXException, UsrSystemException) ) 
{
}

void OXMLReader::setDocumentLocator(
	const XLocatorRef& xLocator) THROWS( (SAXException, UsrSystemException) ) 
{
	m_xLocator = xLocator;
}
