/******************************************************************************
#*	$Id: parser.y,v 1.3 2003/03/25 16:01:25 hr Exp $
******************************************************************************/

%union 
{
	sal_Unicode*                      m_pString;
    AddressBookQueryTerm*         m_pQueryTerm;
    AddressBookQueryFunction      m_eQueryFunction;
}

/* Token */
%token <m_pString>       value
%token <m_pString>       attrib

%type <m_pQueryTerm>    item
%type <m_pQueryTerm>    and
%type <m_pQueryTerm>    or
%type <m_pQueryTerm>    not

%type <m_pQueryTerm>    filtercomp

%type <m_pQueryTerm>    filter
%type <m_pQueryTerm>    filterlist

%type <m_eQueryFunction>  filtertype

%start filter
%%

filter: '(' filtercomp ')'
{
	$$ = $2;
	pTerm = $$;
};

filtercomp: and | or | not | item
;

and: '&' filterlist
{
	$$ = $2;
	$$->Function = AddressBookQueryFunction_AND;
}
;

or: '|' filterlist
{
	$$ = $2;
	$$->Function = AddressBookQueryFunction_OR;
};

not: '!' filter
{
	$$ = new AddressBookQueryTerm;
	$$->Function = AddressBookQueryFunction_NOT;
	UsrAny aAny( $2, AddressBookQueryTerm_getReflection() );
	$$->Arguments = Sequence<UsrAny>( &aAny, 1 );
	delete $2;
};

filterlist: filter
{
	$$ = new AddressBookQueryTerm;
	UsrAny aAny( $1, AddressBookQueryTerm_getReflection() );
	$$->Arguments = Sequence<UsrAny>( &aAny, 1 );
	delete $1;
}
| filterlist filter 
{
	Sequence<UsrAny> aSeq( $1->Arguments.getLen() + 1 );
	UsrAny* pData = aSeq.getArray();
	pData[ 0 ].set( $2, AddressBookQueryTerm_getReflection() );
	copy( $1->Arguments.getConstArray(), $1->Arguments.getConstArray() + 
		  $1->Arguments.getLen(), pData + 1 );
	$1->Arguments = aSeq;
	$$ = $1;
}
;

item: attrib filtertype value
{
	$$ = new AddressBookQueryTerm;
	if( $2 == AddressBookQueryFunction_EQUALITYMATCH &&
		UString( L"*" ) == $3 )
	{
		$$->Function = AddressBookQueryFunction_PRESENT;
		UsrAny aStr;
		aStr.setString( $1 );
		$$->Arguments = Sequence<UsrAny>( &aStr, 1 );
		delete $3;
		delete $1;
	}
	else
	{
		if( UString( $3 ).search( L'*' ) != -1 )
		{
			$$->Function = AddressBookQueryFunction_SUBSTRINGS;
			vector<UString> aStrings;
			parseSubstrings( $3, aStrings );
			delete[] $3;
			$$->Arguments.realloc( aStrings.size() + 1 );
			UsrAny* pSeq = $$->Arguments.getArray();
			const UsrAny* pEnd = pSeq + $$->Arguments.getLen();
			*pSeq++ <<= UString( $1 );
			delete[] $1;
			vector<UString>::const_iterator aIter = aStrings.begin();
			while( pSeq != pEnd )
				*pSeq++ <<= *aIter++;
		}
		else 
		{
			$$->Function = $2;
			UsrAny aList[ 2 ];
			aList[ 0 ] <<= UString( $1 );
			aList[ 1 ] <<= UString( $3 );
			delete[] $1;
			delete[] $3;
			$$->Arguments = Sequence<UsrAny>( aList, 2 );
		}
	}
};

filtertype: '=' 
{
	$$ = AddressBookQueryFunction_EQUALITYMATCH;
}
| '~' '=' 
{
	$$ = AddressBookQueryFunction_APPROXMATCH;
}
| '>' '=' 
{
	$$ = AddressBookQueryFunction_GREATEROREQUAL;
}
| '<' '='
{
	$$ = AddressBookQueryFunction_LESSOREQUAL;
}
;


