/*************************************************************************
 *
 *  $RCSfile: pkgchk_basic.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/02 15:27:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_env.h"

#include "com/sun/star/io/XActiveDataSource.hpp"
#include "com/sun/star/xml/sax/XExtendedDocumentHandler.hpp"


using namespace ::std;
using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;

namespace pkgchk
{

//______________________________________________________________________________
OUString pkgchk_env::basic_get_libname( OUString const & path ) const
{
    try
    {
        ::xmlscript::LibDescriptor import;
        xml_parse(
            expand_reg_url( path ),
            ::xmlscript::importLibrary( import ) );
        return import.aName;
    }
    catch (RuntimeException &)
    {
        throw;
    }
    catch (Exception & exc)
    {
        OUStringBuffer buf( 128 );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                             "retrieving basic library name of ") );
        buf.append( path );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                             ": failed!  exception occured: ") );
        buf.append( exc.Message );
        err( buf.makeStringAndClear() );
        return OUString();
    }
}

//______________________________________________________________________________
void pkgchk_env::basic_flush( basic_libs * libs ) const
{
    if (!libs->m_inited || !libs->m_modified)
        return;
    
    ::xmlscript::LibDescriptorArray export_array( libs->m_map.size() );
    t_libs_map::iterator iPos( libs->m_map.begin() );
    t_libs_map::iterator iEnd( libs->m_map.end() );
    size_t nPos = 0;
    while (iPos != iEnd)
    {
        export_array.mpLibs[ nPos ] = iPos->second;
        ++nPos;
        ++iPos;
    }
    
    try
    {
        // raise sax writer
        Reference< XComponentContext > const & xContext =
            get_component_context();
        Reference< xml::sax::XExtendedDocumentHandler > xHandler(
            xContext->getServiceManager()->createInstanceWithContext(
                OUSTR("com.sun.star.xml.sax.Writer"), xContext ), UNO_QUERY );
        if (! xHandler.is())
        {
            throw DeploymentException(
                OUSTR("no sax writer available!"), Reference< XInterface >() );
        }
        
        // try to erase xlc file
        File::remove( libs->m_container_path );
        // create new one
        Reference< io::XActiveDataSource > xSource( xHandler, UNO_QUERY_THROW );
        xSource->setOutputStream(
            get_simple_file_access()->openFileWrite( libs->m_container_path ) );
        
        ::xmlscript::exportLibraryContainer( xHandler, &export_array );
    }
    catch (RuntimeException &)
    {
        throw;
    }
    catch (Exception & exc)
    {
        throw RuntimeException(
            exc.Message, Reference< XInterface >() );
    }
    
    libs->m_modified = false;
    
    OUStringBuffer buf( 64 );
    buf.appendAscii(
        RTL_CONSTASCII_STRINGPARAM("updated basic library container file ") );
    buf.append( libs->m_container_path );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
    log( buf.makeStringAndClear() );
}

//______________________________________________________________________________
void pkgchk_env::basic_verify_init( basic_libs * libs )
{
    if (! libs->m_inited)
    {
        if (path_exists( libs->m_container_path ))
        {
            OUStringBuffer buf( 128 );
            buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                                 "reading basic library container file ") );
            buf.append( libs->m_container_path );
            try
            {
                ::xmlscript::LibDescriptorArray import_array;
                xml_parse(
                    libs->m_container_path,
                    ::xmlscript::importLibraryContainer( &import_array ) );
                
                for ( sal_Int32 nPos = import_array.mnLibCount; nPos--; )
                {
                    ::xmlscript::LibDescriptor const & descr =
                          import_array.mpLibs[ nPos ];
                    pair< t_libs_map::iterator, bool > insertion(
                        libs->m_map.insert(
                            t_libs_map::value_type( descr.aName, descr ) ) );
                    OSL_ASSERT( insertion.second );
                }
                
                buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
                log( buf.makeStringAndClear() );
            }
            catch (RuntimeException &)
            {
                throw;
            }
            catch (Exception & exc)
            {
                buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                                     ": failed!  exception occured: ") );
                buf.append( exc.Message );
                err( buf.makeStringAndClear() );
            }
        }
        libs->m_modified = false;
        libs->m_inited = true;
    }
}

//______________________________________________________________________________
bool pkgchk_env::basic_insert( OUString const & path )
{
    basic_libs * libs;
    if (ends_with_ignore_ascii_case(
            path, RTL_CONSTASCII_STRINGPARAM("/script.xlb") ))
    {
        libs = &m_basic_script_libs;
    }
    else if (ends_with_ignore_ascii_case(
                 path, RTL_CONSTASCII_STRINGPARAM("/dialog.xlb") ))
    {
        libs = &m_basic_dialog_libs;
    }
    else
    {
        OUStringBuffer buf( 128 );
        buf.appendAscii(
            RTL_CONSTASCII_STRINGPARAM("inserting basic library file ") );
        buf.append( path );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                             " into basic library container: failed!  "
                             "Library file name must either be script.xlb "
                             "or dialog.xlb!") );
        err( buf.makeStringAndClear() );
    }
    
    bool ret = false;
    
    // opt: expand here only once
    OUString expanded_path( path_make_absolute( expand_reg_url( path ) ) );
    
    ::xmlscript::LibDescriptor descr;
    descr.aName = basic_get_libname( expanded_path );
    if (0 != descr.aName.getLength())
    {
        descr.aStorageURL = path;
        descr.bLink = sal_False;
        // all other fields are ignored by xmlscript lib export        
        basic_verify_init( libs );
        if (m_supersede_basic_libs)
        {
            t_libs_map::const_iterator iFind( libs->m_map.find( descr.aName ) );
            if (libs->m_map.end() != iFind) // found one
            {
                if (! expanded_path.equals(
                        path_make_absolute(
                            expand_reg_url( iFind->second.aStorageURL ) ) ))
                {
                    // different lib
                    libs->m_map[ descr.aName ] = descr;
                    libs->m_modified = true;
                }
                ret = true;
            }
        }
        if (! ret)
        {
            pair< t_libs_map::iterator, bool > insertion(
                libs->m_map.insert(
                    t_libs_map::value_type( descr.aName, descr ) ) );
            if (insertion.second)
            {
                libs->m_modified = true;
                ret = true;
            }
        }
    }
    
    // log
    OUStringBuffer buf( 128 );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("inserting basic library ") );
    buf.append( descr.aName );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" (") );
    buf.append( path );
    buf.appendAscii(
        RTL_CONSTASCII_STRINGPARAM(") into basic library container") );
    if (ret)
    {
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
        log( buf.makeStringAndClear() );
    }
    else
    {
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": failed!") );
        if (0 == descr.aName.getLength())
        {
            buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                                 "  Cannot determine library name!") );
        }
        else
        {
            buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                                 "  Library name already exists!") );
        }
        err( buf.makeStringAndClear() );
    }
    
    return ret;
}

//______________________________________________________________________________
bool pkgchk_env::basic_remove(
    basic_libs * libs, OUString const & path, bool exact )
{
    bool ret = false;
    
    basic_verify_init( libs );
    if (exact)
    {
        OUString libname( basic_get_libname( path ) );
        if (libname.getLength())
        {
            size_t erased = libs->m_map.erase( libname );
            if (0 < erased)
            {
                libs->m_modified = true;
                ret = true;
            }
        }
    }
    else // erase some matching url
    {
        OUString expanded_path( path_make_absolute( expand_reg_url( path ) ) );
        
        t_libs_map::iterator iPos( libs->m_map.begin() );
        t_libs_map::iterator iEnd( libs->m_map.end() );
        while (iPos != iEnd)
        {
            OUString const & url = iPos->second.aStorageURL;
            if (0 != url.getLength() /* storage url set */ &&
                path_make_absolute( expand_reg_url( url ) ).match(
                    expanded_path ))
            {
                t_libs_map::iterator iErase( iPos );
                ++iPos;
                libs->m_map.erase( iErase );
                libs->m_modified = true;
            }
            else
            {
                ++iPos;
            }
        }
        ret = true; // always successful
    }
    
    // log
    OUStringBuffer buf( 128 );
    if (exact)
    {
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                             "removing basic library with path ") );
    }
    else
    {
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                             "removing all basic libraries matching path ") );
    }
    buf.append( path );
    buf.appendAscii(
        RTL_CONSTASCII_STRINGPARAM(" from basic library container") );
    if (ret)
    {
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(": ok.") );
        log( buf.makeStringAndClear() );
    }
    else
    {
        buf.appendAscii(
            RTL_CONSTASCII_STRINGPARAM(": failed!") );
        // just warn when revoking
        warn( buf.makeStringAndClear() );
    }
    
    return ret;
}

//______________________________________________________________________________
bool pkgchk_env::basic_remove( OUString const & path )
{
    basic_libs * libs;
    if (ends_with_ignore_ascii_case(
            path, RTL_CONSTASCII_STRINGPARAM("/script.xlb") ))
    {
        libs = &m_basic_script_libs;
    }
    else if (ends_with_ignore_ascii_case(
                 path, RTL_CONSTASCII_STRINGPARAM("/dialog.xlb") ))
    {
        libs = &m_basic_dialog_libs;
    }
    else
    {
        OUStringBuffer buf( 128 );
        buf.appendAscii(
            RTL_CONSTASCII_STRINGPARAM("inserting basic library file ") );
        buf.append( path );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(
                             " into basic library container: failed!  "
                             "Library file name must either be script.xlb "
                             "or dialog.xlb!") );
        // just warn when revoking
        warn( buf.makeStringAndClear() );
    }
    
    return basic_remove( libs, path, true /* exact */ );
}

//______________________________________________________________________________
bool pkgchk_env::basic_remove_cache_entries()
{
    bool ret = basic_remove(
        &m_basic_script_libs, m_reg_cache_path, false /* ! wildcard */ );
    ret = basic_remove(
        &m_basic_dialog_libs, m_reg_cache_path, false /* ! wildcard */ ) && ret;
    return ret;
}

}
