/*************************************************************************
 *
 *  $RCSfile: javaldx.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/29 08:33:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/stat.h>
#include <osl/file.h>
#include <osl/profile.hxx>
#include <osl/security.hxx>
#include <sal/types.h>
#include <rtl/ustring.hxx>
#include <tools/solar.h>
#include "jvmaccess/javainfo.hxx"
#include <rtl/bootstrap.hxx>
#include <osl/nlsupport.h>
#include <osl/thread.hxx>
#include <com/sun/star/uno/Sequence.hxx>
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif


using namespace rtl;
using namespace osl;

using namespace ::com::sun::star::uno;

#define OUSTR(x) OUString(RTL_CONSTASCII_USTRINGPARAM( x ))

static int searchForJava();
static int useLinks();
static sal_Bool  getLibPathFromJavarc(OUString& usLibPath);
static sal_Bool hasOption(char* szOption, int argc, char** argv);
static sal_Bool createJavaDir( const OUString& usInstallPath);
static sal_Bool createLinks( const OUString& usDirName, Sequence<OUString>& seqPaths);

#define HELP_TEXT    \
"\njavaldx is necessary to make Java work on some UNIX platforms." \
"It prints a string to std out that consists of directories which " \
"have to be included into the LD_LIBRARY_PATH variable.The setting of " \
"the variable usually occurs in a shell script that runs javaldx.\n" \
"The directories are either part of a java installation or they are " \
"links which point to directories of a java installation. If they are " \
"links then a javarc was found otherwise it was searched for the best " \
"java on the system. The links are always in \n" \
"<install-dir>/user/temp/java\n \n\n" \
"Options are: \n"\
"--help or -h\n"

int main(int argc, char **argv)
{
    if( hasOption("--help",argc, argv) || hasOption("-h", argc, argv))
        fprintf(stdout, HELP_TEXT);// default
    else
        return searchForJava();
    return -1;
}

static sal_Bool hasOption(char* szOption, int argc, char** argv)
{
    sal_Bool retVal= sal_False;
    for(sal_Int16 i= 1; i < argc; i++)
    {
        if( ! strcmp(argv[i], szOption))
        {
            retVal= sal_True;
            break;
        }
    }
    return retVal;
}

/* If bUseJavarcOnly is true then only then only the JavaInfo API is used.

 */
static int searchForJava()
{
    int res= 0;

    OUString usUserDir;
    OUString usBaseDir;
	Bootstrap::get(OUSTR("BaseInstallation"),
				   usBaseDir,
				   OUSTR("${$SYSBINDIR/bootstraprc:BaseInstallation}"));
	Bootstrap::get(OUSTR("UserInstallation"),
				   usUserDir,
				   OUSTR("${$SYSBINDIR/bootstraprc:UserInstallation}"));

    if(usUserDir.getLength())
    {
        //office: javarc in BaseInstallation/share/config,or UserInstallation/user/config
        res= useLinks();
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"### javaldx: got javarc from UserInstallation, setting links, result: %s\n", res == 0 ? "ok" : "failed");
#endif
    }
    else if(usBaseDir.getLength())
    {
        //Case: workstation setup from a network installation.
        // javarc in net_inst/share/config
        OUString usLibPath;
        Bootstrap::get(OUSTR("JavaLibPath"), usLibPath,
                       OUSTR("${${$SYSBINDIR/bootstraprc:BaseInstallation}/share/config/javarc:Java:JavaLibPath}"));
        OString sLibPath;
        if( ! usLibPath.convertToString(&sLibPath, osl_getThreadTextEncoding(),
                                  RTL_UNICODETOTEXT_FLAGS_UNDEFINED_ERROR |
                                      RTL_UNICODETOTEXT_FLAGS_INVALID_ERROR))
        {
            res= -1;
        }
        else
        {
            if(sLibPath.getLength())
            {
                fprintf(stdout, "%s\n", sLibPath.getStr());
                res = 0;
            }
        }
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"### javaldx: got javarc from BaseInstallation, result: %s\n",res == 0 ? "ok" : "failed");
#endif
    }
    else
    {
    //Case: setup, no javarc, no user/temp yet
        try
        {
            rtl::OUString aDirs(jvmaccess::JavaInfo::createBestInfo(true).
                                getLibLocations());
            rtl::OString sLibsSearch;
            if (!aDirs.convertToString(
                    &sLibsSearch, osl_getThreadTextEncoding(),
                    RTL_UNICODETOTEXT_FLAGS_UNDEFINED_ERROR
                    | RTL_UNICODETOTEXT_FLAGS_INVALID_ERROR))
                res = -1;

            // finally print the paths which are used for Java to stdout
            if( sLibsSearch.getLength())
            {
                fprintf(stdout, "%s\n", sLibsSearch.getStr());
                res = 0;
            }
        }
        catch (jvmaccess::JavaInfo::InitException &)
        {
            res = -1;
        }
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"### javaldx: no javarc found, searching for java, result: %s\n",res == 0 ? "ok" : "failed");
#endif

    }
	return res;
}

/* In order to find the javarc, the UserInstallation and BaseInstallation are used.

   The function requires a user/temp directory. this is not the case when a workstation installation
   is done. Then a javarc is in net_install/share/config/javarc.
 */
static int useLinks()
{
    int retVal= -1;
    OUString usInstallDir;

	// get the url for the user installation directory
	Bootstrap::get(OUSTR("UserInstallation"),
				   usInstallDir,
				   OUSTR("${$SYSBINDIR/bootstraprc:UserInstallation}"));

    // make sure that a user/temp/java directory is available
    sal_Bool bTempExists= sal_True;
    sal_Bool bError= sal_False;
    if( createJavaDir(usInstallDir))
    {
        // create links in <install>/user/temp/java which point
        // to the directories as indicated in javarc:JavaLibPath
        OUString usJavaDir(usInstallDir + OUSTR("/user/temp/java"));
        Sequence<OUString> seqPaths;
        OString sOut;
        if(createLinks(usJavaDir, seqPaths))
        {
            sal_Int32 len= seqPaths.getLength();
            for(sal_Int32 i= 0; i < len; i++)
            {
                if( i != 0)
                    sOut += ":";
                sOut += OUStringToOString(seqPaths[i], osl_getThreadTextEncoding());
            }
        }
        else
        {
            //prepare the paths for the the java directories, even if there are
            // no corresponding links yet.
            OUString usJavaDirPath;
            if( osl_File_E_None == osl_getSystemPathFromFileURL(usJavaDir.pData, &usJavaDirPath.pData))
            {
                OUString ouAll(usJavaDirPath + OUSTR("/a:") +
                               usJavaDirPath + OUSTR("/b:") +
                               usJavaDirPath + OUSTR("/c"));
                sOut= OUStringToOString(ouAll, osl_getThreadTextEncoding());
            }
            else
            {
                fprintf(stderr,"javaldx: osl_getSystemPathFromFileURL failed");
                bError= sal_True;
            }
        }

        if( ! bError)
        {
            //now write the links to stdout
            fprintf(stdout, "%s\n", sOut.getStr());
            retVal= 0;
        }
        else
            retVal= -1;
     }
    return retVal;
}

/* The function creates links in <install-dir>/user/temp/java
   with names, such as "a", "b", "c" which point to the directories
   as contained in the JavaLibPath entry in the javarc.
   @param usDirName contains the path to the directory in which
   the links tho the java directories are to be created.
   @param seqPaths out-param. It contains the links which have been created
 */
static sal_Bool createLinks(const OUString& usDirName, Sequence<OUString>& seqPaths)
{

    sal_Bool bSuccess= sal_True;
    //get the paths
    OUString usPaths;
    if(getLibPathFromJavarc(usPaths))
    {
        //separate the path string into the respective paths
        usPaths.trim();
        sal_Int32 nIndex = 0;
        sal_Int8 cEntries= 0;
        Sequence<OUString> seqPath(5);
        do
        {
            if(cEntries == seqPath.getLength())
                seqPath.realloc(seqPath.getLength() + 5);
            seqPath[cEntries] = usPaths.getToken( 0, ':', nIndex );
            //dont mind the empty strings which are returnd when there is a
            //leading or trailing ':' or two paths are separated by '::'
            seqPath[cEntries].trim();
            if(seqPath[cEntries].getLength() > 0)
                cEntries++;
        }
        while ( nIndex >= 0 );

        char szLinkName[] = "a";

        //allocate space for the out param seqPaths
        seqPaths.realloc(cEntries);
        for( sal_Int8 i= 0; i < cEntries; i++)
        {
            //remove link if exists
            // we have to use a system function since osl_removeDirectory and
            // osl_removeFile dont work currently (bug)
            OUString usSysPathDir;
            osl_getSystemPathFromFileURL(usDirName.pData, &usSysPathDir.pData);
            OString sDir= OUStringToOString(usSysPathDir, osl_getThreadTextEncoding());
            OString sFullLinkName(sDir + OString("/") + OString(szLinkName));
            // if the link does not exist then -1 is returned
            sal_Int32 err= unlink(sFullLinkName);

            //create a new link
            OString sJavaDir= OUStringToOString(seqPath[i], osl_getThreadTextEncoding());
            err= symlink(sJavaDir, sFullLinkName);
            if(err != 0)
            {
                fprintf(stderr,"javaldx: could not create link of name: %s which " \
                        "links to %s, symlink error:  %i \n", sFullLinkName.getStr(),
                        sJavaDir.getStr(), err);
                bSuccess= sal_False;
                break;
            }
            seqPaths[i]= OStringToOUString( sFullLinkName, osl_getThreadTextEncoding());
            OSL_ASSERT( szLinkName[0] > 'Z');
            szLinkName[0]++;
        }
    }
    else
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr, "javaldx: could not get JavaLibPath or it contains no values\n");
#endif
        bSuccess= sal_False;
    }
    return bSuccess;
}


//Creates <install>/user/temp/java directory
static sal_Bool createJavaDir( const OUString& usInstallPath)
{
    sal_Bool bSuccess= sal_True;
    OUString usPath= usInstallPath + OUSTR("/user");
    Directory::RC rc= Directory::create(usPath);
    if(rc == Directory::E_EXIST)
    {
        usPath += OUSTR("/temp");
        Directory::RC rc= Directory::create(usPath);
        if( rc == Directory::E_EXIST || rc == Directory::E_None)
        {
            usPath += OUSTR("/java");
            rc= Directory::create(usPath);
            if( !( rc == Directory::E_EXIST || rc == Directory::E_None))
            {
                // failed: <install>/user/temp/java
                OString err= OUStringToOString(usPath, osl_getTextEncodingFromLocale(NULL));
                fprintf(stderr,"javaldx: failed to open or create  directory %s, error: %i \n",
                    err.getStr(), rc);
                bSuccess= sal_False;
            }
        }
        else
        {
            // failed: <install>/user/temp
            OString err= OUStringToOString(usPath, osl_getTextEncodingFromLocale(NULL));
            fprintf(stderr,"javaldx: failed to open or create  directory %s, error: %i \n",
                    err.getStr(), rc);
            bSuccess= sal_False;
        }
    }
    else
    {
        // if <install>/user does not exist (pointless to go on)
        // This can be the case in a network installation when there is a new installation but an
        // old workstation. Then the old workstation would start the setup. In that scenario
        // the user directory won't be found, which is ok.
#if OSL_DEBUG_LEVEL > 1
        OString err= OUStringToOString(usPath, osl_getTextEncodingFromLocale(NULL));
        fprintf(stderr, "javaldx: failed to open directory %s \n", err.getStr());
#endif
        //if we created the user dir then we remove it
        if(rc == Directory::E_None)
            Directory::remove(usPath);
        bSuccess= sal_False;
    }
    return bSuccess;
}

/* return true - ok, false otherwise
 */
static sal_Bool getLibPathFromJavarc(OUString& usLibPath)
{
    sal_Bool  retVal= sal_True;
	OUString value;

	// try user config
	Bootstrap::get(OUString(RTL_CONSTASCII_USTRINGPARAM("JavaLibPath")),
				   value,
				   OUString(RTL_CONSTASCII_USTRINGPARAM("${${$SYSBINDIR/bootstraprc:UserInstallation}/user/config/javarc:Java:JavaLibPath}")));

	// fall back to share config
	if(!value.getLength())
		Bootstrap::get(OUString(RTL_CONSTASCII_USTRINGPARAM("JavaLibPath")),
					   value,
					   OUString(RTL_CONSTASCII_USTRINGPARAM("${${$SYSBINDIR/bootstraprc:UserInstallation}/share/config/javarc:Java:JavaLibPath}")));

    if(!value.getLength())
    {
        Bootstrap::get(OUString(RTL_CONSTASCII_USTRINGPARAM("JavaLibPath")),
                       value,
                       OUString(RTL_CONSTASCII_USTRINGPARAM("${${$SYSBINDIR/bootstraprc:BaseInstallation}/share/config/javarc:Java:JavaLibPath}")));
    }
    if(value.getLength())
        usLibPath= value;
	else
        retVal= sal_False;
    return retVal;
}


