/*************************************************************************
 *
 *  $RCSfile: configurationflushable.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/09 15:40:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_CONFIGURATIONFLUSHABLE_HXX_
#define _DBA_CORE_CONFIGURATIONFLUSHABLE_HXX_

#ifndef _COM_SUN_STAR_UTIL_XFLUSHABLE_HPP_
#include <com/sun/star/util/XFlushable.hpp>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _UNOTOOLS_CONFIGNODE_HXX_
#include <unotools/confignode.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif

//........................................................................
namespace dbaccess
{
//........................................................................

//==========================================================================
//= OConfigurationFlushable - abstract base class for objects which are
//=								flushable under a configuration noe
//==========================================================================
typedef	::cppu::ImplHelper2	<	::com::sun::star::lang::XUnoTunnel,
								::com::sun::star::util::XFlushable
							>	OConfigurationFlushable_Base;

class OConfigurationFlushable : public OConfigurationFlushable_Base
{
protected:
	::cppu::OInterfaceContainerHelper		m_aFlushListeners;
	::osl::Mutex&							m_rMutex;

	::utl::OConfigurationTreeRoot			m_aConfigurationNode;

	OConfigurationFlushable(::osl::Mutex& _rMutex) : m_aFlushListeners(_rMutex), m_rMutex(_rMutex) { }
	OConfigurationFlushable(::osl::Mutex& _rMutex,const ::utl::OConfigurationTreeRoot& _rConfigurationNode) 
		: m_aFlushListeners(_rMutex), m_rMutex(_rMutex),m_aConfigurationNode(_rConfigurationNode) { }

	/// for scripting : the types of the interfaces supported by this class
	//	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes() throw (::com::sun::star::uno::RuntimeException);

public:
// XInterface
	//	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw(::com::sun::star::uno::RuntimeException);

// XFlushable
    virtual void SAL_CALL flush(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL addFlushListener( const ::com::sun::star::uno::Reference< ::com::sun::star::util::XFlushListener >& l ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeFlushListener( const ::com::sun::star::uno::Reference< ::com::sun::star::util::XFlushListener >& l ) throw(::com::sun::star::uno::RuntimeException);
	// com::sun::star::lang::XUnoTunnel
    virtual sal_Int64 SAL_CALL getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& aIdentifier ) throw(::com::sun::star::uno::RuntimeException);
	static ::com::sun::star::uno::Sequence< sal_Int8 > getUnoTunnelImplementationId();

	virtual void setConfigurationNode(const ::utl::OConfigurationTreeRoot& _rConfigurationNode);

	sal_Bool	hasValidLocation() const { return m_aConfigurationNode.isValid(); }

protected:
	/** to be overwritten by the derived class, implements the flush operation
	*/
	virtual void flush_NoBroadcast_NoCommit() = 0;

	/** to be called when the derived class' object gets disposed, disposes and frees the flush listeners
	*/
	virtual void SAL_CALL disposing();
};

//........................................................................
}	// namespace dbaccess
//........................................................................

#endif // _DBA_CORE_CONFIGURATIONFLUSHABLE_HXX_

