/*************************************************************************
 *
 *  $RCSfile: FilteredContainer.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2002/08/27 11:50:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBACCESS_CORE_FILTERED_CONTAINER_HXX
#define DBACCESS_CORE_FILTERED_CONTAINER_HXX

#ifndef _CONNECTIVITY_SDBCX_COLLECTION_HXX_
#include <connectivity/sdbcx/VCollection.hxx>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif

class WildCard;
namespace dbaccess
{
	class IWarningsContainer;
	class IRefreshListener;

	class OFilteredContainer : public ::connectivity::sdbcx::OCollection
	{
	protected:
		IWarningsContainer*		m_pWarningsContainer;
		IRefreshListener*		m_pRefreshListener;
		
		// holds the original container which where set in construct but they can be null
		::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >	m_xMasterContainer;
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >			m_xConnection;
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData >	m_xMetaData;

		mutable sal_Bool m_bConstructed;		// late ctor called

		virtual sal_Bool isNameValid(const ::rtl::OUString& _rName,
			const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rTableFilter,
			const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rTableTypeFilter,
			const ::std::vector< WildCard >& _rWCSearch) const;

		virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > getTableTypeFilter(const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rTableTypeFilter) const = 0;

		inline virtual void addMasterContainerListener(){}
		inline virtual void removeMasterContainerListener(){}

		// ::connectivity::sdbcx::OCollection
		virtual void impl_refresh() throw(::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNamed > cloneObject(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& _xDescriptor);

		/** tell the container to free all elements and all additional resources.<BR>
			After using this method the object may be reconstructed by calling one of the <code>constrcuct</code> methods.
		*/
		virtual void SAL_CALL disposing();
	public:
		/** ctor of the container. The parent has to support the <type scope="com::sun::star::sdbc">XConnection</type>
			interface.<BR>
			@param			_rParent			the object which acts as parent for the container.
												all refcounting is rerouted to this object
			@param			_rMutex				the access safety object of the parent
			@param			_rTableFilter		restricts the visible tables by name
			@param			_rTableTypeFilter	restricts the visible tables by type
			@see			construct
		*/
		OFilteredContainer( ::cppu::OWeakObject& _rParent,
						::osl::Mutex& _rMutex,
						const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _xCon,
						sal_Bool _bCase,
						IRefreshListener*	_pRefreshListener = NULL,
						IWarningsContainer* _pWarningsContainer = NULL
						);

		inline virtual void SAL_CALL acquire() throw(){ m_rParent.acquire();}
		inline virtual void SAL_CALL release() throw(){ m_rParent.release();}

		inline void dispose() { disposing(); }

		/** late ctor. The container will fill itself with the data got by the connection meta data, considering the
			filters given (the connection is the parent object you passed in the ctor).
		*/
		void construct(
			const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rTableFilter,
			const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rTableTypeFilter
			);

		/** late ctor. The container will fill itself with wrapper objects for the tables returned by the given
			name container.
		*/
		void construct(
			const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& _rxMasterContainer,
			const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rTableFilter,
			const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rTableTypeFilter
			);

		inline sal_Bool isInitialized() const { return m_bConstructed; }
	};
// ..............................................................................
} // namespace
// ..............................................................................

#endif // DBACCESS_CORE_FILTERED_CONTAINER_HXX
