/*************************************************************************
 *
 *  $RCSfile: heap.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2002/03/15 11:39:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_DATAHEAP_HXX
#define CONFIGMGR_DATAHEAP_HXX

#ifndef CONFIGMGR_DATAHEAPMANAGER_HXX
#include "heapmanager.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory
    {
    // -------------------------------------------------------------------------
        class Heap : Noncopyable
        {
            HeapManager       & m_impl;
            HeapManager::Handle m_heap;
            HeapManager::Size   m_size;
        public:
            typedef HeapManager::Lock        Lock;
            typedef HeapManager::Size        Size;
            typedef HeapManager::HeapId      HeapId;
            typedef HeapManager::HeapIdParam HeapIdParam;
            typedef HeapManager::Address     Address;

        //    typedef sal_uInt32 Size;
        //    typedef sal_uInt32 Address;

            Heap(HeapManager& _impl);
            Heap(HeapManager& _impl, Size _nInitialSize);
            Heap(HeapManager& _impl, HeapIdParam _anId);
            ~Heap();

            Size    size() const { return m_size; }

            Size    grow(Size _nReqSize); 

            void *  base() const   { return m_impl.base(m_heap); }
            HeapId  id()   const   { return m_impl.id(m_heap); }

            Address allocate(Size _sNewSize)    { return m_impl.allocate(m_heap, _sNewSize); }
            Address reallocate(Address _aOldAddress, Size _sNewSize)    
            { return m_impl.reallocate(m_heap, _aOldAddress, _sNewSize); }
            void    deallocate(Address _aAddress)    { m_impl.deallocate(m_heap, _aAddress); }
            bool    didAllocate(Address _aAddress) const 
            { return m_impl.didAllocate(m_heap, _aAddress); }

            Lock *  createLock()                { return m_impl.createHeapLock(m_heap); }
            void    destroyLock(Lock * _pLock)  { m_impl.destroyHeapLock(m_heap,_pLock); }
        };
    // -------------------------------------------------------------------------	
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr

#endif // CONFIGMGR_DATAHEAP_HXX

