/*************************************************************************
 *
 *  $RCSfile: sbmod.hxx,v $
 *
 *  $Revision: 1.5.44.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/20 09:56:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SB_SBMOD_HXX
#define _SB_SBMOD_HXX

#include <sbdef.hxx>
#ifndef _SBX_SBXOBJECT_HXX //autogen
#include <svtools/sbxobj.hxx>
#endif
#ifndef _SBXDEF_HXX //autogen
#include <svtools/sbxdef.hxx>
#endif
#ifndef _RTL_USTRING_HXX
#include <rtl/ustring.hxx>
#endif

class SbMethod;
class SbProperty;
class SbiRuntime;
class SbiBreakpoints;
class SbiImage;

class SbModule : public SbxObject
{
	friend class	TestToolObj;	// somit knnen Module nach laden zur Laufzeit initialisiert werden
	friend class	SbiCodeGen;
	friend class	SbMethod;
	friend class	SbiRuntime;
	friend class	StarBASIC;
protected:
    ::rtl::OUString	aOUSource;
	String			aComment;
	SbiImage*		pImage;				// das Image
	SbiBreakpoints*	pBreaks;			// Breakpoints
	void			StartDefinitions();
	SbMethod*		GetMethod( const String&, SbxDataType );
	SbProperty*		GetProperty( const String&, SbxDataType );
	void			EndDefinitions( BOOL=FALSE );
	USHORT 			Run( SbMethod* );
	void			RunInit();
	void 			ClearPrivateVars();
	void			GlobalRunInit( BOOL bBasicStart );	// fuer alle Module
	void			GlobalRunDeInit( void );
	const BYTE* 	FindNextStmnt( const BYTE*, USHORT&, USHORT& ) const;
	const BYTE* 	FindNextStmnt( const BYTE*, USHORT&, USHORT&, 
						BOOL bFollowJumps, const SbiImage* pImg=NULL ) const;
	virtual BOOL LoadData( SvStream&, USHORT );
	virtual BOOL StoreData( SvStream& ) const;
	virtual BOOL LoadCompleted();
	virtual void SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							 const SfxHint& rHint, const TypeId& rHintType );
	virtual ~SbModule();
public:
	SBX_DECL_PERSIST_NODATA(SBXCR_SBX,SBXID_BASICMOD,2);
	TYPEINFO();
					SbModule( const String& );
	virtual void	SetParent( SbxObject* );
	virtual void 	Clear();

	virtual const String& 	GetSource() const;
    const ::rtl::OUString& 	GetSource32() const;
	const String&	GetComment() const            { return aComment; }
	virtual void	SetSource( const String& r );
	void	        SetSource32( const ::rtl::OUString& r );
	void			SetComment( const String& r );

	virtual BOOL	Compile();
	BOOL 			Disassemble( String& rText );
	virtual BOOL	IsCompiled() const;
	const SbxObject* FindType( String aTypeName ) const;

	virtual BOOL	IsBreakable( USHORT nLine ) const;
	virtual USHORT	GetBPCount() const;
	virtual USHORT	GetBP( USHORT n ) const;
	virtual BOOL	IsBP( USHORT nLine ) const;
	virtual BOOL	SetBP( USHORT nLine );
	virtual BOOL	ClearBP( USHORT nLine );
	virtual void	ClearAllBP();

	// Zeilenbereiche von Subs
	virtual SbMethod*	GetFunctionForLine( USHORT );

    // Store only image, no source (needed for new password protection)
   	BOOL StoreBinaryData( SvStream& );    
	BOOL LoadBinaryData( SvStream& );
};

#ifndef __SB_SBMODULEREF_HXX
#define __SB_SBMODULEREF_HXX

SV_DECL_IMPL_REF(SbModule)

#endif

#endif
