/*************************************************************************
 *
 *  $RCSfile: DocumentRequest.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.*;
import java.util.AbstractCollection;

public final class DocumentRequest implements Externalizable {
    private String              _document;
    private String              _docType;
    private MultiTokenLocator   _focus;
    private MultiTokenLocator[] _locators;
    private boolean              _tocRequested;

    public DocumentRequest() { /* for Externalizable */ }

    public DocumentRequest(String document, String docType) {
	_document = document;
	_docType = docType;
    }

    public void setFocus(MultiTokenLocator focus) {
	_focus = focus;
    }

    public String getDocument() {
	return _document;
    }

    public String getDocumentType() {
	return _docType;
    }

    public int size() {
	return _locators != null ? _locators.length : 0;
    }

    public MultiTokenLocator getLocator(int index) {
	return _locators[index];
    }
  
    public void setLocators(AbstractCollection locators) {
	int size = locators.size();
	if (size > 0) {
	    _locators = new MultiTokenLocator[size];
	    _locators = (MultiTokenLocator[])locators.toArray(_locators);
	}
	else
	    _locators = null;
    }

    public void requestToc(boolean yesOrNo) {
	_tocRequested = yesOrNo;
    }

    public boolean isTocRequested() {
	return _tocRequested;
    }

    public MultiTokenLocator[] getLocators() {
	return _locators;
    }

    public MultiTokenLocator getFocus() {
	return _focus;
    }

    public void readExternal(ObjectInput in)
	throws ClassNotFoundException, IOException {
	_document = (String) in.readObject();
	_docType = (String) in.readObject();
	(_focus = new MultiTokenLocator()).readExternal(in);
	final int info = in.readInt();
	_tocRequested = (info & 1) != 0;
	final int nLocators = info >> 1;
	if (nLocators > 0) {
	    _locators = new MultiTokenLocator[nLocators];
	    for (int i = 0; i < nLocators; i++) {
		_locators[i] = new MultiTokenLocator();
		_locators[i].readExternal(in);
	    }
	}
    }
  
    public void writeExternal(ObjectOutput out) throws IOException {
	out.writeObject(_document);
	out.writeObject(_docType);
	_focus.writeExternal(out);
	final int nLocators = size();
	out.writeInt((nLocators << 1) | (_tocRequested ? 1 : 0));
	for (int i = 0; i < nLocators; i++)
	    _locators[i].writeExternal(out);
    }
}
