/*************************************************************************
 *
 *  $RCSfile: TreeResult.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.tree;

import java.util.Vector;
import org.xml.sax.AttributeList;
import com.jclark.xsl.om.*;

public final class TreeResult extends ResultAdapter {
  private final TreeBuilder _builder;
  private final AttributeListImpl _attributes = new AttributeListImpl();
  private Name _startTag;

  private static String toString(Name name) {
    String prefix = name.getPrefix();
    return prefix == null || prefix.length() == 0
      ? name.getLocalPart()
      : prefix + ':' + name.getLocalPart();
  }

  private final class AttributeListImpl implements AttributeList {
    private Vector _attributes = new Vector();
    
    private final class Attribute {
      public String name;
      public String value;
      public Attribute(String name, String value) {
	this.name = name;
	this.value = value;
      }
    } // end of Attribute
    public int getLength() {
      return _attributes.size();
    }
    private Attribute at(int i) {
      return (Attribute)_attributes.elementAt(i);
    }
    public String getName(int i) {
      return at(i).name;
    }
    public String getType(int i) {
      return "";		// !!!
    }
    public String getValue(int i) {
      return at(i).value;
    }
    public String getType(String name) {
      return "";
    }
    public String getValue(String name) {
      for (int i = 0; i < getLength(); i++)
	if (getName(i).equals(name))
	  return at(i).value;
      return null;
    }
    public void clear() {
      _attributes.setSize(0);
    }
    public void addAttribute(String name, String value) {
      _attributes.addElement(new Attribute(name, value));
    }
  } // end of AttributeListImpl
  
  public TreeResult(TreeBuilder builder) {
    _builder = builder;
  }
  public TreeResult(NameTable nameTable) {
    _builder = new TreeBuilder(nameTable);
  }
  private void flushStartTag() {
    if (_startTag != null) {
      /*
      System.out.print(_startTag.toString());
      for (int i = 0; i < _attributes.getLength(); i++) {
	System.out.print(' ');
	System.out.print(_attributes.getName(i));
	System.out.print(" = ");
	System.out.print(_attributes.getValue(i));
      }
      System.out.print('\n');
      */
      _builder.startElement(_startTag.toString(), _attributes);
      _attributes.clear();
      _startTag = null;
    }
  }
  public void init() throws XSLException {
    _builder.startDocument();
    _attributes.clear();
    _startTag = null;
  }
  public Node getRoot() {
    return _builder.getRoot();
  }
  public void startElement(Name elementType, NamespacePrefixMap nsMap)
    throws XSLException {
      flushStartTag();
      _startTag = elementType;
  }
  public void attribute(Name name, String value) throws XSLException {
    _attributes.addAttribute(name.toString(), value);
  }
  public void characters(final String str) {
    flushStartTag();
    _builder.characters(str);
  }
  // more effective to work using Names w/o going through Strings
  public void endElement(Name elementType) {
    flushStartTag();
    _builder.endElement(elementType.toString());
  }
}
