/*************************************************************************
 *
 *  $RCSfile: HtmlContent.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.tree;

import java.util.Hashtable;
import java.io.IOException;
import java.io.OutputStream;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.XSLException;

public final class HtmlContent extends ResultAdapter {
  // HTML markup cache
  private static final Hashtable StartTags  = new Hashtable();
  private static final Hashtable EndTags    = new Hashtable();
  private static final Hashtable Attributes = new Hashtable();
  
  public static final String HighlightTag = "hl";
  
  private static final byte[] Start   = "<html><head></head><body>".getBytes();
  private static final byte[] End     = "</body></html>".getBytes();
  private static final byte[] HlBytes = "<hl></hl>".getBytes();

  private final Name _StartHighlight_Name;
  private final Name _EndHighlight_Name;
  
  private OutputStream _output;
  private boolean _openStartTag;
  private int _highlightCounter;

  public HtmlContent(Names names) throws XSLException {
    _StartHighlight_Name = names.getElementName("StartHighlight");
    _EndHighlight_Name   = names.getElementName("EndHighlight");
  }

  public void setOutputStream(OutputStream out) {
    _output = out;
  }

  public void reset() {
    _openStartTag = false;
    _highlightCounter = 0;
  }

  public int getNumberOfHighlights() {
    return _highlightCounter;
  }
    
  public void init() throws XSLException {
    _highlightCounter = 0;
    try {
      _output.write(Start);
    }
    catch (IOException e) {
      throw new XSLException(e);
    }
  }

  public void finish() throws XSLException {
    try {
      _output.write(End);
      _output.flush();
      _output.close();
    }
    catch (IOException e) {
      throw new XSLException(e);
    }
  }

  private void flushStartTag() throws IOException {
    if (_openStartTag) {
      _output.write('>');
      _openStartTag = false;
    }
  }
    
  public void startElement(Name elementType, NamespacePrefixMap nsMap)
    throws XSLException {
      try {
	flushStartTag();
	if (elementType == _StartHighlight_Name)
	  _highlightCounter++;
	else if (elementType == _EndHighlight_Name)
	  _output.write(HlBytes);
	else {
	  byte[] tagBytes = (byte[])StartTags.get(elementType);
	  if (tagBytes == null) {
	    String tag = elementType.toString();
	    // cache 'open' start tag
	    StartTags.put(elementType, tagBytes = ("<" + tag).getBytes());
	    // proactively cache end tag
	    EndTags.put(elementType, ("</" + tag + ">").getBytes());
	  }
	  _output.write(tagBytes);
	  _openStartTag = true;
	}
      }
      catch (IOException e) {
	throw new XSLException(e);
      }
  }
    
  public void endElement(Name elementType) throws XSLException {
    try {
      flushStartTag();
      if (elementType == _StartHighlight_Name)
	_output.write(HlBytes);
      else if (elementType == _EndHighlight_Name)
	  ;
      else			// cached in startElement
	_output.write((byte[])EndTags.get(elementType));
    }
    catch (IOException e) {
      throw new XSLException(e);
    }
  }
    
  public void attribute(Name name, String value) throws XSLException {
    try {
      byte[] attr = (byte[])Attributes.get(name);
      if (attr == null)
	// cache partial attribute representation in text
	Attributes.put(name, attr = (" " + name.toString() + "=\"").getBytes());
      _output.write(attr);
      _output.write(value.getBytes());
      _output.write('"');
    }
    catch (IOException e) {
      throw new XSLException(e);
    }
  }
    
  public void characters(final String str) throws XSLException {
    try {
      flushStartTag();
      _output.write(str.getBytes());
    }
    catch (IOException e) {
      throw new XSLException(e);
    }
  }
}
  
