/*************************************************************************
 *
 *  $RCSfile: salframe.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>
#include <svmac.h>

#include "mac_start.h"
#ifdef MAC_UNIVERSAL
#include <CursorDevices.h>
#else
#include <SysEqu.h>
#endif
#include "mac_end.h"

#define _SV_SALFRAME_CXX

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _TIME_HXX
#include <tools/time.hxx>
#endif
#ifndef _INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _SV_SALIDS_HRC
#include <salids.hrc>
#endif
#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALINST_HXX
#include <salinst.hxx>
#endif
#ifndef _SV_SALGDI_HXX
#include <salgdi.hxx>
#endif
#ifndef _SV_SALFRAME_HXX
#include <salframe.hxx>
#endif
#ifndef _SV_KEYCOES_HXX
#include <keycodes.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <timer.hxx>
#endif
#ifndef _SV_SETTINGS_HXX
#include <settings.hxx>
#endif

#include "main.h"
#ifndef _MYFONT_HXX
#include <MyFont.HXX>
#endif

long ImplSalCallbackDummy( void*, SalFrame*, USHORT, const void* );
short ImplGetLanguageResId();

// =======================================================================

#define TITLE_BAR_HEIGHT 18

// =======================================================================

long ImplSalCallbackDummy( void*, SalFrame*, USHORT, const void* )
{
	return 0;
}


// =======================================================================
// -----------------------------------------------------------------------

//static int ImplHandleMinMax( SalFrame* pFrame, LPARAM lParam )

// -----------------------------------------------------------------------

// static int ImplHandleSysCommand( SalFrame* pFrame, WPARAM wParam, LPARAM lParam )

// -----------------------------------------------------------------------

// LRESULT CALLBACK SalFrameWndProc( HWND hWnd, UINT nMsg, WPARAM wParam, LPARAM lParam )

// -----------------------------------------------------------------------

void ImplHandleSizeMsg( WindowPtr pMacWin )
{
	if ( pMacWin )
	{	INT16 nWidth, nHeight;
		Rect aRect = pMacWin->portRect;
		nWidth = aRect.right - aRect.left;
		nHeight = aRect.bottom - aRect.top;
		ImplHandleSizeMsg( ImplGetFrameFromMacWin( pMacWin ), nWidth, nHeight);
	}
}

// -----------------------------------------------------------------------

long ImplHandleSizeMsg( SalFrame* pFrame, INT16 nWidth, INT16 nHeight )
{
	if ( !pFrame )
		 return 0L;

	if ( (nWidth > 0) && (nHeight > 0) )
	{
		pFrame->maFrameData.mnWidth  = (int)nWidth;
		pFrame->maFrameData.mnHeight = (int)nHeight;

		// Grow Rgn muss neu berechnet werden
		pFrame->maFrameData.ImplRecalcGrowRgn();

		return pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
										   SALEVENT_RESIZE, 0 );
	}

	return 0;
}

// -----------------------------------------------------------------------

short ImplGetLanguageResId()
{
	static short nResId = 0;

	if ( !nResId )
	{
		LanguageType eLang = GetSystemLanguage();

		if ( ( eLang == LANGUAGE_GERMAN ) ||
			 ( eLang == LANGUAGE_GERMAN_SWISS ) ||
			 ( eLang == LANGUAGE_GERMAN_AUSTRIAN ) )
			nResId = kGermanStrings;
		else
		if ( ( eLang == LANGUAGE_FRENCH )			||
			 ( eLang == LANGUAGE_FRENCH_BELGIAN )	||
			 ( eLang == LANGUAGE_FRENCH_CANADIAN )	||
			 ( eLang == LANGUAGE_FRENCH_SWISS ) 	||
			 ( eLang == LANGUAGE_FRENCH_LUXEMBOURG ) )
			nResId = kFrenchStrings;
		else
			nResId = kEnglishStrings;
	}

	return nResId;
}

// -----------------------------------------------------------------------

String ImplGetMacResString( short nWhich )
{
	Str255 aTemp;
	GetIndString( aTemp, ImplGetLanguageResId(), nWhich );
	return String((const char*) &aTemp[1],aTemp[0]);
}

// =======================================================================
// last changed:	dv	23.09.97

SalFrame* SalInstance::CreateFrame( SalFrame *pParent, USHORT nSalFrameStyle )
{
	SalFrame*	pFrame = new SalFrame;
	WindowPtr	pMacParent;

	if (pParent)
		pMacParent = (WindowPtr)0xFFFFFFFFL;
	else
		pMacParent = nil;

	// determine creation data and create frame
	if ( !pFrame->maFrameData.ImplCreateMacWin( pMacParent, (long) pFrame, nSalFrameStyle ) )
	{
		delete pFrame;
		pFrame = (SalFrame*)NULL;
	}

	return pFrame;
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

void SalInstance::DestroyFrame( SalFrame* pFrame )
{
	delete pFrame;
}

// =======================================================================

SalFrameData::SalFrameData()
{
	;
	// siehe auch ImplCreateMacWin
}

// -----------------------------------------------------------------------

SalFrameData::~SalFrameData()
{
	// siehe auch ImplDestroyWindow
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

short SalFrameData::ImplCalcMacWindowTypFrom( USHORT nSalFrameStyle )
{
	BOOL	bHasTitleBar = FALSE;
	BOOL	bHasGrowArea = FALSE;
	BOOL	bHasGoAway = FALSE;
	short	aWindowTyp = plainDBox;

	mnStyle = nSalFrameStyle;
	if ( nSalFrameStyle & ( SAL_FRAME_STYLE_MOVEABLE | SAL_FRAME_STYLE_CLOSEABLE ) )
	{
		aWindowTyp = noGrowDocProc;
		bHasTitleBar = TRUE;
	}
	if ( nSalFrameStyle & SAL_FRAME_STYLE_SIZEABLE )
	{
		aWindowTyp = documentProc;
		bHasTitleBar = TRUE;
		bHasGrowArea = TRUE;
	}
	if ( nSalFrameStyle & SAL_FRAME_STYLE_MAXABLE )
	{
		if ( aWindowTyp != plainDBox )
		{
			aWindowTyp += zoomDocProc;
		}
		else
		{
			aWindowTyp = zoomNoGrow;
			bHasTitleBar = TRUE;
		}
	}
	if ( nSalFrameStyle & SAL_FRAME_STYLE_CLOSEABLE )
	{
		bHasGoAway = TRUE;
	}
	mbHasTitleBar	= bHasTitleBar;
	mbHasGrowArea	= bHasGrowArea;
	mbHasGoAway 	= bHasGoAway;
	if ( bHasGrowArea )
	{	mhGrowRgn = NewRgn();
	}
	maWindowTyp = aWindowTyp;
	return aWindowTyp;
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

WindowPtr SalFrameData::ImplCreateMacWin( WindowPtr pParent, long nRefCon, USHORT nSalFrameStyle )
{
	WindowPtr	pMyWin;

	// determine creation data
	ImplCalcMacWindowTypFrom( nSalFrameStyle );

	// create frame
	mpMacWin = new WindowRecord;

	maFullScreenRect = qd.screenBits.bounds;

	Rect aWinRect = maFullScreenRect;

	InsetRect( &aWinRect, 4, 4 );
	aWinRect.top -= 4;

	aWinRect.top += 2 * GetMBarHeight();
//	aWinRect.bottom -= 2 * GetMBarHeight();
//	aWinRect.left += 2 * GetMBarHeight();
//	aWinRect.right /= 2;

	pMyWin = NewCWindow( (MAC_Ptr)mpMacWin, &aWinRect,
						 "\pSAL test",
						 false, maWindowTyp, pParent,
						 mbHasGoAway, nRefCon );

	DBG_ASSERT( pMyWin, "ImplCreateMacWin: Couldn't create Macintosh window" );

	mnWidth  = aWinRect.right - aWinRect.left;
	mnHeight = aWinRect.bottom - aWinRect.top;

	return pMyWin;
}

// -----------------------------------------------------------------------
// last changed:	dv	25.09.97

void SalFrameData::ImplDestroyWindow()
{
	GrafPtr pOldPort;
	GetPort ( &pOldPort );

	if ( pOldPort == (GrafPtr)mpMacWin )
		SetGWorld( (CGrafPtr) LMGetWMgrPort(), nil );

	CloseWindow( (WindowPtr) mpMacWin );

	delete mpMacWin;
	mpMacWin = 0L;

	if ( mhGrowRgn )
	{
		DisposeRgn( mhGrowRgn );
		mhGrowRgn = 0L;
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

void SalFrameData::ImplSetWindowPtr( SalFrame *pThis )
{
	// Mauszeiger sind nur gueltig, wenn die Maus ueber diesem Fenster ist,
	// oder wenn es ein CaptureWin gibt und die Maus gedrueckt ist.

	// der zweite Fall ist noch nicht richtig implementiert!!! (Abfrage auf gedrueckt fehlt)

	if ( mhCursor )
	{
		MAC_Point	aPoint;
		WindowPtr	pMacWin;
		SalData 	*pSalData = GetSalData();

		GetMouse( &aPoint );
		LocalToGlobal( &aPoint );

		if ( ( pSalData->mpCaptureFrame == pThis ) ||
			 ( FindWindow( aPoint, &pMacWin ) == inContent ) )
		{
			MAC_SetCursor( *mhCursor );
		}
		else
			MAC_SetCursor( &(qd.arrow) );
	}
	else
	{
		MAC_SetCursor( &(qd.arrow) );
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	28.09.97

void SalFrameData::ImplRecalcGrowRgn()
{
	if ( mhGrowRgn )
	{
		DBG_ASSERT( mpMacWin, "ImplRecalcGrowRgn ohne Mac-Fenster !" );

		MacTempGWorld aTmp( (CGrafPort *) mpMacWin );	// Set current port to this window
		InvalRgn( mhGrowRgn );							// Invalidate old place

		Rect aRect = mpMacWin->port.portRect;

		aRect.left = aRect.right - 15;					// calculate new place
		aRect.top = aRect.bottom - 15;

		RectRgn( mhGrowRgn, &aRect );					// set the region

		InvalRgn( mhGrowRgn );							// Invalidate new place
	}
}

// =======================================================================
// last changed:	dv	23.09.97

SalFrame::SalFrame()
{
	MAC_SAL_TRACE("SalFrame::__ct");
	memset( &maFrameData, 0, sizeof( SalFrameData ) );
	maFrameData.mpProc				= ImplSalCallbackDummy;
	maFrameData.mbFullScreen		= FALSE;

	// insert frame in framelist
	SalData* pSalData = GetSalData();

	maFrameData.mpNextFrame = pSalData->mpFirstFrame;
	pSalData->mpFirstFrame = this;
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

SalFrame::~SalFrame()
{
	MAC_SAL_TRACE("SalFrame::__dt");
	SalData* pSalData = GetSalData();

	// reset mouse leave data
	if ( pSalData->mpWantLeaveMsg == this )
		pSalData->mpWantLeaveMsg = 0L;

	// destroy saved DC
	if ( maFrameData.mpGraphics )
	{
		ImplSalDeInitGraphics( &(maFrameData.mpGraphics->maGraphicsData) );
		delete maFrameData.mpGraphics;
	}

	// resetting focus window
	if ( pSalData->mpFocusWin == (WindowPtr) maFrameData.mpMacWin )
		pSalData->mpFocusWin = 0L;

	// destroy system frame
	maFrameData.ImplDestroyWindow();

	// remove frame from framelist
	if ( this == pSalData->mpFirstFrame )
		pSalData->mpFirstFrame = maFrameData.mpNextFrame;
	else
	{
		SalFrame* pTempFrame = pSalData->mpFirstFrame;
		while ( pTempFrame->maFrameData.mpNextFrame != this )
			pTempFrame = pTempFrame->maFrameData.mpNextFrame;

		pTempFrame->maFrameData.mpNextFrame = maFrameData.mpNextFrame;
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

SalGraphics* SalFrame::GetGraphics()
{
	MAC_SAL_TRACE("SalFrame::GetGraphics");

	if ( maFrameData.mbGraphics )
		return NULL;

	if ( !maFrameData.mpGraphics )
	{
		if ( maFrameData.mpMacWin )
		{
			PixMapHandle hPixmap = ((CGrafPtr)maFrameData.mpMacWin)->portPixMap;

			maFrameData.mpGraphics = new SalGraphics;

			SalGraphicsData* pData = &(maFrameData.mpGraphics->maGraphicsData);

			pData->mpGrafPort = (CGrafPtr)maFrameData.mpMacWin;
			pData->mhDevice = GetMainDevice();
			pData->mhGrowRgn = maFrameData.mhGrowRgn;
			pData->mbPrinter = FALSE;
			pData->mbVirDev  = FALSE;
			pData->mbWindow  = TRUE;
			pData->mbScreen  = TRUE;
//			pData->mnXRes = (**hPixmap).hRes;
//			pData->mnYRes = (**hPixmap).vRes;
			pData->mnXRes = MyIntToFixed( 96 );
			pData->mnYRes = MyIntToFixed( 96 );

			ImplSalInitGraphics( pData );

			maFrameData.mbGraphics = TRUE;
		}
	}
	else
		maFrameData.mbGraphics = TRUE;

	return maFrameData.mpGraphics;
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

void SalFrame::ReleaseGraphics( SalGraphics* pGraphics )
{
	maFrameData.mbGraphics = FALSE;
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

BOOL SalFrame::PostEvent( void* pEventData )
{
	return GetSalData()->ImplSendMessage( this, pEventData, (ULONG)SALEVENT_USEREVENT );
}

// -----------------------------------------------------------------------
// last changed:	dv	08.12.97

void SalFrame::SetTitle( const XubString& rTitle )
{
	SetGWorld( (CGrafPtr) maFrameData.mpMacWin, nil );
	SetWTitle ( (WindowPtr) maFrameData.mpMacWin, rTitle.GetPascalStr() );
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

void SalFrame::Show( BOOL bVisible )
{
	if ( bVisible )
	{
		ImplHandleSizeMsg( (GrafPtr) maFrameData.mpMacWin );
		MAC_ShowWindow( (WindowPtr) maFrameData.mpMacWin );
	}
	else
		HideWindow( (WindowPtr) maFrameData.mpMacWin );
}

// -----------------------------------------------------------------------
// last changed:	dv	28.09.97

void SalFrame::SetClientSize( long nWidth, long nHeight )
{
	if ( maFrameData.mpMacWin )
	{
		// Position so berechnen, das Fenster zentriert auf dem Desktop
		// angezeigt wird
		Rect *pRect = &(maFrameData.maFullScreenRect);

		long nXPos = ( pRect->right - pRect->left - nWidth ) / 2;
		long nYPos = ( pRect->bottom - pRect->top - nHeight -
					   GetMBarHeight() - TITLE_BAR_HEIGHT ) / 2;
		nYPos += GetMBarHeight() + TITLE_BAR_HEIGHT;

		MoveWindow( (WindowPtr) maFrameData.mpMacWin, nXPos, nYPos, false );

		// Fenster vergroessern
		SizeWindow( (WindowPtr) maFrameData.mpMacWin, nWidth, nHeight, true );
	}

	// Resize ausloesen
	ImplHandleSizeMsg( this, nWidth, nHeight );
}

// -----------------------------------------------------------------------

void SalFrame::GetClientSize( long& rWidth, long& rHeight )
{
	rWidth	= maFrameData.mnWidth;
	rHeight = maFrameData.mnHeight;
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

void SalFrame::ShowFullScreen( BOOL bFullScreen )
{
	if ( maFrameData.mbFullScreen == bFullScreen || !maFrameData.mpMacWin )
		return;

	Rect * pRect;

	maFrameData.mbFullScreen = bFullScreen;

	if ( bFullScreen )
	{
		// save old position
		Rect		aRect = ((GrafPtr)maFrameData.mpMacWin)->portRect;
		MAC_Point*	pPoint = (MAC_Point*)&aRect;
		LocalToGlobal(pPoint++);LocalToGlobal(pPoint);
		maFrameData.maFullScreenRect = aRect;

		// hide menubar, recalc qd.screenBits.bounds
		Mac_StartPresentationMode( this, (USHORT)0 );

		// set window to screen size
		pRect = &qd.screenBits.bounds;

		INT16 nDX = pRect->right - pRect->left;
		INT16 nDY = pRect->bottom - pRect->top;

		MoveWindow( (WindowPtr)maFrameData.mpMacWin, pRect->left,  pRect->top, FALSE );
		SizeWindow( (WindowPtr)maFrameData.mpMacWin, nDX, nDY, TRUE );
	}
	else
	{
		Show( FALSE );
		Mac_EndPresentationMode();

		pRect = &maFrameData.maFullScreenRect;
		MoveWindow( (WindowPtr)maFrameData.mpMacWin, pRect->left, pRect->top, FALSE );
		SizeWindow( (WindowPtr)maFrameData.mpMacWin, pRect->right  - pRect->left,
										  pRect->bottom - pRect->top, TRUE);
	}
	pRect = &((GrafPtr)maFrameData.mpMacWin)->portRect;
	ImplHandleSizeMsg( this , pRect->right	- pRect->left, pRect->bottom - pRect->top );

	if ( ! bFullScreen )
		Show( TRUE );
}

// -----------------------------------------------------------------------

void SalFrame::StartPresentation( BOOL bStart )
{
	DBG_ERROR( "SalFrame::StartPresentation NYI" );
}

// -----------------------------------------------------------------------

void SalFrame::SetAlwaysOnTop( BOOL bOnTop )
{
	DBG_ERROR( "SalFrame::SetAlwaysOnTop NYI" );
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

//	nFlags wird noch nicht benutzt!!!!!!
void SalFrame::ToTop(  USHORT nFlags )
{
	SalData* pSalData = GetSalData();

	// Falls wir nicht der Front-Prozess sind, dann ab nach vorne
	ProcessSerialNumber aMe, aFront;
	MAC_Boolean aRet;
	GetCurrentProcess( &aMe );
	GetFrontProcess( &aFront );
	SameProcess( &aMe, &aFront, &aRet );
	if ( !aRet )
		SetFrontProcess( &aMe );

	SelectWindow ( (WindowPtr) maFrameData.mpMacWin );
}

// -----------------------------------------------------------------------
// last changed:	hro 21.01.98

#define _POINTER_HSIZE		131
#define _POINTER_VSIZE		132
#define _POINTER_NESWSIZE	133
#define _POINTER_NWSESIZE	134

static struct{
	PointerStyle	eStyle;
	short			cursorID;
} _MousePointerTable[POINTER_COUNT] = {
	{ POINTER_ARROW 				,0 },
	{ POINTER_NULL					,182 },
	{ POINTER_WAIT					,watchCursor },
	{ POINTER_TEXT					,iBeamCursor },


	{ POINTER_HELP					,128 },
	{ POINTER_CROSS 				,129 },
	{ POINTER_MOVE					,130 },
	{ POINTER_NSIZE 				,_POINTER_VSIZE },
	{ POINTER_SSIZE 				,_POINTER_VSIZE },
	{ POINTER_WSIZE 				,_POINTER_HSIZE },
	{ POINTER_ESIZE 				,_POINTER_HSIZE },
	{ POINTER_NWSIZE				,_POINTER_NWSESIZE },
	{ POINTER_NESIZE				,_POINTER_NESWSIZE },
	{ POINTER_SWSIZE				,_POINTER_NESWSIZE },
	{ POINTER_SESIZE				,_POINTER_NWSESIZE },
	{ POINTER_WINDOW_NSIZE			,(short)POINTER_NSIZE },
	{ POINTER_WINDOW_SSIZE			,(short)POINTER_SSIZE },
	{ POINTER_WINDOW_WSIZE			,(short)POINTER_WSIZE },
	{ POINTER_WINDOW_ESIZE			,(short)POINTER_ESIZE },
	{ POINTER_WINDOW_NWSIZE 		,(short)POINTER_NWSIZE },
	{ POINTER_WINDOW_NESIZE 		,(short)POINTER_NESIZE },
	{ POINTER_WINDOW_SWSIZE 		,(short)POINTER_SWSIZE },
	{ POINTER_WINDOW_SESIZE 		,(short)POINTER_SESIZE },
	{ POINTER_HSPLIT				,135 },
	{ POINTER_VSPLIT				,136 },
	{ POINTER_HSIZEBAR				,137 },
	{ POINTER_VSIZEBAR				,138 },
	{ POINTER_HAND					,139 },
	{ POINTER_REFHAND				,140 },
	{ POINTER_PEN					,141 },
	{ POINTER_MAGNIFY				,142 },
	{ POINTER_FILL					,143 },
	{ POINTER_ROTATE				,144 },
	{ POINTER_HSHEAR				,145 },
	{ POINTER_VSHEAR				,146 },
	{ POINTER_MIRROR				,147 },
	{ POINTER_CROOK 				,148 },
	{ POINTER_CROP					,149 },
	{ POINTER_MOVEPOINT 			,150 },
	{ POINTER_MOVEBEZIERWEIGHT		,151 },
	{ POINTER_MOVEDATA				,152 },
	{ POINTER_COPYDATA				,153 },
	{ POINTER_LINKDATA				,154 },
	{ POINTER_MOVEDATALINK			,155 },
	{ POINTER_COPYDATALINK			,156 },
	{ POINTER_MOVEFILE				,157 },
	{ POINTER_COPYFILE				,158 },
	{ POINTER_LINKFILE				,159 },
	{ POINTER_MOVEFILELINK			,160 },
	{ POINTER_COPYFILELINK			,161 },
	{ POINTER_MOVEFILES 			,162 },
	{ POINTER_COPYFILES 			,163 },
	{ POINTER_NOTALLOWED			,164 },
	{ POINTER_DRAW_LINE 			,165 },
	{ POINTER_DRAW_RECT 			,166 },
	{ POINTER_DRAW_POLYGON			,167 },
	{ POINTER_DRAW_BEZIER			,168 },
	{ POINTER_DRAW_ARC				,169 },
	{ POINTER_DRAW_PIE				,170 },
	{ POINTER_DRAW_CIRCLECUT		,171 },
	{ POINTER_DRAW_ELLIPSE			,172 },
	{ POINTER_DRAW_FREEHAND 		,173 },
	{ POINTER_DRAW_CONNECT			,174 },
	{ POINTER_DRAW_TEXT 			,175 },
	{ POINTER_DRAW_CAPTION			,176 },
	{ POINTER_CHART 				,177 },
	{ POINTER_DETECTIVE 			,178 },
	{ POINTER_PIVOT_COL 			,179 },
	{ POINTER_PIVOT_ROW 			,180 },
	{ POINTER_PIVOT_FIELD			,181 },
	{ POINTER_CHAIN 				,(short)POINTER_ARROW },
	{ POINTER_CHAIN_NOTALLOWED		,(short)POINTER_NOTALLOWED }
};


void SalFrame::SetPointer( PointerStyle ePointerStyle )
{
	CursHandle hMacCursor;

	DBG_ASSERT(POINTER_COUNT, "Mauszeiger haben sich verndert");

	short cursorID = _MousePointerTable[ePointerStyle].cursorID;

	if (cursorID > 0)
		hMacCursor = GetCursor(cursorID);
	else
		hMacCursor = NULL;

	maFrameData.mhCursor = hMacCursor;

	maFrameData.ImplSetWindowPtr( this );
}

// -----------------------------------------------------------------------

void SalFrame::CaptureMouse( BOOL bCapture )
{
	SalData* pSalData = GetSalData();

	if ( bCapture )
	{	 pSalData->mpCaptureFrame = this;
	}
	else if ( pSalData->mpCaptureFrame == this )
	{	pSalData->mpCaptureFrame = NULL;
	}
}

// -----------------------------------------------------------------------

void SalFrame::SetPointerPos( long nX, long nY )
{
#ifndef MAC_UNIVERSAL
	MAC_Point aMacPoint;
	// Set the mouse pointer position
	aMacPoint.h = nX;
	aMacPoint.v =nY;
	aMacPoint.v += GetMBarHeight();
	*( (MAC_Point*) RawMouse ) = aMacPoint;
	*( (MAC_Point*) MTemp ) = aMacPoint;
	*( (BYTE*) CrsrNew ) = *( (BYTE*) CrsrCouple );
#else
	// Hier muss Code aus CursorDevices.h rein, aber wie ohne doku
	DBG_ERROR( "SalFrame::SetPointerPos NYI !!!");
#endif
}

// -----------------------------------------------------------------------

void SalFrame::SetInputContext( SalInputContext* pContext )
{
}

// -----------------------------------------------------------------------

void SalFrame::UpdateExtTextInputArea()
{
}

// -----------------------------------------------------------------------

void SalFrame::EndExtTextInput( USHORT nFlags )
{
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

XubString SalFrame::GetKeyName( USHORT nKeyCode )
{
	String	aKeyCode;
	String	aCode;

	if ( nKeyCode & KEY_MOD2 )
		aKeyCode = ImplGetMacResString(eKeyCodOption);

	if ( nKeyCode & KEY_MOD1 )
	{
		if ( aKeyCode.Len() )
			aKeyCode += '+';
		aKeyCode += ImplGetMacResString(eKeyCodCommand);
	}

	if ( nKeyCode & KEY_SHIFT )
	{
		if ( aKeyCode.Len() )
			aKeyCode += '+';
		aKeyCode += ImplGetMacResString(eKeyCodShift);
	}

	USHORT nMaskedKeyCode = nKeyCode & 0x0FFF;
	switch ( nMaskedKeyCode )
	{
		case KEY_0:
		case KEY_1:
		case KEY_2:
		case KEY_3:
		case KEY_4:
		case KEY_5:
		case KEY_6:
		case KEY_7:
		case KEY_8:
		case KEY_9:
			aCode = (char)('0' + (nMaskedKeyCode - KEY_0));
			break;

		case KEY_A:
		case KEY_B:
		case KEY_C:
		case KEY_D:
		case KEY_E:
		case KEY_F:
		case KEY_G:
		case KEY_H:
		case KEY_I:
		case KEY_J:
		case KEY_K:
		case KEY_L:
		case KEY_M:
		case KEY_N:
		case KEY_O:
		case KEY_P:
		case KEY_Q:
		case KEY_R:
		case KEY_S:
		case KEY_T:
		case KEY_U:
		case KEY_V:
		case KEY_W:
		case KEY_X:
		case KEY_Y:
		case KEY_Z:
			aCode = (char)('A' + (nMaskedKeyCode - KEY_A));
			break;

		case KEY_F1:
		case KEY_F2:
		case KEY_F3:
		case KEY_F4:
		case KEY_F5:
		case KEY_F6:
		case KEY_F7:
		case KEY_F8:
		case KEY_F9:
		case KEY_F10:
		case KEY_F11:
		case KEY_F12:
		case KEY_F13:
		case KEY_F14:
		case KEY_F15:
		case KEY_F16:
		case KEY_F17:
		case KEY_F18:
		case KEY_F19:
		case KEY_F20:
		case KEY_F21:
		case KEY_F22:
		case KEY_F23:
		case KEY_F24:
			aCode = "F";
			aCode += String( (USHORT)nMaskedKeyCode - KEY_F1 + 1 );
			break;

		case KEY_DOWN:
			aCode = ImplGetMacResString(eKeyCodDown);
			break;
		case KEY_UP:
			aCode = ImplGetMacResString(eKeyCodUp);
			break;
		case KEY_LEFT:
			aCode = ImplGetMacResString(eKeyCodLeft);
			break;
		case KEY_RIGHT:
			aCode = ImplGetMacResString(eKeyCodRight);
			break;
		case KEY_HOME:
			aCode = ImplGetMacResString(eKeyCodHome);
			break;
		case KEY_END:
			aCode = ImplGetMacResString(eKeyCodEnd);
			break;
		case KEY_PAGEUP:
			aCode = ImplGetMacResString(eKeyCodPageUp);
			break;
		case KEY_PAGEDOWN:
			aCode = ImplGetMacResString(eKeyCodPageDown);
			break;
		case KEY_RETURN:
			aCode =  ImplGetMacResString(eKeyCodEnter);
			break;
		case KEY_ESCAPE:
			aCode = ImplGetMacResString(eKeyCodEsc);
			break;
		case KEY_TAB:
			aCode = ImplGetMacResString(eKeyCodTab);
			break;
		case KEY_BACKSPACE:
			aCode = ImplGetMacResString(eKeyCodBackspace);
			break;
		case KEY_SPACE:
			aCode = ImplGetMacResString(eKeyCodSpace);
			break;
		case KEY_INSERT:
			aCode = ImplGetMacResString(eKeyCodInsert);
			break;
		case KEY_DELETE:
			aCode = ImplGetMacResString(eKeyCodDelete);
			break;

		case KEY_ADD:
			aCode = '+';
			break;
		case KEY_SUBTRACT:
			aCode = '-';
			break;
		case KEY_MULTIPLY:
			aCode = '*';
			break;
		case KEY_DIVIDE:
			aCode = '/';
			break;
		case KEY_POINT:
			aCode = '.';
			break;
		case KEY_COMMA:
			aCode = ',';
			break;
		case KEY_LESS:
			aCode = '<';
			break;
		case KEY_GREATER:
			aCode = '>';
			break;
		case KEY_EQUAL:
			aCode = '=';
			break;
	}

	if ( aCode.Len() )
	{
		if ( aKeyCode.Len() )
			aKeyCode += '+';
		aKeyCode += aCode;
	}

	return aKeyCode;
}

// -----------------------------------------------------------------------
// last changed:	dv	10.12.97

void SalFrame::UpdateSettings( AllSettings& rSettings )
{
	Size	 aStdSize = Size( 0, 8 );
	Size	 aSmallSize = Size( 0, 6 );
	XubString aSysFontName = ImplGetFontName( 0 );
	Font	 aSystemFont = Font( aSysFontName, aStdSize );
	Font	 aSmallFont = Font( "Geneva", aSmallSize );

	StyleSettings aStyleSettings = rSettings.GetStyleSettings();
	aStyleSettings.SetStandardMacStyles();

	aStyleSettings.SetMenuFont( aSystemFont );
	aStyleSettings.SetTitleFont( aSystemFont );

	aSmallFont.SetWeight( WEIGHT_BOLD );
	aStyleSettings.SetFloatTitleFont( aSmallFont );

	/* ... */
	rSettings.SetStyleSettings( aStyleSettings );
}

// -----------------------------------------------------------------------

void SalFrame::Beep( SoundType eSoundType )
{
	// !!! hier fehlt die Unterstuetzung von verschiedenen Sound Typen
	SysBeep( 10 );
}

// -----------------------------------------------------------------------

void SalFrame::SetCallback( void* pInst, SALFRAMEPROC pProc )
{
	maFrameData.mpInst	= pInst;
	if ( pProc )
		maFrameData.mpProc	= pProc;
	else
		maFrameData.mpProc	= ImplSalCallbackDummy;
}

// -----------------------------------------------------------------------
// last changed:	dv	07.11.97

void SalFrame::SetWindowState( const SalFrameState* pState )
{
	WindowPtr pMacWin = (WindowPtr) maFrameData.mpMacWin;

	DBG_ASSERT( pMacWin, "SetWindowState ohne Macintosh Window geht nicht gut" );

	if ( ! pMacWin )
		return;

	if ( pState->mnState == SAL_FRAMESTATE_MAXIMIZED )
	{
		Impl_DoZoom( NULL, pMacWin, inZoomOut );
	}
	else
	{
		// !!! hier sollte noch ein Test rein, ob wenigstens die Titelzeile noch
		// auf dem Bildschirm ist, damit man das Fenster auch noch verschieben kann
		MoveWindow( pMacWin, (int)pState->mnX, (int)pState->mnY, FALSE );
		SizeWindow( pMacWin, (int)pState->mnWidth, (int)pState->mnHeight, TRUE );
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	07.11.97

BOOL SalFrame::GetWindowState( SalFrameState* pState )
{
	WindowPtr pMacWin = (WindowPtr) maFrameData.mpMacWin;

	DBG_ASSERT( pMacWin, "GetWindowState ohne Macintosh Window geht nicht gut" );

	if ( ! pMacWin )
		return FALSE;

	MacTempGWorld aSavedWorld( (CGrafPort*) pMacWin );

	Rect	aRect = pMacWin->portRect;
	short	nWidth = aRect.right - aRect.left;
	short	nHeight = aRect.bottom - aRect.top;

	LocalToGlobal( (MAC_Point*) &aRect.top );	// convert to global coordinates

	pState->mnX = aRect.left;
	pState->mnY = aRect.top;
	pState->mnWidth = nWidth;
	pState->mnHeight = nHeight;

	aRect = ( ** (WStateDataHandle) (((WindowPeek)pMacWin)->dataHandle) ).stdState;

	if ( ( aRect.right - aRect.left == nWidth ) &&
		 ( aRect.bottom - aRect.top == nHeight ) )
	{
		pState->mnState = SAL_FRAMESTATE_MAXIMIZED;
	}
	else
	{
		pState->mnState = 0;
	}
	return TRUE;
}

// -----------------------------------------------------------------------
// last changed:	rg 6.2.98

XubString SalFrame::GetSymbolKeyName( const XubString&, USHORT nKeyCode )
{
	return GetKeyName( nKeyCode );
}
// -----------------------------------------------------------------------
void SalFrame::Flush()
{
}
	const SystemEnvData*	 SalFrame::GetSystemData() const {return NULL;}
	void					 SalFrame::Sync() {}

