/*************************************************************************
 *
 *  $RCSfile: salprn.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>
#include <svmac.h>

#define _SV_SALPRN_CXX

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _NEW_HXX
#include <tools/new.hxx>
#endif
#ifndef _SV_SALINST_HXX
#include <salinst.hxx>
#endif
#ifndef _SV_SALPRN_HXX
#include <salprn.hxx>
#endif
#ifndef _SV_SALPTYPE_HXX
#include <salptype.hxx>
#endif
#ifndef _SV_JOBSET_H
#include <jobset.h>
#endif
#ifndef _SV_PRINT_H
#include <print.h>
#endif
#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALGDI_HXX
#include <salgdi.hxx>
#endif

// =======================================================================

#define RESID_PRINTERNAME	-8192
#define BIT_ORIENTATION		0x02

// =======================================================================

// -----------------------------------------------------------------------
//	ImplCalcPaperFormat() berechnet aus der Seitengroesse in Millimetern
//		das StarView Papierformat
//	Letzte Aenderung  DV 04.10.97

static USHORT aSizeTable[] =
{
	297, 420,	// A3
	210, 297,	// A4
	148, 210,	// A5
	250, 353,	// B4
	176, 250,	// B5
	216, 279,	// Letter
	216, 356,	// Legal
	279, 431	// Tabloid
};

#define nTableSize	8
#define nSloppy		3

// -----------------------------------------------------------------------
//	Letzte Aenderung  HRO 21.01.98

static Paper ImplCalcPaperFormat( THPrint hPrtRec )
{
	short	nXRes = (**hPrtRec).prInfo.iHRes;
	short	nYRes = (**hPrtRec).prInfo.iVRes; 
	Rect	aRect = (**hPrtRec).rPaper;
	long	nWidth = aRect.right - aRect.left;
	long	nHeight = aRect.bottom - aRect.top;
	long	nAbsHeight, nAbsWidth;
	
	nWidth = ( nWidth * 127 ) / ( 5 * nXRes );		// (Width / DPI) * 25,4
	nHeight = ( nHeight * 127 ) / ( 5 * nYRes );

	if ( nWidth > nHeight )		// breiter als hoch ==> vertauschen, da uns hier nur das
	{							// Format interessiert
		nAbsHeight = nWidth;
		nWidth = nHeight;
		nHeight = nAbsHeight;
	}

	for ( int i=0; i<nTableSize; i++ )
	{
		nAbsWidth = abs( nWidth - aSizeTable[ 2*i ] );
		nAbsHeight = abs( nHeight - aSizeTable[ 2*i+1 ] );

		if ( ( nAbsWidth < nSloppy ) && ( nAbsHeight < nSloppy ) )
			return (Paper) i;
	}

	return PAPER_USER;
}

// -----------------------------------------------------------------------
//  Diese Funktion setzt im uebergebenen THPrint Handle die maximale vom
//		aktuellen Drucker unterstuetzte Aufloesung. Dies ist noetig, weil
//		die default Aufloesung immer 72 DPI betraegt. Der Code fuer diese
//		Funktion stammt aus einem Artikel im Develop Magazin.
//
//	Letzte Aenderung  DV 04.10.97

static void ImplSetMaxResolution( THPrint hPrtRec )
{
	TGetRslBlk	getResRec;
	TSetRslBlk	setResRec;
	USHORT		i, nMaxDPI;

	// setting max Resolution
	getResRec.iOpCode = getRslDataOp;
	PrGeneral( (MAC_Ptr)&getResRec );
	if ( ( getResRec.iError == noErr ) &&
		 ( (PrError() == noErr) || (PrError() == iPrAbort) ) )
	{
		nMaxDPI = 0;
		for ( i=0; i<getResRec.iRslRecCnt; i++ )
		{
			if ( ( getResRec.rgRslRec[i].iXRsl ==
				   getResRec.rgRslRec[i].iYRsl ) &&
				 ( getResRec.rgRslRec[i].iXRsl >nMaxDPI ) )
				nMaxDPI = getResRec.rgRslRec[i].iXRsl;
		}
		if ( nMaxDPI )
		{
			setResRec.iOpCode = setRslOp;
			setResRec.hPrint = hPrtRec;
			setResRec.iXRsl = nMaxDPI;
			setResRec.iYRsl = nMaxDPI;
			PrGeneral ((MAC_Ptr)(&setResRec));
		}
	}
}

// -----------------------------------------------------------------------
//  Letzte Aenderung  DV 04.10.97

static void ImplTHPrint2JobSetup( ImplJobSetup* pSetupData,
								  THPrint hPrtRec )
{
	if ( pSetupData->mnDriverDataLen != sizeof( TPrint ) )
	{
		if ( pSetupData->mpDriverData )
			SvMemFree( pSetupData->mpDriverData );
		pSetupData->mpDriverData = (BYTE*) SvMemAlloc( sizeof( TPrint ) );
		pSetupData->mnDriverDataLen = sizeof( TPrint );
	}
	
	if ( (**hPrtRec).prStl.wDev & BIT_ORIENTATION )
		pSetupData->meOrientation = ORIENTATION_PORTRAIT;
	else
		pSetupData->meOrientation = ORIENTATION_LANDSCAPE;

	pSetupData->mnPaperBin = 0;
	pSetupData->mePaperFormat = ImplCalcPaperFormat( hPrtRec );

	Rect aRect = (**hPrtRec).prInfo.rPage;

	pSetupData->mnPaperWidth = aRect.right - aRect.left;
	pSetupData->mnPaperHeight = aRect.bottom - aRect.top;
	
	memcpy( (char*) pSetupData->mpDriverData,
			(char*) *hPrtRec, sizeof( TPrint ) );

	if (pSetupData->mnPaperHeight < 0 || pSetupData->mnPaperHeight > 10000)
		pSetupData->mnPaperHeight = -pSetupData->mnPaperHeight;
	if (pSetupData->mnPaperWidth < 0 || pSetupData->mnPaperWidth > 10000)
		pSetupData->mnPaperWidth = -pSetupData->mnPaperWidth;
}

// -----------------------------------------------------------------------
//  Letzte Aenderung  DV 05.10.97

static void ImplSetupJobSetup( ImplJobSetup* pSetupData )
{
	// Druckertreiber ggfs. oeffnen ( ACHTUNG, andere Programme bekommen 
	// Probleme beim Drucken, wenn der Drucker waehrend der gesammten Programm-
	// laufzeit offen gehalten wird! )

	if ( ! GetSalData()->mbPrinterInit )
	{
		PrOpen();
		if ( PrError() )
			return;
	}

	THPrint hPrtRec = (THPrint) NewHandleClear( sizeof( TPrint ) );

	// Default Daten des Druckers holen ...
	PrintDefault( hPrtRec );

	// Aufloesung setzen
	if ( ! PrError() )
		ImplSetMaxResolution( hPrtRec );

	// ... und alle Daten in JobSetup eintragen
	if ( ! PrError() )
		ImplTHPrint2JobSetup( pSetupData, hPrtRec );

	// zum Schluss wieder aufraeumen
	if ( ! GetSalData()->mbPrinterInit )
		PrClose();

	DisposeHandle( (Handle) hPrtRec );
}

// -----------------------------------------------------------------------
//  Letzte Aenderung  hro 20.01.98

static void ImplUpdateJobSetup( ULONG nFlags, ImplJobSetup* pSetupData )
{
	DBG_TRACE( "ImplUpdateJobSetup" );
	DBG_ASSERT( pSetupData->mnDriverDataLen == sizeof( TPrint ),
				"ImplUpdateJobSetup: Setup Daten FALSCH!" );

	TPrint	*pData = (TPrint*) pSetupData->mpDriverData;
	
	if (nFlags & SAL_JOBSET_ORIENTATION)
	{
		if ( pSetupData->meOrientation == ORIENTATION_PORTRAIT )
			pData->prStl.wDev |= BIT_ORIENTATION;
		else
			pData->prStl.wDev &= ~BIT_ORIENTATION;
	}
	
	if (nFlags & SAL_JOBSET_PAPERBIN)
	{
	}
	
	if (nFlags & SAL_JOBSET_PAPERSIZE)
	{
		Rect	*pRect = &(pData->prInfo.rPage);
		pRect->bottom	= pRect->top + pSetupData->mnPaperHeight;
		pRect->right	= pRect->left + pSetupData->mnPaperWidth;
		
	}
	if (pSetupData->mnPaperHeight < 0 || pSetupData->mnPaperHeight > 10000)
		pSetupData->mnPaperHeight = -pSetupData->mnPaperHeight;
	if (pSetupData->mnPaperWidth < 0 || pSetupData->mnPaperWidth > 10000)
		pSetupData->mnPaperWidth = -pSetupData->mnPaperWidth;
}

// -----------------------------------------------------------------------
//  Letzte Aenderung  HRO 16.01.98

static THPrint ImplGetPrintRecFromSetup(ImplJobSetup* pSetupData )
{
	if ( pSetupData->mnDriverDataLen != sizeof( TPrint ) )
		return NULL;

	THPrint hPrtRec = ( THPrint ) NewHandle( sizeof( TPrint ) );
	memcpy( (char*)(*hPrtRec), (char*) pSetupData->mpDriverData, sizeof( TPrint ) );

	return hPrtRec;
}

// -----------------------------------------------------------------------

static SalGraphics* ImplCreateSalPrnGraphics( GWorldPtr pPrinter )
{
	SalGraphics* pGraphics = new SalGraphics;
	pGraphics->maGraphicsData.mpGrafPort	= (CGrafPtr) pPrinter;
	pGraphics->maGraphicsData.mbPrinter		= TRUE;
	pGraphics->maGraphicsData.mbVirDev		= FALSE;
	pGraphics->maGraphicsData.mbWindow		= FALSE;
	pGraphics->maGraphicsData.mbScreen		= FALSE;
	ImplSalInitGraphics( &(pGraphics->maGraphicsData) );
	return pGraphics;
}

// -----------------------------------------------------------------------
//  Letzte Aenderung  DV 10.11.97

static void ImplSetResolution( SalGraphics* pGraphics,
							   ImplJobSetup* pSetupData )
{
	if ( pSetupData->mpDriverData )
	{
		TPrint *pPrint = (TPrint*) pSetupData->mpDriverData;
		pGraphics->maGraphicsData.mnXRes = MyIntToFixed( pPrint->prInfo.iHRes );
		pGraphics->maGraphicsData.mnYRes = MyIntToFixed( pPrint->prInfo.iVRes );
	}
}

// -----------------------------------------------------------------------
//	Diese Funktion erzeugt ein kleines Fenster mit dem Namen des
//		Druckjobs, um so den Druckertreiber dazu zu bewegen, diesen
//		Namen fuer seinen Druckjob zu benutzen
//
//  Letzte Aenderung  DV 05.10.97

static void ImplSetPrinterName( const XubString& rName, THPrint hPrint )
{
	WindowPtr	pWindow, pFrontWin;
	Rect 		aBounds;

	SetRect( &aBounds, 1, 1, 2, 2 );

	pFrontWin = FrontWindow();

	pWindow = NewWindow( nil, &aBounds, rName.GetPascalStr(),
						 true, plainDBox, nil, false, 0 );

	BringToFront( pWindow );

	// To set the jobname
	PrValidate( hPrint );

	if ( pFrontWin )
		SendBehind( pWindow, pFrontWin );

	DisposeWindow( pWindow );
}

// -----------------------------------------------------------------------
//	Diese Funktion setzt einen neuen Printer Job auf.
//		Dies ist notwendig, wenn sich irgendwelche Daten am PrinterSetup
//		geaendert haben.
//
//  Letzte Aenderung  DV 08.12.97

void SalPrinterData::ImplNewPrintJob( ImplJobSetup* pSetupData )
{
	CGrafPtr	pOldPort, pWMgrPort;
	GDHandle	hOldDevice;
	TPrStatus	pStatus;

	// PrOpenDoc fuehrt zu Abstuerzen, wenn der current Port auf ein
	// virtual Device zeigt.
	GetGWorld( &pOldPort, &hOldDevice );
	GetCWMgrPort( &pWMgrPort );
	SetGWorld( pWMgrPort, NULL );

	// alten Printer schliessen
	PrCloseDoc( mpPort );
	if ( (*(mhPrtRec))->prJob.bJDocLoop == bSpoolLoop )
	{
		PrValidate( mhPrtRec );
		PrPicFile( mhPrtRec, nil, nil, nil, &pStatus );
	}

	// und einen neuen Printer aufmachen
	// dazu zuerst die neuen Daten kopieren
	PrValidate( mhPrtRec );
	memcpy( (void*) *(mhPrtRec), (void*) pSetupData->mpDriverData, sizeof( TPrint ) );

	// Set the IdleProc
//	(*(pThis->aImpPRN.hPrtRec))->prJob.pIdleProc = pIdleProc;

	mpPort = PrOpenDoc( mhPrtRec, nil, nil );
	SetGWorld( pOldPort, hOldDevice );
}

// =======================================================================

void SalInstance::GetPrinterQueueInfo( ImplPrnQueueList* pList )
{
	DBG_TRACE( "SalInstance::GetPrinterQueueInfo" );
	// Neuen Eintrag anlegen
	SalPrinterQueueInfo* pInfo = new SalPrinterQueueInfo;
	pInfo->maPrinterName = SalInstance::GetDefaultPrinter();
//	pInfo->maDriver 	 = aDriver;
//	pInfo->maLocation	 = aPortName;
//	pInfo->mpSysData	 = new String;
	pInfo->mpSysData	 = NULL;
	pList->Add( pInfo );
}

// -----------------------------------------------------------------------

void SalInstance::GetPrinterQueueState( SalPrinterQueueInfo* pInfo )
{
	DBG_TRACE( "SalInstance::GetPrinterQueueState" );
	DBG_ERROR( "SalInstance::GetPrinterQueueState  NYI" );
}

// -----------------------------------------------------------------------

void SalInstance::DeletePrinterQueueInfo( SalPrinterQueueInfo* pInfo )
{
	DBG_TRACE( "SalInstance::DeletePrinterQueueInfo" );
//	delete (String*)(pInfo->mpSysData);
	delete pInfo;
}

// -----------------------------------------------------------------------

XubString SalInstance::GetDefaultPrinter()
{
	DBG_TRACE( "SalInstance::GetDefaultPrinter" );

	XubString		aDefaultPrinter;
	StringHandle	hStr = GetString( RESID_PRINTERNAME );

	if ( hStr )
	{
		aDefaultPrinter = XubString( (const char*)(*hStr)+1,
									(USHORT)(**hStr) );
		ReleaseResource( (Handle) hStr );
	}

	return aDefaultPrinter;
}

// =======================================================================
//  Letzte Aenderung  DV 10.11.97

SalInfoPrinter* SalInstance::CreateInfoPrinter( SalPrinterQueueInfo* pQueueInfo,
												ImplJobSetup* pSetupData )
{
	DBG_TRACE( "SalInstance::CreateInfoPrinter" );

	SalInfoPrinter* pPrinter = new SalInfoPrinter;
	pPrinter->maPrinterData.maDriverName	= pQueueInfo->maDriver;
	pPrinter->maPrinterData.maDeviceName	= pQueueInfo->maPrinterName;
//	pPrinter->maPrinterData.maPortName		= *(String*)(pQueueInfo->mpSysData);

	Rect		aRect;
	GWorldPtr	pDummyPrinter;
	OSErr		nErr;

	// statt eines echten Druckers benutzen wir ein virtuelles device, da sonst
	// das MacOS Probleme bekommt. ( evtl. mal prueffen, ob das unter Sys 8.0 auch
	// noch gilt )

	SetRect( &aRect, 0, 0, 1, 1 );
	nErr = NewGWorld( &pDummyPrinter, 0, &aRect, nil, nil, 0 );

	if ( !pDummyPrinter )
	{
		delete pPrinter;
		return NULL;
	}

	SalGraphics* pGraphics = ImplCreateSalPrnGraphics( pDummyPrinter );
	pPrinter->maPrinterData.mpGWorld	= pDummyPrinter;
	pPrinter->maPrinterData.mpGraphics	= pGraphics;

	if ( pSetupData->mnDriverDataLen != sizeof( TPrint ) )
		ImplSetupJobSetup( pSetupData );
	else
		ImplUpdateJobSetup( SAL_JOBSET_ALL, pSetupData );

	ImplSetResolution( pGraphics, pSetupData );

	return pPrinter;
}

// -----------------------------------------------------------------------

void SalInstance::DestroyInfoPrinter( SalInfoPrinter* pPrinter )
{
	DBG_TRACE( "SalInstance::DestroyInfoPrinter" );
	delete pPrinter;
}

// =======================================================================

SalInfoPrinter::SalInfoPrinter()
{
	DBG_TRACE( "SalInfoPrinter::SalInfoPrinter" );
	maPrinterData.mpGWorld		= NULL;
	maPrinterData.mhPrintRec	= NULL;
	maPrinterData.mpGraphics	= NULL;
	maPrinterData.mbGraphics	= FALSE;
}

// -----------------------------------------------------------------------

SalInfoPrinter::~SalInfoPrinter()
{
	DBG_TRACE( "SalInfoPrinter::~SalInfoPrinter" );
	ImplSalDeInitGraphics( &(maPrinterData.mpGraphics->maGraphicsData) );
	DisposeGWorld( maPrinterData.mpGWorld );
	
	if ( maPrinterData.mhPrintRec )
		DisposeHandle( (Handle) maPrinterData.mhPrintRec );

	delete maPrinterData.mpGraphics;
}

// -----------------------------------------------------------------------

SalGraphics* SalInfoPrinter::GetGraphics()
{
	if ( maPrinterData.mbGraphics )
		return NULL;

	if ( maPrinterData.mpGraphics )
		maPrinterData.mbGraphics = TRUE;

	return maPrinterData.mpGraphics;
}

// -----------------------------------------------------------------------

void SalInfoPrinter::ReleaseGraphics( SalGraphics* )
{
	maPrinterData.mbGraphics = FALSE;
}

// -----------------------------------------------------------------------

BOOL SalInfoPrinter::Setup( SalFrame* pFrame, ImplJobSetup* pSetupData )
{
	BOOL	bRet = FALSE;

	if ( ! GetSalData()->mbPrinterInit )
	{
		PrOpen();
		if ( PrError() )
			return FALSE;
	}

	THPrint	hPrtRec = ImplGetPrintRecFromSetup(pSetupData );

	if ( hPrtRec )
	{
		PrValidate( hPrtRec );

		if ( PrError() )
		{
			DisposeHandle( (Handle) hPrtRec );
			if ( ! GetSalData()->mbPrinterInit )
				PrClose();
			return FALSE;
		}

		// Wenn der Dialog angezeigt werden soll, dann eben anzeigen, sonst
		// muss PrValidate reichen.
		if ( pFrame )
			bRet = PrStlDialog( hPrtRec );
		else
			bRet = TRUE;

		// Die Daten aus dem Handle wieder ins Jobsetup kopieren
		if( bRet == TRUE )
		{
			ImplTHPrint2JobSetup( pSetupData, hPrtRec );
			ImplSetResolution( maPrinterData.mpGraphics, pSetupData );
		}

		// Alten PrinterRec entsorgen
		if ( maPrinterData.mhPrintRec )
			DisposeHandle( (Handle) maPrinterData.mhPrintRec );
	
		maPrinterData.mhPrintRec = hPrtRec;
//		DisposeHandle( (Handle) hPrtRec );
	}

	if ( ! GetSalData()->mbPrinterInit )
		PrClose();

	return bRet;
}

// -----------------------------------------------------------------------

BOOL SalInfoPrinter::SetPrinterData( ImplJobSetup* pSetupData )
{
	ImplUpdateJobSetup(SAL_JOBSET_ALL, pSetupData);
	Setup(NULL, pSetupData);
	return TRUE;
}

// -----------------------------------------------------------------------

BOOL SalInfoPrinter::SetData( ULONG nFlags, ImplJobSetup* pSetupData )
{
	ImplUpdateJobSetup(nFlags, pSetupData);
	Setup(NULL, pSetupData);
	return TRUE;
}

// -----------------------------------------------------------------------

ULONG SalInfoPrinter::GetPaperBinCount( const ImplJobSetup* )
{
	// NYI : (dv) man kann nicht mit dem Printer kommunizieren

	return 0;
}

// -----------------------------------------------------------------------

XubString SalInfoPrinter::GetPaperBinName( const ImplJobSetup*, ULONG nPaperBin )
{
	// NYI : (dv) man kann nicht mit dem Printer kommunizieren

	XubString aPaperBinName;
	return aPaperBinName;
}

// -----------------------------------------------------------------------

void SalInfoPrinter::GetPageInfo( const ImplJobSetup* pSetupData,
								  long& rOutWidth, long& rOutHeight,
								  long& rPageOffX, long& rPageOffY,
								  long& rPageWidth, long& rPageHeight )
{
	if ( ! GetSalData()->mbPrinterInit )
	{
		PrOpen();
		if ( PrError() )
			return;
	}

//	THPrint	hPrtRec = maPrinterData.mhPrintRec;
	THPrint hPrtRec = ImplGetPrintRecFromSetup(pSetupData );

	if ( !hPrtRec )
	{
		hPrtRec = (THPrint) NewHandleClear( sizeof( TPrint ) );
		// Default Daten des Druckers holen ...
		PrintDefault( hPrtRec );
		ImplSetMaxResolution( hPrtRec );
		maPrinterData.mhPrintRec = hPrtRec;
	}

	Rect aRect = (**hPrtRec).rPaper;
	rPageWidth = aRect.right - aRect.left;
	rPageHeight = aRect.bottom - aRect.top;
		
	rPageOffX = - aRect.left;
	rPageOffY = - aRect.top;

	aRect = (**hPrtRec).prInfo.rPage;
	rOutWidth = aRect.right - aRect.left;
	rOutHeight = aRect.bottom - aRect.top;

	if ( ! GetSalData()->mbPrinterInit )
		PrClose();
}

// =======================================================================

SalPrinter* SalInstance::CreatePrinter( SalInfoPrinter* pInfoPrinter )
{
	SalPrinter* pPrinter = new SalPrinter;
	pPrinter->maPrinterData.mpInfoPrinter = pInfoPrinter;
	return pPrinter;
}

// -----------------------------------------------------------------------

void SalInstance::DestroyPrinter( SalPrinter* pPrinter )
{
	delete pPrinter;
}

// =======================================================================

SalPrinter::SalPrinter()
{
	maPrinterData.mpPort		= NULL;
	maPrinterData.mpGraphics	= NULL;
	maPrinterData.mbAbort		= FALSE;
}

// -----------------------------------------------------------------------

SalPrinter::~SalPrinter()
{
}

// -----------------------------------------------------------------------
//  Letzte Aenderung  DV 08.12.97

BOOL SalPrinter::StartJob( const XubString* pFileName,
						   const XubString& rJobName,
						   const XubString& rAppName,
							ULONG nCopies, BOOL bCollate,
						   ImplJobSetup* pSetupData )
{
	CGrafPtr	pOldPort, pWMgrPort;
	GDHandle	hOldDevice;
	THPrint		hPrtRec;
	BOOL		bCloseIt = FALSE;

	// PrOpenDoc fuehrt zu Abstuerzen, wenn der current Port auf ein
	// virtual Device zeigt.
	GetGWorld( &pOldPort, &hOldDevice );
	GetCWMgrPort( &pWMgrPort );
	SetGWorld( pWMgrPort, NULL );

//	if ( pIdleProc == 0 )
//		pIdleProc = NewPrIdleProc( MyPIdleProc );

	if ( ! GetSalData()->mbPrinterInit )
	{
		PrOpen();
		GetSalData()->mbPrinterInit = TRUE;
		bCloseIt = TRUE;
	}

	// getting default PrintRecord values
	hPrtRec = ImplGetPrintRecFromSetup(pSetupData );

	// To get the jobname
	ImplSetPrinterName( rJobName, hPrtRec );

	if ( PrError() )
	{
		maPrinterData.mpPort = NULL;
		maPrinterData.mnError = SAL_PRINTER_ERROR_GENERALERROR;
		if ( bCloseIt )
		{
			PrClose();
			GetSalData()->mbPrinterInit = FALSE;
		}
		return FALSE;
	}

	// Set the IdleProc
//	(*(pThis->aImpPRN.hPrtRec))->prJob.pIdleProc = pIdleProc;

	maPrinterData.mpPort	= PrOpenDoc( hPrtRec, nil, nil);

	// jetzt koennen wir den curGrafPort wieder restaurieren.
	SetGWorld( pOldPort, hOldDevice );

	if ( PrError() )
	{
		maPrinterData.mpPort = NULL;
		maPrinterData.mnError = SAL_PRINTER_ERROR_GENERALERROR;
		if ( bCloseIt )
		{
			PrClose();
			GetSalData()->mbPrinterInit = FALSE;
		}
		return FALSE;
	}

	maPrinterData.mnError	= 0;
	maPrinterData.mbAbort	= FALSE;
	maPrinterData.mhPrtRec	= hPrtRec;

	return TRUE;
}

// -----------------------------------------------------------------------

BOOL SalPrinter::EndJob()
{
	TPrStatus	pStatus;
	BOOL		bRet = TRUE;

	DBG_ASSERT( maPrinterData.mpPort, "EndJob ohne Printer Port!" );

	PrCloseDoc( maPrinterData.mpPort );

	if ( PrError() )
		bRet = FALSE;

	if ( bRet )
	{
		// To get the jobname
		ImplSetPrinterName( maPrinterData.maJobName, maPrinterData.mhPrtRec);

		if ( !maPrinterData.mbAbort )
		{
			if ( (*(maPrinterData.mhPrtRec))->prJob.bJDocLoop == bSpoolLoop )
			{
				PrPicFile( maPrinterData.mhPrtRec, nil, nil, nil, &pStatus );
			}
		}

		if ( GetSalData()->mbPrinterInit )
		{
			PrClose();
			GetSalData()->mbPrinterInit = FALSE;
		}
		if ( PrError() )
			bRet = FALSE;
	}
	
	DisposeHandle( (Handle) maPrinterData.mhPrtRec );
	delete maPrinterData.mpGraphics;

	maPrinterData.mhPrtRec = NULL;
	maPrinterData.mpPort = NULL;
	maPrinterData.mpGraphics = NULL;

	return bRet;
}

// -----------------------------------------------------------------------

BOOL SalPrinter::AbortJob()
{
	PrSetError(iPrAbort);

	maPrinterData.mbAbort = TRUE;
	return EndJob();
}

// -----------------------------------------------------------------------

SalGraphics* SalPrinter::StartPage( ImplJobSetup* pSetupData, BOOL bNewJobData )
{
	DBG_ASSERT( maPrinterData.mpPort, "StartPage ohne PORT!" );

	// ggfs. neuen Printjob aufsetzen,
	// aber nur wenn sich etwas am JobSetup geaendert hat
	if ( pSetupData && ( pSetupData->mnDriverDataLen == sizeof( TPrint ) ) )
	{
		if ( memcmp( (void*) *(maPrinterData.mhPrtRec),
					 (void*) pSetupData->mpDriverData,
					 sizeof( TPrint ) ) )
		{
			maPrinterData.ImplNewPrintJob( pSetupData );
		}
	}

	// Seite erzeugen
	PrOpenPage( maPrinterData.mpPort, nil );

	if ( PrError() )
	{
		maPrinterData.mnError = SAL_PRINTER_ERROR_GENERALERROR;
		return NULL;
	}

	SalGraphics* pGraphics = new SalGraphics;

	pGraphics->maGraphicsData.mpGrafPort	= (CGrafPtr) maPrinterData.mpPort;
	pGraphics->maGraphicsData.mbPrinter		= TRUE;
	pGraphics->maGraphicsData.mbVirDev		= FALSE;
	pGraphics->maGraphicsData.mbWindow		= FALSE;
	pGraphics->maGraphicsData.mbScreen		= FALSE;

	ImplSalInitGraphics( &(pGraphics->maGraphicsData) );

	maPrinterData.mpGraphics = pGraphics;

	return pGraphics;
}

// -----------------------------------------------------------------------

BOOL SalPrinter::EndPage()
{
	DBG_ASSERT( maPrinterData.mpPort, "EndPage ohne PORT!" );

	delete maPrinterData.mpGraphics;
	maPrinterData.mpGraphics = NULL;

	// Seitenvorschub erzeugen
	PrClosePage( maPrinterData.mpPort );

	if ( PrError() )
	{
		maPrinterData.mnError = SAL_PRINTER_ERROR_GENERALERROR;
		return FALSE;
	}
	else
		return TRUE;
}

// -----------------------------------------------------------------------

ULONG SalPrinter::GetErrorCode()
{
	return maPrinterData.mnError;
}

ULONG	SalInfoPrinter::GetCapabilities( const ImplJobSetup* pSetupData, USHORT nType )
{
	return 0;
}

