/*************************************************************************
 *
 *  $RCSfile: ttprops.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_TTPROPS_HXX
#define _SVTOOLS_TTPROPS_HXX

#ifndef _RTTI_HXX // manual
#include <tools/rtti.hxx>
#endif
#ifndef _VCL_APPTYPES_HXX //autogen
#include <vcl/apptypes.hxx>
#endif
#include "svtdata.hxx"

class SfxPoolItem;
class Bitmap;

// Defines zur Steuerung der Ausfhrung von Slots
#define EXECUTE_NO					0
#define EXECUTE_POSSIBLE			1
#define EXECUTE_YES					2
#define EXECUTEMODE_ASYNCHRON		1
#define EXECUTEMODE_DIALOGASYNCHRON	2

#define SFX_USE_BINDINGS		0x8000


// Property Requests(PR)
#define TT_PR_ONCE		0x100

#define TT_PR_SLOTS		( 0x001 | TT_PR_ONCE )
#define TT_PR_DISPATCHER (0x002 )
#define TT_PR_IMG		( 0x004 )

#define TT_PR_ERR_NODISPATCHER	01
#define TT_PR_ERR_NOEXECUTE		02

///	To detect inconsistencies
#define TT_PROPERTIES_VERSION	1

class TTProperties : public ApplicationProperty
{
	USHORT nDonePRs;					// Verwaltung fr die Properties, die nur einmal gerufen werden mussen.
	BOOL RequestProperty( USHORT nRequest );

	BOOL HasSlots(){ return nPropertyVersion == TT_PROPERTIES_VERSION; }

public:
	TYPEINFO();

	TTProperties() : nPropertyVersion( 0 ), mpBmp( NULL ), mppArgs( NULL ), nDonePRs( 0 ){;}

	BOOL GetSlots();

	/// ExecuteFunction
	USHORT mnSID;
	SfxPoolItem** mppArgs;
	USHORT mnMode;
	USHORT ExecuteFunction( USHORT nSID, SfxPoolItem** ppArgs = NULL, USHORT nMode = 0 );

	/// Img
	Bitmap *mpBmp;
	BOOL Img( Bitmap *pBmp );

	static SvtResId GetSvtResId( USHORT nId );
	
	ULONG nSidOpenUrl;
	ULONG nSidFileName;
	ULONG nSidNewDocDirect;
	ULONG nSidCopy;
	ULONG nSidPaste;
	ULONG nSidSourceView;
	ULONG nSidSelectAll;
	ULONG nSidReferer;

	USHORT nActualPR;
	USHORT nPropertyVersion;		// Wird bei jedem call gesetzt.
};

#endif // _SVTOOLS_TTPROPS_HXX

