/*************************************************************************
 *
 *  $RCSfile: componentloader.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: rt $ $Date: 2003/06/12 08:20:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_HELPER_COMPONENTLOADER_HXX_
#include <helper/componentloader.hxx>
#endif

#ifndef __FRAMEWORK_HELPER_ASYNCLOADTHREAD_HXX_
#include <helper/asyncloadthread.hxx>
#endif

#ifndef __FRAMEWORK_HELPER_LOADEVENTLISTENER_HXX_
#include <helper/loadeventlistener.hxx>
#endif

#ifndef __FRAMEWORK_INTERACTION_RESTRICTEDUIINTERACTION_HXX_
#include <interaction/restricteduiinteraction.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_FILTERCACHE_HXX_
#include <classes/filtercache.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_TASKCREATOR_HXX_
#include <classes/taskcreator.hxx>
#endif

#ifndef __FRAMEWORK_TARGETS_H_
#include <targets.h>
#endif

#ifndef __FRAMEWORK_PROTOCOLS_H_
#include <protocols.h>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETRUNTIMEEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetRuntimeException.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_lang_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_CLOSEVETOEXCEPTION_HPP_
#include <com/sun/star/util/CloseVetoException.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XSYNCHRONOUSFRAMELOADER_HPP_
#include <com/sun/star/frame/XSynchronousFrameLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAMELOADER_HPP_
#include <com/sun/star/frame/XFrameLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XACTIONLOCKABLE_HPP_
#include <com/sun/star/document/XActionLockable.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XTYPEDETECTION_HPP_
#include <com/sun/star/document/XTypeDetection.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_MACROEXECMODE_HPP_
#include <com/sun/star/document/MacroExecMode.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_INTERACTIVEIOEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveIOException.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_INTERACTIVEAUGMENTEDIOEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveAugmentedIOException.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XWINDOW_HPP_
#include <com/sun/star/awt/XWindow.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_XTOPWINDOW_HPP_
#include <com/sun/star/awt/XTopWindow.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_MACROEXECMODE_HPP_
#include <com/sun/star/document/MacroExecMode.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_UPDATEDOCMODE_HPP_
#include <com/sun/star/document/UpdateDocMode.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XJOBEXECUTOR_HPP_
#include <com/sun/star/task/XJobExecutor.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

#define DOCSERVICE_WRITER            DECLARE_ASCII("com.sun.star.text.TextDocument"                )
#define DOCSERVICE_WRITERWEB         DECLARE_ASCII("com.sun.star.text.WebDocument"                 )
#define DOCSERVICE_WRITERGLOBAL      DECLARE_ASCII("com.sun.star.text.GlobalDocument"              )
#define DOCSERVICE_CALC              DECLARE_ASCII("com.sun.star.sheet.SpreadsheetDocument"        )
#define DOCSERVICE_DRAW              DECLARE_ASCII("com.sun.star.drawing.DrawingDocument"          )
#define DOCSERVICE_IMPRESS           DECLARE_ASCII("com.sun.star.presentation.PresentationDocument")
#define DOCSERVICE_MATH              DECLARE_ASCII("com.sun.star.formula.FormulaProperties"        )
#define DOCSERVICE_CHART             DECLARE_ASCII("com.sun.star.chart.ChartDocument"              )

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************
DEFINE_XINTERFACE_2( ComponentLoader                                        ,
                     OWeakObject                                            ,
                     DIRECT_INTERFACE(css::lang::XTypeProvider             ),
                     DIRECT_INTERFACE(css::frame::XComponentLoader)
                   )

DEFINE_XTYPEPROVIDER_2( ComponentLoader                      ,
                        css::lang::XTypeProvider             ,
                        css::frame::XComponentLoader
                      )

/*-****************************************************************************************************//**
    @interface  native
    @rights     public

    @short      standard constructor to create instance
	@descr		This constructor initialize a new instance of this class by valid factory,
				and will be set valid values on his member and baseclasses.

    @param      xFactory
                    is the uno service manager, which has created this instance.
                    We can use it internaly to create on services if neccessary.
                    Must be different from NULL.

    @threadsafe not neccessary - it's the ctor
    @modified   02.07.2002 13:34, as96863
*//*-*****************************************************************************************************/
ComponentLoader::ComponentLoader( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory ,
                                  const css::uno::Reference< css::frame::XFrame >&              xFrame   )
        // init baseclasses first!
        : ThreadHelpBase     ( &Application::GetSolarMutex() )
        , ::cppu::OWeakObject(                               )
        // init member
        , m_xFactory         ( xFactory                      )
        , m_xOwner           ( xFrame                        )
{
}

/*-****************************************************************************************************//**
    @interface  native
    @rights     public

	@short		standard destructor
    @descr      We must release all used references here (if they wasn't released before).

    @threadsafe not neccessary - it's the dtor
    @modified   04.07.2002 13:45, as96863
*//*-*****************************************************************************************************/
ComponentLoader::~ComponentLoader()
{
    m_xFactory = css::uno::Reference< css::lang::XMultiServiceFactory >();
    m_xOwner   = css::uno::Reference< css::frame::XFrame >();
}

//_______________________________________________

/**
 */

css::uno::Reference< css::lang::XComponent > SAL_CALL loadFromModel( const css::uno::Reference< css::frame::XFrame >&              xFrame      ,
                                                                     const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR       ,
                                                                     const css::uno::Sequence< css::beans::PropertyValue >&        lDescriptor )
    throw (css::io::IOException               ,
           css::lang::IllegalArgumentException,
           css::uno::RuntimeException         )
{
    css::uno::Reference< css::frame::XSynchronousFrameLoader > xLoader(xSMGR->createInstance(IMPLEMENTATIONNAME_GENERICFRAMELOADER), css::uno::UNO_QUERY);
    if (!xLoader.is())
        return css::uno::Reference< css::lang::XComponent >();
    css::uno::Reference< css::document::XActionLockable > xLock(xFrame, css::uno::UNO_QUERY);
    if (xLock.is())
        xLock->addActionLock();
    sal_Bool bLoaded = xLoader->load(lDescriptor, xFrame);
    if (bLoaded)
    {
        ArgumentAnalyzer aDescriptor(lDescriptor);
        ComponentLoader::updateFrameAfterLoading(xSMGR,xFrame,aDescriptor);
    }
    if (xLock.is())
        xLock->removeActionLock();
    return ComponentLoader::getFrameComponent(xFrame);
}


/*-****************************************************************************************************//**
    @interface  XComponentLoader
    @rights     public

    @short      interface for loading documents
    @descr      This method can be used to provide this functionality at own interfaces.
                It capsulate the whole process of detecting and loading a document.
                And it doesn't depend if internal processes are synchron or asynchron.

    @param      sURL
                    URL which should be loaded
                    It must represent a loadable content. So e.g. "slot:" or ".uno" URLs are not allowed!

    @param      sTargetName
                    name of the target frame which should include the loaded document afterwards
                    Special targets (e.g. _blank, _default) are allowed too.

    @param      nFlags
                    optional search flags if target isn't a special one

    @param      lDescriptor
                    optional MediaDescriptor which provides some more functionality for loading

    @return     A reference to the loaded document or NULL if it failed.

    @throw      css::io::IOException
                    if loading failed by a general io error

    @throw      css::lang::IllegalArgumentException
                    if an incoming argument is wrong
                    Note: URLs of not loadable contents (e.g. "slot*", ".uno*") produce such exception too.

    @threadsafe yes
    @modified   02.07.2002 13:38, as96863
*//*-*****************************************************************************************************/
css::uno::Reference< css::lang::XComponent > SAL_CALL ComponentLoader::loadComponentFromURL( const ::rtl::OUString&                                 sURL         ,
                                                                                             const ::rtl::OUString&                                 sTargetName  ,
                                                                                                   sal_Int32                                        nSearchFlags ,
                                                                                             const css::uno::Sequence< css::beans::PropertyValue >& lDescriptor  ) throw (css::io::IOException               ,
                                                                                                                                                                          css::lang::IllegalArgumentException,
                                                                                                                                                                          css::uno::RuntimeException         )
{
	// see "Attention" mark of method impl_checkLoadParameters()!
	// It's usefull to prevent the following code against self-killing :-)
	css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this),css::uno::UNO_QUERY);

    RTL_LOGFILE_CONTEXT( aLog, "framework (as96863) ::ComponentLoader::loadComponentFromURL" );

    // Use a copy of the given argument list - because we must use it as a changeable one
    // for the following statements. And a const reference isn't possible then.
    // Set wrapper object in top of this descriptor - an MediaDescriptor.
    // So all further called helper methods mustn't parse sequence again.
    // They can use this wrapper for easy change it ...
    // sal_True => force using of an internal copy of the given descriptor
    ArgumentAnalyzer aDescriptor(lDescriptor);

    // Check incoming parameter and throw an exception for wrong values!
    // Note: This method throws the right exception automaticly ...
    impl_checkLoadParameters(sURL,sTargetName,nSearchFlags,aDescriptor);

    // make some copies of our member in a threadsafe manner
    /* SAFE { */
    ReadGuard aReadLock(m_aLock);
    css::uno::Reference< css::lang::XMultiServiceFactory > xFactory = m_xFactory;
    css::uno::Reference< css::frame::XFrame >              xOwner   = m_xOwner  ;
    aReadLock.unlock();
    /* } SAFE */

    /*REMOVEME*/
    if (ProtocolCheck::isProtocol(sURL, ProtocolCheck::E_PRIVATE_OBJECT) && TargetCheck::matchSpecialTarget(sTargetName, SPECIALTARGET_SELF))
        return loadFromModel(xOwner, xFactory, lDescriptor);
    /*REMOVEME*/

    // Parse the given URL and convert it to his structured form.
    // In case we can't parse it (because we doesnt get the right service for that)
    // we try to work with a non parsed URL. We set the Complete part only then and hope
    // it's enough for further steps.
    css::uno::Reference< css::util::XURLTransformer > xParser( xFactory->createInstance(SERVICENAME_URLTRANSFORMER), css::uno::UNO_QUERY );
    css::util::URL  aURL;
    aURL.Complete = sURL;
    if (xParser.is())
        xParser->parseStrict(aURL);
    aDescriptor.setArgument(E_URL,aURL);

#if 0 // the target URL can have no extension or a wrong one
	
	// check URL if it is a component
    // If not - using of loadComponentFromURL isn't allowed.
    if ( ! ComponentLoader::isComponent(xFactory,aURL.Complete,aDescriptor) )
        return css::uno::Reference< css::lang::XComponent >();
#endif
	
    // make a type and filter detection to be shure it's realy neccessary to search or
    // create a possible target frame
    // This helper call will set the right informations (type,filter) inside the given descriptor!
    // Last parameter true activates a deep detection.
    if ( ! ComponentLoader::detectTypeAndFilter(xFactory,aURL,aDescriptor,sal_True) )
        return css::uno::Reference< css::lang::XComponent >();

    // try to find the righ target now
    css::uno::Reference< css::frame::XFrame > xTarget;

    // a) look for special target "_default"
    //    Because it combines a search for a possible task, which include already the required document.
    //    Then this method will be breaked - and the task will get the focus.
    //    Otherwhise we search for a task, which can be recylced (if it's an empty one).
    //    If such frame doesn't exist too - we reset _default to _blank and create a new one.
    ::rtl::OUString sRightTarget = sTargetName;
    if (sRightTarget==SPECIALTARGET_DEFAULT)
    {
        // a1) return already loaded document
        xTarget = ComponentLoader::findAndActivateAlreadyLoadedTask(xFactory,aURL,aDescriptor);
        if (xTarget.is())
            return ComponentLoader::getFrameComponent(xTarget);
        // a2) try to find recycle task
        xTarget = ComponentLoader::findAndActivateAlreadyLoadedTask(xFactory,aURL,aDescriptor);
        if (xTarget.is())
            return ComponentLoader::getFrameComponent(xTarget);
        // a3) reset target name to _blank for following findFrame() call!
        sRightTarget = SPECIALTARGET_BLANK;
    }

    // b) may be we doesn't found a task for recycling or doesn't tried it.
    //    Or we doesn't created a new one before ...
    //    Then we must use normal API call findFrame() to find the right target.
    xTarget = xOwner->findFrame(sRightTarget,nSearchFlags);

    // normaly not possible ... but we should check it
    if ( ! xTarget.is() )
        return css::uno::Reference< css::lang::XComponent >();

    // now - load it realy :-)
    // All neccessary things are done by this helper
    // It loads the document into the target frame,
    // listen for possible results,
    // uses interaction,
    // disable UI by setting right parameters inside the descriptor
    // throw and IO Exception if neccessary
    // return the component, which was loaded.
    css::uno::Reference< css::lang::XComponent > xDocument = ComponentLoader::loadItIntoFrame(xFactory,aURL,aDescriptor,xTarget);

    // But dont forget to initialize the frame after loading.
    // means: make it visible, set the title ...
    ComponentLoader::updateFrameAfterLoading(xFactory,xTarget,aDescriptor);
    return xDocument;
}

/*-****************************************************************************************************//**
    @interface  native
    @rights     private

    @short      it checks for right parameters for loadComponentFromURL() call
    @descr      We must check the incoming parameter of the interface request. In case
                we found any invalid parameter we throw the IllegalArgumentException.
                The original interface request should pass this exception due to he original caller.

	@attention	In case we throw an exception inside the following lines of code ... it's not a good idea
				to do it without a valid reference to ourself!
				See this example, to know what can occure:
				<pre>
				XComponent Frame::loadComponentFromURL(...)
				{
					// => we are used as native c++ object and nobody hold an UNO reference to us!
					ComponentLoader aLoader(..);
					aLoader.loadComponentFromURL(..);
				}
				...
				void ComponentLoader::impl_checkLoadParameters(...)
				{
					...
					// => here we set ourself as source of this thrown exception
					// And following will happen: UNO tries to get a reference to us and calls aquire().
					//                            But then they call release to the same reference and
					//                            we die immediatly. Following code (e.g. inside ComponentLoader::loadComponentFromURL(),
					//                            which calls this impl method runs into already deleted memory structures.
			        throw css::lang::IllegalArgumentException( ..., static_cast< ::cppu::OWeakObject* >(this), ... );
					...
				}
				<pre>

				What can we do?
				a) Our user has to use us by reference and not as native c++ object.
				b) We can hold us alive by ourself - using a temp. reference to ourself.
				Because a) can be forgoten by the outside code - we use b) as fallback here too.
				And we should do that inside our own loadComponentFrpmURL() method too.

    @threadsafe not neccessary - we don't use internal member here
    @modified   02.07.2002 13:42, as96863
*//*-*****************************************************************************************************/
void ComponentLoader::impl_checkLoadParameters( const ::rtl::OUString&  sURL         ,
                                                const ::rtl::OUString&  sTargetName  ,
                                                      sal_Int32         nSearchFlags ,
                                                const ArgumentAnalyzer& rDescriptor  ) throw (css::lang::IllegalArgumentException)
{
	// see "Attention" mark before!
	css::uno::Reference< css::uno::XInterface > xThis(static_cast< ::cppu::OWeakObject* >(this),css::uno::UNO_QUERY);

    // check for valid URL
	// We can't work with an empty URL.
	// In case the stream property of the argument list should be used, the URL must be set to "private:stream".
	// Further we don't work for some protocols in general. (e.g. slot, uno, macro)
    ::rtl::OUString sCheckURL = sURL.toAsciiLowerCase();
    if(
        ( sCheckURL.getLength() <  1                                     ) ||
        ( ProtocolCheck::isProtocol(sCheckURL,ProtocolCheck::E_UNO     ) ) ||
        ( ProtocolCheck::isProtocol(sCheckURL,ProtocolCheck::E_SLOT    ) ) ||
        ( ProtocolCheck::isProtocol(sCheckURL,ProtocolCheck::E_MACRO   ) ) ||
        ( ProtocolCheck::isProtocol(sCheckURL,ProtocolCheck::E_SERVICE ) ) ||
        ( ProtocolCheck::isProtocol(sCheckURL,ProtocolCheck::E_MAILTO  ) ) ||
        ( ProtocolCheck::isProtocol(sCheckURL,ProtocolCheck::E_NEWS    ) )
      )
    {
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("Not a valid or supported URL."), xThis, 1 );
    }

    // check for right target name
    if ( ! TargetCheck::isValidTarget(sTargetName) )
    {
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("Not a valid target name."), xThis, 2 );
    }

    // check for right flags
    // We accept combinations of defined flags only.
    // Note: a) ALL and GLOBAL are already combinations of some of following queried flags!
    //       b) AUTO can't be supported - it's not a valid combination ...
    //       c) Flags are optional - They wont be used if target is a special one. Check it too!
    //          Special targets starts with a '_' everytime.
    if (
        ( ! TargetCheck::isSpecialTarget(sTargetName)                                                 )  &&
        (nSearchFlags & css::frame::FrameSearchFlag::PARENT   != css::frame::FrameSearchFlag::PARENT  )  &&
        (nSearchFlags & css::frame::FrameSearchFlag::SELF     != css::frame::FrameSearchFlag::SELF    )  &&
        (nSearchFlags & css::frame::FrameSearchFlag::CHILDREN != css::frame::FrameSearchFlag::CHILDREN)  &&
        (nSearchFlags & css::frame::FrameSearchFlag::CREATE   != css::frame::FrameSearchFlag::CREATE  )  &&
        (nSearchFlags & css::frame::FrameSearchFlag::SIBLINGS != css::frame::FrameSearchFlag::SIBLINGS)  &&
        (nSearchFlags & css::frame::FrameSearchFlag::TASKS    != css::frame::FrameSearchFlag::TASKS   )
       )
    {
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("Not a valid flag combination."), xThis, 3 );
    }

    // check for a valid argument list
    if ( ! rDescriptor.isValid())
    {
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("Not a valid argument list."), xThis, 4 );
    }
}

/*-************************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      try to load given URL into the target frame
    @descr      We try to find any registered frame loader and create it. If it was successfully - we start loading of URL.
                It could be synchron or asynchron (depends from created loader service and his supported interfaces ...
                We prefer a synchronous loading!) For asynchronoues mode we will be a listener.
                But we don't support more the one actions at the same time. You have to use multiple instances of this class
                for more then one load request.

    @param      xFactory
                    reference to service manager to create neccessary services

    @param      aURL
                    URL which should be loaded

    @param      lDescriptor
                    optional description for this URL

    @param      xTarget
                    target of load operation

    @return     [XComponent]
                    will be a valid reference to the loaded document, if loading was succesfully
                    or <NULL/> if load failed.

    @throw      css::io::IOException
                    in case we found out, that our internal interaction was used and
                    any reason for an io error could be found.

    @threadsafe yes
    @modified   04.07.2002 15:44, as96863
*//*-*************************************************************************************************************/
css::uno::Reference< css::lang::XComponent > ComponentLoader::loadItIntoFrame( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                                                               const css::util::URL&                                         aURL        ,
                                                                                     ArgumentAnalyzer&                                       rDescriptor ,
                                                                               const css::uno::Reference< css::frame::XFrame >&              xTarget     ) throw(css::io::IOException)
{
    // extract the type name from the descriptor and search for a valid
    // frame loader
    ::rtl::OUString sTypeName;
    rDescriptor.getArgument(E_TYPENAME,sTypeName);

    if (sTypeName.getLength()<1)
        return css::uno::Reference< css::lang::XComponent >();

    FilterCache               aCacheRef;
    CheckedStringListIterator pIterator;
    ::rtl::OUString           sLoader  ;
    pIterator.reset();
    if (
        ! aCacheRef.searchLoaderForType(sTypeName,pIterator,sLoader) ||
        ! aCacheRef.existsLoader(sLoader)
       )
    {
        return css::uno::Reference< css::lang::XComponent >();
    }

    // create the loader and use it.
    // Detect his supported interfaces and prefer the synchronous version.
    css::uno::Reference< css::uno::XInterface >                 xLoader     ( xFactory->createInstance(sLoader), css::uno::UNO_QUERY );
    css::uno::Reference< css::frame::XSynchronousFrameLoader >  xSyncLoader ( xLoader                          , css::uno::UNO_QUERY );
    css::uno::Reference< css::frame::XFrameLoader >             xAsyncLoader( xLoader                          , css::uno::UNO_QUERY );

    if (
        ! xSyncLoader.is() &&
        ! xAsyncLoader.is()
       )
    {
        return css::uno::Reference< css::lang::XComponent >();
    }

    // OK - at this point we have a valid frame for loading the document
    // and know the type and may be the filter which should be used.
    // Now it's time to modify the MedirDescriptor
    // E.g.; to influence macro execution mode
    if ( ! rDescriptor.existArgument( E_MACROEXECUTIONMODE ) )
        rDescriptor.setArgument( E_MACROEXECUTIONMODE, css::document::MacroExecMode::NEVER_EXECUTE );
    if ( ! rDescriptor.existArgument( E_UPDATEDOCMODE ) )
        rDescriptor.setArgument( E_UPDATEDOCMODE, css::document::UpdateDocMode::NO_UPDATE );

    // We use a special object to handle possible interactions during next load call.
    // But we supress it if an outside item is already set inside the descriptor.
    // This interaction doesn't show any UI or solve conflicts realy (expecting some
    // are solveable without an UI!). Most of requests will be aborted only.
    RestrictedUIInteraction* pDefaultInteraction = NULL;
    if ( ! rDescriptor.existArgument( E_INTERACTIONHANDLER ) )
    {
        pDefaultInteraction = new RestrictedUIInteraction(xFactory);
		css::uno::Reference< css::task::XInteractionHandler > xInteraction( static_cast< ::cppu::OWeakObject* >(pDefaultInteraction), css::uno::UNO_QUERY );
        rDescriptor.setArgument( E_INTERACTIONHANDLER, xInteraction);
    }

    // Don't forget to lock task for following load process. Otherwise they could die during this operation by
    // terminating office or closing of this task by using api.
    // If we set this lock "close()" will return false and closing will be broken.
    // Attention: Don't forget to reset this lock again after finishing operation. Otherwise task couldn't die!!!
    css::uno::Reference< css::document::XActionLockable > xLock( xTarget, css::uno::UNO_QUERY );
    if (xLock.is())
        xLock->addActionLock();

    // ... prefer synchron loading!
    ELoadState eState = E_UNSPECIFIED;

    if (xSyncLoader.is())
    {
        if (xSyncLoader->load(rDescriptor.getArgumentsConst(),xTarget))
            eState = E_SUCCESS;
        else
            eState = E_FAILED;
    }
    else
    // ... or use old asynchron mechanism :-(
    if (xAsyncLoader.is())
    {
        // Use special listener and a special load thread to do so.
        // We wait for finishing the thread - the thread wait for the listener - and the listener wait for te use async loader.
		LoadEventListener* pListener = new LoadEventListener;
        css::uno::Reference < css::frame::XLoadEventListener > aLoadListener( pListener );

		xAsyncLoader->load( xTarget, aURL.Complete, rDescriptor.getArgumentsConst(), aLoadListener );

		while ( pListener->getState() != E_SUCCESS && pListener->getState() != E_FAILED )
			Application::Yield();

        // Now the load request should be finished realy.
        // Now we can look for the state of the operation.
        // It's available at the used listener object.
        eState = pListener->getState();
    }

    // react for all possible detected load states
    // But may we must correct it first.
    // e.g. interaction was used and we must switch from error state FAILED to INTERACTION
    css::uno::Reference< css::lang::XComponent > xComponent;
    ::rtl::OUString                              sIOError  ;

    if (
        (eState              == E_FAILED)   &&
        (pDefaultInteraction != NULL    )   &&
        (pDefaultInteraction->wasUsed() )
       )
    {
        if (LoadStateHelper::wasIOError(pDefaultInteraction->getRequest(),sIOError))
            eState = E_IOERROR;
        else
            eState = E_INTERACTION;
    }

    // Don't use the default interaction outside this method!
    // Delete it again. Don't delete the pointer here.
    // Releasing of the reference inside the descriptor will do that automaticly.
    // Set it to NULL only!
    if (pDefaultInteraction)
    {
        rDescriptor.deleteArgument(E_INTERACTIONHANDLER);
        pDefaultInteraction = NULL;
    }

    switch( eState )
    {
        case E_SUCCESS :
                xComponent = ComponentLoader::getFrameComponent(xTarget);
                break;

        case E_IOERROR :
                // Must be done here explicitly. Because the normal resetLock() call
                // won't be reached. Because we throw an exception here!
                if (xLock.is())
                    xLock->resetActionLocks();
                throw css::io::IOException( sIOError, css::uno::Reference< css::uno::XInterface >() );
                break;

        case E_FAILED :
        case E_INTERACTION :
                xComponent = css::uno::Reference< css::lang::XComponent >();
                break;
    }

    // Don't forget it - otherwhise this task live for ever.
    if (xLock.is())
        xLock->resetActionLocks();

    return xComponent;
}

/*-****************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      make a type detection and look for matching type and filter entries inside the descriptor
    @descr      Forst we make a type detection here. User can allow it deep or not. After that
                we search for any valid filter for this type. But it's not a reason to return this method
                with <FALSE/> if no one can be found. Because we have a type info. May it's not a component -
                its a content which doesn't need any filter or frame loader!

    @param      xFactory
                    neccessary to create services for internal use

    @param      aURL
                    URL which should be checked
                    We set it on the descriptor too, if it's not already a part of it!

    @param      lDescriptor
                    the MediaDescriptor we will change to return the required informations

    @param      bDeep
                    it regulate the used type detection
                    <TRUE/>  => we look into the stream
                    <FALSE/> => we use the URL and the configuration only

    @return     <TRUE/> if detection was successfully
                <FALSE/> if not.
                Only if no type information will be available or a detected filter doesn't match
                to a well known type, we return <FALSE/>.

    @threadsafe not neccessary - we don't use internal member here, it's a static method
    @modified   03.07.2002 14:00, as96863
*//*-*****************************************************************************************************/
sal_Bool ComponentLoader::detectTypeAndFilter( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                               const css::util::URL&                                         aURL        ,
                                                     ArgumentAnalyzer&                                       rDescriptor ,
                                                     sal_Bool                                                bDeep       )
{
    // be shure that the URL is part of the given descriptor in any case
    // It's neccessary for following detection. In case the external code whish
    // to detect based on the stream inside the descriptor the URL must be
    // a special one named "private:stream"
    if ( ! rDescriptor.existArgument(E_URL) )
        rDescriptor.setArgument(E_URL,aURL);

    // make a type detection based on given URL and MediaDescriptor first
    css::uno::Reference< css::document::XTypeDetection > xDetection( xFactory->createInstance(SERVICENAME_TYPEDETECTION), css::uno::UNO_QUERY );
    if ( ! xDetection.is() )
    {
        rDescriptor.deleteArgument(E_TYPENAME  );
        rDescriptor.deleteArgument(E_FILTERNAME);
        return sal_False;
    }

    // We have to react for some interaction requests during detection too!
    // May we found some ambihous filter during detection ...
    // Use a still interaction (without any UI). But don't overwrite external
    // interaction objects!
    css::uno::Reference< css::task::XInteractionHandler > xDefaultInteraction;
    if ( ! rDescriptor.existArgument( E_INTERACTIONHANDLER ) )
    {
        RestrictedUIInteraction* pDefaultInteraction = new RestrictedUIInteraction(xFactory);
                                 xDefaultInteraction = css::uno::Reference< css::task::XInteractionHandler >(static_cast< css::task::XInteractionHandler* >(pDefaultInteraction), css::uno::UNO_QUERY);
        rDescriptor.setArgument( E_INTERACTIONHANDLER, xDefaultInteraction );
    }

    // get copy(!) of the descriptor, which is wrapped inside the ArgumentAnalyzer!
    // But don't forget to restore it after finishing the detection operation.
    // May be the following code need the actualized version ...
    // The reason: the name say it ... getArgumentsAndRest() is a reset too!
    css::uno::Sequence< css::beans::PropertyValue > lDescriptor = rDescriptor.getArgumentsAndReset();
    ::rtl::OUString                                 sTypeName   ;
    try
    {
        sTypeName = xDetection->queryTypeByDescriptor(lDescriptor,bDeep);
    }
    catch( css::lang::WrappedTargetRuntimeException& )
    {
        sTypeName = ::rtl::OUString();
    }
    rDescriptor.setArguments(lDescriptor);

    // Attention: It's important to delete an own interaction object!
    // Because it was used to make an interaction without some special UI for special cases only.
    // But the outside code doesn't need such feature. And of course he wouldn't overwrite already
    // existing handlers inside the descriptor too. So we MUST delete it after using.
    if (xDefaultInteraction.is())
    {
        rDescriptor.deleteArgument(E_INTERACTIONHANDLER);
        xDefaultInteraction = css::uno::Reference< css::task::XInteractionHandler >();
    }

    // If detection failed - we can return here .
    // But we should actualize the descriptor.
    if (sTypeName.getLength()<1)
    {
        rDescriptor.deleteArgument(E_TYPENAME  );
        rDescriptor.deleteArgument(E_FILTERNAME);
        return sal_False;
    }

    // now there should be some setted values insid the descriptor
    // Search for it
    // But set the already well nown type there - may he wasn't added to the descriptor
    // or doesn't match the return value ...
    ::rtl::OUString sFilterName;
    rDescriptor.setArgument(E_TYPENAME  ,sTypeName  );
    rDescriptor.getArgument(E_FILTERNAME,sFilterName);

    // may the type is well known now -
    // but it's not guaranteed for the filter
    // Because the type detection can offer a possible filter
    // but it's not a must.
    // We set the preferred filter if no one is set.
    if (sFilterName.getLength()<1)
    {
        CheckedStringListIterator pIterator;
        FilterCache().searchFilterForType(sTypeName,pIterator,sFilterName);
    }

    if (sFilterName.getLength()<1)
        // Note: An unknown filter is no problem!
        // Because we have a type info. May it's not a component
        // its a content which doesn't need any filter or frame loader!
        rDescriptor.deleteArgument(E_FILTERNAME);
    else
    {
        // check for correct combinations!
        FilterCache aCacheRef;
        if (aCacheRef.existsFilter(sFilterName))
        {
            // Add the possible filter ...
            rDescriptor.setArgument(E_FILTERNAME,sFilterName);
            if (aCacheRef.getFilter(sFilterName).sType != sTypeName)
            {
                // ... but delete the type and the filter if the can't be combined.
                // The result of such combination isn't guaranteed!
                rDescriptor.deleteArgument(E_TYPENAME  );
                rDescriptor.deleteArgument(E_FILTERNAME);
                return sal_False;
            }
        }
    }

    // We returned with false on error states before. Now it's time
    // to return with success!
    return sal_True;
}

/*-****************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      helper to check if given URL is a content or not
    @descr      It checks if the given URL represent a content. Please note - it's not
                the same as a component. E.g. sounds are contents which doesn't require a frame
                as container ... but e.g. text documents are components which need that.
                So isContent() isn't so specialized then isComponent()!

    @seealso    isComponent()

    @param      xFactory
                    reference to the uno service manager to be able to create neccessary services

    @param      sURL
                    the URL which should be checked

    @return     <TRUE/> if URL represent a content
                <FALSE/> otherwhise

    @threadsafe not neccessary - it's static and works on given parameters only
    @modified   07.08.2002 14:41, as96863
*//*-*****************************************************************************************************/
sal_Bool ComponentLoader::isContent( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory ,
                                     const ::rtl::OUString&                                        sURL     )
{
    // (a) filter some special well known protocols, which are not loadable in general
    //     Of course an empty URL must be ignored here too.
    if(
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_UNO    ) )   ||
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_SLOT   ) )   ||
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_MACRO  ) )   ||
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_SERVICE) )   ||
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_MAILTO ) )   ||
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_NEWS   ) )
      )
    {
        return sal_False;
    }

    // (b) some special URLs indicates a given input stream or used to open an empty document
	//     they should be loadable in general
    if (
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_PRIVATE_STREAM  ) )   ||
        ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_PRIVATE_FACTORY ) )
	   )
	{
        return sal_True;
	}

	sal_Bool bContent = sal_False;

    // (c) an UCB provide loadable contents only
    css::uno::Reference< css::ucb::XContentProviderManager > xUCB( xFactory->createInstance(SERVICENAME_UCBCONTENTBROKER), css::uno::UNO_QUERY );
    if (xUCB.is())
        bContent = xUCB->queryContentProvider(sURL).is();

    // (d) if we can detect a type for given URL - it must be loadable too
    //     Don't allow deep detection here - it can be to expensive!
	if ( ! bContent)
	{
		css::uno::Reference< css::document::XTypeDetection > xDetection( xFactory->createInstance(SERVICENAME_TYPEDETECTION), css::uno::UNO_QUERY );
		if (xDetection.is())
            bContent = (xDetection->queryTypeByURL(sURL).getLength()>0);
	}

    return bContent;
}

/*-****************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      helper to check if given URL is a component or not
    @descr      It checks if the given URL represent a component. Please note - it's not
                the same as a content. E.g. sounds are contents which doesn't require a frame
                as container ... but e.g. text documents are components which need that.
                So isComponent() is more special then isContent()!

    @seealso    isContent()

    @param      xFactory
                    reference to the uno service manager to be able to create neccessary services

    @param      sURL
                    the URL which should be checked

    @param      lDescriptor
                    optional description for this URL
                    Will be used to search for set type or filter names, which can help.

    @return     <TRUE/> if URL represent a component
                <FALSE/> otherwhise

    @threadsafe not neccessary - it's static and works on given parameters only
    @modified   03.07.2002 13:31, as96863
*//*-*****************************************************************************************************/
sal_Bool ComponentLoader::isComponent( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                       const ::rtl::OUString&                                        sURL        ,
                                             ArgumentAnalyzer&                                       rDescriptor )
{
    // of course a component must represent a content
    if ( ! ComponentLoader::isContent(xFactory,sURL) )
        return sal_False;

    // but it needs more then that
    // For real contents (which doesn't need any frame as target)
    // we know: a type - a filter - a content handler - but no frame loader or frame loader
    // So we should try to find a registered content handler.
    // If we found someone we can say: it's a content only.
    // If not - we can say it should be a component.

	// Attention: There exist one exception from this rule.
	// Loading from a stream. Such type isn't detectable using a flat detection.
	// But it uses a special url then.
    if ( ProtocolCheck::isProtocol(sURL,ProtocolCheck::E_PRIVATE_STREAM) )
        return sal_True;

    FilterCache               aCacheRef      ;
    CheckedStringListIterator pIterator      ;
    ::rtl::OUString           sTypeName      ;
    ::rtl::OUString           sContentHandler;

    if ( ! rDescriptor.existArgument(E_TYPENAME) )
	{
		css::uno::Reference< css::document::XTypeDetection > xDetection( xFactory->createInstance(SERVICENAME_TYPEDETECTION), css::uno::UNO_QUERY );
		if (xDetection.is())
            sTypeName = xDetection->queryTypeByURL(sURL);
		if (sTypeName.getLength()>0)
            rDescriptor.setArgument(E_TYPENAME,sTypeName);
	}

	// no type -> no content -> no component
    if (sTypeName.getLength()<1)
        return sal_False;

	// if content handler -> is content -> but no component
    pIterator.reset();
    if (aCacheRef.searchContentHandlerForType(sTypeName,pIterator,sContentHandler))
        return sal_False;

	// component!
    return sal_True;
}

/*-************************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      return the component of the given frame
    @descr      A component can be:
                    a) a window for pure previews
                    b) or a controller for more reach ones
                    c) or a full featured component - a model
                We analyze the given frame to return the right object.

    @param      xFrame
                    reference to valid frame in hierarchy
                    <NULL/> will be checked too and return <NULL/> as result too.

    @return     A reference to found component or <NULL/> if frame is not valid or empty.

    @threadsafe yes
    @modified   03.07.2002 10:14, as96863
*//*-*************************************************************************************************************/
css::uno::Reference< css::lang::XComponent > ComponentLoader::getFrameComponent( const css::uno::Reference< css::frame::XFrame >& xFrame )
{
    // no frame -> no component
    if ( ! xFrame.is() )
        return css::uno::Reference< css::lang::XComponent >();

    css::uno::Reference< css::frame::XController > xController = xFrame->getController();
    if ( ! xController.is() )
    {
        // no controller -> no model
        // but may a window
        // don try any other solutions - they doesn't exist
        // Return the window - may it's null
        return css::uno::Reference< css::lang::XComponent >( xFrame->getComponentWindow(), css::uno::UNO_QUERY );
    }

    // controller exist -> may be a model too ?
    // If not - it must be the controller.
    css::uno::Reference< css::frame::XModel > xModel = xController->getModel();
    if (xModel.is())
        return css::uno::Reference< css::lang::XComponent >( xModel, css::uno::UNO_QUERY );
    else
        return css::uno::Reference< css::lang::XComponent >( xController, css::uno::UNO_QUERY );

    // no controller - no window - no model -> no chance
    return css::uno::Reference< css::lang::XComponent >();
}

/*-************************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      it tries to specify in which application module the given URL normaly would be loaded
    @descr      Sometimes we need the information which module this URL can handle. Of course the result
                can't be guaranteed. But for some features (e.g. recycling of empty tasks) it's enough.
                We make a flat type and filter detection only here to find out which document service
                should be usable. Of course we use an optional MedaDescriptor too, to check for preselected
                values.

    @attention  It's not a good idea to add e.g. the type or filter information to the descriptor.
                Because we make a flat detection only, which can't guarantee 100% correct results.
                But if we add this informations to the descriptor, may an additional realy deep type
                detection use our set values as preselected ones and will be forwarded into the rong direction ...

    @param      xFactory
                    we use it internaly to create own services if neccessary

    @param      aURL
                    URL which should be checked

    @param      lDescriptor
                    the optional MediaDescriptor which provide more informations, which may can help
                    to find right information

    @return     The found document service name or and empty value if search failed.

    @threadsafe not neccessary - its a static operation
    @modified   03.07.2002 08:42, as96863
*//*-*************************************************************************************************************/
::rtl::OUString ComponentLoader::specifyDocServiceByURL( const css::uno::Reference< css::lang::XMultiServiceFactory > xFactory    ,
                                                         const css::util::URL&                                        aURL        ,
                                                               ArgumentAnalyzer&                                      rDescriptor )
{
    ::rtl::OUString sTypeName  ;
    ::rtl::OUString sFilterName;

    // try to find any preselected values
    rDescriptor.getArgument( E_TYPENAME  , sTypeName   );
    rDescriptor.getArgument( E_FILTERNAME, sFilterName );

    // if we find a preselected filter - we can use it to ask for his document service property
    if (sFilterName.getLength()>0 )
    {
        FilterCache aCacheRef;
        if (aCacheRef.existsFilter(sFilterName))
            return aCacheRef.getFilter(sFilterName).sDocumentService;
    }

    // if we have no preselected filter - we must detect the type
    // ... search for the preferred filter for this type
    // ... and ask for his document service property
    if (sTypeName.getLength()<1)
    {
        // try to find the prefered type for this URL
        css::uno::Reference< css::document::XTypeDetection > xDetection( xFactory->createInstance(SERVICENAME_TYPEDETECTION), css::uno::UNO_QUERY );
        if (xDetection.is())
            sTypeName = xDetection->queryTypeByURL(aURL.Complete);
    }

    // try to find the prefered (not the default!) filter for the detected or preselected type
    // (don't move this code to the scope before .. because here we use the possible detected
    // type of t his scopt. But in case a type was preselected we reach this point and type detection
    // was not neccessary!
    if (sTypeName.getLength()>0)
    {
        CheckedStringListIterator aIterator;
        FilterCache().searchFilterForType(sTypeName,aIterator,sFilterName);

        if (sFilterName.getLength()>0 )
        {
            FilterCache aCacheRef;
            if (aCacheRef.existsFilter(sFilterName))
                return aCacheRef.getFilter(sFilterName).sDocumentService;
        }
    }

    return ::rtl::OUString();
}

/*-************************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      it tries to specify which application module the given document model match
    @descr      This information can be used then to implement the feature "recycle a non modified task".
                We use the interface XServiceInfo of the given document reference to find out
                which module it represent. If this way doesnt give us the needed information we try
                some other ways too. (e.g. to use a model and ask for his URL or filter).

    @param      xFactory
                    we use it internaly to create own services if neccessary

    @param      xDocument
                    the document which should be detected
                    We accept <NULL/> here - because it's easy to check it here instead in the outside code.
                    So this method can be used with return values of other interface methods without
                    using temp. variables explicitly! e.g. XFrame->getController()

    @return     The found document service name or and empty value if search failed.

    @threadsafe not neccessary - its a static operation
    @modified   03.07.2002 09:32, as96863
*//*-*************************************************************************************************************/
::rtl::OUString ComponentLoader::specifyDocServiceByDocument( const css::uno::Reference< css::lang::XMultiServiceFactory > xFactory  ,
                                                              const css::uno::Reference< css::frame::XController >&        xDocument )
{
    if ( ! xDocument.is() )
        return ::rtl::OUString();

    // first try to use the interface XServiceInfo
    css::uno::Reference< css::lang::XServiceInfo > xInfo( xDocument, css::uno::UNO_QUERY );
    if (xInfo.is())
    {
        if (xInfo->supportsService(DOCSERVICE_WRITER))
            return DOCSERVICE_WRITER;
        if (xInfo->supportsService(DOCSERVICE_WRITERWEB))
            return DOCSERVICE_WRITERWEB;
        if (xInfo->supportsService(DOCSERVICE_WRITERGLOBAL))
            return DOCSERVICE_WRITERGLOBAL;
        if (xInfo->supportsService(DOCSERVICE_CALC))
            return DOCSERVICE_CALC;
        if (xInfo->supportsService(DOCSERVICE_DRAW))
            return DOCSERVICE_DRAW;
        if (xInfo->supportsService(DOCSERVICE_IMPRESS))
            return DOCSERVICE_IMPRESS;
        if (xInfo->supportsService(DOCSERVICE_MATH))
            return DOCSERVICE_MATH;
        if (xInfo->supportsService(DOCSERVICE_CHART))
            return DOCSERVICE_CHART;
    }

    // OK - XServiceInfo wasn't available at this document or
    // doesn't support the right factory.
    // Try to find an URL or filter name to use it.
    // But this informations are available on a model only.
    // Pure windows or controllers can't be used for that.
    css::uno::Reference< css::frame::XModel > xModel( xDocument->getModel(), css::uno::UNO_QUERY );
    if (xModel.is())
    {
        // All this needed informations are available at the original MediaDescriptor of the model
        ArgumentAnalyzer aDescriptor (xModel->getArgs(),sal_True);
        ::rtl::OUString  sFilterName ;
        ::rtl::OUString  sURL        ;

        // try filter name first
        if (aDescriptor.getArgument(E_FILTERNAME, sFilterName))
        {
            FilterCache aCacheRef;
            if (aCacheRef.existsFilter(sFilterName))
                return aCacheRef.getFilter(sFilterName).sDocumentService;
        }

        // try URL of then
        sURL = xModel->getURL();
        if (sURL.getLength()>0)
        {
            css::uno::Reference< css::util::XURLTransformer > xParser( xFactory->createInstance(SERVICENAME_URLTRANSFORMER), css::uno::UNO_QUERY );
            if (xParser.is())
            {
                css::util::URL  aURL;
                aURL.Complete = sURL;
                xParser->parseStrict(aURL);
                return ComponentLoader::specifyDocServiceByURL(xFactory,aURL,aDescriptor);
            }
        }
    }

    // no chance ...
    return ::rtl::OUString();
}

/*-************************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      Tries to find frame that has already loaded the document specified by URL.
    @descr      We search on our desktop container to find any task, which has already loaded
                given URL. If we found anyone we try to set focus on it to bring it to front.
                But dont do it in special cases ... like: - hidden loaded documents
                                                          - loaded from template
                                                          - second view of a document ...

    @param      xFactory
                    we use it internaly to create own services if neccessary

    @param      aURL
                    URL we try to find as already loaded

    @param      lDescriptor
                    the optional MediaDescriptor which provide more informations, which may can help
                    to find right task

    @return     The found task, which was activated or <NULL/> if search was failed.

    @threadsafe not neccessary - its a static operation
    @modified   02.07.2002 14:18, as96863
*//*-*************************************************************************************************************/
css::uno::Reference< css::frame::XFrame > ComponentLoader::findAndActivateAlreadyLoadedTask( const css::uno::Reference< css::lang::XMultiServiceFactory > xFactory    ,
                                                                                             const css::util::URL&                                        aURL        ,
                                                                                                   ArgumentAnalyzer&                                      rDescriptor )
{
    // break search if new load proccess is a special request!
    sal_Bool bSet;
    if(
        ( rDescriptor.getArgument( E_ASTEMPLATE , bSet ) && bSet )    ||
        ( rDescriptor.getArgument( E_HIDDEN     , bSet ) && bSet )    ||
        ( rDescriptor.getArgument( E_OPENNEWVIEW, bSet ) && bSet )
      )
    {
        return css::uno::Reference< css::frame::XFrame >();
    }

    // otherwhise - iterate through the tasks of the desktop container
    css::uno::Reference< css::frame::XFramesSupplier > xSupplier( xFactory->createInstance(SERVICENAME_DESKTOP), css::uno::UNO_QUERY );
    if ( ! xSupplier.is() )
        return css::uno::Reference< css::frame::XFrame >();

    css::uno::Reference< css::container::XIndexAccess > xTaskList( xSupplier->getFrames(), css::uno::UNO_QUERY );
    if ( ! xTaskList.is() )
        return css::uno::Reference< css::frame::XFrame >();

    sal_Int32 nCount      = xTaskList->getCount();
    sal_Int16 nNewVersion = 0;
    rDescriptor.getArgument( E_VERSION, nNewVersion );

    for( sal_Int32 i=0; i<nCount; ++i )
    {
        css::uno::Reference< css::frame::XFrame > xTask    ;
        css::uno::Any                             aElement = xTaskList->getByIndex(i);
        if ( !(aElement>>=xTask) || !xTask.is() )
            continue;

        css::uno::Reference< css::frame::XController > xController  ;
        css::uno::Reference< css::frame::XModel >      xModel       ;

        if (xTask.is())
            xController = xTask->getController();

        if (xController.is())
			xModel = xController->getModel();

        // Without a model - we have no chance to decide if it contains the searched document or not
        if ( ! xModel.is() )
            continue;

        // don't check the complete URL here - ignore optional jumpmarks!
        if (aURL.Main==xModel->getURL())
        {
            // OK - it seams we have the right task. But we should ignore hidden ones
            // and documents in another version then the required one.
            sal_Bool  bHidden     = sal_False;
            sal_Int32 nOldVersion = 0;

            // Analyze old arguments of the already loaded document too.
            // We must know, if it was a preview or hidden load before.
            // Don't set this model descriptor on the incoming rDescriptor parameter!
            ArgumentAnalyzer aOldArgs(xModel->getArgs(),sal_True);

            aOldArgs.getArgument( E_HIDDEN , bHidden     );
            aOldArgs.getArgument( E_VERSION, nOldVersion );

            if ( ! bHidden && nNewVersion==nOldVersion )
            {
                // Now we are shure, that this task includes the searched document.
                // It's time to activate it. As special feature we try to jump internaly
                // if an optional jumpmark is given too.
				if(aURL.Mark.getLength()>0)
				{
                    css::uno::Reference< css::frame::XDispatchProvider > xProvider( xTask, css::uno::UNO_QUERY );
                    if (xProvider.is())
                    {
                        css::uno::Reference< css::frame::XDispatch > xDispatcher = xProvider->queryDispatch(aURL,SPECIALTARGET_SELF,0);
                        if (xDispatcher.is())
                            xDispatcher->dispatch(aURL,rDescriptor.getArgumentsConst());
                    }
				}

                css::uno::Reference< css::awt::XWindow >    xTaskWindow = xTask->getContainerWindow();
                css::uno::Reference< css::awt::XTopWindow > xTopWindow  ( xTaskWindow, css::uno::UNO_QUERY );
                if (xTopWindow.is())
				{
                    // W can show the window here - because the new request is not hidden.
                    // We checked it already ...
					xTaskWindow->setVisible( sal_True );
					xTopWindow->toFront();
				}

                // It doesn't matter if we was able to bring it to front.
                // But we have found such task and can return it as our result.
                return xTask;
            }
        }
    }

    // No chance. This document isn't loaded currently.
    // (Ok may it's loaded hidden - but then we have to ignore it!)
    return css::uno::Reference< css::frame::XFrame >();
}

/*-************************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      Tries to find frame that can be recycled
    @descr      If new URL use same factory like an current existing one - and these existing one
                isn't realy used yet - we can recylce the frame. We search on our desktop container to iterate
                over all current existing tasks ... but we should ignore it, if follow rules match:
                    - document use different factory
                    - document was modified
                    - document was/should be loaded hidden
                    - task already locked by another load process (!!! otherwise we recycle a recyled task again !!!)

    @param      xFactory
                    we use it internaly to create own services if neccessary

    @param      aURL
                    URL we try to find as already loaded

    @param      lDescriptor
                    the optional MediaDescriptor which provide more informations, which may can help
                    to find right task

    @return     The found task, which was found or <NULL/> if search was failed.

    @threadsafe not neccessary - its a static operation
    @modified   02.07.2002 14:40, as96863
*//*-*************************************************************************************************************/
css::uno::Reference< css::frame::XFrame > ComponentLoader::findAndLockRecycleTask( const css::uno::Reference< css::lang::XMultiServiceFactory > xFactory    ,
                                                                                   const css::util::URL&                                        aURL        ,
                                                                                         ArgumentAnalyzer&                                      rDescriptor )
{
    // break search if new load proccess is a special request!
    sal_Bool bValue = sal_False;
    if(
        ( rDescriptor.getArgument( E_ASTEMPLATE , bValue ) && bValue )    ||
        ( rDescriptor.getArgument( E_HIDDEN     , bValue ) && bValue )    ||
        ( rDescriptor.getArgument( E_OPENNEWVIEW, bValue ) && bValue )
      )
    {
        return css::uno::Reference< css::frame::XFrame >();
    }

    // try to find the current active frame
    // It's allowed to recylce this task only!
    css::uno::Reference< css::frame::XFramesSupplier > xSupplier( xFactory->createInstance(SERVICENAME_DESKTOP), css::uno::UNO_QUERY );
    if ( ! xSupplier.is() )
        return css::uno::Reference< css::frame::XFrame >();

    // try to find out which application modules (means document services)
    // are used by the old and the possible new document.
    css::uno::Reference< css::frame::XFrame >      xTask      = xSupplier->getActiveFrame();
    css::uno::Reference< css::frame::XController > xController;
    css::uno::Reference< css::frame::XModel >      xModel     ;
    if (xTask.is())
        xController = xTask->getController();

    ::rtl::OUString sNewDocService = ComponentLoader::specifyDocServiceByURL(xFactory,aURL,rDescriptor);
    ::rtl::OUString sOldDocService ;

    if (xController.is())
    {
        // We need the model some lines later ... but we ask for xController.is() here
        // So it's a good idea to get the model here too ...
        xModel         = xController->getModel();
        sOldDocService = ComponentLoader::specifyDocServiceByDocument(xFactory,xController);
    }

    // get some more informations
    // The old document must be unmodified or a new created one
    // Note: If the model doesn't provide an URL it indicates using of special URLs like "private:factory/*"!
    // Decide then if its possible to recyle this task or not.
    css::uno::Reference< css::util::XModifiable > xModifyCheck( xModel, css::uno::UNO_QUERY );
    sal_Bool bIsModified = (xModifyCheck.is() && xModifyCheck->isModified());

    if ( ! bIsModified                    &&
           xModel->getURL().getLength()<1 &&
           sOldDocService==sNewDocService
       )
    {
        // OK this task seams to be useable for recycling
        // But we should mark it as such - means set an action lock.
        // Otherwhise it would be used more then ones or will be destroyed
        // by a close() or terminate() request.
        // But if such lock already exist ... it means this task is used for
        // any other operation already. Don't use it then.
        css::uno::Reference< css::document::XActionLockable > xLockable( xTask, css::uno::UNO_QUERY );

        // OK - this task isn't lockable.
        // Nevertheless we should try it recycle it!
        if ( ! xLockable.is() )
            return xTask;

        // Otherwhise we have to look for any other existing lock.
        if ( ! xLockable->isActionLocked() )
        {
            xLockable->addActionLock();
            return xTask;
        }
    }

    // no task found which match the criteria
    return css::uno::Reference< css::frame::XFrame >();
}

/*-************************************************************************************************************//**
    @interface  static native
    @rights     public

    @short      update the frame after loading of a document init
    @descr      Such frame may must be made visible, or get his right title ...
                or in case the frame is empty, which indicates that the load request before was not successully,
                it must be closed. All these things are done by this helper method. Normaly they should be called
                directly after ComponentLoader::loadItIntoFrame(). We don't do it automaticly there - may be the user
                of that method whish to try loading another document into the same frame. Then it's not a good idea
                to have it deleted automaticly before!

                Note: Don't restore any window related states here. Because that's the part of the PersistentWindowState
                listener, which every frame (created by this framework code) has and which implement the feature
                "Persistent Task Window State"s.

    @param      xFactory
                    we use it internaly to create own services if neccessary

    @param      xFrame
                    the target frame, which was used for loading before and should be updated now

    @param      lDescriptor
                    the optional MediaDescriptor which provide more informations, which may can help
                    to find right task

    @return     The found task, which was found or <NULL/> if search was failed.

    @threadsafe not neccessary - its a static operation
    @modified   02.07.2002 14:40, as96863
*//*-*************************************************************************************************************/
void ComponentLoader::updateFrameAfterLoading( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                               const css::uno::Reference< css::frame::XFrame >&              xFrame      ,
                                                     ArgumentAnalyzer&                                       rDescriptor )
{
    if ( ! xFrame.is())
        return;

    // analyze the given frame first.
    // If it is empty - close it.
    // But be aware; may there are some listener, which has a veto for that ...
    // On the other side: Don't dispose it. Give registered listeners a chance.
    // May they have her own reasons to do so.

    // How we can know, that a frame is empty? He must contain a component window as minimum!
    css::uno::Reference< css::awt::XWindow > xComponentWindow = xFrame->getComponentWindow();
    if ( ! xComponentWindow.is())
    {
        try
        {
            // It's enough to close the frame (or dispose it in case it doesn't provide this way)
            // He will deregister itself at his parent. Otherwhise we have to much to do here.
            css::uno::Reference< css::util::XCloseable > xCloseable( xFrame, css::uno::UNO_QUERY );
            if (xCloseable.is())
                xCloseable->close(sal_True); // true => we deliver the owner ship to the code, which may raise a veto excepton ...
            else
            {
                css::uno::Reference< css::lang::XComponent > xDisposeable( xFrame, css::uno::UNO_QUERY );
                if (xDisposeable.is())
                    xDisposeable->dispose();
            }
        }
        catch(css::util::CloseVetoException&) {}
        catch(css::lang::DisposedException& ) {}
        // It doesn't matter, if we was able to close this frame or not.
        // We delivered the owner ship to the code, which raises the veto exception
        // and now we can forget this frame. We are not interested on it any longer.
        return;
    }

    // OK - this frame is a valid one and contains a document.
    // Then we should show him and set the right title.
    // But do it for real visible frames only. Not for hidden loaded ones.
    // And use the container window of the frane instead of the component window.
    // The reason: the component window is visible in general. But the container window - and
    // so the frame can control the state hidden or not!
    css::uno::Reference< css::awt::XWindow > xFrameWindow = xFrame->getContainerWindow();
    if ( ! xFrameWindow.is())
        return;

    // make it visible
    sal_Bool bHidden = sal_False;
    rDescriptor.getArgument(E_HIDDEN,bHidden);
    xFrameWindow->setVisible( !bHidden );

    // set the name of this frame
    // Attention: Two cases could occure.
    //  1) argument "FrameName" isn't available ...
    //  2) argument is an empty string(!?)
    // Both cases should be ignored! We must set valid names only.
    ::rtl::OUString sFrameName;
    if (
        rDescriptor.getArgument(E_FRAMENAME,sFrameName) &&
        sFrameName.getLength() > 0
       )
    {
        xFrame->setName(sFrameName);
    }
}

}	// namespace framework
