/*************************************************************************
 *
 *  $RCSfile: sdbstorage.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_SDBSTORAGE_HXX_
#include "sdbstorage.hxx"
#endif

#ifndef _FSYS_HXX //autogen
#include <tools/fsys.hxx>
#endif
#ifndef _SOT_STORINFO_HXX
#include <sot/storinfo.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STRING_HXX 
#include <tools/string.hxx>
#endif
#include <ctype.h>

#define	USERTYPENAME		USERTYPENAME_5
#define	USERTYPENAME_1		"Scotty"
#define	USERTYPENAME_2		"Lt. Ohura"
#define	USERTYPENAME_3		"Pille"
#define	USERTYPENAME_4		"Spock"
#define	USERTYPENAME_5		"Lt. Cmd. Data"

#define DIR					"Dir"
#define NAME_OFFSET			100

//.........................................................................
namespace dbi
{
//.........................................................................

	SvGlobalName aClassName(0x91B54A60, 0xC097, 0x11D0,
							0xAA, 0x75, 0x00, 0xA0, 0x24, 0x8A, 0xA7, 0xBC);

	//==============================================================================
	//= 
	//==============================================================================
	static SimpleStringHash(const ByteString& _rStr)
	{
		// This is a very ugly hash, I know (And, to make things worse, it's nearly senseless for unicode
		// strings ...).
		// But for compatibility reasons: Don't touch this!
		register const char* p = _rStr.GetBuffer();
		register sal_uInt32 nHash = 0;
		while (*p)
			nHash = (nHash << 1) + toupper(*((unsigned char*)p++));
		return nHash;
	}

	//==============================================================================
	//= SdbStorInfo
	//==============================================================================
	DBG_NAME(SdbStorInfo);
	//------------------------------------------------------------------------------
	SdbStorInfo::SdbStorInfo(SvStorage* pStor)
				:pImpl(pStor)
	{
		DBG_CTOR(SdbStorInfo,NULL);
		pImpl->AddRef();
	}

	//------------------------------------------------------------------------------
	SdbStorInfo::~SdbStorInfo()
	{
		DBG_DTOR(SdbStorInfo,NULL);
		pImpl->ReleaseRef();
	}

	//==============================================================================
	//= SdbStorageDir
	//==============================================================================
	//------------------------------------------------------------------------------
	SvStream& operator >> (SvStream &rStream, SdbStorageDir& rDir)
	{
		sal_uInt32	nKey;
		ByteString	aName;

		rStream.Seek(STREAM_SEEK_TO_END);	// steht etwas im Stream?

		if (rStream.Tell() < 4)
			return rStream;

		rStream.Seek(0);
		rStream.SetNumberFormatInt(NUMBERFORMAT_INT_LITTLEENDIAN);
		rStream.SetStreamCharSet(RTL_TEXTENCODING_MS_1252);
		rStream >> nKey;
		rStream.ReadByteString(aName);
		while (!rStream.IsEof() && rStream.GetError() == SVSTREAM_OK)
		{
			if (aName.Len())
				rDir.Insert(nKey, String(aName, gsl_getSystemTextEncoding()));
			else
				DBG_WARNING("operator>>(SvStream&, SdbStorageDir&) : reading an empty String !");
				// leere Verzeichnisnamen sollten nicht vorkommen
				// (das ist nur eine Warnung : es gab mal einen Bug, der im Storage wirklich leere Namen geschrieben hat, der ist
				// wech, aber die leeren Namen sind noch da ....)
			rStream >> nKey;
			rStream.ReadByteString(aName);
		}
		return rStream;
	}

	DBG_NAME(SdbStorageDir);
	//------------------------------------------------------------------------------
	SdbStorageDir::SdbStorageDir(SdbStorage& rStor)
		:rStorage(rStor)
		,pStream(NULL)
		,m_aPos(m_aNames.end())
	{
		DBG_CTOR(SdbStorageDir,NULL);
	}

	//------------------------------------------------------------------------------
	SdbStorageDir::~SdbStorageDir()
	{
		// geaendertes Verzeichnis schreiben
		if (pStream)
			pStream->ReleaseRef();
		DBG_DTOR(SdbStorageDir,NULL);
	}

	//------------------------------------------------------------------------------
	String SdbStorageDir::first()
	{
		m_aPos = m_aNames.begin();
		return next();
	}

	//------------------------------------------------------------------------------
	String SdbStorageDir::next()
	{
		String sReturn;
		if (m_aPos == m_aNames.end())
		{
			DBG_ERROR("SdbStorageDir::next: already reached the end!");
		}
		else
		{
			sReturn = m_aPos->second;
			++m_aPos;
		}
		return sReturn;
	}

	//------------------------------------------------------------------------------
	void SdbStorageDir::Insert(sal_uInt32 nKey, const String& rValue)
	{
		DBG_CHKTHIS(SdbStorageDir, NULL);
		DBG_ASSERT(rValue.Len(), "SdbStorageDir::Insert : invalid (empty) name !");
		DBG_ASSERT(m_aNames.end() == m_aNames.find(nKey), "FalscherKey");

		m_aNames[nKey] = rValue;
	}

	//------------------------------------------------------------------------------
	sal_uInt32 SdbStorageDir::GetKey(const String& rName) const
	{
		DBG_CHKTHIS(SdbStorageDir, NULL);

		// wenn ich schon einen Key fuer den String habe, returne ich lieber den, das ist 'korrekter'
		// (Szenario : man legt einen Eintrag <name> an, laesst sich dafuer einen Key ermitteln,
		// das wird aber nicht der Hashwert n, sondern n + 1 (weil n schon von irgend-
		// einem anderen Eintrag benutzt wird). Dann loescht man den Eintrag, der fuer n
		// verantwortlich ist, und fragt erneut nach dem Key von <name>. -> Jetzt wird n
		// geliefert, obwohl der zugehoerige Storage eigentlich n+1 ist.
		// Diese Zeilen hier verhindern das.)
		
		for	(	ConstMapInt2StringIterator aLoop = m_aNames.begin();
				aLoop != m_aNames.end();
				++aLoop
			)
		{
			if (rName == aLoop->second)
				return aLoop->first;
		}

		sal_uInt32 nKey = SimpleStringHash(ByteString(rName, gsl_getSystemTextEncoding()));

		ConstMapInt2StringIterator aExistent = m_aNames.find(nKey);
		while (m_aNames.end() != aExistent)
		{
			if (rName == aExistent->second)
				break;
			else
				++nKey;
			aExistent = m_aNames.find(nKey);
		}

		return nKey;
	}

	//------------------------------------------------------------------------------
	void SdbStorageDir::Remove(sal_uInt32 nKey)
	{
		DBG_CHKTHIS(SdbStorageDir, NULL);

		MapInt2StringIterator aExistent = m_aNames.find(nKey);
		DBG_ASSERT(m_aNames.end() == aExistent, "SdbStorageDir::Remove: invalid key!");

		if (m_aPos == aExistent)
			++m_aPos;

		m_aNames.erase(aExistent);
	}

	//------------------------------------------------------------------------------
	void SdbStorageDir::Init(SvStorageStream* pStr)
	{
		DBG_CHKTHIS(SdbStorageDir, NULL);

		pStream = pStr;
		pStream->SetBufferSize(1024);
		pStream->AddRef();
		(*pStream) >> (*this);

		rStorage.m_nStreamError = pStream->GetErrorCode();
		if (ERRCODE_NONE == rStorage.m_nStreamError)
		{
			// Manchmal kommt es vor, dass das Directory noch Eintraege enthaelt, die gar nicht mehr
			// (als Storages) existieren. (Keine Ahnung, unter welchen Umstaenden, eigentlich
			// sollte das nicht passieren, vielleicht ein Absturz waehrend des DB-Zugriffs ?)
			// Die muss ich in dem Fall noch ausfiltern.
			MapInt2StringIterator aLoop = m_aNames.begin();
			while (m_aNames.end() != aLoop)
			{
				if (!rStorage.Impl()->IsStorage(String::CreateFromInt32(aLoop->first)))
				{
					// preserve position
					MapInt2StringIterator aNext(aLoop);
					++aNext;

					// adjust the position if necessary
					if (m_aPos == aLoop)
						++m_aPos;

					m_aNames.erase(aLoop);
					aLoop = aNext;
				}
				else
					++aLoop;
			}
		}
	}

	//==============================================================================
	//= SdbStorage
	//==============================================================================
	DBG_NAME(SdbStorage);
	//------------------------------------------------------------------------------
	SdbStorage::SdbStorage(const String & rName)
	#pragma warning (disable : 4355)
		:aDir(*this)
	#pragma warning (default : 4355)
		,pImpl(NULL)
	{
		DBG_CTOR(SdbStorage,NULL);

		sal_Bool bExists = DirEntry(rName).Exists();
		pImpl = new SdbStorInfo(new SvStorage(rName, STREAM_STD_READ, 0));

		m_nStreamError = Impl()->GetErrorCode();
		if (ERRCODE_NONE != m_nStreamError)
			return;

		if (!bExists)
		{
			String aUserName;
			aUserName.AssignAscii(USERTYPENAME);
			Impl()->SetClass(aClassName, 0, aUserName);
			if (aUserName.EqualsAscii(USERTYPENAME_1))
				Impl()->SetVersion(1);
			else if (aUserName.EqualsAscii(USERTYPENAME_2))
				Impl()->SetVersion(2);
			else if (aUserName.EqualsAscii(USERTYPENAME_3))
				Impl()->SetVersion(3);
			else if (aUserName.EqualsAscii(USERTYPENAME_5))
				Impl()->SetVersion(5);
			else
				Impl()->SetVersion(4);
		}
		else
		{
			if (Impl()->GetClassName() == aClassName)
			{
				if (Impl()->GetUserName().EqualsAscii(USERTYPENAME_1))
					Impl()->SetVersion(1);
				else if (Impl()->GetUserName().EqualsAscii(USERTYPENAME_2))
					Impl()->SetVersion(2);
				else if (Impl()->GetUserName().EqualsAscii(USERTYPENAME_3))
					Impl()->SetVersion(3);
				else if (Impl()->GetUserName().EqualsAscii(USERTYPENAME_5))
					Impl()->SetVersion(5);
				else
					Impl()->SetVersion(4);
			}
			// fuer ltere Versionen, die noch keinen Classname verwenden
			else if (Impl()->IsStream(String::CreateFromAscii(SIGNATURE_STREAM)))
				Impl()->SetVersion(0);
			else
			{
				m_nStreamError = ERRCODE_IO_WRONGFORMAT;
				return;
			}
		}

		// open the directory stream
		if (GetVersion())
		{
			SvStorageStream* pStream = Impl()->OpenStream(String::CreateFromAscii(DIR), STREAM_STD_READ);
			m_nStreamError = pStream->GetErrorCode();
			if (ERRCODE_NONE != m_nStreamError)
			{
				pStream->AddRef();
				pStream->ReleaseRef();
			}
			else
				aDir.Init(pStream);
		}
	}

	//------------------------------------------------------------------------------
	SdbStorage::SdbStorage(SdbStorage& rParent, const String& rName)
	#pragma warning (disable : 4355)
		:aDir(*this)
	#pragma warning (default : 4355)
		,pImpl(NULL)
	{
		DBG_CTOR(SdbStorage,NULL);

		String aRealName;
		sal_uInt32 nKey;
		if (rParent.GetVersion())
		{
			nKey = rParent.aDir.GetKey(rName);
			aRealName = String::CreateFromInt32(nKey);
		}
		else
			aRealName = rName;

		sal_Bool bExists = rParent.IsStorage(aRealName);

		pImpl = new SdbStorInfo(rParent.Impl()->OpenStorage(aRealName, STREAM_STD_READ, 0));

		// check for errors
		m_nStreamError = Impl()->GetErrorCode();
		if (ERRCODE_NONE != m_nStreamError)
			return;

		Impl()->SetVersion(rParent.GetVersion());
		if (!GetVersion())
			return;

		// beim Vater registrieren
		if (!rParent.aDir.knows(nKey) && GetVersion())
			rParent.aDir.Insert(nKey, rName);

		// eigenes Verzeichnis erzeugen
		SvStorageStream* pStream = Impl()->OpenStream(String::CreateFromAscii(DIR), STREAM_STD_READ);
		m_nStreamError = pStream->GetErrorCode();
		if (ERRCODE_NONE != m_nStreamError)
		{
			pStream->AddRef();
			pStream->ReleaseRef();
		}
		else
			aDir.Init(pStream);
	}

	//------------------------------------------------------------------------------
	SdbStorage::~SdbStorage()
	{
		DBG_DTOR(SdbStorage,NULL);
		delete pImpl;
	}

	//------------------------------------------------------------------------------
	sal_Bool SdbStorage::HasStorage(const String& strName,sal_Bool _bTable) const
	{
		String sRealName = GetVersion() ? String::CreateFromInt32(aDir.GetKey(strName)) : strName;
		return Impl()->IsStorage(sRealName);
	}

	//------------------------------------------------------------------------------
	sal_Bool SdbStorage::HasStreams() const
	{
		SvStorageInfoList aInfoList;
		Impl()->FillInfoList(&aInfoList);
		for (sal_uInt32 i = 0; i < aInfoList.Count(); i++)
		{
			SvStorageInfo& rInfo = aInfoList[i];
			if (!rInfo.IsStream())
				continue;
			String sObjName(rInfo.GetName());
			if (sObjName == String::CreateFromAscii(DIR))
				continue;
			return sal_True;
		}
		return sal_False;
	}

	//------------------------------------------------------------------------------
	sal_Bool SdbStorage::HasStorages() const
	{
		if (GetVersion())
		{
			return aDir.size() > 0;
		}
		else
		{
			SvStorageInfoList aInfoList;
			Impl()->FillInfoList(&aInfoList);
			return aInfoList.Count() > 0;
		}
	}

	//------------------------------------------------------------------------------
	void SdbStorage::GetStorageNameList(StringArray& rList)
	{
		DBG_CHKTHIS(SdbStorage, NULL);
		rList.clear();

		if (GetVersion())
		{
			String sName;

			for (sal_Bool bResult = GetStorageName(sName, sal_True);
				bResult;
				bResult = GetStorageName(sName, sal_False))
			{
				DBG_ASSERT(sName.Len(), "SdbStorage::GetStorageNameList : empty storage names shouldn't occure ! (aDir may be corrupt)");
				if (sName.Len())
					rList.push_back(sName);
			}
		}
		else
		{
			SvStorageInfoList aInfoList;
			Impl()->FillInfoList(&aInfoList);

			for (sal_uInt32 i = 0; i < aInfoList.Count(); ++i)
				rList.push_back(aInfoList[i].GetName());
		}
	}

	//------------------------------------------------------------------------------
	void SdbStorage::GetStreamNameList(StringArray& rList)
	{
		DBG_CHKTHIS(SdbStorage, NULL);
		rList.clear();

		SvStorageInfoList aInfoList;
		Impl()->FillInfoList(&aInfoList);
		for (sal_uInt32 i = 0; i < aInfoList.Count(); ++i)
		{
			SvStorageInfo& rInfo = aInfoList[i];
			if (!rInfo.IsStream())
				continue;

			String sObjName(rInfo.GetName());
			if (sObjName == String::CreateFromAscii(DIR))
				continue;

			if (!sObjName.Len())
			{
				DBG_WARNING("SdbStorage::GetStreamNameList : there is a stream with an empty name ! how this ?");
				continue;
			}

			rList.push_back(sObjName);
		}
	}

	//------------------------------------------------------------------------------
	sal_Bool SdbStorage::GetStorageName(String& rName, sal_Bool bFirst)
	{
		DBG_CHKTHIS(SdbStorage, NULL);

		if (aDir.done() && !bFirst)
			return sal_False;
		if ((0 == aDir.size()) && bFirst)
			return sal_False;

		rName = bFirst ? aDir.first() : aDir.next();
		return sal_True;
	}

	//------------------------------------------------------------------------------
	SvStorageStream* SdbStorage::OpenStream(const String& rName)
	{
		DBG_CHKTHIS(SdbStorage, NULL);
		SvStorageStream* pStream = Impl()->OpenStream(rName, STREAM_STD_READ);

		m_nStreamError = pStream->GetErrorCode();
		if (ERRCODE_NONE != m_nStreamError)
		{
			pStream->AddRef();
			pStream->ReleaseRef();
			pStream = NULL;
		}
		else
			pStream->SetBufferSize(1024);

		return pStream;
	}

	//------------------------------------------------------------------------------
	SdbStorage*	SdbStorage::OpenStorage(const String& rName)
	{
		DBG_CHKTHIS(SdbStorage, NULL);

		SdbStorage* pStorage = new SdbStorage(*this, rName);
		if (pStorage->isError())
		{
			m_nStreamError = pStorage->getError();
			pStorage->acquire();
			pStorage->release();
			pStorage = NULL;
		}
		return pStorage;
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

