/*************************************************************************
 *
 *  $RCSfile: wpdesktp.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WPDESKTOP_H
#define _WPDESKTOP_H

#ifdef __cplusplus
extern "C" {
#endif

	/*
	 * typedefs for api functions
	 */

	typedef LHANDLE (*PFN_CONNECT)	  (VOID);
	typedef LHANDLE (*PFN_RECONNECT)  (LHANDLE);
	typedef void	(*PFN_DISCONNECT) (LHANDLE);
	typedef APIRET	(*PFN_REQUEST)	  (LHANDLE, const PSZ, BYTE, PVOID, PULONG);
	typedef HOBJECT (*PFN_HQUERY)	  (PSZ);

	/*
	 * api declararion
	 */

	typedef struct {
		PFN_CONNECT	   wps_connect;
		PFN_RECONNECT  wps_reconnect;
		PFN_DISCONNECT wps_disconnect;
		PFN_REQUEST	   wps_request;
		PFN_HQUERY	   wps_queryHandle;
	} wps_api;

	/*
	 * defines for action code
	 */

#define VERSION_INFO		0
#define API_ERROR			1
#define FIND_FIRST_OBJECT	2
#define FIND_NEXT_OBJECT	3
#define GET_OBJECT_INFO		4
#define GET_OBJECT_HANDLE	5
#define GET_OBJECT_LOCATION 6
#define GET_OBJECT_ICON		7
#define GET_LINK_INFO		8
#define BUILD_CRC			9
#define RENAME_OBJECT	   10
#define DELETE_OBJECT	   11
#define POPULATE_FOLDER	   12
#define RELEASE_LOCK	   13

	/*
	 * object info structure returned by wps agent
	 */

	typedef struct {
		USHORT	attrObject;
		LHANDLE hIcon;
		UCHAR	cbName;
		UCHAR	cbTitle;
		CHAR	szName [1];
		CHAR	szTitle[1];
	} wps_objectInfo;

	/*
	 * object attributes defines
	 */

#define OBJECT_ATTRIB_DO_NOT_LINK	 0x0001
#define OBJECT_ATTRIB_DO_NOT_MOVE	 0x0002
#define OBJECT_ATTRIB_DO_NOT_RENAME	 0x0004
#define OBJECT_ATTRIB_DO_NOT_DELETE	 0x0008
#define OBJECT_ATTRIB_DO_NOT_COPY	 0x0010
#define OBJECT_ATTRIB_DO_NOT_DRAG	 0x0020
#define OBJECT_ATTRIB_DO_NOT_DROP_ON 0x0040
#define OBJECT_ATTRIB_DO_NOT_PRINT	 0x0080
#define OBJECT_ATTRIB_HIDDEN		 0x0100
#define OBJECT_ATTRIB_IS_LINK		 0x0200
#define OBJECT_ATTRIB_IS_FOLDER		 0x0400
#define OBJECT_ATTRIB_IS_FILESYSTEM	 0x0800

	/*
	 * link info structure returned by wps agent
	 */

	typedef struct {
		UCHAR	linkType;
		LHANDLE hIcon;
		UCHAR	cbTarget;
		UCHAR	cbArguments;
		UCHAR	cbWorkingDir;
		CHAR	szTarget[1];
		CHAR	szArguments[1];
		CHAR	szWorkingDir[1];
	} wps_linkInfo;

	/*
	 * link type defines
	 */

#define LINK_TYPE_SHADOW  0x01
#define LINK_TYPE_PROGRAM 0x02
#define LINK_TYPE_DIR	  0x80

#ifdef __cplusplus
}
#endif

#endif /* _WPDESKTOP_H */





