/*************************************************************************
 *
 *  $RCSfile: scimport.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:45:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>


// SPECIAL FOR DEBUGGING

#include "scdebug.h"

#ifdef __cplusplus
#define _TYPEDEF
#else
#define _TYPEDEF typedef
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define CmPerInch                 2.54F
#define PixelPerInch              96.0F
#define PointsPerInch             72.27F
#define TwipsPerPoint             20.0F

const float InchPerCm           = 1.0F / CmPerInch;
const float PointsPerCm         = PointsPerInch / CmPerInch;
const float TwipsPerInch        = TwipsPerPoint * PointsPerInch;
const float TwipsPerCm          = TwipsPerInch / CmPerInch;
const float TwipsPerPixel       = TwipsPerInch / PixelPerInch;
const float TwipsPerChar        = TwipsPerInch / 13.6F;
const float PixelPerTwips       = PixelPerInch / TwipsPerInch;

#define MinRealValue              1e-37
#define MaxRealValue              1e30
#define MinExtendedValue          1e-4000
#define MaxExtendedValue          1e4000

// Maximale Tabellendimension
#define MaxCol                    255
#define MaxRow                    8191
#define MaxTab                    255

#define MinColWidth               TwipsPerInch / 10.0
#define MaxColWidth               8.0 * TwipsPerInch
#define MinRowHeight              8.0 * TwipsPerPoint
#define MaxRowHeight              128.0 * TwipsPerPoint

#define MinPageWidth              2.0 * TwipsPerInch
#define MinPageHeight             TwipsPerInch

#define MaxDecimals               8

#define NVValue                   -1

// Zeilen- / Spaltenattribute
#define craSoftBreak              0x01
#define craHardBreak              0x02
#define craHidden                 0x04
#define craMarked                 0x08

// Zeichenattribute
#define atNone                    0x00
#define atBold                    0x01
#define atItalic                  0x02
#define atUnderline               0x04
#define atStrikeOut               0x08

// Ausrichtungsattribute
#define jWordBreak                0x01
#define jBottomTop                0x02
#define jTopBottom                0x04

// Ausmaskierungswerte fr Ausrichtung
#define HorJustifyMask            0x000f
#define VerJustifyMask            0x00f0
#define OJustifyMask              0x0f00

// Zelltypen
#define ctNone                    0
#define ctValue                   1
#define ctString                  2
#define ctFormula                 3

// Attribute fr horizontale Ausrichtung
#define jhStandard                0
#define jhLeft                    1
#define jhCenter                  2
#define jhRight                   3

// Attribute fr vertikale Ausrichtung
#define jvStandard                0
#define jvTop                     1
#define jvCenter                  2
#define jvBottom                  3

// Definitionen fr Hintergrund-Raster
#define rNone                     0
#define rGray12                   1
#define rGray25                   2
#define rGray50                   3
#define rGray75                   4
#define rGray100                  5

// Zellformate
#define fStandard                 0
#define fMoney                    1
#define fThousand                 2
#define fPercent                  3
#define fExponent                 4
#define fZero                     5
#define fDate                     6
#define fTime                     7
#define fBoolean                  8
#define fFormula                  9
#define fString                   10
#define fNone                     11

// Attribute fr Datum und Zeit
#define dfNameDayMonthYearLong    0
#define dfDayMonthYearLong        1
#define dfMonthYearLong           2
#define dfNameDayMonthLong        3
#define dfDayMonthLong            4
#define dfMonthLong               5
#define dfNameDayMonthYearShort   6
#define dfDayMonthYearShort       7
#define dfMonthYearShort          8
#define dfNameDayMonthShort       9
#define dfDayMonthShort           10
#define dfMonthShort              11

#define tfHourMinSec24				0
#define tfHourMin24					1
#define tfHourMinSec12				2
#define tfHourMin12					3



// Attribute fr Zellschutz
#define paProtect                 1
#define paHideFormula             2
#define paHideAll                 4
#define paHidePrint               8

// Rahmenattribute
#define fNoLine                   0
#define fThinLine                 1
#define fThickLine                3

_TYPEDEF struct VALUEFORMAT
{ BYTE nFormat;
  BYTE nInfo;
};

_TYPEDEF struct HEADFOOTLINE
{ sal_Char sz[128];
  LOGFONT logfont;
  BYTE horJustify;
  BYTE verJustify;
  UINT wRaster;
  UINT wFrame;
  COLORREF textColor;
  COLORREF backColor;
  COLORREF rasterColor;
  UINT wFrameColor;
  UINT reserved;
};

_TYPEDEF struct BLOCKRECT
{ POINT a, b;
};

_TYPEDEF struct PAGEFORMAT
{ HEADFOOTLINE headline;
  HEADFOOTLINE footline;

  // Seite
  int nOrientation;
  int nWidth;
  int nHeight;
  int nNonPrintableX;
  int nNonPrintableY;

  // Rnder
  int nLeft;
  int nTop;
  int nRight;
  int nBottom;
  int nHead;
  int nFoot;

  // Zentrierung
  BOOL bHorCenter;
  BOOL bVerCenter;

  // Druck
  BOOL bPrintGrid;
  BOOL bPrintColRow;
  BOOL bPrintNote;

  // Druckrichtung
  BOOL bTopBottomDir;

  // Optionen
  sal_Char szPrintAreaName[32];
  BLOCKRECT PrintArea;
  BYTE prnzoom[6]; // PASCAL-REAL (6 Bytes) !!!
  UINT wFirstPageNo;
  int nRowRepeatStart;
  int nRowRepeatEnd;
  int nColRepeatStart;
  int nColRepeatEnd;

  // Fr Erweiterungen
  BYTE  reserved[28];
};

void scInit();
void scDone();

void scLock();
void scUnlock();

void scGetPageFormat(int nTab, PAGEFORMAT* pageformat);
void scPutPageFormat(int nTab, PAGEFORMAT* pageformat);
void scInsertNamedReference(LPSTR lpstrName, LPSTR lpstrRef);

void scGetTableCount(int* nCount);
void scGetTableName(int nTab, LPSTR lpstrName);
void scGetTableIndex(LPSTR lpstrName, int* nTab);
void scInsertTable(int nTab, LPSTR lpstrName);
void scDeleteTable(int nTab);
void scRenameTable(int nTab, LPSTR lpstrName);

void scGetColWidth(int nCol, int nTab, int* nWidth);
void scPutColWidth(int nCol, int nTab, int* nWidth);
void scGetColAttr(int nCol, int nTab, int* nAttr);
void scPutColAttr(int nCol, int nTab, int* nAttr);

void scGetRowHeight(int nRow, int nTab, int* nHeight);
void scPutRowHeight(int nRow, int nTab, int* nHeight);
void scGetRowAttr(int nRow, int nTab, int* nAttr);
void scPutRowAttr(int nRow, int nTab, int* nAttr);

void scGetCellType(int nCol, int nRow, int nTab, BYTE* byCellType);

void scGetString(int nCol, int nRow, int nTab, LPSTR lpstrString);
void scPutString(int nCol, int nRow, int nTab, LPSTR lpstrString);

void scGetValue(int nCol, int nRow, int nTab, long double* ldValue);
void scPutValue(int nCol, int nRow, int nTab, long double* ldValue);

void scGetFont(int nCol, int nRow, int nTab, UINT* hFont);
void scPutFont(int nCol, int nRow, int nTab, UINT* hFont);
void scGetLogFont(int nCol, int nRow, int nTab, LOGFONT* logfont);
void scPutLogFont(int nCol, int nRow, int nTab, LOGFONT* logfont);

void scGetAttr(int nCol, int nRow, int nTab, UINT* wAttr);
void scPutAttr(int nCol, int nRow, int nTab, UINT* wAttr);
void scSetAttr(int nCol, int nRow, int nTab, UINT* wAttr);
void scDelAttr(int nCol, int nRow, int nTab, UINT* wAttr);

void scGetJustify(int nCol, int nRow, int nTab, UINT* wJustify);
void scPutJustify(int nCol, int nRow, int nTab, UINT* wJustify);

void scGetFrame(int nCol, int nRow, int nTab, UINT* wFrame);
void scPutFrame(int nCol, int nRow, int nTab, UINT* wFrame);

void scGetRaster(int nCol, int nRow, int nTab, UINT* wRaster);
void scPutRaster(int nCol, int nRow, int nTab, UINT* wRaster);

void scGetValueFormat(int nCol, int nRow, int nTab, VALUEFORMAT* valueformat);
void scPutValueFormat(int nCol, int nRow, int nTab, VALUEFORMAT* valueformat);

void scGetColor(int nCol, int nRow, int nTab, UINT* wColor);
void scPutColor(int nCol, int nRow, int nTab, UINT* wColor);

void scGetFrameColor(int nCol, int nRow, int nTab, UINT* wColor);
void scPutFrameColor(int nCol, int nRow, int nTab, UINT* wColor);

void scGetFlag(int nCol, int nRow, int nTab, UINT* wFlag);
void scPutFlag(int nCol, int nRow, int nTab, UINT* wFlag);

void scGetEndPos(int nTab, int* nEndCol, int* nEndRow);

void scPutStringEx(int nCol, int nRow, int nTab, LPSTR lpstrString);
void scPutValueEx(int nCol, int nRow, int nTab, long double* ldValue);

void scPercentBoxInit(long double ldMinValue, long double ldMaxValue);
void scPercentBoxDone();
void scPercentBoxPut(long double ldValue);

#ifdef __cplusplus
}
#endif
