/*************************************************************************
 *
 *  $RCSfile: conditn.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/14 09:48:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#ifndef __THREAD_HXX
#include "thread.hxx"
#endif

#ifndef __SEMAPHOR_HXX
#include "semaphor.hxx"
#endif

#ifndef __SCHEDULE_HXX
#include "schedule.hxx"
#endif

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif

//----------------------------------------------------------------------------
//	SALCondition::SALCondition
//----------------------------------------------------------------------------

SALCondition::SALCondition() :
    SALThreadQueue(),
    bSet(FALSE)
{
    SCHEDULER->conditionQueue()->append(this);
}

//----------------------------------------------------------------------------
//	SALCondition::~SALCondition
//----------------------------------------------------------------------------

SALCondition::~SALCondition()
{
	SALThread *pThread = first();

    while (pThread)
    {
      pThread->meStatus = STATUS_ERROR;
		pThread = pThread->next();
    }
}

//----------------------------------------------------------------------------
//	SALCondition::test
//----------------------------------------------------------------------------

BOOL SALCondition::test() const
{
	return bSet;
}

//----------------------------------------------------------------------------
//	SALCondition::set
//----------------------------------------------------------------------------

BOOL SALCondition::set(STATUS eStatus)
{
    if (!bSet)
    {
        SALThread *pThread;
        while ((pThread = first()) != NULL)
        {
            remove(pThread);
            SCHEDULER->readyQueue()->append(pThread);
            pThread->meStatus = eStatus;
        }
    }

    return (bSet = TRUE);
}

//----------------------------------------------------------------------------
//	SALCondition::wait
//----------------------------------------------------------------------------

STATUS SALCondition::wait(unsigned long milliseconds)
{
    if (bSet)
    {
        SCHEDULER->dispatch();
        return STATUS_OK;
    }
    else
    {
        SALThread *pThread = SCHEDULER->activeThread();

        SCHEDULER->readyQueue()->remove(pThread);
        pThread->mnDelay = milliseconds;
        append(pThread);
        SCHEDULER->dispatch();

        // Hier koennen wir nicht mehr sicher sein,
        // dass SALCondition::this noch gueltig ist !!!

        return pThread->meStatus;
    }
}

//============================================================================
//
//	OSL-Interface
//
//============================================================================

#include <osl/conditn.h>

extern "C" {

/** Creates a condition.
	@returns 0 if condition could not be created.
*/
oslCondition SAL_CALL osl_createCondition()
{
	SALCondition *pCondition = new SALCondition;

	return (oslCondition)pCondition;
}

/** Free the memory used by the condition.
	@param Condition the condition handle.
*/
void SAL_CALL osl_destroyCondition(oslCondition Condition)
{
	SALCondition *pCondition = (SALCondition *)Condition;

	if (pCondition)
		delete pCondition;
}

/** Sets condition to True => wait() will not block, check() returns True.
	NOTE: ALL threads waiting on this condition are unblocked!
	@param Condition handle to a created condition.
	@return False if system-call failed.
*/
sal_Bool SAL_CALL osl_setCondition(oslCondition Condition)
{
	SALCondition *pCondition = (SALCondition *)Condition;

	if (pCondition)
		return (sal_Bool)pCondition->set();
	else
		return sal_False;
}

/** Sets condition to False => wait() will block, check() returns False
	@param Condition handle to a created condition.
	@return False if system-call failed.
*/
sal_Bool SAL_CALL osl_resetCondition(oslCondition Condition)
{
	SALCondition *pCondition = (SALCondition *)Condition;

	if (pCondition)
	{
		pCondition->reset();
		return sal_True;
	}
	else
		return sal_False;
}

/** Blocks if condition is not set<BR>
	If condition has been destroyed prematurely, wait() will
	return with False.
	@param Condition handle to a created condition.
	@param pTimeout Tiemout value or NULL for infinite waiting
	@return False if system-call failed.
*/

oslConditionResult SAL_CALL osl_waitCondition(oslCondition Condition, const TimeValue* pTimeout)
{
	SALCondition *pCondition = (SALCondition *)Condition;

	if (pCondition)
	{
		STATUS	eStatus = pCondition->wait(MILLISECONDS(pTimeout));

		switch (eStatus)
		{
			case STATUS_OK:
				return osl_cond_result_ok;
			case STATUS_TIMEOUT:
				return osl_cond_result_timeout;
			case STATUS_ERROR:
			default:
				return osl_cond_result_error;
		}
	}
	else
		return osl_cond_result_error;
}

/** Queries the state of the condition without blocking.
	@param Condition handle to a created condition.
	@return True: condition is set. <BR>
	False: condition is not set. <BR>
*/
sal_Bool SAL_CALL osl_checkCondition(oslCondition Condition)
{
	SALCondition *pCondition = (SALCondition *)Condition;

	if (pCondition)
		return (sal_Bool)pCondition->test();
	else
		return sal_False;
}


} // extern "C"




