/*************************************************************************
 *
 *  $RCSfile: ThreadedBuffer.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 14:13:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Martin Gallwey (gallwey@sun.com)
 *
 *
 ************************************************************************/
#ifndef _THREADED_BUFFER_HXX
#include <ThreadedBuffer.hxx>
#endif
#ifndef OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _VOS_DIAGNOSE_H_
#include <vos/diagnose.hxx>
#endif
#ifndef _ZIP_OUTPUT_STREAM_HXX
#include <ZipOutputStream.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::osl;

ThreadedBuffer::ThreadedBuffer(sal_Int64 nNewBufferSize, ZipPackage & rNewZipPackage )
: ZipPackageBuffer ( nNewBufferSize )
, m_aOutputThread ( rNewZipPackage)
, m_aReadSemaphore ( 0 )
, m_aWriteSemaphore ( 0 )
, m_nOffset ( 0 )
, m_nTotalWritten ( 0 )
, m_bShouldResume ( sal_False )
, m_bThreadCreated ( sal_False )
, m_bShouldSleep ( sal_True )
{
	m_aOutputThread.setThreadedBuffer ( *this );
}

ThreadedBuffer::~ThreadedBuffer(void) 
{
	if (m_aOutputThread.isRunning() )
	{
		m_aOutputThread.terminate();
		m_aWriteSemaphore.release();
		m_aOutputThread.resume();
		m_aOutputThread.join();
	}
}
sal_Int32 SAL_CALL ThreadedBuffer::readBytes( Sequence< sal_Int8 >& aData, sal_Int32 nBytesToRead ) 
		throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	if (nBytesToRead < 0)
		throw BufferSizeExceededException(::rtl::OUString(), *this);
	
	m_bShouldResume = sal_True;
	aData.realloc ( nBytesToRead );
	m_nEnd = nBytesToRead;
	m_nCurrent = 0;
	m_pUCBBuffer = &aData;
	sal_Int32 nBufferSize = m_aWriteBuffer.getLength() - m_nOffset;

	if ( nBufferSize )
	{
		// if we've still got stuff in the buffer from last time, copy that in first
		if ( nBufferSize > nBytesToRead )
			nBufferSize = nBytesToRead;

		writeToBuffer( m_pUCBBuffer->getArray(), m_aWriteBuffer.getConstArray() + m_nOffset, nBufferSize );
		m_nOffset += nBufferSize;
		if ( nBufferSize >= nBytesToRead )
			m_bShouldResume = sal_False;
		else
			// This decrements the internal reference count of the sequence and sets this sequence's length to 0
			m_aWriteBuffer.realloc ( 0 );
	}

	if ( m_bShouldResume && !m_aOutputThread.isFinished() )
	{
		if ( m_bThreadCreated )
			m_aWriteSemaphore.release();
		else
		{
			m_bThreadCreated = sal_True;
			m_aOutputThread.create ();
		}
		m_aReadSemaphore.acquire();
	}
	
	if (m_nCurrent < nBytesToRead )
		aData.realloc ( static_cast < sal_Int32 > ( m_nCurrent ) );
	return static_cast < sal_Int32 > ( m_nCurrent );
}

void SAL_CALL ThreadedBuffer::writeBytes( const Sequence< sal_Int8 >& aData ) 
		throw(NotConnectedException, BufferSizeExceededException, IOException, RuntimeException)
{
	m_nOffset = static_cast < sal_Int32 > ( aData.getLength() );
	const sal_Int8 *pData   = aData.getConstArray();
	m_bShouldSleep = sal_False;

	if (m_nCurrent + m_nOffset > m_nEnd)
	{
		// The output thread wrote more data than the UCB requested, tell
		// it to hold its horses, take a reference to the buffer and
		// give the UCB as much as we can for now.
		m_bShouldSleep = sal_True;
		m_nOffset = static_cast < sal_Int32 > (m_nEnd - m_nCurrent);
		// This increments the internal reference count of the sequence
		m_aWriteBuffer = aData;
	}
	// Otherwise, give the UCB everything

	writeToBuffer( m_pUCBBuffer->getArray() + m_nCurrent, aData.getConstArray(), m_nOffset );

	if ( m_bShouldSleep )
	{
		m_aReadSemaphore.release();
		m_aWriteSemaphore.acquire();
		// if we are terminating the threading buffer early (possible with
		// the use of the interaction handler), check if we should terminate
		// here
		m_aOutputThread.schedule();
	}
}
void ThreadedBuffer::writeToBuffer ( sal_Int8 * pDestination, const sal_Int8 * pSource, sal_Int32 nSize )
{
	memcpy ( pDestination, pSource, nSize );
	m_nCurrent += nSize;
	m_nTotalWritten += nSize;
}
void SAL_CALL ThreadedBuffer::seek( sal_Int64 location ) 
		throw(::com::sun::star::lang::IllegalArgumentException, IOException, RuntimeException)
{
	VOS_ENSURE(0, "seek can't be used on a threaded buffer!!");
}
sal_Int64 SAL_CALL ThreadedBuffer::getPosition(  ) 
		throw(IOException, RuntimeException)
{
	return m_nTotalWritten;
}
sal_Int64 SAL_CALL ThreadedBuffer::getLength(  ) 
		throw(IOException, RuntimeException)
{
	VOS_ENSURE (0, "getLength can't be used on a threaded buffer!!");
	return 0;
}
void ThreadedBuffer::setZipOutputStream ( ZipOutputStream & rNewZipOutputStream )
{
	m_pZipOutputStream = &rNewZipOutputStream;
	m_aOutputThread.setZipOutputStream ( rNewZipOutputStream );
}
