/*************************************************************************
 *
 *  $RCSfile: propset.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_PROPSET_HXX
#define _ADR_PROPSET_HXX

#if STLPORT_VERSION < 321
#include <tools/presys.h>
#include <vector.h>
#include <hash_map.h>
#include <list.h>
#include <slist.h>
#include <tools/postsys.h>
#else
#include <vector>
#include <hash_map>
#include <list>
#endif

#include <usr/uno.hxx>
#include <usr/refl.hxx>

#ifndef _USR_PROPSHLP_HXX //autogen wg. OPropertyDescriptor
#include <usr/propshlp.hxx>
#endif

#ifndef _USR_ITERHLP_HXX //autogen wg. OBroadcastHelper
#include <usr/iterhlp.hxx>
#endif

#ifndef _USR_PROPTYPEHLP_HXX //autogen wg. OPropertyTypeConversion
#include <usr/proptypehlp.hxx>
#endif

#ifndef _USR_MRC_HXX //autogen wg. OComponentHelper
#include <usr/comphlp.hxx>
#endif

#ifndef _VOS_REF_HXX_ //autogen wg. ORef
#include <vos/ref.hxx>
#endif

#include <stardiv/uno/util/containr.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif

#define SHOULDBEUNICODE( x ) StringToOUString( x, CHARSET_SYSTEM )
#define SHOULDTAKEUNICODE( x ) OUStringToString( x, CHARSET_SYSTEM )
#define MAXSTRINGLEN 512
#define MAXSTRINGLISTLEN 32768

// we want getUsrReflection( BOOL*) to return BOOL_getReflection() instead
// of BYTE_getReflection()

template<class T>
inline Reflection* getUsrReflection( T* )
{
	return ::getReflection( (T*) 0 );
}

inline Reflection* getUsrReflection( BOOL* )
{
	return BOOL_getReflection();
}

template<class T>
void operator <<=( UsrAny& rAny, const T& rValue )
{
	rAny.set( &rValue, getUsrReflection( (T*)0 ) );
}


template<class T>
BOOL operator >>=( const UsrAny& rAny, T& rValue )
{
	if( !getUsrReflection( (T*)0 )->equals( *rAny.getReflection() ) )
		return FALSE;
	else rAny.getReflection()->assignObject( &rValue, rAny.get() );
	return TRUE;
}


class Ss;
inline void* operator new( size_t nSize, Ss* pAddr ) { return pAddr; }

struct UStringEqual
{
	inline bool operator()(const UString & s1, const UString & s2) const
	{
		return s1 == s2;
	}
};

struct UStringHash
{
	size_t operator()(const UString & UString) const {
		return UString.hashCode(); }
};

typedef NAMESPACE_STD(hash_map)
<UString, INT32, UStringHash, UStringEqual>
OHandleHashMap;

#define QUERYIFACE( x ) 						\
if( aUik == x::getSmartUik() ) 					\
{												\
	rOut = (x*)this;							\
	return TRUE;								\
}
template<class T>
inline BOOL isEqual( const T& rFirst, const T& rSecond )
{
	return rFirst == rSecond;
}


#define DECLARE_SEQEQUAL( T )												 \
BOOL inline isEqual( const Sequence<T >& rFirst, const Sequence<T >& rSecond ) \
{																			 \
	return isEqualSeq( rFirst, rSecond );									 \
}


inline void* getObjectPtr( UsrAny* pAny, TypeClass eClass )
{
	return eClass  == TypeClass_ANY ?
		pAny : pAny->get();
}

inline const void* getObjectPtr( const UsrAny* pAny, TypeClass eClass )
{
	return getObjectPtr( (UsrAny*)pAny, eClass );
}

// a propertytype adds comparison method to a reflection.


struct IPropertyTypeStaticImpl;
class IPropertyType
{
public:
	IPropertyType() {} // registerPropertyType( this ); }
	virtual Reflection* getReflection() const= 0;
	virtual INT32       getSize( ) const = 0;
	virtual INT16       getAlign( ) const { return 4; }
	virtual BOOL        equals( const void* p1, const void* p2 ) const = 0;
	virtual NAMESPACE_USR( OGetReflectionFunctionType ) getReflectionFunction() const = 0;
	
	static IPropertyType* getPropertyType( const UString& rName );
protected:
	static void registerPropertyType( IPropertyType* pType );
private:
	static IPropertyTypeStaticImpl* pImpl;
	IPropertyType& operator=( const IPropertyType& ); // n.i
	IPropertyType( const IPropertyType& ); // n.i
};

template<class T>
class OPropertyType : public IPropertyType
{
public:
	virtual Reflection* getReflection() const;
	virtual BOOL    equals( const void* p1, const void* p2 ) const;
	virtual NAMESPACE_USR( OGetReflectionFunctionType ) getReflectionFunction() const;
	virtual INT32       getSize( ) const { return sizeof( T ); }

	static  IPropertyType* getInstance();
	static  Reflection* getStaticReflection();
private:
	OPropertyType(){}
};

template<class T>
NAMESPACE_USR( OGetReflectionFunctionType ) 
OPropertyType<T>::getReflectionFunction()  const
{ 
	return getStaticReflection; 
}

template<class T>
Reflection* OPropertyType<T>::getStaticReflection() 
{ 
	return ::getReflection( (T*) 0 ); 
}

template<class T>
IPropertyType* OPropertyType<T>::getInstance()
{
	static OPropertyType<T>* pType = 0;
	if( !pType ) pType = new OPropertyType<T>;
	return pType;
}

template<class T>
Reflection* OPropertyType<T>::getReflection() const
{
	return getUsrReflection( (T*)0 ); 
}

template<class T>
BOOL OPropertyType<T>::equals( const void* p1, const void* p2 ) const
{
	return isEqual( *(const T*)p1, *(const T*)p2 );
}

typedef IPropertyType* (*OGetPropertyTypeFunctionType)();

template<class T>
inline IPropertyType* getPropertyType( T* )
{
	return OPropertyType<T>::getInstance();
}

// egcs doesn't like this specialization, if it is not inline
BOOL isEqualAny( const UsrAny& rFirst, const UsrAny& rSecond );
inline BOOL isEqual( const UsrAny& rFirst, const UsrAny& rSecond )
{
	return isEqualAny( rFirst, rSecond );
}


// msvc41 doesnt know specialization of templates. thus isEqual has to
// specified for each sequence as function.

template<class T>
BOOL isEqualSeq( const Sequence<T>& rFirst, const Sequence<T>& rSecond )
{
	INT32 nLen = rFirst.getLen();
	if( nLen != rSecond.getLen() ) return false;
	const T* pFirst = rFirst.getConstArray();
	const T* pSecond = rSecond.getConstArray();
	const IPropertyType* pType = OPropertyType<T>::getInstance();
	while( nLen-- )
		if( !pType->equals( pFirst + nLen, pSecond + nLen ) ) return false;
	return true;
}

DECLARE_SEQEQUAL( UString )

class OPropertyObject
{
public:
	virtual ~OPropertyObject() {}
};

// describes a property in an OPropertyObject. The m_nOffset is the location
// of the property in memory relative to the start of the OPropertyObject part
// of the object.
struct OPropertyAccessor
{
	const sal_Unicode*                     m_pName;
	INT32                              m_nOffset;
	INT16                              m_nFlags;
	const IPropertyType*                     m_pType;
	static Reflection*        getClassReflection();
	const IPropertyType* getType() const { return m_pType; }
	void* getPtr( OPropertyObject* pObj ) const { return (char*)pObj + m_nOffset; }
};

struct OPropertyAccessorWithUString : public OPropertyAccessor
{
	UString m_aName;
};



// calculate property type and position of a property.
#define ADR_PROPERTY( Class, Name, Flags )							\
{																	\
	 L#Name, (INT32)&((Class*)0)->m_##Name -						\
		  ((INT32)(Class*)1 - (INT32)(Class*)(OPropertyObject*)1),	\
		  Flags, ::getPropertyType( &((Class*)0)->m_##Name )		\
}

// OObjectClassBase holds metainformation for a class of OPropertyObject. Via
// its OPropertyAccessors it knows where to find properties in memory
// given an OPropertyObject pointer. 
class OObjectClassBase
{
public:
	OObjectClassBase() : m_pArray( 0 ), m_pDescriptors( 0 ), m_pParent( 0 ) {}
	virtual ~OObjectClassBase() { delete m_pDescriptors; delete m_pArray; }
	
	OObjectClassBase* getParent() const { return m_pParent; }
	NAMESPACE_USR( OPropertyDescriptor )* getPropertyDescriptor() const {
		return m_pDescriptors; }
			
	const OPropertyAccessor* getAccessor( INT32 nPos ) const {
		return &m_aAccessors[ nPos ]; }
	INT32 getAccessorCount() const { return m_aAccessors.size(); }
	NAMESPACE_USR( IPropertyArrayHelper )& getPropertyArray() const;
	XPropertySetInfoRef getPropertySetInfo() const;

	INT32               getIndex( const UString& rName ) const;
	void setPropertyValues( 
		OPropertyObject* pObj, const Sequence<PropertyValue>& rValues ) const;
	Sequence<PropertyValue> getPropertyValues( OPropertyObject* pObj ) const;
	void init();
	NAMESPACE_VOS( IMutex )& getMutex() const { 
		return (NAMESPACE_VOS(IMutex)&) m_aMutex; }
			
protected:
	virtual void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps ) const = 0;
	NAMESPACE_STD(vector)<OPropertyAccessor>                  m_aAccessors;
private:
	OObjectClassBase& operator=( const OObjectClassBase& ); // n.i
	OObjectClassBase( const OObjectClassBase& ); // n.i
	
	XPropertySetInfoRef                        m_xInfo;
	NAMESPACE_USR( OPropertyArrayHelper )*     m_pArray;
	OObjectClassBase*                          m_pParent;
	NAMESPACE_USR( OPropertyDescriptor )*      m_pDescriptors;
	OHandleHashMap                             m_aHandles;
	NAMESPACE_VOS( OMutex )                    m_aMutex;
};

template<class T>
class OObjectClass : public OObjectClassBase
{
public:
	static OObjectClassBase& getInstance();
protected:
	virtual void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps ) const { T::fillClassInfo(
			rpParentClass, rProps ); }
};

template<class T>
OObjectClassBase& OObjectClass<T>::getInstance()
{
	static OObjectClass<T>* pClass = 0;
	if( pClass == 0 )
	{
		pClass = new OObjectClass<T>;
		pClass->init( );
	}
	return *pClass;
}

class OGenericObject;
class OGenericObjectClass : 
	public OObjectClassBase, public NAMESPACE_VOS( OReference )
{
 public:
	OGenericObjectClass();
	OGenericObjectClass( OObjectClassBase* pParent );
	void addProperty( 
		const IPropertyType* pType, const UString& rName, INT16 nFlags );
	OGenericObject* createInstance( );
	OGenericObject& clone( OGenericObject& rObj );
 protected:
	virtual void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps ) const;
 private:
	NAMESPACE_STD(vector)<OPropertyAccessorWithUString>                 m_aGenericAccessors;
	OObjectClassBase*                         m_pGenericParent;
	INT32                                     m_nOffset;
};

class OGenericObject : public OPropertyObject
{
public:
	OGenericObject( 
		OGenericObjectClass* pClass )
		: m_xClass( pClass )	{}
	const NAMESPACE_VOS(ORef)<OGenericObjectClass>& getClass() {
		return m_xClass; }
	OGenericObject& clone( ) { return m_xClass->clone( *this ); }
private:
	NAMESPACE_VOS(ORef)<OGenericObjectClass> m_xClass;
	long m_nEnd;
	friend class OGenericObjectClass;
};


class XRegistryKeyRef;
class OPropertySet : 
	public NAMESPACE_USR( OBroadcastHelper ),
	public NAMESPACE_USR( OPropertySetHelper ), 
	public NAMESPACE_USR( OComponentHelper ),
	public XPropertyAccess
{
 public:
	SMART_UNO_DECLARATION( OPropertySet, OComponentHelper );
	OPropertySet( 
		NAMESPACE_VOS( IMutex )& rMutex_,
		OPropertyObject* pObject, const OObjectClassBase& rClass, BOOL bOwner )
		: m_pClass( &rClass ),
		OPropertySetHelper( (NAMESPACE_USR(OBroadcastHelper)&)*this ), m_pObject( pObject ),
		OBroadcastHelper( rMutex_ ), m_bOwner( bOwner ), 
		OComponentHelper( rMutex_ ), m_rMutex( rMutex_ ) {}
	OPropertySet( 
		NAMESPACE_VOS( IMutex )& rMutex_ )
		: m_pClass( 0 ),
		OPropertySetHelper( (NAMESPACE_USR(OBroadcastHelper)&)*this ), m_pObject( 0 ), 
		OBroadcastHelper( rMutex_ ), m_bOwner( false ), 
		OComponentHelper( rMutex_ ), m_rMutex( rMutex_ ) {}
	NAMESPACE_VOS( IMutex )& getMutex() const { return m_rMutex; }
	~OPropertySet() { if( m_bOwner ) delete m_pObject; }

	// XIdlClassProvider
	Sequence<XIdlClassRef>	getIdlClasses();
	static XIdlClassRef getStaticIdlClass();

	XPropertySetInfoRef getPropertySetInfo() const {
		return m_pClass->getPropertySetInfo(); }
	
    virtual Sequence< PropertyValue > getPropertyValues(void) const THROWS( (UsrSystemException) );
    virtual void setPropertyValues(const Sequence< PropertyValue >& aProps) THROWS( (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, UsrSystemException) );

	BOOL		queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	static void savePropertySet( 
		const XPropertySetRef& xProp, const XRegistryKeyRef& xKey );
	static void saveProperty( 
		const UsrAny& rAny, const XIdlClassRef& xClass, 
		const XRegistryKeyRef& xKey );
	static void loadPropertySet( 
		const XPropertySetRef& xProp, const XRegistryKeyRef& xKey );
	static UsrAny loadProperty( 
		const XIdlClassRef& xClass, const XRegistryKeyRef& xKey );

 protected:

	virtual NAMESPACE_USR( IPropertyArrayHelper ) & getInfoHelper() const { 
		return m_pClass->getPropertyArray(); }
			 
	virtual BOOL convertFastPropertyValue( 
		UsrAny & rConvertedValue, UsrAny & rOldValue, 
		INT32 nHandle, const UsrAny& rValue )
		THROWS( (IllegalArgumentException) );
	virtual void setFastPropertyValue_NoBroadcast( 
		INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) );
	virtual void getFastPropertyValue( 
		UsrAny& rValue, INT32 nHandle ) const;

	const OObjectClassBase*               m_pClass;
	OPropertyObject*                      m_pObject;
	BOOL                                  m_bOwner;
	IMutex&                               m_rMutex;

 private:

	friend XInterfaceRef OPropertySet_createInstance();
};


template<class Iterator>
class OEnumerationHelper : public XEnumeration
{
public:
	OEnumerationHelper( NAMESPACE_VOS( IMutex )& rMutex ) : m_rMutex( rMutex ){}
	void setIterators( const Iterator& rFirst, const Iterator& rEnd ) {
		m_aCur = rFirst; m_aEnd = rEnd; }
	virtual BOOL hasMoreElements(void);
    virtual UsrAny nextElement(void);
		
private:
	NAMESPACE_VOS( IMutex )& m_rMutex;
	Iterator m_aCur;
	Iterator m_aEnd;
};

template<class Iterator>
BOOL OEnumerationHelper<Iterator>::hasMoreElements(void) 
{
	NAMESPACE_VOS( OGuard ) aGuard( m_rMutex );
	return m_aCur != m_aEnd; 
}

template<class Iterator>
UsrAny OEnumerationHelper<Iterator>::nextElement()
{
	NAMESPACE_VOS( OGuard ) aGuard( m_rMutex );
  	UsrAny aRet( &*m_aCur, getReflection( 
  		NAMESPACE_STD(value_type)( *(Iterator*) 0) ) );
	m_aCur++;
	return aRet;
}

typedef NAMESPACE_STD(hash_map)
<UString, INT32, UStringHash, UStringEqual>
OHandleHashMap;

template<class C> class ONameContainerHelper : public XNameContainer
{
public:
	typedef NAMESPACE_STD(hash_map)
		<UString, C, UStringHash, UStringEqual> hashmap;
	ONameContainerHelper( 
		NAMESPACE_VOS( IMutex)& rMutex, 
		hashmap& rMap ) : m_rMap( rMap ), m_rMutex( rMutex ){}

	virtual UsrAny getByName(const UString& aName) const;
    virtual Sequence< UString > getElementNames(void) const;
	
    virtual BOOL hasByName(const UString& aName) const {
		NAMESPACE_VOS(OGuard) aGuard( m_rMutex );
		return m_rMap.find( aName ) != m_rMap.end(); }

    virtual XIdlClassRef getElementType(void) const { 
		return getReflection( (C*) 0)->getIdlClass(); }
    virtual BOOL hasElements(void) const { 
		NAMESPACE_VOS(OGuard) aGuard( m_rMutex );
		return m_rMap.begin() != m_rMap.end(); }
			

    virtual void replaceByName(const UString& aName, const UsrAny& aElement);
    virtual void insertByName(const UString& aName, const UsrAny& aElement);
    virtual void removeByName(const UString& Name) {
		NAMESPACE_VOS(OGuard) aGuard( m_rMutex );
		m_rMap.erase( Name ); }

private:
	hashmap& m_rMap;
	NAMESPACE_VOS( IMutex)& m_rMutex;
};

template<class C>
Sequence< UString > ONameContainerHelper<C>::getElementNames(void) const
{
	NAMESPACE_VOS(OGuard) aGuard( m_rMutex );
	Sequence<UString> aRet( m_rMap.size() );
	NAMESPACE_STD(transform)( m_rMap.begin(), m_rMap.end(), aRet.getArray(), 
			   NAMESPACE_STD(select1st)<hashmap::value_type>() );
	return aRet;
}

template<class C>
UsrAny ONameContainerHelper<C>::getByName(const UString& aName) const 
{
	NAMESPACE_VOS(OGuard) aGuard( m_rMutex );
	hashmap::const_iterator aIter = m_rMap.find( aName );
	if( aIter == m_rMap.end() ) THROW( NoSuchElementException() );
	UsrAny aAny;
	aAny <<= (*aIter).second;
	return aAny;
}

template<class C>
void ONameContainerHelper<C>::replaceByName(
	const UString& aName, const UsrAny& aElement)  
{
	NAMESPACE_VOS(OGuard) aGuard( m_rMutex );
	if( !aElement.getReflection()->equals(*getReflection( (C*)0 ) ) )
		THROW( IllegalArgumentException() );
	hashmap::iterator aIter = m_rMap.find( aName );
	if( aIter == m_rMap.end() ) THROW( NoSuchElementException() );
	(*aIter).second = *(C*) aElement.get();
}

template<class C>
void ONameContainerHelper<C>::insertByName(
	const UString& aName, const UsrAny& aElement) 
{
	NAMESPACE_VOS(OGuard) aGuard( m_rMutex );
	if( !aElement.getReflection()->equals(*getReflection( (C*)0 ) ) )
		THROW( IllegalArgumentException() );
	hashmap::const_iterator aIter = m_rMap.find( aName );
	if( aIter != m_rMap.end() ) THROW( ElementExistException() );
	m_rMap.insert( hashmap::value_type( aName, *(C*) aElement.get() ) );
}

template<class ElementType, class Cont>
inline void copySequenceToContainer( const Sequence<ElementType>& from, Cont& to )
{
	const ElementType* pFrom = from.getConstArray();
	copy( pFrom, pFrom + from.getLen(), 
		  insert_iterator<Cont>( to, to.begin() ) );
}

template<class ElementType, class Container>
inline void copyContainerToSequence( const Container& from, Sequence<ElementType>& to )
{
	to = Sequence<ElementType>( from.size() );
	NAMESPACE_STD(copy)( from.begin(), from.end(), to.getArray());
}

BOOL extractInterface( const UsrAny& rAny, XInterfaceRef& xIFace, Uik aUik );

template<class InterfaceRef>
inline BOOL extractInterface( const UsrAny& rAny, InterfaceRef& xIface )
{
	return extractInterface( rAny, xIface, xIface->getSmartUik() );
}

#define ARRSIZE( x ) ( sizeof( x ) / sizeof( *x ) )

void throwException( const UsrAny& rAny );
UsrAny exceptionToAny( const UsrException& rExp );

#define OPERATORSFORSOLARIS( x )				\
inline BOOL operator==( const x&, const x& )	\
{												\
	return FALSE;								\
}												\
inline BOOL operator<( const x&, const x& )		\
{												\
	return FALSE;								\
}



#endif

