/*************************************************************************
 *
 *  $RCSfile: content.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <propset.hxx>


#ifndef _SMART_COM_SUN_STAR_CHAOS_SENDINFO_HXX_
#include <smart/com/sun/star/chaos/SendInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_CONNECTIONMODE_HXX_
#include <smart/com/sun/star/chaos/ConnectionMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_THREADINGINFO_HXX_
#include <smart/com/sun/star/chaos/ThreadingInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_SEARCHRECURSION_HXX_
#include <smart/com/sun/star/chaos/SearchRecursion.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_DOCUMENTHEADERFIELD_HXX_
#include <smart/com/sun/star/chaos/DocumentHeaderField.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_WALLPAPERSTYLE_HXX_
#include <smart/com/sun/star/chaos/WallpaperStyle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_SEARCHINFO_HXX_
#include <smart/com/sun/star/chaos/SearchInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_SEARCHCRITERIUM_HXX_
#include <smart/com/sun/star/chaos/SearchCriterium.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_SENDMEDIATYPES_HXX_
#include <smart/com/sun/star/chaos/SendMediaTypes.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_NAMECLASH_HXX_
#include <smart/com/sun/star/chaos/NameClash.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_GROUPVIEWCONFIG_HXX_
#include <smart/com/sun/star/chaos/GroupViewConfig.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_FOLDERVIEWMODE_HXX_
#include <smart/com/sun/star/chaos/FolderViewMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_THREADING_HXX_
#include <smart/com/sun/star/chaos/Threading.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_RULETERM_HXX_
#include <smart/com/sun/star/chaos/RuleTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_EXPORTSTREAMINFO_HXX_
#include <smart/com/sun/star/chaos/ExportStreamInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_OPENMODE_HXX_
#include <smart/com/sun/star/chaos/OpenMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_TRANSFERINFO_HXX_
#include <smart/com/sun/star/chaos/TransferInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_RULESET_HXX_
#include <smart/com/sun/star/chaos/RuleSet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_CRAWLSTATE_HXX_
#include <smart/com/sun/star/chaos/CrawlState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_ICONPOSINFO_HXX_
#include <smart/com/sun/star/chaos/IconPosInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_CONTENTTYPE_HXX_
#include <smart/com/sun/star/chaos/ContentType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_SYNCHRONIZEPOLICY_HXX_
#include <smart/com/sun/star/chaos/SynchronizePolicy.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_PRIORITY_HXX_
#include <smart/com/sun/star/chaos/Priority.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_DOCUMENTVIEWMODE_HXX_
#include <smart/com/sun/star/chaos/DocumentViewMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_RULEACTION_HXX_
#include <smart/com/sun/star/chaos/RuleAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_CROSSREFERENCE_HXX_
#include <smart/com/sun/star/chaos/CrossReference.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_VALUEADDEDMODE_HXX_
#include <smart/com/sun/star/chaos/ValueAddedMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_ICONPOSMODE_HXX_
#include <smart/com/sun/star/chaos/IconPosMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_RULEOPERATOR_HXX_
#include <smart/com/sun/star/chaos/RuleOperator.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_RECIPIENTINFO_HXX_
#include <smart/com/sun/star/chaos/RecipientInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_RULE_HXX_
#include <smart/com/sun/star/chaos/Rule.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_SORTINGINFO_HXX_
#include <smart/com/sun/star/chaos/SortingInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_EXPORTURLINFO_HXX_
#include <smart/com/sun/star/chaos/ExportURLInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_VERIFICATIONMODE_HXX_
#include <smart/com/sun/star/chaos/VerificationMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_DOCUMENTSTOREMODE_HXX_
#include <smart/com/sun/star/chaos/DocumentStoreMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_OUTGOINGMESSAGEVIEWMODE_HXX_
#include <smart/com/sun/star/chaos/OutgoingMessageViewMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_COLUMNCONFIG_HXX_
#include <smart/com/sun/star/chaos/ColumnConfig.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_WALLPAPER_HXX_
#include <smart/com/sun/star/chaos/WallPaper.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_OUTGOINGMESSAGESTATE_HXX_
#include <smart/com/sun/star/chaos/OutgoingMessageState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_MENUDESCRIPTOR_HXX_
#include <smart/com/sun/star/chaos/MenuDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_MENUITEMDESCRIPTOR_HXX_
#include <smart/com/sun/star/chaos/MenuItemDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_XCOMMANDEXECUTOR_HXX_
#include <smart/com/sun/star/chaos/XCommandExecutor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_XURLCONTENT_HXX_
#include <smart/com/sun/star/chaos/XURLContent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XDATAEDITOR_HXX_
#include <smart/com/sun/star/util/XDataEditor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XUNIQUEIDACCESS_HXX_
#include <smart/com/sun/star/container/XUniqueIDAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XNAMETRANSLATOR_HXX_
#include <smart/com/sun/star/schedule/XNameTranslator.hxx>
#endif



#ifndef _TOOLS_RESID_HXX
#include <tools/resid.hxx>
#endif

class OAdrResId : public ResId
{
public:
	OAdrResId( USHORT nId );
	static ResMgr* GetResManager();
};


struct OContentData : public OPropertyObject
{
	BOOL                  m_IsFolder;
	BOOL                  m_HasFolder;
	INT32                 m_MaskColor;
	UString               m_OwnURL;
	UString               m_Rename;
	Sequence<SortingInfo> m_Sorting;
	UString               m_TargetFrames;
	UString               m_Title;
	ContentType           m_ContentType;
	UString               m_DeleteMe;
	UString               m_NewChild;
	UString               m_MessageId;
	UString               m_IconId;
	UString               m_ViewDescription;
//	UString               m_Commands;
	MenuDescriptor        m_PopupMenu;

	static void fillClassInfo(
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	OContentData() : 
		m_HasFolder( TRUE ), m_MaskColor( 0x00ff00ff ), m_IsFolder( TRUE ),
		m_MessageId( L"0" ) {}
};

class OContent : public OContentData, public OPropertySet, 
				 public XURLContent, public XCommandExecutor
{
public:
	SMART_UNO_DECLARATION( OContent, OPropertySet );
	OContent( const XMultiServiceFactoryRef& xFactory ) : OPropertySet( 
		m_aMutex, this, OObjectClass<OContentData>::getInstance(), FALSE ),
	m_xMgr( xFactory )
		{
		}
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

    // interface  XChild
    virtual XInterfaceRef		getParent() const { return m_xParent; }
    virtual void				setParent( const XInterfaceRef& Parent ) {
		m_xParent = Parent; }

	// interface XURLContent
	virtual UString getURL() const { return m_OwnURL; }
    virtual BOOL	initialize( 
		const XURLContentRef& aParent, const UString& aURL );

	// XCommandExecutor
	virtual void cancel(const XInterfaceRef& CommandId);

	XDataEditorRef getDataEditor( const UString& rSourceServiceName );
	XSingleServiceFactoryRef getFactory( const UString& rSourceServiceName );
	UString getDefaultXMLPath( const XPropertySetRef& xProp );
	
	void importSource( const XPropertySetRef& xSource, const UString& rPath );

protected:
	XMultiServiceFactoryRef m_xMgr;
	OMutex        m_aMutex;
	XInterfaceRef m_xParent;
};

class OSourceEditorListener : public UsrObject, public XDataEditorListener
{
public:
	SMART_UNO_DECLARATION( OSourceEditorListener, UsrObject );
	OSourceEditorListener( 
		const XDataEditorRef& xEditor, const XMultiServiceFactoryRef& xMgr, BOOL bNew ) : 
		m_bNew( bNew ), m_xMgr( xMgr ), m_xEditor( xEditor ) {}

	virtual void disposing( const EventObject& rObj ) {}
	virtual void updateDataEditorState( const DataEditorEvent& rEvent );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

private:
	BOOL m_bNew;
	XMultiServiceFactoryRef m_xMgr;
	XDataEditorRef m_xEditor;
};

class OContentRoot : public OContent, public XContainerListener
{
public:
	SMART_UNO_DECLARATION( OContentRoot, OContent );
	OContentRoot( const XMultiServiceFactoryRef& rFactory );
	static XInterfaceRef createInstance( 
		const XMultiServiceFactoryRef& xFactory ) {
		return *new OContentRoot( xFactory ); }
		
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void elementInserted(const ContainerEvent& Event) 
		THROWS( (UsrSystemException) );
    virtual void elementRemoved(const ContainerEvent& Event) 
		THROWS( (UsrSystemException) );
    virtual void elementReplaced(const ContainerEvent& Event) 
		THROWS( (UsrSystemException) );
	
	virtual void disposing( const EventObject& rObj ) {}
	virtual void disposing();

//  	virtual BOOL initialize( 
//  		const XURLContentRef& aParent, const UString& rURL );

	// XCommandExecutor
    virtual Sequence< UString > queryCommands() const;
    virtual void execute(
		const UString& Command, const UsrAny& Args, 
		const XStatusCallbackRef& Callback);
	
	

private:

	void createDefaultSources();
};

class OContentSource : public OContent, public XPropertyChangeListener
{
public:
	SMART_UNO_DECLARATION( OContentSource, OContent );
	OContentSource( const XMultiServiceFactoryRef& rFactory );
	static XInterfaceRef createInstance( 
		const XMultiServiceFactoryRef& xFactory ) {
		return *new OContentSource( xFactory ); }
		
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void disposing( const EventObject& rObj ) {}
	virtual void disposing();

//  	virtual BOOL initialize( 
//  		const XURLContentRef& aParent, const UString& rURL );

	// XCommandExecutor
    virtual Sequence< UString > queryCommands() const;
    virtual void execute(
		const UString& Command, const UsrAny& Args, 
		const XStatusCallbackRef& Callback);

	void update();
	void propertyChange( const PropertyChangeEvent& ) {
		update(); }
			

    virtual BOOL	initialize( 
		const XURLContentRef& aParent, const UString& aURL );

protected:
	XPropertySetRef m_xSource;
};

class OIdentityInternationalizer : public UsrObject, public XNameTranslator
{
public:
	static XInterfaceRef create( const XMultiServiceFactoryRef& ) {
		return *new OIdentityInternationalizer(); }
	SMART_UNO_DECLARATION( OIdentityInternationalizer, UsrObject );
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	UString getTranslatedName( const UString& rName ) { return rName; }
};

class OResourceInternationalizer : public UsrObject, public XNameTranslator
{
public:
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr ) {
		return *new OResourceInternationalizer( xMgr ); }
	SMART_UNO_DECLARATION( OResourceInternationalizer, UsrObject );
	OResourceInternationalizer( const XMultiServiceFactoryRef& xMgr )
		: m_xMgr( xMgr ) {}
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	UString getTranslatedName( const UString& rName );

private:
	XMultiServiceFactoryRef m_xMgr;
};




