/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "PixelConvertExpressionFactory_p.h"

#include <llvm/Instructions.h>

#include "GTLCore/Type.h"
#include "GTLCore/AST/ConvertExpression.h"
#include "GTLCore/ExpressionResult_p.h"

#include "CodeGenerator_p.h"
#include "Debug.h"

using namespace OpenShiva;

namespace OpenShiva {
  class PixelConvertExpression : public GTLCore::AST::ConvertExpression {
    public:
      PixelConvertExpression( GTLCore::AST::Expression* _value,  const GTLCore::Type* _dstType ) : GTLCore::AST::ConvertExpression( _value ), m_dstType(_dstType)
      {
      }
      virtual ~PixelConvertExpression() {}
      virtual const GTLCore::Type* type() const { return m_dstType; }
      virtual GTLCore::ExpressionResult generateValue( GTLCore::GenerationContext& _gc, llvm::BasicBlock* bb ) const
      {
        llvm::Value* pixelPtr = value()->generateValue( _gc, bb).value();
        
        llvm::Value* pixelDataPtr = OpenShiva::CodeGenerator::accessPixelDataPtr( _gc, bb, pixelPtr);
        return GTLCore::ExpressionResult( new llvm::LoadInst( pixelDataPtr, "", bb ) , m_dstType );
      }
    private:
      const GTLCore::Type* m_dstType;
  };
}

PixelConvertExpressionFactory::PixelConvertExpressionFactory()
{
}

PixelConvertExpressionFactory::~PixelConvertExpressionFactory()
{
}

GTLCore::AST::ConvertExpression* PixelConvertExpressionFactory::create( GTLCore::AST::Expression* value, const GTLCore::Type* _dstType ) const
{
  return new PixelConvertExpression( value, _dstType );
}

bool PixelConvertExpressionFactory::canConvertBetween( const GTLCore::Type* srcType, const GTLCore::Type* dstType) const
{
  return  srcType->dataType() == GTLCore::Type::STRUCTURE and srcType->structName().startWith( "pixel" )
      and (*srcType->structDataMembers())[0].type() == dstType;
}
