/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_PARSER_H_
#define _OPENSHIVA_PARSER_H_

#include "GTLCore/ParserBase_p.h"

namespace GTLCore {
  namespace AST {
    class Tree;
  }
}

namespace OpenShiva {
  class Compiler;
  class Lexer;
  class Parser : public GTLCore::ParserBase {
    public:
      Parser( Compiler* , Lexer* );
      ~Parser();
      GTLCore::AST::Tree* parse();
    protected:
      virtual GTLCore::AST::Tree* tree();
      virtual GTLCore::AST::Statement* parseStatement();
      virtual const GTLCore::Type* parseType();
    private:
      void parseKernelBody();
    private:
      struct Private;
      Private* const d;
  };
}

#endif
