/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_COMPILER_H_
#define _OPENSHIVA_COMPILER_H_

#include <GTLCore/String.h>
#include <GTLCore/CompilerBase_p.h>

namespace GTLCore {
  class ModuleData;
}

namespace OpenShiva {
  
  class Compiler : public GTLCore::CompilerBase {
    public:
      Compiler();
      ~Compiler();
      bool compile(const GTLCore::String& _sourceCode, const GTLCore::String& _kernelName, GTLCore::ModuleData* _moduleData, GTLCore::String& _nameSpace);
      virtual GTLCore::TypeManager* typeManager();
    public:
      GTLCore::AST::Expression* standardConstant( const GTLCore::String& _name );
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
