/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLIMAGEIO_IMAGE_DC_REGISTRY_H_
#define _GTLIMAGEIO_IMAGE_DC_REGISTRY_H_

#include <GTLCore/String.h>

namespace GTLImageIO {
  class ImageDC;
  class ImageDCRegistry {
      ImageDCRegistry();
      virtual ~ImageDCRegistry();
      void initialise();
    public:
      static ImageDCRegistry* instance();
      void registerDC( ImageDC* _imageDC );
      const ImageDC* decoder( const GTLCore::String& _fileName ) const;
      const ImageDC* encoder( const GTLCore::String& _fileName ) const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
