/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_UTILS_P_H_
#define _GTLCORE_UTILS_P_H_

namespace GTLCore {

  /**
   * @internal
   * Delete all pointers of a list or a vector.
   * @ingroup GTLCore
   */
  template<class _Type_>
  void deleteAll( _Type_& list )
  {
    for( typename _Type_::iterator it = list.begin(); it != list.end(); ++it)
    {
      delete *it;
    }
  }
  /**
   * @internal
   * Delete all second members of a map
   * @ingroup GTLCore
   */
  template<class _Type_>
  void deleteAllSecondMember( _Type_& map )
  {
    for( typename _Type_::iterator it = map.begin(); it != map.end(); ++it)
    {
      delete it->second;
    }
  }

}

#endif
