/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _PRIMITIVE_TYPES_TRAITS_H_
#define _PRIMITIVE_TYPES_TRAITS_H_

#include "GTLCore/Value.h"

namespace GTLCore {
  template<typename _TYPE_>
  class PrimitiveTypeTrait {
    public:
      inline static const char* nameForType();
      inline static _TYPE_ convert(const GTLCore::Value& );
  };
  
  
  template<>
  class PrimitiveTypeTrait<int> {
    public:
      inline static const char* nameForType()
      {
        return "Integer";
      }
      inline static int convert(const GTLCore::Value& v)
      {
        return v.asInt32();
      }
  };
  
  template<>
  class PrimitiveTypeTrait<unsigned int> {
    public:
      inline static const char* nameForType()
      {
        return "Unsigned Integer";
      }
      inline static unsigned int convert(const GTLCore::Value& v)
      {
        return v.asUnsignedInt32();
      }
  };
  
  template<>
  class PrimitiveTypeTrait<bool> {
    public:
      inline static const char* nameForType()
      {
        return "Boolean";
      }
      inline static bool convert(const GTLCore::Value& v)
      {
        return v.asBoolean();
      }
  };
  
  template<>
  class PrimitiveTypeTrait<float> {
    public:
      inline static const char* nameForType()
      {
        return "Float";
      }
      inline static float convert(const GTLCore::Value& v)
      {
        return v.asFloat();
      }
  };
}

#endif
