/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _AST_FUNCTION_DELCARATION_H_
#define _AST_FUNCTION_DELCARATION_H_

#include <vector>

#include <GTLCore/ScopedName.h>
#include <GTLCore/String.h>

#include <GTLCore/Parameter.h>
#include <GTLCore/Function.h>

namespace llvm {
  class Module;
}

namespace GTLCore {
  class CodeGenerator;
  class Type;
  class VariableNG;
  class ModuleData;
  namespace AST {
    class Expression;
    class Statement;
    /**
     * @internal
     * @brief This class represent a function parameter.
     * @ingroup GTLCore_AST
     */
    class FunctionParameter {
      public:
        FunctionParameter( const Parameter& _parameter, Expression* _initialiser) : m_parameter(_parameter), m_initialiser(_initialiser)
        {
        }
        ~FunctionParameter();
        const Parameter& parameter() const { return m_parameter; }
        const Expression* initialiser() const { return m_initialiser; }
      private:
        Parameter m_parameter;
        Expression* m_initialiser;
    };
    /**
     * @internal
     * @brief This class represent a function declaration.
     * @ingroup GTLCore_AST
     */
    class FunctionDeclaration {
      public:
        FunctionDeclaration( const GTLCore::ScopedName& _name, const GTLCore::Type* _returnType, std::vector< FunctionParameter* > _parameters );
        ~FunctionDeclaration();
        Function* function();
        void setStatement( Statement* statement );
        const std::vector< GTLCore::VariableNG* >& parametersVariable() { return m_parametersVariable; }
        void generate( ModuleData* _module, GTLCore::CodeGenerator* _codeGenerator);
      private:
        std::vector< FunctionParameter* > m_parameters;
        std::vector< GTLCore::VariableNG* > m_parametersVariable;
        Function* m_function;
        Function::Data* m_functionData;
        Statement* m_statement;
    };
  }
}

#endif
