/* random.h
 *        Copyright (C) 2003 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CDK_RANDOM_H
#define CDK_RANDOM_H

#if !defined(USE_RNDLINUX) && !defined(__MINGW32__)
# define USE_RNDLINUX 1
#endif

#ifdef USE_RNDLINUX
# define NAME_OF_DEV_RANDOM "/dev/random"
# define NAME_OF_DEV_URANDOM "/dev/urandom"
#endif

#ifndef SIZEOF_UNSIGNED_LONG
# define SIZEOF_UNSIGNED_LONG 4
#endif

enum cdk_rand_level_t {
    CDK_RANDOM_WEAK        = 0,
    CDK_RANDOM_STRONG      = 1,
    CDK_RANDOM_VERY_STRONG = 2
};

/*-- randlib/random.c --*/
int cdk_random_add_bytes( const void * buf, size_t buflen, int quality );
void * cdk_random_bytes( size_t nbytes, enum cdk_rand_level_t level );
void * cdk_random_bytes_secure( size_t nbytes, enum cdk_rand_level_t level );
void cdk_randomize( byte *buffer, size_t length, enum cdk_rand_level_t level );
void _cdk_random_initialize( void );

#endif /*CDK_RANDOM_H*/
